/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.glassfish.external.statistics.impl.StatisticImpl;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedData
@Description(value="109 deployed endpoint info")
public class DeployedEndpointData
extends StatisticImpl
implements Map {
    @ManagedAttribute
    @Description(value="Application Name")
    public final String appName;
    @ManagedAttribute
    @Description(value="Endpoint Name")
    public final String endpointName;
    @ManagedAttribute
    @Description(value="Target Namespace of the Web Service")
    public final String namespace;
    @ManagedAttribute
    @Description(value="Web Service name")
    public final String serviceName;
    @ManagedAttribute
    @Description(value="Web Service port name")
    public final String portName;
    @ManagedAttribute
    @Description(value="Service Implementation Class")
    public final String implClass;
    @ManagedAttribute
    @Description(value="Address for Web Service")
    public final String address;
    @ManagedAttribute
    @Description(value="WSDL for Web Service")
    public final String wsdl;
    @ManagedAttribute
    @Description(value="Tester for Web Service")
    public final String tester;
    @ManagedAttribute
    @Description(value="Implementation Type: EJB or SERVLET")
    public final String implType;
    @ManagedAttribute
    @Description(value="Deployment Type: 109 or RI")
    public final String deploymentType;
    private Map<String, String> infoMap = new HashMap<String, String>();

    public DeployedEndpointData(String path, Application app, WebServiceEndpoint endpoint) {
        super(path, "", "");
        this.appName = app.getAppName();
        this.endpointName = endpoint.getEndpointName();
        this.namespace = endpoint.getServiceName().getNamespaceURI();
        this.serviceName = endpoint.getServiceName().getLocalPart();
        QName pName = endpoint.getWsdlPort();
        this.portName = pName != null ? pName.getLocalPart() : "";
        this.implClass = endpoint.implementedByEjbComponent() ? endpoint.getEjbComponentImpl().getEjbImplClassName() : endpoint.getServletImplClass();
        this.address = path;
        this.wsdl = this.address + "?wsdl";
        this.tester = this.address + "?Tester";
        this.implType = endpoint.implementedByEjbComponent() ? "EJB" : "SERVLET";
        this.deploymentType = "109";
        this.fillStatMap();
    }

    public DeployedEndpointData(String path, ServletAdapter adapter) {
        super(path, "", "");
        WSEndpoint endpoint = adapter.getEndpoint();
        this.appName = "";
        this.endpointName = adapter.getName();
        this.namespace = endpoint.getServiceName().getNamespaceURI();
        this.serviceName = endpoint.getServiceName().getLocalPart();
        this.portName = endpoint.getPortName().getLocalPart();
        this.implClass = endpoint.getImplementationClass().getName();
        this.address = path;
        this.wsdl = this.address + "?wsdl";
        this.tester = "";
        this.implType = "SERVLET";
        this.deploymentType = "RI";
        this.fillStatMap();
    }

    public Map<String, String> getStaticAsMap() {
        return this.infoMap;
    }

    private void fillStatMap() {
        this.infoMap.put("appName", this.appName);
        this.infoMap.put("endpointName", this.endpointName);
        this.infoMap.put("namespace", this.namespace);
        this.infoMap.put("serviceName", this.serviceName);
        this.infoMap.put("portName", this.portName);
        this.infoMap.put("implClass", this.implClass);
        this.infoMap.put("address", this.address);
        this.infoMap.put("wsdl", this.wsdl);
        this.infoMap.put("tester", this.tester);
        this.infoMap.put("implType", this.implType);
        this.infoMap.put("deploymentType", this.deploymentType);
    }

    @Override
    public int size() {
        return this.infoMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.infoMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.infoMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.infoMap.containsValue(value);
    }

    public Object get(Object key) {
        return this.infoMap.get(key);
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException("DeployedEndpointData is a read-only map");
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException("DeployedEndpointData is a read-only map");
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException("DeployedEndpointData is a read-only map");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("DeployedEndpointData is a read-only map");
    }

    public Set keySet() {
        return this.infoMap.keySet();
    }

    public Collection values() {
        return this.infoMap.values();
    }

    public Set entrySet() {
        return this.infoMap.entrySet();
    }
}

