/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.txnlog.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.util.MQThread;
import com.sun.messaging.jmq.util.txnlog.CheckPointListener;
import com.sun.messaging.jmq.util.txnlog.TransactionLogRecord;
import com.sun.messaging.jmq.util.txnlog.TransactionLogWriter;
import com.sun.messaging.jmq.util.txnlog.file.FileCorruptedException;
import com.sun.messaging.jmq.util.txnlog.file.FileLogRecordIterator;
import com.sun.messaging.jmq.util.txnlog.file.FileTransactionLogRecord;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class FileTransactionLogWriter
implements TransactionLogWriter,
Runnable {
    public static final short FILE_VERSION = 1;
    public static final int FILE_HEADER_SIZE = 48;
    public static final int FILE_MAGIC_NUMBER = 0x5555AAAA;
    public static final short FILE_RESERVED_SHORT = 0;
    public static final int FILE_STATUS_POSITION = 6;
    public static final int FILE_CHECK_POINT_POSITION = 8;
    public static final int FILE_CHECK_SUM_POSITION = 32;
    public static final int RECORD_HEADER_SIZE = 48;
    public static final int RECORD_MAGIC_NUMBER = -1431677611;
    public static final int RECORD_TYPE = -1;
    public static final long RECORD_TIME_STAMP = 0L;
    public static final int RECORD_BODY_SIZE = 0;
    public static final long RECORD_CHECK_SUM = 0L;
    public static final int RECORD_HEADER_RESERVE = 0;
    public static final short FILE_STATUS_CREATE_NORMAL = 0;
    public static final short FILE_STATUS_SHUTDOWN_NORMAL = 1;
    public static final short FILE_STATUS_BACKUP = 2;
    public static final short FILE_STATUS_CHK_POINT_UPDATED = 3;
    public static final short FILE_STATUS_RESET = 4;
    public static final long DEFAULT_MAX_SIZE = 0xA00000L;
    public static final String TXNLOG_DEBUG_PROP_NAME = "imq.debug.txnlog";
    public static final String TXNLOG_BACKUP_PROP_NAME = "imq.txnlog.backup";
    private long maxSize = 0xA00000L;
    private long cpOffset = 512000L;
    private long cpSize = this.maxSize - this.cpOffset;
    private CheckPointListener callback = null;
    private boolean isListenerCalled = false;
    private RandomAccessFile raf = null;
    private File file = null;
    public static final String RWD_MODE = "rwd";
    private static final String RWS_MODE = "rws";
    public static final String RW_MODE = "rw";
    private String fileMode = "rwd";
    private FileChannel fchannel = null;
    private boolean useFileChannelSync = false;
    private long checkPointPosition = 48L;
    private boolean debug = false;
    private Object txnLogSyncObj = new Object();
    private Checksum checksumEngine = new Adler32();
    private boolean playBackRequired = false;
    private boolean isFileCorrupted = false;
    private long checkpointSequence = 0L;
    private long entrySequence = 0L;
    private TransactionLogRecord lastEntry = null;
    public static final String TXNLOG_BACKUP_EXT = ".1";
    private boolean doFileBackup = false;
    private boolean doAsyncWrites = false;
    private boolean closed;
    private MQThread asyncWriteThread = null;
    private int sampleNum;
    private int sampleCount = 1000;
    private int[] numrecordsArray = new int[this.sampleCount];
    private List<TransactionLogRecord> transactionLogRecordList = new LinkedList<TransactionLogRecord>();
    private Object recordListMutex = new Object();

    public FileTransactionLogWriter(File file, String string, long l) throws IOException {
        this.init(file, string, l);
    }

    public FileTransactionLogWriter(String string) throws IOException {
        this.init(null, string, 0xA00000L);
    }

    public FileTransactionLogWriter(File file, String string, long l, String string2) throws IOException {
        if (RW_MODE.equals(string2)) {
            this.useFileChannelSync = true;
            this.fileMode = RW_MODE;
        } else if (RWS_MODE.equals(string2)) {
            this.fileMode = RWS_MODE;
        } else if (!RWD_MODE.equals(string2)) {
            throw new IllegalArgumentException("This file mode is not supported: " + string2);
        }
        this.init(file, string, l);
    }

    private void init(File file, String string, long l) throws IOException {
        this.debug = Boolean.getBoolean(TXNLOG_DEBUG_PROP_NAME);
        this.doFileBackup = Boolean.getBoolean(TXNLOG_BACKUP_PROP_NAME);
        this.doAsyncWrites = Globals.isAsyncTxnLogWrites();
        this.file = new File(file, string);
        this.maxSize = l;
        if (this.raf != null) {
            this.raf.close();
        }
        if (this.doAsyncWrites) {
            this.log("starting asyncwrite");
            this.asyncWriteThread = new MQThread((Runnable)this, string + "AsyncWrite");
            this.asyncWriteThread.setPriority(4);
            this.asyncWriteThread.start();
        }
        this.log("Using file mode: " + this.fileMode);
        this.raf = new RandomAccessFile(this.file, this.fileMode);
        if (this.useFileChannelSync) {
            this.log("File Channel Sync flag is on ...");
            this.fchannel = this.raf.getChannel();
        }
        if (this.raf.length() > 0L) {
            if (this.debug) {
                this.log("file exists: " + this.file.getAbsolutePath() + ", file size: " + this.raf.length());
            }
            this.readFileHeader();
            if (!this.playBackRequired) {
                this.writeFileHeader((short)3, 48L);
            }
        } else {
            this.initNewFile();
        }
    }

    private void initNewFile() throws IOException {
        this.raf.seek(0L);
        this.raf.setLength((int)this.maxSize);
        this.doWrite(new byte[(int)this.maxSize]);
        this.checkpointSequence = 0L;
        this.entrySequence = 0L;
        this.writeFileHeader((short)0, 48L);
        if (this.debug) {
            this.log("file created: " + this.file.getAbsolutePath() + ", size: " + this.raf.length());
        }
    }

    private void readFileHeader() throws IOException {
        this.raf.seek(0L);
        byte[] byArray = new byte[48];
        int n = this.raf.read(byArray);
        if (n != 48) {
            this.isFileCorrupted = true;
            throw new FileCorruptedException("File Header size mismatch. Expected:  48, read: " + n);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n2 = byteBuffer.getInt();
        short s = byteBuffer.getShort();
        short s2 = byteBuffer.getShort();
        long l = byteBuffer.getLong();
        long l2 = byteBuffer.getLong();
        long l3 = byteBuffer.getLong();
        long l4 = byteBuffer.getLong();
        long l5 = this.calculateCheckSum(byArray, 0, 32);
        if (this.debug) {
            this.log("read file header, magic=" + n2 + ", fversion=" + s + ", status=" + s2 + ", cpPosition=" + l + ", timestamp=" + l2 + ", cpSequence=" + l3 + ", chksum=" + l4);
        }
        if (l4 != l5) {
            this.isFileCorrupted = true;
            throw new FileCorruptedException("File Header checksum mismatch. Expected: " + l4 + ", calculated: " + l5);
        }
        if (n2 != 0x5555AAAA || s != 1) {
            this.isFileCorrupted = true;
            throw new FileCorruptedException("File Magic number/version mismatch: " + n2 + ":" + s);
        }
        if (s2 != 1) {
            this.playBackRequired = true;
        }
        if (this.debug) {
            this.log("playbackRequired=" + this.playBackRequired);
        }
        this.checkPointPosition = l;
        this.checkpointSequence = l3;
        this.raf.seek(48L);
    }

    private void writeFileHeader(short s, long l) throws IOException {
        this.checkpointSequence = this.checkpointSequence > 0x7FFFFFFFFFFFFFFEL ? 0L : ++this.checkpointSequence;
        this.entrySequence = 0L;
        this.raf.seek(0L);
        byte[] byArray = new byte[48];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putInt(0x5555AAAA);
        byteBuffer.putShort((short)1);
        byteBuffer.putShort(s);
        byteBuffer.putLong(l);
        long l2 = System.currentTimeMillis();
        byteBuffer.putLong(l2);
        byteBuffer.putLong(this.checkpointSequence);
        long l3 = this.calculateCheckSum(byArray, 0, 32);
        byteBuffer.putLong(l3);
        byteBuffer.putLong(0L);
        this.doWrite(byArray);
        if (this.debug) {
            this.log("write file header. magic=1431677610, fversion=1, status=" + s + ", cpPosition=" + l + ", timestamp=" + l2 + ", cpSequence=" + this.checkpointSequence + ", chksum=" + l3);
        }
    }

    public void setCheckpointSize(long l) {
        this.cpSize = l;
    }

    public void setMaximumSize(long l) {
        this.maxSize = l;
        this.cpSize = this.maxSize - this.cpOffset;
    }

    public void setCheckPointOffset(long l) {
        this.cpOffset = l;
        this.cpSize = this.maxSize - l;
    }

    public void setCheckPointListener(CheckPointListener checkPointListener) {
        this.callback = checkPointListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAsyncRecord(TransactionLogRecord transactionLogRecord) throws IOException {
        Object object = this.recordListMutex;
        synchronized (object) {
            this.transactionLogRecordList.add(transactionLogRecord);
            this.recordListMutex.notify();
        }
        object = transactionLogRecord;
        synchronized (object) {
            try {
                while (!transactionLogRecord.isWritten()) {
                    transactionLogRecord.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTransactionLogRecordList() {
        TransactionLogRecord transactionLogRecord;
        TransactionLogRecord[] transactionLogRecordArray = null;
        Object object = this.recordListMutex;
        synchronized (object) {
            while (this.transactionLogRecordList.size() == 0 && !this.closed) {
                try {
                    this.recordListMutex.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            transactionLogRecordArray = new TransactionLogRecord[this.transactionLogRecordList.size()];
            transactionLogRecordArray = this.transactionLogRecordList.toArray(transactionLogRecordArray);
            this.transactionLogRecordList.clear();
        }
        if (this.debug) {
            this.numrecordsArray[this.sampleNum] = transactionLogRecordArray.length;
            ++this.sampleNum;
            int n = 0;
            if (this.sampleNum == this.sampleCount) {
                this.sampleNum = 0;
                for (int i = 0; i < this.sampleCount; ++i) {
                    n += this.numrecordsArray[i];
                    System.out.print(this.numrecordsArray[i] + ",");
                }
                float f = (float)n / (float)this.sampleCount;
                this.log(" average records in compound txn record = " + f);
            }
        }
        if (transactionLogRecordArray.length == 1) {
            TransactionLogRecord transactionLogRecord2 = transactionLogRecordArray[0];
            try {
                this.writeRecord(transactionLogRecord2);
            }
            catch (IOException iOException) {
                transactionLogRecord2.setException(iOException);
            }
            TransactionLogRecord transactionLogRecord3 = transactionLogRecord2;
            synchronized (transactionLogRecord3) {
                transactionLogRecord2.setWritten(true);
                transactionLogRecord2.notify();
            }
            return;
        }
        try {
            this.writeCompoundRecord(transactionLogRecordArray);
        }
        catch (IOException iOException) {
            for (int i = 0; i < transactionLogRecordArray.length; ++i) {
                transactionLogRecord = transactionLogRecordArray[i];
                transactionLogRecord.setException(iOException);
            }
        }
        for (int i = 0; i < transactionLogRecordArray.length; ++i) {
            TransactionLogRecord transactionLogRecord4;
            transactionLogRecord = transactionLogRecord4 = transactionLogRecordArray[i];
            synchronized (transactionLogRecord) {
                transactionLogRecord4.setWritten(true);
                transactionLogRecord4.notify();
                continue;
            }
        }
    }

    public void run() {
        this.log("run called ");
        while (!this.closed) {
            try {
                this.processTransactionLogRecordList();
            }
            catch (Exception exception) {}
        }
        this.log("run ending ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCompoundRecord(TransactionLogRecord[] transactionLogRecordArray) throws IOException {
        Object object = this.txnLogSyncObj;
        synchronized (object) {
            int n;
            if (this.closed) {
                return;
            }
            int n2 = transactionLogRecordArray.length;
            FileTransactionLogRecord fileTransactionLogRecord = new FileTransactionLogRecord();
            fileTransactionLogRecord.setType(8);
            int n3 = 4;
            for (int i = 0; i < n2; ++i) {
                n3 += 8;
                n3 += transactionLogRecordArray[i].getBody().length;
            }
            byte[] byArray = new byte[n3];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putInt(n2);
            for (n = 0; n < n2; ++n) {
                byteBuffer.putInt(transactionLogRecordArray[n].getType());
                byteBuffer.putInt(transactionLogRecordArray[n].getBody().length);
                byteBuffer.put(transactionLogRecordArray[n].getBody());
            }
            fileTransactionLogRecord.setBody(byArray);
            fileTransactionLogRecord.setCheckPointSequence(this.checkpointSequence);
            fileTransactionLogRecord.setTimestamp(System.currentTimeMillis());
            fileTransactionLogRecord.setSequence(this.entrySequence++);
            n = 48 + fileTransactionLogRecord.getBody().length;
            byte[] byArray2 = new byte[n];
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray2);
            this.writeRecordHeader(byteBuffer2, fileTransactionLogRecord);
            byteBuffer2.put(fileTransactionLogRecord.getBody());
            this.doWrite(byArray2);
            if (this.raf.getFilePointer() > this.cpSize && !this.isListenerCalled) {
                if (this.debug) {
                    this.log("calling check point listener, fpointer: " + this.raf.getFilePointer());
                }
                this.callback.checkpoint();
                this.isListenerCalled = true;
            }
            this.lastEntry = fileTransactionLogRecord;
        }
    }

    public void write(TransactionLogRecord transactionLogRecord) throws IOException {
        if (this.doAsyncWrites) {
            this.writeAsyncRecord(transactionLogRecord);
        } else {
            this.writeRecord(transactionLogRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRecord(TransactionLogRecord transactionLogRecord) throws IOException {
        Object object = this.txnLogSyncObj;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (this.isFileCorrupted) {
                throw new IllegalStateException("File is corrupted. You must reset the log file to continue.");
            }
            if (this.playBackRequired) {
                throw new IllegalStateException("File not synced.  You must call Iterator to play back log file.");
            }
            if (this.callback == null) {
                throw new IllegalStateException("Check point listener not set. You must set a CheckPointListener before writing TransactionLogRecords.");
            }
            transactionLogRecord.setCheckPointSequence(this.checkpointSequence);
            transactionLogRecord.setTimestamp(System.currentTimeMillis());
            transactionLogRecord.setSequence(this.entrySequence++);
            int n = 48 + transactionLogRecord.getBody().length;
            byte[] byArray = new byte[n];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            this.writeRecordHeader(byteBuffer, transactionLogRecord);
            byteBuffer.put(transactionLogRecord.getBody());
            this.doWrite(byArray);
            if (this.raf.getFilePointer() > this.cpSize && !this.isListenerCalled) {
                if (this.debug) {
                    this.log("calling check point listener, fpointer: " + this.raf.getFilePointer());
                }
                this.callback.checkpoint();
                this.isListenerCalled = true;
            }
            this.lastEntry = transactionLogRecord;
        }
    }

    private void writeRecordHeader(ByteBuffer byteBuffer, TransactionLogRecord transactionLogRecord) {
        byteBuffer.putInt(-1431677611);
        byteBuffer.putInt(transactionLogRecord.getType());
        byteBuffer.putInt(transactionLogRecord.getBody().length);
        byteBuffer.putLong(transactionLogRecord.getTimestamp());
        byteBuffer.putLong(transactionLogRecord.getSequence());
        byteBuffer.putLong(transactionLogRecord.getCheckPointSequence());
        long l = this.calculateCheckSum(transactionLogRecord.getBody());
        byteBuffer.putLong(l);
        byteBuffer.putInt(0);
    }

    private void doWrite(byte[] byArray) throws IOException {
        this.raf.write(byArray);
        if (this.useFileChannelSync) {
            this.raf.getFD().sync();
        }
    }

    long calculateCheckSum(byte[] byArray) {
        long l = this.calculateCheckSum(byArray, 0, byArray.length);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long calculateCheckSum(byte[] byArray, int n, int n2) {
        long l = -1L;
        Object object = this.txnLogSyncObj;
        synchronized (object) {
            this.checksumEngine.update(byArray, n, n2);
            l = this.checksumEngine.getValue();
            this.checksumEngine.reset();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionLogRecord checkpoint() throws IOException {
        Object object = this.txnLogSyncObj;
        synchronized (object) {
            long l = this.raf.getFilePointer();
            if (l > this.cpSize) {
                this.writeFileHeader((short)3, 48L);
            } else {
                this.writeFileHeader((short)3, l);
                this.raf.seek(l);
            }
            this.isListenerCalled = false;
            return this.lastEntry;
        }
    }

    public Iterator iterator() throws IOException {
        FileLogRecordIterator fileLogRecordIterator = new FileLogRecordIterator(this);
        return fileLogRecordIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        this.log("Reseting txn log file ...");
        Object object = this.txnLogSyncObj;
        synchronized (object) {
            if (this.doFileBackup) {
                this.backupLogFile();
            }
            if (this.isFileCorrupted) {
                this.initNewFile();
            } else {
                this.writeFileHeader((short)3, 48L);
            }
            this.checkPointPosition = 48L;
            this.playBackRequired = false;
            this.isFileCorrupted = false;
            this.isListenerCalled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionLogRecord getLastEntry() {
        Object object = this.txnLogSyncObj;
        synchronized (object) {
            return this.lastEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.txnLogSyncObj;
        synchronized (object) {
            long l = this.raf.getFilePointer();
            this.writeFileHeader((short)1, 48L);
            this.raf.close();
            this.closed = true;
        }
    }

    public TransactionLogRecord newTransactionLogRecord() {
        return new FileTransactionLogRecord();
    }

    RandomAccessFile getRAF() {
        return this.raf;
    }

    long getCPPosition() {
        return this.checkPointPosition;
    }

    public synchronized long getCPSequence() {
        return this.checkpointSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupLogFile() throws IOException {
        Object object = this.txnLogSyncObj;
        synchronized (object) {
            String string = this.file.getCanonicalPath();
            this.deleteBackUpFile(string);
            this.copyFile(string);
        }
    }

    private void copyFile(String string) throws IOException {
        String string2 = string + TXNLOG_BACKUP_EXT;
        File file = new File(string2);
        if (file.exists()) {
            throw new IOException("Cannot backup txnlog.  You must remove the back up file to continue: " + string2);
        }
        long l = this.raf.getFilePointer();
        if (!this.useFileChannelSync) {
            this.fchannel = this.raf.getChannel();
        }
        this.fchannel.position(0L);
        FileChannel fileChannel = new FileOutputStream(file).getChannel();
        fileChannel.transferFrom(this.fchannel, 0L, this.fchannel.size());
        fileChannel.close();
        if (!this.useFileChannelSync) {
            this.fchannel.close();
            this.raf.close();
            this.raf = new RandomAccessFile(this.file, this.fileMode);
        }
        this.raf.seek(l);
    }

    private void deleteBackUpFile(String string) throws IOException {
        String string2 = string + TXNLOG_BACKUP_EXT;
        File file = new File(string2);
        if (file.exists()) {
            file.delete();
        }
    }

    public boolean playBackRequired() {
        return this.playBackRequired;
    }

    private void log(String string) {
        if (this.debug) {
            System.out.println(new Date() + " " + Thread.currentThread() + ": " + string);
        }
    }
}

