/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.admin.handlers;

import com.sun.messaging.bridge.BridgeBaseContext;
import com.sun.messaging.bridge.BridgeServiceManagerImpl;
import com.sun.messaging.bridge.admin.handlers.AdminCmdHandler;
import com.sun.messaging.bridge.admin.handlers.DebugHandler;
import com.sun.messaging.bridge.admin.handlers.HelloHandler;
import com.sun.messaging.bridge.admin.handlers.ListHandler;
import com.sun.messaging.bridge.admin.handlers.PauseHandler;
import com.sun.messaging.bridge.admin.handlers.ResumeHandler;
import com.sun.messaging.bridge.admin.handlers.StartHandler;
import com.sun.messaging.bridge.admin.handlers.StopHandler;
import com.sun.messaging.bridge.admin.util.AdminMessageType;
import com.sun.messaging.bridge.resources.BridgeManagerResources;
import com.sun.messaging.bridge.service.BridgeException;
import java.util.Locale;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;

public class AdminMessageHandler {
    private static boolean DEBUG = false;
    private BridgeManagerResources _br = null;
    private BridgeBaseContext _bc = null;
    private BridgeServiceManagerImpl _bsm = null;
    private AdminCmdHandler[] _handlers = null;

    public AdminMessageHandler(BridgeServiceManagerImpl bridgeServiceManagerImpl) {
        DEBUG = bridgeServiceManagerImpl.getDEBUG();
        this._bc = bridgeServiceManagerImpl.getBridgeBaseContext();
        this._br = bridgeServiceManagerImpl.getBridgeManagerResources();
        this._bsm = bridgeServiceManagerImpl;
        this.initHandlers();
    }

    protected boolean getDEBUG() {
        return DEBUG;
    }

    public void handle(Session session, ObjectMessage objectMessage) {
        block16: {
            BridgeManagerResources bridgeManagerResources = this._br;
            ObjectMessage objectMessage2 = null;
            int n = 30;
            try {
                Object object;
                String string;
                Object object2;
                String string2;
                objectMessage2 = session.createObjectMessage();
                if (DEBUG) {
                    this._bc.logInfo("BridgeAdminMessageHandler.handle:\n<<<<****" + objectMessage.toString(), null);
                }
                try {
                    string2 = objectMessage.getStringProperty("JMQLocaleLanguage");
                    object2 = objectMessage.getStringProperty("JMQLocaleCountry");
                    string = objectMessage.getStringProperty("JMQLocaleVariant");
                    object = new Locale(string2, (String)object2, string);
                    bridgeManagerResources = BridgeServiceManagerImpl.getBridgeManagerResources((Locale)object);
                }
                catch (Exception exception) {
                    bridgeManagerResources = this._br;
                    object2 = "Unable to get locale information: " + exception.toString() + ", from bridge admin message " + objectMessage.toString();
                    this._bc.logWarn((String)object2, null);
                }
                string2 = objectMessage.getJMSDestination();
                if (!(string2 instanceof Queue)) {
                    throw new BridgeException("Received bridge admin message from non-queue destination: " + string2);
                }
                if (!((Queue)string2).getQueueName().equals(this._bsm.getAdminDestinationName())) {
                    throw new BridgeException("Received bridge admin message from unexpected destination: " + string2);
                }
                try {
                    n = objectMessage.getIntProperty("JMQMessageType");
                }
                catch (Exception exception) {
                    n = 30;
                    string = "Unexpected exception in processing bridge admin message " + objectMessage.toString();
                    this._bc.logError(string, exception);
                    throw new BridgeException(string, exception);
                }
                object2 = null;
                try {
                    object2 = this._handlers[n];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    object = "Unexpected admin message type " + AdminMessageType.getString(n);
                    throw new BridgeException((String)object);
                }
                if (object2 == null) {
                    string = "No bridge admin handler for message type " + AdminMessageType.getString(n);
                    throw new BridgeException(string);
                }
                objectMessage2.setIntProperty("JMQMessageType", ++n);
                ((AdminCmdHandler)object2).handle(session, objectMessage, objectMessage2, bridgeManagerResources);
            }
            catch (Throwable throwable) {
                int n2 = 500;
                if (throwable instanceof BridgeException) {
                    BridgeException bridgeException = (BridgeException)throwable;
                    n2 = bridgeException.getStatus();
                    if (bridgeException.getCause() == null) {
                        this._bc.logError(throwable.getMessage(), null);
                    }
                } else {
                    this._bc.logError(throwable.getMessage(), throwable);
                }
                if (DEBUG) {
                    this._bc.logInfo("BridgeAdminMessageHandler exception: " + throwable.getMessage() + (objectMessage2 == null ? "no reply created" : "sending error reply"), throwable);
                }
                if (objectMessage2 == null) break block16;
                this.sendReply(session, (Message)objectMessage, objectMessage2, n2, AdminCmdHandler.getMessageFromThrowable(throwable), bridgeManagerResources);
            }
        }
    }

    private void initHandlers() {
        this._handlers = new AdminCmdHandler[30];
        this._handlers[18] = new ListHandler(this, this._bsm);
        this._handlers[20] = new PauseHandler(this, this._bsm);
        this._handlers[22] = new ResumeHandler(this, this._bsm);
        this._handlers[24] = new StartHandler(this, this._bsm);
        this._handlers[26] = new StopHandler(this, this._bsm);
        this._handlers[28] = new HelloHandler(this, this._bsm);
        this._handlers[16] = new DebugHandler(this, this._bsm);
    }

    public void sendReply(Session session, Message message, ObjectMessage objectMessage, int n, String string, BridgeManagerResources bridgeManagerResources) {
        ObjectMessage objectMessage2 = objectMessage;
        try {
            Destination destination = message.getJMSReplyTo();
            if (destination == null) {
                this._bc.logError("Bridge admin message has no JMSReplyTo destination. Not replying.", null);
                return;
            }
            if (objectMessage2 == null) {
                objectMessage2 = session.createObjectMessage();
            }
            objectMessage2.setIntProperty("JMQStatus", n);
            if (string != null) {
                objectMessage2.setStringProperty("JMQErrorString", string);
            }
            MessageProducer messageProducer = session.createProducer(destination);
            messageProducer.send((Message)objectMessage2, 1, 4, 0L);
            if (DEBUG) {
                try {
                    this._bc.logInfo("BridgeAdminMessageHandler: sent REPLY\n>>>>****" + objectMessage2.toString() + "Body:" + objectMessage2.getObject(), null);
                }
                catch (Throwable throwable) {
                    this._bc.logWarn("Unexpected exception : " + throwable.getMessage(), throwable);
                }
            }
        }
        catch (Throwable throwable) {
            this._bc.logError("Unable to send reply " + objectMessage2.toString() + " for bridge admin message " + message, throwable);
        }
    }
}

