/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms;

import com.sun.messaging.bridge.service.Bridge;
import com.sun.messaging.bridge.service.BridgeCmdSharedReplyData;
import com.sun.messaging.bridge.service.BridgeContext;
import com.sun.messaging.bridge.service.BridgeException;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeImpl
implements Bridge {
    private final String _type = "JMS";
    private String _name = null;
    private Bridge.State _state = Bridge.State.STOPPED;
    private JMSBridge _jmsbridge = null;

    @Override
    public synchronized void start(BridgeContext bridgeContext, String[] stringArray) throws Exception {
        String string = this.parseLinkName(stringArray);
        if (string != null) {
            if (this._state != Bridge.State.STARTED) {
                throw new IllegalStateException("Link operation can only be operated when the bridge is in " + (Object)((Object)Bridge.State.STARTED) + " state");
            }
            this._jmsbridge.start(string);
            return;
        }
        if (this._state == Bridge.State.STARTED) {
            return;
        }
        this._state = Bridge.State.STARTING;
        boolean bl = false;
        try {
            this._jmsbridge = new JMSBridge();
            this._jmsbridge.init(bridgeContext, this._name, this.parseResetArg(stringArray));
            bl = true;
            this._jmsbridge.start(this.parseLinkName(stringArray));
            this._state = Bridge.State.STARTED;
        }
        catch (Exception exception) {
            try {
                this.stop(bridgeContext, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!bl) {
                this._jmsbridge = null;
                throw exception;
            }
            throw new BridgeException(exception.getMessage(), exception, 201);
        }
    }

    @Override
    public synchronized void pause(BridgeContext bridgeContext, String[] stringArray) throws Exception {
        String string = this.parseLinkName(stringArray);
        if (string != null) {
            if (this._state != Bridge.State.STARTED) {
                throw new IllegalStateException("Link operation can only be operated when the bridge is in " + (Object)((Object)Bridge.State.STARTED) + " state");
            }
            this._jmsbridge.pause(string);
            return;
        }
        if (this._state == Bridge.State.PAUSED) {
            return;
        }
        if (this._state != Bridge.State.STARTED) {
            throw new IllegalStateException("Can't pause bridge " + this.getName() + " in state " + (Object)((Object)this._state));
        }
        this._state = Bridge.State.PAUSING;
        try {
            this._jmsbridge.pause(this.parseLinkName(stringArray));
        }
        catch (Exception exception) {
            try {
                this._jmsbridge.stop(this.parseLinkName(stringArray));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw exception;
        }
        this._state = Bridge.State.PAUSED;
    }

    @Override
    public synchronized void resume(BridgeContext bridgeContext, String[] stringArray) throws Exception {
        String string = this.parseLinkName(stringArray);
        if (string != null) {
            if (this._state != Bridge.State.STARTED) {
                throw new IllegalStateException("Link operation can only be operated when the bridge is in " + (Object)((Object)Bridge.State.STARTED) + " state");
            }
            this._jmsbridge.resume(string);
            return;
        }
        if (this._state == Bridge.State.STARTED) {
            return;
        }
        if (this._state == Bridge.State.STOPPED) {
            throw new IllegalStateException("Can't pause bridge " + this.getName() + " in state " + (Object)((Object)this._state));
        }
        this._state = Bridge.State.RESUMING;
        try {
            this._jmsbridge.resume(this.parseLinkName(stringArray));
        }
        catch (Exception exception) {
            try {
                this._jmsbridge.stop(this.parseLinkName(stringArray));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw exception;
        }
        this._state = Bridge.State.STARTED;
    }

    @Override
    public synchronized void stop(BridgeContext bridgeContext, String[] stringArray) throws Exception {
        if (this._jmsbridge == null) {
            this._state = Bridge.State.STOPPED;
            throw new IllegalStateException("Bridge " + this.getName() + " not initialized");
        }
        String string = this.parseLinkName(stringArray);
        if (string != null) {
            if (this._state != Bridge.State.STARTED) {
                throw new IllegalStateException("Link operation can only be operated when the bridge is in " + (Object)((Object)Bridge.State.STARTED) + " state");
            }
            this._jmsbridge.stop(string);
            return;
        }
        if (this._state == Bridge.State.STOPPED) {
            return;
        }
        this._state = Bridge.State.STOPPING;
        this._jmsbridge.stop(this.parseLinkName(stringArray));
        this._state = Bridge.State.STOPPED;
    }

    @Override
    public ArrayList<BridgeCmdSharedReplyData> list(BridgeContext bridgeContext, String[] stringArray, ResourceBundle resourceBundle) throws Exception {
        JMSBridge jMSBridge = this._jmsbridge;
        if (jMSBridge == null) {
            throw new IllegalStateException("Bridge " + this.getName() + " not initialized");
        }
        ArrayList<BridgeCmdSharedReplyData> arrayList = new ArrayList<BridgeCmdSharedReplyData>();
        BridgeCmdSharedReplyData bridgeCmdSharedReplyData = new BridgeCmdSharedReplyData(4, 3, "-");
        Object[] objectArray = new String[]{resourceBundle.getString("BS1000"), resourceBundle.getString("BS1001"), resourceBundle.getString("BS1002"), resourceBundle.getString("BS1003")};
        bridgeCmdSharedReplyData.addTitle((String[])objectArray);
        objectArray[0] = this.getName();
        objectArray[1] = this.getType();
        objectArray[2] = this.getState().toString();
        objectArray[3] = String.valueOf(jMSBridge.getNumLinks());
        bridgeCmdSharedReplyData.add(objectArray);
        arrayList.add(bridgeCmdSharedReplyData);
        String string = this.parseLinkName(stringArray);
        boolean bl = this.parseDebugModeArg(stringArray);
        ArrayList<BridgeCmdSharedReplyData> arrayList2 = jMSBridge.list(string, resourceBundle, bl);
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    @Override
    public String getType() {
        return "JMS";
    }

    @Override
    public boolean isMultipliable() {
        return true;
    }

    @Override
    public void setName(String string) {
        this._name = string;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name + "[" + (Object)((Object)this._state) + "]";
    }

    @Override
    public Bridge.State getState() {
        return this._state;
    }

    @Override
    public Object getExportedService(String string, Properties properties) throws Exception {
        if (string == null) {
            throw new IllegalArgumentException("null class name");
        }
        if (properties == null) {
            throw new IllegalArgumentException("null props");
        }
        if (string.equals("com.sun.messaging.bridge.service.JMSBridgeStore")) {
            return JMSBridge.exportJMSBridgeStoreService(properties);
        }
        throw new IllegalArgumentException("Unexpected class name " + string);
    }

    private String parseLinkName(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-ln")) continue;
            return stringArray[++i];
        }
        return null;
    }

    private boolean parseResetArg(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-reset")) continue;
            return true;
        }
        return false;
    }

    private boolean parseDebugModeArg(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-debug")) continue;
            return true;
        }
        return false;
    }
}

