/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListener;
import com.sun.grizzly.ControllerStateListenerAdapter;
import com.sun.grizzly.DefaultProtocolChain;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.ProtocolParser;
import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.SSLSelectorHandler;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.filter.ParserProtocolFilter;
import com.sun.grizzly.util.AttributeHolder;
import com.sun.grizzly.util.ConnectionCloseHandler;
import com.sun.messaging.bridge.service.BridgeContext;
import com.sun.messaging.bridge.service.LogSimpleFormatter;
import com.sun.messaging.bridge.service.MessageTransformer;
import com.sun.messaging.bridge.service.stomp.StompProtocolFilter;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandler;
import com.sun.messaging.bridge.service.stomp.StompProtocolParser;
import java.io.File;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;
import javax.jms.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StompServer
implements ConnectionCloseHandler {
    private static final String PROP_TCPENABLED_SUFFIX = ".tcp.enabled";
    private static final String PROP_SSLENABLED_SUFFIX = ".tls.enabled";
    private static final String PROP_TCPPORT_SUFFIX = ".tcp.port";
    private static final String PROP_SSLPORT_SUFFIX = ".tls.port";
    private static final String PROP_SSL_REQUIRE_CLIENTAUTH_SUFFIX = ".tls.requireClientAuth";
    private static final String PROP_FLOWLIMIT_SUFFIX = ".consumerFlowLimit";
    private static final String PROP_MSGTRANSFORM_SUFFIX = ".messageTransformer";
    public static final int DEFAULT_TCPPORT = 7672;
    public static final int DEFAULT_SSLPORT = 7673;
    private static Logger _logger = null;
    private int TCPPORT = 7672;
    private int SSLPORT = 7673;
    private Controller controller = null;
    private static MessageTransformer<Message, Message> _msgTransformer = null;
    private ConnectionFactory jmscf;
    private BridgeContext _bc = null;
    private boolean _tcpEnabled = false;
    private boolean _sslEnabled = false;
    private boolean _inited = false;

    public synchronized void init(BridgeContext bridgeContext) throws Exception {
        Object object;
        BaseSelectionKeyHandler baseSelectionKeyHandler;
        String string;
        String string2;
        this._bc = bridgeContext;
        Properties properties = bridgeContext.getConfig();
        String string3 = properties.getProperty((string2 = properties.getProperty("BRIDGE_PROP_PREFIX")) + PROP_MSGTRANSFORM_SUFFIX);
        if (string3 != null) {
            _msgTransformer = (MessageTransformer)Class.forName(string3).newInstance();
        }
        Properties properties2 = new Properties();
        String string4 = properties.getProperty(string2 + PROP_FLOWLIMIT_SUFFIX);
        if (string4 != null) {
            properties2.setProperty("imqConsumerFlowLimit", String.valueOf(Integer.parseInt(string4)));
        }
        this.jmscf = bridgeContext.getConnectionFactory(properties2);
        _logger = Logger.getLogger(string2);
        String string5 = bridgeContext.getRootDir();
        File file = new File(string5);
        if (!file.exists()) {
            file.mkdirs();
        }
        String string6 = string5 + File.separator + "stomp%g.log";
        FileHandler fileHandler = new FileHandler(string6, true);
        fileHandler.setFormatter(new LogSimpleFormatter(_logger));
        _logger.addHandler(fileHandler);
        _logger.log(Level.INFO, "StompServer log domain: " + string2);
        _logger.log(Level.INFO, "StompServer log file: " + string6);
        Controller.setLogger((Logger)_logger);
        String string7 = properties.getProperty(string2 + PROP_TCPENABLED_SUFFIX, "true");
        if (string7 != null && Boolean.valueOf(string7).booleanValue()) {
            string = properties.getProperty(string2 + PROP_TCPPORT_SUFFIX, String.valueOf(7672));
            this.TCPPORT = Integer.parseInt(string);
            this._tcpEnabled = true;
        }
        if ((string7 = properties.getProperty(string2 + PROP_SSLENABLED_SUFFIX, "false")) != null && Boolean.valueOf(string7).booleanValue()) {
            string = properties.getProperty(string2 + PROP_SSLPORT_SUFFIX, String.valueOf(7673));
            this.SSLPORT = Integer.parseInt(string);
            this._sslEnabled = true;
        }
        if (!this._tcpEnabled && !this._sslEnabled) {
            throw new IllegalArgumentException("No protocol enabled");
        }
        this.controller = new Controller();
        if (this._tcpEnabled) {
            string = new TCPSelectorHandler();
            baseSelectionKeyHandler = new BaseSelectionKeyHandler();
            baseSelectionKeyHandler.setConnectionCloseHandler((ConnectionCloseHandler)this);
            string.setSelectionKeyHandler((SelectionKeyHandler)baseSelectionKeyHandler);
            string.setPort(this.TCPPORT);
            this.controller.addSelectorHandler((SelectorHandler)string);
            object = new DefaultProtocolChain();
            object.setContinuousExecution(true);
            this.setProtocolChain((SelectorHandler)string, (ProtocolChain)object, null);
        }
        if (this._sslEnabled) {
            _logger.log(Level.INFO, "Initialize SSL/TLS transport ...");
            string = new SSLSelectorHandler();
            baseSelectionKeyHandler = new BaseSelectionKeyHandler();
            baseSelectionKeyHandler.setConnectionCloseHandler((ConnectionCloseHandler)this);
            string.setSelectionKeyHandler((SelectionKeyHandler)baseSelectionKeyHandler);
            string.setPort(this.SSLPORT);
            this.controller.addSelectorHandler((SelectorHandler)string);
            object = this._bc.getDefaultSSLContextConfig();
            SSLConfig sSLConfig = new SSLConfig(false);
            sSLConfig.setKeyStoreFile(((Properties)object).getProperty("javax.net.ssl.keyStore"));
            sSLConfig.setKeyStorePass(((Properties)object).getProperty("javax.net.ssl.trustStorePassword"));
            sSLConfig.setKeyStoreType(((Properties)object).getProperty("javax.net.ssl.keyStoreType"));
            sSLConfig.setKeyManagerFactoryAlgorithm(((Properties)object).getProperty("ssl.KeyManagerFactory.algorithm"));
            sSLConfig.setTrustStoreFile(((Properties)object).getProperty("javax.net.ssl.trustStore"));
            sSLConfig.setTrustStorePass(((Properties)object).getProperty("javax.net.ssl.trustStorePassword"));
            sSLConfig.setTrustStoreType(((Properties)object).getProperty("javax.net.ssl.trustStoreType"));
            sSLConfig.setTrustManagerFactoryAlgorithm(((Properties)object).getProperty("ssl.TrustManagerFactory.algorithm"));
            sSLConfig.setSecurityProtocol(((Properties)object).getProperty("securesocket.protocol"));
            string7 = properties.getProperty(string2 + PROP_SSL_REQUIRE_CLIENTAUTH_SUFFIX, "false");
            if (string7 != null && Boolean.valueOf(string7).booleanValue()) {
                sSLConfig.setNeedClientAuth(true);
            }
            DefaultProtocolChain defaultProtocolChain = new DefaultProtocolChain();
            defaultProtocolChain.setContinuousExecution(true);
            this.setProtocolChain((SelectorHandler)string, (ProtocolChain)defaultProtocolChain, sSLConfig);
        }
        if (this._tcpEnabled) {
            this._bc.registerService("stomp[TCP]", "stomp", this.TCPPORT, null);
        }
        if (this._sslEnabled) {
            this._bc.registerService("stomp[SSL/TLS]", "stomp", this.SSLPORT, null);
        }
        this._inited = true;
    }

    private void setProtocolChain(SelectorHandler selectorHandler, final ProtocolChain protocolChain, SSLConfig sSLConfig) throws Exception {
        ParserProtocolFilter parserProtocolFilter = new ParserProtocolFilter(){

            public ProtocolParser newProtocolParser() {
                StompProtocolParser stompProtocolParser = new StompProtocolParser(StompServer.this._bc);
                return stompProtocolParser;
            }
        };
        if (sSLConfig != null) {
            parserProtocolFilter.setSSLConfig(sSLConfig);
        }
        protocolChain.addFilter((ProtocolFilter)parserProtocolFilter);
        protocolChain.addFilter((ProtocolFilter)new StompProtocolFilter(this.jmscf, this._bc));
        selectorHandler.setProtocolChainInstanceHandler(new ProtocolChainInstanceHandler(){

            public ProtocolChain poll() {
                return protocolChain;
            }

            public boolean offer(ProtocolChain protocolChain2) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "ProtocolChain.offer(): return false");
                }
                return false;
            }
        });
    }

    public synchronized void start() {
        if (!this._inited) {
            _logger.log(Level.SEVERE, "StompServer has been not initialized !");
            throw new IllegalStateException("StompServer has not been initialized");
        }
        if (this._tcpEnabled) {
            _logger.log(Level.INFO, "Starting StompServer TCP transport on port " + this.TCPPORT);
        }
        if (this._sslEnabled) {
            _logger.log(Level.INFO, "Starting StompServer SSL/TLS transport on port " + this.SSLPORT);
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        this.controller.addStateListener((ControllerStateListener)new ControllerStateListenerAdapter(){

            public void onReady() {
                countDownLatch.countDown();
            }

            public void onException(Throwable throwable) {
                if (countDownLatch.getCount() > 0L) {
                    _logger.log(Level.SEVERE, "StompServer: Exception in starting the controller", throwable);
                    countDownLatch.countDown();
                } else {
                    _logger.log(Level.SEVERE, "StompServer: Exception in controller processing", throwable);
                }
            }
        });
        new Thread((Runnable)this.controller).start();
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            _logger.log(Level.WARNING, "Waiting for StompServer to start is interrupted:" + interruptedException.getMessage());
        }
        if (!this.controller.isStarted()) {
            throw new IllegalStateException("StompServer failed to started");
        }
        _logger.log(Level.INFO, "StompServer has been started successfully.");
    }

    public synchronized void stop() {
        if (!this._inited) {
            _logger.log(Level.SEVERE, "StompServer has been not initialized !");
            throw new IllegalStateException("StompServer has not been initialized");
        }
        _logger.log(Level.INFO, "Stopping StompServer ...");
        try {
            this.controller.stop();
        }
        catch (IOException iOException) {
            _logger.log(Level.WARNING, "Got exception in stopping StompServer: " + iOException.getMessage());
            iOException.printStackTrace();
        }
        _logger.log(Level.INFO, "StompServer has been stopped.");
    }

    protected static Logger getLogger() {
        return _logger;
    }

    protected static MessageTransformer<Message, Message> getMessageTransformer() {
        return _msgTransformer;
    }

    public void locallyClosed(SelectionKey selectionKey) {
        AttributeHolder attributeHolder;
        StompProtocolHandler stompProtocolHandler;
        _logger.log(Level.INFO, "Notified selection key " + selectionKey + " locally closed");
        Object object = selectionKey.attachment();
        if (selectionKey == null) {
            return;
        }
        if (object instanceof AttributeHolder && (stompProtocolHandler = (StompProtocolHandler)(attributeHolder = (AttributeHolder)object).getAttribute("stomp-protocol-handler")) != null) {
            _logger.log(Level.INFO, "Closing stomp protocol handler " + stompProtocolHandler + " for selection key " + selectionKey);
            stompProtocolHandler.close(true);
        }
    }

    public void remotlyClosed(SelectionKey selectionKey) {
        AttributeHolder attributeHolder;
        StompProtocolHandler stompProtocolHandler;
        _logger.log(Level.INFO, "Notified selection key " + selectionKey + " remotely closed");
        if (selectionKey == null) {
            return;
        }
        Object object = selectionKey.attachment();
        if (object instanceof AttributeHolder && (stompProtocolHandler = (StompProtocolHandler)(attributeHolder = (AttributeHolder)object).getAttribute("stomp-protocol-handler")) != null) {
            _logger.log(Level.INFO, "Closing stomp protocol handler " + stompProtocolHandler + " for selection key " + selectionKey);
            stompProtocolHandler.close(true);
        }
    }
}

