/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.service.stomp.StompConnection;
import com.sun.messaging.bridge.service.stomp.StompFrameMessage;
import com.sun.messaging.bridge.service.stomp.StompOutputHandler;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandler;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;

public class StompSubscriberSession
implements MessageListener {
    public Logger _logger = StompServer.getLogger();
    private String _subid = null;
    private Session _session = null;
    private MessageConsumer _subscriber = null;
    private StompOutputHandler _out = null;
    private ArrayList<Message> _unacked = new ArrayList();
    private String _duraName = null;
    private StompConnection _stompc;

    public StompSubscriberSession(String string, int n, StompConnection stompConnection) throws Exception {
        this._stompc = stompConnection;
        this._subid = string;
        this._session = stompConnection.getConnection().createSession(false, n);
    }

    public void createSubscriber(Destination destination, String string, String string2, boolean bl, StompOutputHandler stompOutputHandler) throws Exception {
        if (this._subscriber != null) {
            throw new IllegalStateException("createSubscriber(): Unexpected call");
        }
        if (destination instanceof Queue) {
            this._subscriber = this._session.createConsumer(destination, string);
        } else if (string2 != null) {
            this._subscriber = this._session.createDurableSubscriber((Topic)destination, string2, string, bl);
            this._duraName = string2;
        } else {
            this._subscriber = this._session.createConsumer(destination, string, bl);
        }
        this._subscriber.setMessageListener(this);
        this._out = stompOutputHandler;
    }

    public void closeSubscriber() throws Exception {
        if (this._subscriber != null) {
            this._subscriber.close();
        }
    }

    public Session getJMSSession() {
        return this._session;
    }

    public String getDuraName() {
        return this._duraName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            if (this._session.getAcknowledgeMode() == 2) {
                ArrayList<Message> arrayList = this._unacked;
                synchronized (arrayList) {
                    this._unacked.add(message);
                }
            }
            this._out.sendToClient(this._stompc.toStompFrameMessage(message, this._subid, this._session));
        }
        catch (Throwable throwable) {
            if (throwable instanceof ClosedChannelException) {
                this._logger.log(Level.WARNING, "Unable to deliver message to subscription[" + this._subid + "]: channel closed - " + throwable.getMessage());
                return;
            }
            this._logger.log(Level.WARNING, "Unable to deliver message to subscription[" + this._subid + "]: " + throwable.getMessage(), throwable);
            StompFrameMessage stompFrameMessage = null;
            try {
                stompFrameMessage = StompProtocolHandler.toStompErrorMessage("Subscriber[" + this._subid + "].onMessage", throwable);
            }
            catch (Throwable throwable2) {
                this._logger.log(Level.WARNING, "Unable to make error message: " + throwable2.getMessage(), throwable2);
                return;
            }
            try {
                this._out.sendToClient(stompFrameMessage);
            }
            catch (Throwable throwable3) {
                if (throwable3 instanceof ClosedChannelException) {
                    this._logger.log(Level.WARNING, "Unable to send error message: channel closed -" + throwable3.getMessage());
                    return;
                }
                this._logger.log(Level.WARNING, "Unable to send error message: " + throwable3.getMessage(), throwable3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(String string) throws Exception {
        if (this._session.getAcknowledgeMode() != 2) {
            throw new JMSException("Ack a message[" + string + "] in subscriber[" + this._subid + "] that is not client ack mode");
        }
        ArrayList<Message> arrayList = this._unacked;
        synchronized (arrayList) {
            Message message = null;
            int n = this._unacked.size() - 1;
            boolean bl = false;
            int n2 = 0;
            for (n2 = n; n2 >= 0; --n2) {
                message = this._unacked.get(n2);
                if (!string.equals(message.getJMSMessageID())) continue;
                ((MessageImpl)message).acknowledgeUpThroughThisMessage();
                bl = true;
                break;
            }
            if (bl) {
                for (int i = 0; i <= n2; ++i) {
                    this._unacked.remove(0);
                }
                return;
            }
        }
        throw new JMSException("Ack a message[" + string + "] that is not found in subscriber[" + this._subid + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        try {
            this._subscriber.close();
        }
        catch (Exception exception) {
            try {
                this._session.close();
            }
            finally {
                ArrayList<Message> arrayList = this._unacked;
                synchronized (arrayList) {
                    this._unacked.clear();
                }
            }
        }
        finally {
            try {
                this._session.close();
            }
            finally {
                ArrayList<Message> arrayList = this._unacked;
                synchronized (arrayList) {
                    this._unacked.clear();
                }
            }
        }
    }
}

