/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.async.AsyncQueueWriteUnit;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.util.AttributeHolder;
import com.sun.grizzly.util.SSLOutputWriter;
import com.sun.grizzly.util.WorkerThread;
import com.sun.messaging.bridge.service.BridgeContext;
import com.sun.messaging.bridge.service.stomp.AsyncStompOutputHandler;
import com.sun.messaging.bridge.service.stomp.StompFrameMessage;
import com.sun.messaging.bridge.service.stomp.StompOutputHandler;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;
import javax.net.ssl.SSLEngine;

public class StompProtocolFilter
implements ProtocolFilter,
StompOutputHandler {
    protected static final String STOMP_PROTOCOL_HANDLER_ATTR = "stomp-protocol-handler";
    private static Logger _logger = Controller.logger();
    private ConnectionFactory _jmscf = null;
    private BridgeContext _bc = null;

    public StompProtocolFilter(ConnectionFactory connectionFactory, BridgeContext bridgeContext) {
        this._jmscf = connectionFactory;
        this._bc = bridgeContext;
    }

    public boolean execute(Context context) throws IOException {
        StompProtocolHandler stompProtocolHandler = null;
        try {
            stompProtocolHandler = this.getStompProtocolHandler(context);
            StompFrameMessage stompFrameMessage = (StompFrameMessage)context.removeAttribute("ProtocolMessage");
            switch (stompFrameMessage.getCommand()) {
                case CONNECT: {
                    stompProtocolHandler.onCONNECT(stompFrameMessage, this, context);
                    break;
                }
                case SEND: {
                    stompProtocolHandler.onSEND(stompFrameMessage, this, context);
                    break;
                }
                case SUBSCRIBE: {
                    AsyncStompOutputHandler asyncStompOutputHandler = new AsyncStompOutputHandler(context.getSelectionKey(), context.getSelectorHandler(), ((WorkerThread)Thread.currentThread()).getSSLEngine(), stompProtocolHandler, this._bc);
                    stompProtocolHandler.onSUBSCRIBE(stompFrameMessage, this, context, asyncStompOutputHandler);
                    break;
                }
                case UNSUBSCRIBE: {
                    stompProtocolHandler.onUNSUBSCRIBE(stompFrameMessage, this, context);
                    break;
                }
                case BEGIN: {
                    stompProtocolHandler.onBEGIN(stompFrameMessage, this, context);
                    break;
                }
                case COMMIT: {
                    stompProtocolHandler.onCOMMIT(stompFrameMessage, this, context);
                    break;
                }
                case ABORT: {
                    stompProtocolHandler.onABORT(stompFrameMessage, this, context);
                    break;
                }
                case ACK: {
                    stompProtocolHandler.onACK(stompFrameMessage, this, context);
                    break;
                }
                case DISCONNECT: {
                    stompProtocolHandler.onDISCONNECT(stompFrameMessage, this, context);
                    break;
                }
                case ERROR: {
                    this.sendToClient(stompFrameMessage, context, stompProtocolHandler);
                    break;
                }
                default: {
                    throw new IOException("Internal Error: unexpected STOMP frame " + (Object)((Object)stompFrameMessage.getCommand()));
                }
            }
        }
        catch (Throwable throwable) {
            try {
                StompFrameMessage stompFrameMessage = StompProtocolHandler.toStompErrorMessage("StompProtocolFilter", throwable);
                this.sendToClient(stompFrameMessage, context, stompProtocolHandler);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "Unable to create stomp error message for exception:" + throwable.getMessage(), throwable);
            }
        }
        return false;
    }

    public void sendToClient(StompFrameMessage stompFrameMessage) throws Exception {
        throw new UnsupportedOperationException("sendToclient(msg)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToClient(final StompFrameMessage stompFrameMessage, final Context context, StompProtocolHandler stompProtocolHandler) throws Exception {
        block11: {
            try {
                boolean bl = false;
                if (stompFrameMessage.getCommand() == StompFrameMessage.Command.ERROR && stompFrameMessage.isFatalERROR()) {
                    bl = true;
                }
                SSLEngine sSLEngine = ((WorkerThread)Thread.currentThread()).getSSLEngine();
                ByteBuffer byteBuffer = stompFrameMessage.marshall();
                if (sSLEngine == null) {
                    if (!bl) {
                        context.getAsyncQueueWritable().writeToAsyncQueue(byteBuffer);
                    } else {
                        AsyncWriteCallbackHandler asyncWriteCallbackHandler = new AsyncWriteCallbackHandler(){

                            public void onWriteCompleted(SelectionKey selectionKey, AsyncQueueWriteUnit asyncQueueWriteUnit) {
                                _logger.log(Level.FINE, "Completed sending " + stompFrameMessage + ", canceling key " + selectionKey);
                                context.getSelectorHandler().getSelectionKeyHandler().cancel(selectionKey);
                            }

                            public void onException(Exception exception, SelectionKey selectionKey, ByteBuffer byteBuffer, Queue<AsyncQueueWriteUnit> queue) {
                            }
                        };
                        context.getAsyncQueueWritable().writeToAsyncQueue(byteBuffer, asyncWriteCallbackHandler);
                    }
                    break block11;
                }
                SelectableChannel selectableChannel = context.getSelectionKey().channel();
                Object object = selectableChannel;
                synchronized (object) {
                    SSLOutputWriter.flushChannel((SelectableChannel)selectableChannel, (ByteBuffer)byteBuffer);
                }
                if (bl) {
                    object = context.getSelectionKey();
                    _logger.log(Level.INFO, "Sent " + stompFrameMessage + ", canceling selection key " + object);
                    context.getSelectorHandler().getSelectionKeyHandler().cancel((SelectionKey)object);
                }
            }
            catch (ClosedChannelException closedChannelException) {
                _logger.log(Level.WARNING, "Unable to send message " + stompFrameMessage + ": " + closedChannelException.toString());
                if (stompProtocolHandler != null) {
                    stompProtocolHandler.close(false);
                }
                throw closedChannelException;
            }
        }
    }

    public boolean postExecute(Context context) throws IOException {
        return true;
    }

    private StompProtocolHandler getStompProtocolHandler(Context context) {
        StompProtocolHandler stompProtocolHandler = null;
        AttributeHolder attributeHolder = context.getAttributeHolderByScope(Context.AttributeScope.CONNECTION);
        if (attributeHolder == null) {
            WorkerThread workerThread = (WorkerThread)Thread.currentThread();
            attributeHolder = workerThread.getAttachment();
            context.getSelectionKey().attach(attributeHolder);
        }
        if ((stompProtocolHandler = (StompProtocolHandler)attributeHolder.getAttribute(STOMP_PROTOCOL_HANDLER_ATTR)) == null) {
            stompProtocolHandler = new StompProtocolHandler(this._jmscf);
            attributeHolder.setAttribute(STOMP_PROTOCOL_HANDLER_ATTR, (Object)stompProtocolHandler);
        }
        return stompProtocolHandler;
    }
}

