/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.handlers.DataHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.CompactDestinationHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.CreateDestinationHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.DebugHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.DeleteMessageHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.DestroyConnectionsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.DestroyDestinationHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.DestroyDurableHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetBrokerPropsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetClusterHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetConnectionsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetConsumersHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetDestinationsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetDurablesHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetJMXConnectorsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetLogsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetMessagesHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetMetricsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetServicesHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetTransactionsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.HelloHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.PauseHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.PurgeDestinationHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.PurgeDurableHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.QuiesceHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ReloadClusterHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ReplaceMessageHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ResetMetricsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ResumeHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.RollbackCommitHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ShutdownHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.TakeoverHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.UnquiesceHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.UpdateBrokerPropsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.UpdateDestinationHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.UpdateServiceHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ViewLogHandler;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.admin.MessageType;
import java.io.IOException;
import java.util.Hashtable;

public class AdminDataHandler
extends DataHandler {
    private static boolean DEBUG = AdminDataHandler.getDEBUG();
    private AdminCmdHandler[] handlers = null;
    private BrokerResources rb = Globals.getBrokerResources();
    protected TransactionList tl = null;
    public PacketRouter adminPktRtr = null;
    private int activeHandlers = 0;

    public AdminDataHandler(TransactionList transactionList) {
        super(transactionList);
        this.tl = transactionList;
        this.initHandlers();
    }

    public void setPacketRouter(PacketRouter packetRouter) {
        this.adminPktRtr = packetRouter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        int n;
        Object object;
        Hashtable hashtable;
        block27: {
            Integer n2;
            block26: {
                block25: {
                    if (DEBUG) {
                        this.logger.log(2, "AdminDataHandler: handle() [ Received JMS Admin Message] {0} ", packet.toString());
                        if (this.logger.level >= 1) {
                            packet.dump(System.out);
                        }
                    }
                    String string = packet.getDestination();
                    if (!packet.getIsQueue() || !string.equals("__JMQAdmin") && !string.equals("__JMQBridgeAdmin")) {
                        return super.handle(iMQConnection, packet);
                    }
                    boolean bl = false;
                    if (string.equals("__JMQBridgeAdmin")) {
                        if (DEBUG) {
                            this.logger.log(8, "Received bridge admin message");
                        }
                        bl = true;
                    }
                    hashtable = null;
                    n2 = null;
                    try {
                        hashtable = packet.getProperties();
                        n2 = (Integer)hashtable.get("JMQMessageType");
                    }
                    catch (Exception exception) {
                        String string2 = this.rb.getString("B3100", "Admin: Could not extract properties from pkt");
                        this.logger.log(16, string2, exception);
                        throw new BrokerException(string2, exception);
                    }
                    if (hashtable == null || n2 == null) {
                        String string3 = this.rb.getString("B3100", "Message received on administration destination " + string + " has no " + "JMQMessageType" + " property ignoring it.");
                        this.logger.log(16, string3);
                        throw new BrokerException(string3);
                    }
                    if (bl && n2 != 28) {
                        return super.handle(iMQConnection, packet);
                    }
                    if (packet.getSendAcknowledge()) {
                        Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
                        packet2.setPacketType(9);
                        packet2.setConsumerID(packet.getConsumerID());
                        object = new Hashtable<String, Integer>();
                        ((Hashtable)object).put("JMQStatus", new Integer(200));
                        packet2.setProperties((Hashtable)object);
                        iMQConnection.sendControlMessage(packet2);
                    }
                    n = n2;
                    object = null;
                    if (iMQConnection.getAccessController().isRestrictedAdmin() && n != 38 && n != 28 && n != 34) {
                        this.logger.log(16, "B2050", MessageType.getString(n));
                        Packet packet3 = new Packet(iMQConnection.useDirectBuffers());
                        packet3.setPacketType(5);
                        AdminCmdHandler.setProperties(packet3, n + 1, 403, null);
                        this.sendReply(iMQConnection, packet, packet3);
                        return true;
                    }
                    if (n != 38) {
                        this.incrementActiveHandlers();
                    }
                    try {
                        if (!BrokerStateHandler.shuttingDown) break block25;
                        String string4 = Globals.getBrokerResources().getKString("B1156", MessageType.getString(n));
                        this.logger.log(16, string4);
                        Packet packet4 = new Packet(iMQConnection.useDirectBuffers());
                        packet4.setPacketType(5);
                        AdminCmdHandler.setProperties(packet4, n + 1, 503, string4);
                        this.sendReply(iMQConnection, packet, packet4);
                        boolean bl2 = true;
                        Object var13_24 = null;
                        if (n != 38) {
                            this.decrementActiveHandlers();
                        }
                        return bl2;
                    }
                    catch (Throwable throwable) {
                        block28: {
                            Object var13_29 = null;
                            if (n == 38) break block28;
                            this.decrementActiveHandlers();
                        }
                        throw throwable;
                    }
                }
                if (Broker.getBroker().startupComplete) break block26;
                String string = Globals.getBrokerResources().getKString("B1155", MessageType.getString(n));
                this.logger.log(16, string);
                Packet packet5 = new Packet(iMQConnection.useDirectBuffers());
                packet5.setPacketType(5);
                AdminCmdHandler.setProperties(packet5, n + 1, 503, string);
                this.sendReply(iMQConnection, packet, packet5);
                boolean bl = true;
                Object var13_25 = null;
                if (n != 38) {
                    this.decrementActiveHandlers();
                }
                return bl;
            }
            try {
                object = this.handlers[n];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.logger.log(32, "B3100", "Bad JMQMessageType: " + n);
                boolean bl = true;
                Object var13_26 = null;
                if (n != 38) {
                    this.decrementActiveHandlers();
                }
                return bl;
            }
            if (object != null) break block27;
            this.logger.log(32, "B3100", "No administration handler found for message type " + n2 + ". Ignoring.");
            boolean bl = true;
            Object var13_27 = null;
            if (n != 38) {
                this.decrementActiveHandlers();
            }
            return bl;
        }
        boolean bl = ((AdminCmdHandler)object).handle(iMQConnection, packet, hashtable);
        Object var13_28 = null;
        if (n != 38) {
            this.decrementActiveHandlers();
        }
        return bl;
    }

    private void initHandlers() {
        this.handlers = new AdminCmdHandler[92];
        this.handlers[10] = new CreateDestinationHandler(this);
        this.handlers[70] = new DestroyConnectionsHandler(this);
        this.handlers[12] = new DestroyDestinationHandler(this);
        this.handlers[14] = new DestroyDurableHandler(this);
        this.handlers[16] = new GetConnectionsHandler(this);
        this.handlers[18] = new GetConsumersHandler(this);
        this.handlers[20] = new GetDestinationsHandler(this);
        this.handlers[22] = new GetDurablesHandler(this);
        this.handlers[24] = new GetLogsHandler(this);
        this.handlers[26] = new GetServicesHandler(this);
        this.handlers[28] = new HelloHandler(this);
        this.handlers[30] = new PauseHandler(this);
        this.handlers[32] = new PurgeDestinationHandler(this);
        this.handlers[36] = new ResumeHandler(this);
        this.handlers[38] = new ShutdownHandler(this);
        this.handlers[40] = new UpdateDestinationHandler(this);
        this.handlers[46] = new UpdateServiceHandler(this);
        this.handlers[44] = new ViewLogHandler(this);
        this.handlers[52] = new GetMetricsHandler(this);
        this.handlers[54] = new GetBrokerPropsHandler(this);
        this.handlers[56] = new UpdateBrokerPropsHandler(this);
        this.handlers[58] = new ReloadClusterHandler(this);
        this.handlers[60] = new GetTransactionsHandler(this);
        this.handlers[64] = new RollbackCommitHandler(this);
        this.handlers[62] = new RollbackCommitHandler(this);
        this.handlers[66] = new PurgeDurableHandler(this);
        this.handlers[68] = new CompactDestinationHandler(this);
        this.handlers[72] = new DebugHandler(this);
        this.handlers[74] = new QuiesceHandler(this);
        this.handlers[76] = new TakeoverHandler(this);
        this.handlers[78] = new GetClusterHandler(this);
        this.handlers[80] = new GetJMXConnectorsHandler(this);
        this.handlers[82] = new UnquiesceHandler(this);
        this.handlers[84] = new ResetMetricsHandler(this);
        this.handlers[86] = new GetMessagesHandler(this);
        this.handlers[88] = new DeleteMessageHandler(this);
        this.handlers[90] = new ReplaceMessageHandler(this);
    }

    public void sendReply(IMQConnection iMQConnection, Packet packet, Packet packet2) {
        String string = packet.getReplyTo();
        if (string == null) {
            this.logger.log(32, "B3100", "Administration message has no ReplyTo destination. Not replying.");
            return;
        }
        packet2.setDestination(string);
        packet2.setIsQueue(true);
        packet2.setPersistent(false);
        packet2.setTransactionID(0L);
        packet2.setSendAcknowledge(false);
        if (iMQConnection instanceof IMQBasicConnection) {
            packet2.setPort(((IMQBasicConnection)iMQConnection).getLocalPort());
        }
        packet2.setIP(Globals.getBrokerInetAddress().getAddress());
        packet2.updateTimestamp();
        packet2.updateSequenceNumber();
        packet2.generateTimestamp(false);
        packet2.generateSequenceNumber(false);
        if (DEBUG) {
            try {
                this.logger.log(4, "AdminDataHandler: REPLY: " + packet2 + ": " + packet2.getProperties());
            }
            catch (IOException iOException) {
                this.logger.log(16, "B3100", (Object)"Admin: Could not extract properties from pkt", (Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logger.log(16, "B3100", (Object)"Admin: Could not extract properties from pkt", (Throwable)classNotFoundException);
            }
        }
        try {
            super.handle(iMQConnection, packet2, true);
        }
        catch (BrokerException brokerException) {
            this.logger.log(32, "B3100", (Object)"Could not reply to administrative message.", (Throwable)brokerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementActiveHandlers() {
        AdminDataHandler adminDataHandler = this;
        synchronized (adminDataHandler) {
            ++this.activeHandlers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementActiveHandlers() {
        AdminDataHandler adminDataHandler = this;
        synchronized (adminDataHandler) {
            --this.activeHandlers;
            if (this.activeHandlers == 0) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForHandlersToComplete(int n) {
        AdminDataHandler adminDataHandler = this;
        synchronized (adminDataHandler) {
            try {
                if (this.activeHandlers > 0) {
                    this.wait(n * 1000);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

