/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.ComplexSelectorHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.ConnectorHandlerPool;
import com.sun.grizzly.Context;
import com.sun.grizzly.ControllerStateListener;
import com.sun.grizzly.ControllerStateListenerAdapter;
import com.sun.grizzly.DefaultConnectorHandlerPool;
import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.DefaultSelectionKeyHandler;
import com.sun.grizzly.Handler;
import com.sun.grizzly.Lifecycle;
import com.sun.grizzly.NIOContext;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ReadController;
import com.sun.grizzly.RoundRobinSelectorHandler;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.SelectorHandlerRunner;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.util.AttributeHolder;
import com.sun.grizzly.util.Cloner;
import com.sun.grizzly.util.ConcurrentLinkedQueuePool;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.DefaultThreadPool;
import com.sun.grizzly.util.LinkedTransferQueue;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.SelectedKeyAttachmentLogic;
import com.sun.grizzly.util.State;
import com.sun.grizzly.util.StateHolder;
import com.sun.grizzly.util.SupportStateHolder;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller
implements Runnable,
Lifecycle,
Copyable,
ConnectorHandlerPool,
AttributeHolder,
SupportStateHolder<State> {
    private ConcurrentLinkedQueuePool<NIOContext> contexts;
    protected ProtocolChainInstanceHandler instanceHandler;
    protected SelectionKeyHandler selectionKeyHandler;
    protected ComplexSelectorHandler multiReadThreadSelectorHandler = null;
    protected ConnectorHandlerPool connectorHandlerPool = null;
    protected LinkedTransferQueue<SelectorHandler> selectorHandlers;
    protected StateHolder<State> stateHolder;
    protected int readThreadsCount = 0;
    protected ReadController[] readThreadControllers;
    protected static Logger logger = Logger.getLogger("grizzly");
    protected ExecutorService threadPool;
    protected final Collection<ControllerStateListener> stateListeners = new LinkedTransferQueue<ControllerStateListener>();
    protected AtomicInteger readySelectorHandlerCounter;
    protected AtomicInteger stoppedSelectorHandlerCounter;
    private boolean handleReadWriteConcurrently = true;
    protected Map<String, Object> attributes;
    private static final LinkedTransferQueue<Controller> controllers = new LinkedTransferQueue();

    public Controller() {
        this.contexts = new ConcurrentLinkedQueuePool<NIOContext>(){

            @Override
            public NIOContext newInstance() {
                return new NIOContext();
            }
        };
        this.stateHolder = new StateHolder(true);
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        if (this.threadPool == null) {
            this.threadPool = new DefaultThreadPool();
        }
        if (this.instanceHandler == null) {
            this.instanceHandler = new DefaultProtocolChainInstanceHandler();
        }
        if (this.selectorHandlers == null) {
            this.selectorHandlers = new LinkedTransferQueue();
        }
        if (this.connectorHandlerPool == null) {
            this.connectorHandlerPool = new DefaultConnectorHandlerPool(this);
        }
        controllers.add(this);
    }

    protected void doSelect(SelectorHandler selectorHandler, NIOContext serverCtx) {
        try {
            if (selectorHandler.getSelectionKeyHandler() == null) {
                this.initSelectionKeyHandler(selectorHandler);
            }
            selectorHandler.preSelect(serverCtx);
            Set<SelectionKey> readyKeys = selectorHandler.select(serverCtx);
            if (readyKeys.size() != 0) {
                this.handleSelectedKeys(readyKeys, selectorHandler, serverCtx);
                readyKeys.clear();
            }
            selectorHandler.postSelect(serverCtx);
        }
        catch (Throwable e) {
            this.handleSelectException(e, selectorHandler, null);
        }
    }

    private void initSelectionKeyHandler(SelectorHandler selectorHandler) {
        SelectionKeyHandler assgnSelectionKeyHandler;
        block5: {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Set DefaultSelectionKeyHandler to SelectorHandler: " + selectorHandler);
            }
            assgnSelectionKeyHandler = null;
            if (selectorHandler.getPreferredSelectionKeyHandler() != null) {
                Class<? extends SelectionKeyHandler> keyHandlerClass = selectorHandler.getPreferredSelectionKeyHandler();
                try {
                    assgnSelectionKeyHandler = keyHandlerClass.newInstance();
                    assgnSelectionKeyHandler.setSelectorHandler(selectorHandler);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.WARNING)) break block5;
                    logger.log(Level.WARNING, "Exception initializing preffered SelectionKeyHandler '" + keyHandlerClass + "' for the SelectorHandler '" + selectorHandler + "'");
                }
            }
        }
        if (assgnSelectionKeyHandler == null) {
            assgnSelectionKeyHandler = new DefaultSelectionKeyHandler(selectorHandler);
        }
        selectorHandler.setSelectionKeyHandler(assgnSelectionKeyHandler);
    }

    private void handleSelectedKeys(Set<SelectionKey> readyKeys, SelectorHandler selectorHandler, NIOContext serverCtx) {
        boolean isLogLevelFine = logger.isLoggable(Level.FINE);
        for (SelectionKey key : readyKeys) {
            try {
                Object attachment = key.attachment();
                if (attachment instanceof SelectedKeyAttachmentLogic) {
                    ((SelectedKeyAttachmentLogic)attachment).handleSelectedKey(key);
                    continue;
                }
                if (!key.isValid()) {
                    selectorHandler.addPendingKeyCancel(key);
                    continue;
                }
                int readyOps = key.readyOps();
                if ((readyOps & 0x10) != 0) {
                    if (this.readThreadsCount > 0 && this.multiReadThreadSelectorHandler.supportsProtocol(selectorHandler.protocol())) {
                        if (isLogLevelFine) {
                            this.dolog("OP_ACCEPT passed to multi readthread handler on ", key);
                        }
                        this.multiReadThreadSelectorHandler.onAcceptInterest(key, serverCtx);
                        continue;
                    }
                    if (isLogLevelFine) {
                        this.dolog("OP_ACCEPT on ", key);
                    }
                    selectorHandler.onAcceptInterest(key, serverCtx);
                    continue;
                }
                if ((readyOps & 8) != 0) {
                    if (isLogLevelFine) {
                        this.dolog("OP_CONNECT on ", key);
                    }
                    selectorHandler.onConnectInterest(key, serverCtx);
                    continue;
                }
                boolean delegateToWorker = false;
                Context.OpType opType = null;
                boolean skipOpWrite = false;
                if ((readyOps & 1) != 0) {
                    if (isLogLevelFine) {
                        this.dolog("OP_READ on ", key);
                    }
                    if (delegateToWorker = selectorHandler.onReadInterest(key, serverCtx)) {
                        opType = Context.OpType.OP_READ;
                    }
                    if (!this.handleReadWriteConcurrently) {
                        skipOpWrite = true;
                    }
                }
                if (!skipOpWrite && (readyOps & 4) != 0 && key.isValid()) {
                    if (isLogLevelFine) {
                        this.dolog("OP_WRITE on ", key);
                    }
                    boolean opWriteDelegate = selectorHandler.onWriteInterest(key, serverCtx);
                    delegateToWorker |= opWriteDelegate;
                    if (opWriteDelegate) {
                        opType = opType == Context.OpType.OP_READ ? Context.OpType.OP_READ_WRITE : Context.OpType.OP_WRITE;
                    }
                }
                if (!delegateToWorker) continue;
                NIOContext context = this.pollContext(key, opType);
                this.configureContext(context, selectorHandler);
                context.execute(context.getProtocolChainContextTask());
            }
            catch (Throwable e) {
                this.handleSelectException(e, selectorHandler, key);
            }
        }
    }

    private void dolog(String msg, SelectionKey key) {
        logger.log(Level.FINE, msg + key + " attachment: " + key.attachment());
    }

    private void handleSelectException(Throwable e, SelectorHandler selectorHandler, SelectionKey key) {
        if (e instanceof ClosedSelectorException) {
            if (this.stateHolder.getState() == State.STARTED && selectorHandler.getStateHolder().getState() == State.STARTED) {
                logger.log(Level.SEVERE, "Selector was unexpectedly closed.");
                this.notifyException(e);
            } else {
                logger.log(Level.FINE, "doSelect Selector closed");
            }
        } else if (e instanceof ClosedChannelException) {
            if (this.stateHolder.getState() == State.STARTED && selectorHandler.getStateHolder().getState() == State.STARTED) {
                logger.log(Level.WARNING, "Channel was unexpectedly closed");
                if (key != null) {
                    selectorHandler.getSelectionKeyHandler().cancel(key);
                }
                this.notifyException(e);
            }
        } else if (e instanceof IOException) {
            if (this.stateHolder.getState() == State.STARTED && selectorHandler.getStateHolder().getState() == State.STARTED) {
                logger.log(Level.SEVERE, "Selector was unexpectedly closed.");
                this.notifyException(e);
            } else {
                logger.log(Level.FINE, "doSelect IOException", e);
            }
        } else {
            try {
                if (key != null) {
                    selectorHandler.getSelectionKeyHandler().cancel(key);
                }
                this.notifyException(e);
                logger.log(Level.SEVERE, "doSelect exception", e);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
    }

    public void registerKey(SelectionKey key) {
        this.registerKey(key, 1);
    }

    public void registerKey(SelectionKey key, int ops) {
        this.registerKey(key, ops, this.selectorHandlers.peek().protocol());
    }

    public void registerKey(SelectionKey key, int ops, Protocol protocol) {
        if (this.stateHolder.getState() == State.STOPPED) {
            return;
        }
        this.getSelectorHandler(protocol).register(key, ops);
    }

    public void cancelKey(SelectionKey key) {
        if (this.stateHolder.getState() == State.STOPPED) {
            return;
        }
        SelectorHandler selectorHandler = this.getSelectorHandler(key.selector());
        if (selectorHandler == null) {
            throw new IllegalStateException("SelectionKey is not associated with known SelectorHandler");
        }
        selectorHandler.getSelectionKeyHandler().cancel(key);
    }

    public NIOContext pollContext(SelectionKey key) {
        return this.pollContext(key, null);
    }

    public NIOContext pollContext(SelectionKey key, Context.OpType opType) {
        NIOContext ctx = this.contexts.poll();
        ctx.setController(this);
        ctx.setSelectionKey(key);
        if (opType != null) {
            ctx.setCurrentOpType(opType);
        } else if (key != null) {
            ctx.configureOpType(key);
        }
        return ctx;
    }

    public void configureContext(NIOContext ctx, SelectorHandler selectorHandler) {
        ctx.setSelectorHandler(selectorHandler);
        ctx.setThreadPool(selectorHandler.getThreadPool());
        ctx.setAsyncQueueReader(selectorHandler.getAsyncQueueReader());
        ctx.setAsyncQueueWriter(selectorHandler.getAsyncQueueWriter());
    }

    public void returnContext(Context ctx) {
        if (ctx.decrementRefCount() > 0) {
            return;
        }
        ctx.recycle();
        this.contexts.offer((NIOContext)ctx);
    }

    public static Logger logger() {
        return logger;
    }

    public static void setLogger(Logger l) {
        logger = l;
        LoggerUtils.setLogger(l);
    }

    public void setProtocolChainInstanceHandler(ProtocolChainInstanceHandler instanceHandler) {
        this.instanceHandler = instanceHandler;
    }

    public ProtocolChainInstanceHandler getProtocolChainInstanceHandler() {
        return this.instanceHandler;
    }

    public void setSelectionKeyHandler(SelectionKeyHandler selectionKeyHandler) {
        this.selectionKeyHandler = selectionKeyHandler;
    }

    public SelectionKeyHandler getSelectionKeyHandler() {
        return this.selectionKeyHandler;
    }

    public void addSelectorHandler(SelectorHandler selectorHandler) {
        this.selectorHandlers.add(selectorHandler);
        if (this.stateHolder.getState(false) != null && !State.STOPPED.equals((Object)this.stateHolder.getState())) {
            this.addSelectorHandlerOnReadControllers(selectorHandler);
            if (this.readySelectorHandlerCounter != null) {
                this.readySelectorHandlerCounter.incrementAndGet();
            }
            if (this.stoppedSelectorHandlerCounter != null) {
                this.stoppedSelectorHandlerCounter.incrementAndGet();
            }
            this.startSelectorHandlerRunner(selectorHandler);
        }
    }

    public void setSelectorHandler(SelectorHandler selectorHandler) {
        this.addSelectorHandler(selectorHandler);
    }

    public SelectorHandler getSelectorHandler(Protocol protocol) {
        for (SelectorHandler selectorHandler : this.selectorHandlers) {
            if (selectorHandler.protocol() != protocol) continue;
            return selectorHandler;
        }
        return null;
    }

    public SelectorHandler getSelectorHandler(Selector selector) {
        for (SelectorHandler selectorHandler : this.selectorHandlers) {
            if (selectorHandler.getSelector() != selector) continue;
            return selectorHandler;
        }
        return null;
    }

    public LinkedTransferQueue getSelectorHandlers() {
        return this.selectorHandlers;
    }

    public void removeSelectorHandler(SelectorHandler selectorHandler) {
        if (this.selectorHandlers.remove(selectorHandler)) {
            this.removeSelectorHandlerOnReadControllers(selectorHandler);
            selectorHandler.shutdown();
        }
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public int getReadThreadsCount() {
        return this.readThreadsCount;
    }

    public void setReadThreadsCount(int readThreadsCount) {
        this.readThreadsCount = readThreadsCount;
    }

    public ConnectorHandlerPool getConnectorHandlerPool() {
        return this.connectorHandlerPool;
    }

    public void setConnectorHandlerPool(ConnectorHandlerPool connectorHandlerPool) {
        this.connectorHandlerPool = connectorHandlerPool;
    }

    @Override
    public void run() {
        try {
            this.start();
        }
        catch (IOException e) {
            this.notifyException(e);
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public void copyTo(Copyable copy) {
        Controller copyController = (Controller)copy;
        copyController.contexts = this.contexts;
        copyController.attributes = this.attributes;
        copyController.instanceHandler = this.instanceHandler;
        copyController.threadPool = this.threadPool;
        copyController.readThreadControllers = this.readThreadControllers;
        copyController.readThreadsCount = this.readThreadsCount;
        copyController.selectionKeyHandler = this.selectionKeyHandler;
        copyController.stateHolder = this.stateHolder;
    }

    public void addStateListener(ControllerStateListener stateListener) {
        this.stateListeners.add(stateListener);
    }

    public void removeStateListener(ControllerStateListener stateListener) {
        this.stateListeners.remove(stateListener);
    }

    public void notifyStarted() {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onStarted();
        }
    }

    public void notifyReady() {
        if (this.readySelectorHandlerCounter.decrementAndGet() == 0) {
            for (ControllerStateListener stateListener : this.stateListeners) {
                stateListener.onReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyStopped() {
        if (this.stoppedSelectorHandlerCounter.decrementAndGet() == 0) {
            AtomicInteger atomicInteger = this.stoppedSelectorHandlerCounter;
            synchronized (atomicInteger) {
                this.stoppedSelectorHandlerCounter.notifyAll();
            }
        }
    }

    protected void notifyException(Throwable e) {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        this.stateHolder.getStateLocker().writeLock().lock();
        boolean isUnlocked = false;
        try {
            if (this.stateHolder.getState(false) == null || this.stateHolder.getState(false) == State.STOPPED) {
                if (this.selectorHandlers.isEmpty()) {
                    TCPSelectorHandler selectorHandler = new TCPSelectorHandler();
                    this.selectorHandlers.add(selectorHandler);
                }
                if (this.readThreadsCount > 0) {
                    this.initReadThreads();
                    this.multiReadThreadSelectorHandler = new RoundRobinSelectorHandler(this.readThreadControllers);
                }
                this.stateHolder.setState(State.STARTED, false);
                this.notifyStarted();
                int selectorHandlerCount = this.selectorHandlers.size();
                this.readySelectorHandlerCounter = new AtomicInteger(selectorHandlerCount);
                this.stoppedSelectorHandlerCounter = new AtomicInteger(selectorHandlerCount);
                Iterator<SelectorHandler> it = this.selectorHandlers.iterator();
                while (it.hasNext() && selectorHandlerCount-- > 0) {
                    SelectorHandler selectorHandler = it.next();
                    this.startSelectorHandlerRunner(selectorHandler);
                }
            }
        }
        finally {
            if (!isUnlocked) {
                this.stateHolder.getStateLocker().writeLock().unlock();
            }
        }
        this.waitUntilSeletorHandlersStop();
        if (this.readThreadsCount > 0) {
            this.multiReadThreadSelectorHandler.shutdown();
            this.multiReadThreadSelectorHandler = null;
            for (ReadController readController : this.readThreadControllers) {
                try {
                    ((Controller)readController).stop();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Exception occured when stopping read Controller!", e);
                }
            }
            this.readThreadControllers = null;
        }
        this.selectorHandlers.clear();
        this.threadPool.shutdown();
        this.attributes = null;
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onStopped();
        }
    }

    @Override
    public void stop() throws IOException {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean isAsync) throws IOException {
        final CountDownLatch latch = new CountDownLatch(1);
        this.stateHolder.getStateLocker().writeLock().lock();
        try {
            if (this.stateHolder.getState(false) == State.STOPPED) {
                logger.log(Level.FINE, "Controller is already in stopped state");
                return;
            }
            if (!isAsync) {
                this.addStateListener(new ControllerStateListenerAdapter(){

                    public void onException(Throwable e) {
                        Controller.this.removeStateListener(this);
                        latch.countDown();
                    }

                    public void onStopped() {
                        Controller.this.removeStateListener(this);
                        latch.countDown();
                    }
                });
            }
            this.stateHolder.setState(State.STOPPED, false);
        }
        finally {
            this.stateHolder.getStateLocker().writeLock().unlock();
        }
        if (!isAsync) {
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void pause() throws IOException {
        this.stateHolder.setState(State.PAUSED);
    }

    @Override
    public void resume() throws IOException {
        if (!State.PAUSED.equals((Object)this.stateHolder.getState(false))) {
            throw new IllegalStateException("Controller is not in PAUSED state, but: " + (Object)((Object)this.stateHolder.getState(false)));
        }
        this.stateHolder.setState(State.STARTED);
    }

    @Override
    public StateHolder<State> getStateHolder() {
        return this.stateHolder;
    }

    private void initReadThreads() throws IOException {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(2);
        }
        this.readThreadControllers = new ReadController[this.readThreadsCount];
        for (int i = 0; i < this.readThreadsCount; ++i) {
            ReadController controller = new ReadController();
            this.copyTo(controller);
            controller.setReadThreadsCount(0);
            this.readThreadControllers[i] = controller;
        }
        for (SelectorHandler selectorHandler : this.selectorHandlers) {
            this.addSelectorHandlerOnReadControllers(selectorHandler);
        }
        for (int i = 0; i < this.readThreadControllers.length; ++i) {
            new WorkerThreadImpl("GrizzlyReadController-" + i, (Runnable)this.readThreadControllers[i]).start();
        }
    }

    private void addSelectorHandlerOnReadControllers(SelectorHandler selectorHandler) {
        if (this.readThreadControllers == null || this.readThreadsCount == 0) {
            return;
        }
        if (selectorHandler.getAttributes() == null) {
            selectorHandler.setAttributes(new HashMap<String, Object>(2));
        }
        for (ReadController readController : this.readThreadControllers) {
            SelectorHandler copySelectorHandler = Cloner.clone(selectorHandler);
            try {
                copySelectorHandler.setSelector(Selector.open());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error opening selector!", e);
            }
            readController.addSelectorHandler(copySelectorHandler);
        }
    }

    protected void startSelectorHandlerRunner(SelectorHandler selectorHandler) {
        if (selectorHandler.getThreadPool() == null) {
            selectorHandler.setThreadPool(this.threadPool);
        }
        SelectorHandlerRunner selectorRunner = new SelectorHandlerRunner(this, selectorHandler);
        if (selectorHandler.getSelector() != null) {
            this.notifyReady();
        }
        new WorkerThreadImpl("GrizzlySelectorRunner-" + (Object)((Object)selectorHandler.protocol()), (Runnable)selectorRunner).start();
    }

    private void removeSelectorHandlerOnReadControllers(SelectorHandler selectorHandler) {
        if (this.readThreadControllers == null) {
            return;
        }
        for (ReadController readController : this.readThreadControllers) {
            readController.removeSelectorHandlerClone(selectorHandler);
        }
    }

    public boolean isStarted() {
        return this.stateHolder.getState() == State.STARTED;
    }

    public ConnectorHandler acquireConnectorHandler(Protocol protocol) {
        return this.connectorHandlerPool.acquireConnectorHandler(protocol);
    }

    public void releaseConnectorHandler(ConnectorHandler connectorHandler) {
        this.connectorHandlerPool.releaseConnectorHandler(connectorHandler);
    }

    public boolean isHandleReadWriteConcurrently() {
        return this.handleReadWriteConcurrently;
    }

    public void setHandleReadWriteConcurrently(boolean handleReadWriteConcurrently) {
        this.handleReadWriteConcurrently = handleReadWriteConcurrently;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilSeletorHandlersStop() {
        AtomicInteger atomicInteger = this.stoppedSelectorHandlerCounter;
        synchronized (atomicInteger) {
            while (this.stoppedSelectorHandlerCounter.get() > 0 || !State.STOPPED.equals((Object)this.stateHolder.getState())) {
                try {
                    this.stoppedSelectorHandlerCounter.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public Object removeAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public static Controller getHandlerController(Handler handler) {
        if (handler instanceof SelectorHandler) {
            for (Controller controller : controllers) {
                if (!controller.getSelectorHandlers().contains(handler)) continue;
                return controller;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Protocol {
        UDP,
        TCP,
        TLS,
        CUSTOM;

    }
}

