/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.admin.bridgemgr;

import com.sun.messaging.bridge.admin.bridgemgr.BridgeMgrStatusEvent;
import com.sun.messaging.bridge.admin.bridgemgr.Globals;
import com.sun.messaging.bridge.service.BridgeCmdSharedReplyData;
import com.sun.messaging.jmq.admin.apps.console.event.CommonCmdStatusEvent;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminConn;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.TemporaryQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeAdmin
extends BrokerAdminConn {
    private BridgeMgrStatusEvent statusEvent = null;
    private QueueSender _sender = null;

    public BridgeAdmin(String string, int n) throws BrokerAdminException {
        this(string, n, null, null, -1L, false, -1, -1L);
    }

    public BridgeAdmin(String string, int n, String string2, String string3) throws BrokerAdminException {
        this(string, n, string2, string3, -1L, false, -1, -1L);
    }

    public BridgeAdmin(String string, int n, String string2, String string3, int n2) throws BrokerAdminException {
        this(string, n, string2, string3, n2, false, -1, -1L);
    }

    public BridgeAdmin(String string, String string2, String string3, int n, boolean bl) throws BrokerAdminException {
        this(string, string2, string3, n, false, -1, -1L, bl);
    }

    public BridgeAdmin(String string, int n, String string2, String string3, long l, boolean bl, int n2, long l2) throws BrokerAdminException {
        super(string, n, string2, string3, l, bl, n2, l2);
    }

    public BridgeAdmin(String string, String string2, String string3, long l, boolean bl, int n, long l2, boolean bl2) throws BrokerAdminException {
        super(string, string2, string3, l, bl, n, l2, bl2);
    }

    public BridgeAdmin(Properties properties, String string, String string2, long l) throws BrokerAdminException {
        super(properties, string, string2, l);
    }

    @Override
    public String getAdminQueueDest() {
        return "__JMQBridgeAdmin";
    }

    @Override
    public String getAdminMessagePropNameMessageType() {
        return "JMQMessageType";
    }

    @Override
    public String getAdminMessagePropNameErrorString() {
        return "JMQErrorString";
    }

    @Override
    public String getAdminMessagePropNameStatus() {
        return "JMQStatus";
    }

    @Override
    public int getAdminMessageStatusOK() {
        return 200;
    }

    @Override
    public int getAdminMessageTypeSHUTDOWN_REPLY() {
        return 30;
    }

    @Override
    public CommonCmdStatusEvent newCommonCmdStatusEvent(int n) {
        return new BridgeMgrStatusEvent(this, this, n);
    }

    @Override
    public CommonCmdStatusEvent getCurrentStatusEvent() {
        return this.statusEvent;
    }

    @Override
    public void clearStatusEvent() {
        this.statusEvent = null;
    }

    private BridgeMgrStatusEvent createStatusEvent(int n, int n2, String string) {
        CommonCmdStatusEvent commonCmdStatusEvent = this.newCommonCmdStatusEvent(n);
        commonCmdStatusEvent.setReplyType(n2);
        commonCmdStatusEvent.setReplyTypeString(string);
        return (BridgeMgrStatusEvent)commonCmdStatusEvent;
    }

    public void sendHelloMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendHelloMessage *****");
        }
        this.checkIfBusy();
        ObjectMessage objectMessage = null;
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 28);
            this.statusEvent = this.createStatusEvent(5000, 29, "HELLO_REPLY");
            if (debug) {
                this.printMsgType(28, "HELLO");
                Globals.stdOutPrintln("\tJMQProtocolLevel=440");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveHelloReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveHelloReplyMessage() *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 29, "HELLO_REPLY");
            TemporaryQueue temporaryQueue = (TemporaryQueue)objectMessage.getJMSReplyTo();
            if (temporaryQueue == null) {
                Globals.stdErrPrintln("HELLO_REPLY protocol error: no JMSReplyTo");
                throw new BrokerAdminException(2);
            }
            if (debug) {
                Globals.stdOutPrintln("*****Got replyQueue from broker: " + temporaryQueue);
            }
            this._sender = this.session.createSender((Queue)temporaryQueue);
            this._sender.setDeliveryMode(1);
            if (debug) {
                Globals.stdOutPrintln("***** Created a _sender: " + this._sender);
            }
            this.isConnected = true;
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendCommandMessage(String string, String string2, String string3, String string4, int n, String string5, int n2, int n3, String string6) throws BrokerAdminException {
        this.sendCommandMessage(string, string2, string3, string4, n, string5, n2, n3, string6, false);
    }

    public void sendCommandMessage(String string, String string2, String string3, String string4, int n, String string5, int n2, int n3, String string6, boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** send " + string + " Message *****");
        }
        this.checkIfBusy();
        ObjectMessage objectMessage = null;
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", n);
            if (string2 != null) {
                objectMessage.setStringProperty("JMQBridgeName", string2);
            }
            if (string3 != null) {
                objectMessage.setStringProperty("JMQBridgeType", string3);
            }
            if (string4 != null) {
                objectMessage.setStringProperty("JMQLinkName", string4);
            }
            if (bl) {
                objectMessage.setBooleanProperty("JMQDebug", Boolean.valueOf(bl).booleanValue());
            }
            Locale locale = Locale.getDefault();
            objectMessage.setStringProperty("JMQLocaleLanguage", locale.getLanguage());
            objectMessage.setStringProperty("JMQLocaleCountry", locale.getCountry());
            objectMessage.setStringProperty("JMQLocaleVariant", locale.getVariant());
            this.statusEvent = this.createStatusEvent(n2, n3, string6);
            if (debug) {
                this.printMsgType(n, string5);
                Globals.stdOutPrintln("\tJMQBridgeName=" + string2);
                Globals.stdOutPrintln("\tJMQBridgeType=" + string3);
                Globals.stdOutPrintln("\tJMQLinkName=" + string4);
            }
            this._sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveCommandReplyMessage(String string, int n, String string2) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receive " + string2 + " Message() *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, n, string2);
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public ArrayList<BridgeCmdSharedReplyData> receiveListReplyMessage() throws BrokerAdminException {
        return this.receiveListReplyMessage(true);
    }

    public ArrayList<BridgeCmdSharedReplyData> receiveListReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveListReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            Serializable serializable;
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 19, "LIST_REPLY");
            if (debug) {
                Globals.stdErrPrintln("Received list reply: " + objectMessage);
            }
            if ((serializable = objectMessage.getObject()) != null && serializable instanceof ArrayList) {
                return (ArrayList)serializable;
            }
            if (debug) {
                Globals.stdErrPrintln("Unexpected reply from broker: " + serializable);
            }
            throw new RuntimeException("Unexpected reply type " + serializable + " for LIST");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
            return null;
        }
    }

    public void sendDebugMessage(String string, String string2, Properties properties) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** send debug " + string + " Message *****");
        }
        this.checkIfBusy();
        ObjectMessage objectMessage = null;
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 16);
            if (string != null) {
                objectMessage.setStringProperty("JMQCommandArg", string);
            }
            if (string2 != null) {
                objectMessage.setStringProperty("JMQTarget", string2);
            }
            if (properties != null) {
                objectMessage.setObject((Serializable)properties);
            }
            Locale locale = Locale.getDefault();
            objectMessage.setStringProperty("JMQLocaleLanguage", locale.getLanguage());
            objectMessage.setStringProperty("JMQLocaleCountry", locale.getCountry());
            objectMessage.setStringProperty("JMQLocaleVariant", locale.getVariant());
            this.statusEvent = this.createStatusEvent(5006, 17, "DEBUG_REPLY");
            if (debug) {
                this.printMsgType(16, "DEBUG");
                Globals.stdOutPrintln("\tJMQCommandArg=" + string);
                Globals.stdOutPrintln("\tJMQTarget=" + string2);
            }
            this._sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Hashtable receiveDebugReplyMessage() throws BrokerAdminException {
        return this.receiveDebugReplyMessage(true);
    }

    public Hashtable receiveDebugReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveDebugReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 17, "DEBUG_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Hashtable) {
                return (Hashtable)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    private void printMsgType(int n, String string) {
        Globals.stdOutPrintln("\tJMQMessageType=" + n + "(" + string + ")");
    }
}

