/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx.log;

import com.sun.messaging.bridge.service.JMSBridgeStore;
import com.sun.messaging.bridge.service.UpdateOpaqueDataCallback;
import com.sun.messaging.bridge.service.jms.tx.BranchXid;
import com.sun.messaging.bridge.service.jms.tx.GlobalXid;
import com.sun.messaging.bridge.service.jms.tx.log.LogRecord;
import com.sun.messaging.bridge.service.jms.tx.log.TxLog;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

public class JDBCTxLogImpl
extends TxLog {
    private static final String _type = "jdbc";
    private JMSBridgeStore _store = null;
    private boolean _inited = false;
    private boolean _closed = false;

    public void setJDBCStore(JMSBridgeStore jMSBridgeStore) throws IllegalArgumentException {
        if (jMSBridgeStore == null) {
            throw new IllegalArgumentException("null JDBC store");
        }
        this._store = jMSBridgeStore;
    }

    public String getType() {
        return _type;
    }

    public void init(Properties properties, boolean bl) throws Exception {
        if (this._store == null) {
            throw new IllegalStateException("JDBC store is null");
        }
        if (this._logger == null) {
            throw new IllegalArgumentException("logger not set");
        }
        this._jmsbridge = properties.getProperty("jmsbridge");
        if (this._jmsbridge == null) {
            throw new IllegalArgumentException("Property 'jmsbridge' not set");
        }
        this._tmname = properties.getProperty("tmname");
        if (this._tmname == null) {
            throw new IllegalStateException("Property 'tmname' not set");
        }
        super.init(properties, bl);
        this._inited = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logGlobalDecision(LogRecord logRecord) throws Exception {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "jdbcTxLog: log global decision  " + logRecord);
        }
        super.checkClosedAndSetInProgress();
        try {
            this._store.storeTMLogRecord(logRecord.getGlobalXid().toString(), logRecord.toBytes(), this._jmsbridge, false, this._logger);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logHeuristicBranch(BranchXid branchXid, LogRecord logRecord) throws Exception {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "jdbcTxLog: log branch heuristic decision  " + logRecord);
        }
        final GlobalXid globalXid = logRecord.getGlobalXid();
        final BranchXid branchXid2 = branchXid;
        final LogRecord logRecord2 = logRecord;
        super.checkClosedAndSetInProgress();
        try {
            UpdateOpaqueDataCallback updateOpaqueDataCallback = new UpdateOpaqueDataCallback(){

                public Object update(Object object) throws Exception {
                    ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream((byte[])object));
                    LogRecord logRecord = (LogRecord)objectInputStream.readObject();
                    if (!logRecord.getGlobalXid().equals(globalXid)) {
                        throw new IllegalArgumentException("Unexpected global xid " + logRecord.getGlobalXid() + " from store, expected:" + globalXid);
                    }
                    objectInputStream.close();
                    if (logRecord == null) {
                        throw new IllegalArgumentException("Unexpected null current log record for " + globalXid);
                    }
                    if (logRecord.getBranchDecision(branchXid2) == logRecord2.getBranchDecision(branchXid2)) {
                        return object;
                    }
                    logRecord.setBranchDecision(branchXid2, logRecord2.getBranchDecision(branchXid2));
                    return logRecord;
                }
            };
            this._store.updateTMLogRecord(globalXid.toString(), logRecord.toBytes(), this._jmsbridge, updateOpaqueDataCallback, true, true, this._logger);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reap(String string) throws Exception {
        String string2 = string;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "jdbcTxLog: remove global transaction xid " + string2);
        }
        super.checkClosedAndSetInProgress();
        try {
            this._store.removeTMLogRecord(string2, this._jmsbridge, true, this._logger);
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogRecord getLogRecord(GlobalXid globalXid) throws Exception {
        String string = globalXid.toString();
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "jdbcTxLog: get log record for  xid " + string);
        }
        super.checkClosedAndSetInProgress();
        try {
            byte[] byArray = this._store.getTMLogRecord(string, this._jmsbridge, this._logger);
            if (byArray == null) {
                LogRecord logRecord = null;
                return logRecord;
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            LogRecord logRecord = (LogRecord)objectInputStream.readObject();
            objectInputStream.close();
            LogRecord logRecord2 = logRecord;
            return logRecord2;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllLogRecords() throws Exception {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "jdbcTxLog: get all log records");
        }
        ArrayList<LogRecord> arrayList = new ArrayList<LogRecord>();
        super.checkClosedAndSetInProgress();
        try {
            Object object;
            List list = this._store.getTMLogRecordsByName(this._jmsbridge, this._logger);
            if (list == null) {
                ArrayList<LogRecord> arrayList2 = arrayList;
                return arrayList2;
            }
            byte[] byArray2 = null;
            for (byte[] byArray2 : list) {
                object = new ObjectInputStream(new ByteArrayInputStream(byArray2));
                LogRecord logRecord = (LogRecord)((ObjectInputStream)object).readObject();
                ((ObjectInputStream)object).close();
                arrayList.add(logRecord);
            }
            object = arrayList;
            return object;
        }
        finally {
            super.setInProgress(false);
        }
    }

    public void close() throws Exception {
        this._logger.log(Level.INFO, "jdbcTxLog: closing");
        super.setClosedAndWait();
        super.close();
    }
}

