/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.service.stomp.NotConnectedException;
import com.sun.messaging.bridge.service.stomp.StompFrameMessage;
import com.sun.messaging.bridge.service.stomp.StompProtocolException;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandler;
import com.sun.messaging.bridge.service.stomp.StompSenderSession;
import com.sun.messaging.bridge.service.stomp.StompSenderSessionImpl;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.StompSubscriberSession;
import com.sun.messaging.bridge.service.stomp.StompTransactedSession;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;

public class StompConnection
implements ExceptionListener {
    private Logger _logger = StompServer.getLogger();
    private ConnectionFactory _jmscf = null;
    private Connection _connection = null;
    private String _connectionUID = "";
    private boolean _connectionException = false;
    private StompSenderSession _pubSession = null;
    private String _clientid = null;
    private Map<String, StompSubscriberSession> _subSessions = Collections.synchronizedMap(new HashMap());
    private StompTransactedSession _txSession = null;
    private StompProtocolHandler _sph = null;

    public StompConnection(ConnectionFactory connectionFactory, StompProtocolHandler stompProtocolHandler) {
        this._jmscf = connectionFactory;
        this._sph = stompProtocolHandler;
    }

    public synchronized String connect(String string, String string2, String string3) throws Exception {
        if (this._connection != null) {
            throw new IllegalStateException("Unexpected " + (Object)((Object)StompFrameMessage.Command.CONNECT) + ", already connected");
        }
        this._logger.log(Level.INFO, "Creating JMS connection for user " + string + (string3 == null ? "" : " with clientid " + string3));
        this._connection = string != null ? this._jmscf.createConnection(string, string2) : this._jmscf.createConnection();
        if (string3 != null) {
            this._clientid = string3;
            this._connection.setClientID(string3);
        }
        ((ConnectionImpl)this._connection)._setAppTransactedAck();
        this._connectionUID = ((ConnectionImpl)this._connection)._getConnectionID() + "[" + this._connection.getClientID() + "]";
        this._connection.start();
        this._logger.log(Level.INFO, "Started JMS connection " + this._connectionUID + " for user " + string);
        return this._connectionUID;
    }

    public Connection getConnection() {
        return this._connection;
    }

    public String toString() {
        String string = this._connectionUID;
        return string == null ? "" : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect(boolean bl) throws Exception {
        if (bl) {
            this.checkConnection();
        }
        if (this._connection != null) {
            try {
                if (this._pubSession != null) {
                    this._pubSession.close();
                    this._pubSession = null;
                }
                if (this._txSession != null) {
                    this._txSession.close();
                    this._txSession = null;
                }
                Map<String, StompSubscriberSession> map = this._subSessions;
                synchronized (map) {
                    for (String string : this._subSessions.keySet()) {
                        StompSubscriberSession stompSubscriberSession = this._subSessions.get(string);
                        stompSubscriberSession.close();
                    }
                    this._subSessions.clear();
                }
                this._connection.close();
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                this._connection = null;
                this._connectionException = false;
            }
            this._logger.log(Level.INFO, "Stomp connection " + this._connectionUID + " closed.");
        } else {
            this._logger.log(Level.FINE, "Stomp connection " + this._connectionUID + " not connected.");
        }
    }

    public synchronized void beginTransactedSession(String string) throws Exception {
        String string2;
        Connection connection = this._connection;
        this.checkConnection(connection);
        if (string == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this._txSession == null) {
            this._txSession = new StompTransactedSession(this);
        }
        if ((string2 = this._txSession.getTransactionID()) != null) {
            throw new StompProtocolException("Nested transaction not allowed: current transaction=" + string2 + ", new transaction=" + string);
        }
        this._txSession.setTransactionID(string);
    }

    public synchronized void commitTransactedSession(String string) throws Exception {
        Connection connection = this._connection;
        this.checkConnection(connection);
        if (string == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this._txSession == null) {
            throw new StompProtocolException("Session not exist for transaction " + string);
        }
        String string2 = this._txSession.getTransactionID();
        if (string2 == null || !string2.equals(string)) {
            throw new StompProtocolException("Transaction " + string + " not found" + (string2 == null ? "" : ", current transaction is " + string2));
        }
        this._txSession.commit();
    }

    public synchronized void abortTransactedSession(String string) throws Exception {
        Connection connection = this._connection;
        this.checkConnection(connection);
        if (string == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this._txSession == null) {
            throw new StompProtocolException("Session not exist for transaction " + string);
        }
        String string2 = this._txSession.getTransactionID();
        String string3 = this._txSession.getLastRolledbackTID();
        if (string2 == null && string3 != null && string3.equals(string)) {
            this._logger.log(Level.INFO, "Transaction " + string + " already rolled back");
            return;
        }
        if (string2 == null || !string2.equals(string)) {
            throw new StompProtocolException("Transaction " + string + " not found" + (string2 == null ? "" : ", current transaction is " + string2));
        }
        this._txSession.rollback();
    }

    public synchronized StompTransactedSession getTransactedSession(String string) throws Exception {
        this.checkConnection();
        if (string == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this._txSession == null) {
            throw new StompProtocolException("No session for transaction " + string + " found");
        }
        String string2 = this._txSession.getTransactionID();
        if (string2 == null || !string2.equals(string)) {
            throw new StompProtocolException("No session for transaction " + string + " found");
        }
        return this._txSession;
    }

    public synchronized StompTransactedSession getTransactedSession() throws Exception {
        this.checkConnection();
        if (this._txSession == null) {
            return null;
        }
        if (this._txSession.getTransactionID() == null) {
            return null;
        }
        return this._txSession;
    }

    public synchronized StompSenderSession getSenderSession() throws Exception {
        Connection connection = this._connection;
        this.checkConnection(connection);
        if (this._pubSession == null) {
            this._pubSession = new StompSenderSessionImpl(connection);
        }
        return this._pubSession;
    }

    public synchronized StompSubscriberSession createSubscriberSession(String string, int n) throws Exception {
        Connection connection = this._connection;
        this.checkConnection(connection);
        if (string == null) {
            throw new IllegalArgumentException("No subscription id");
        }
        StompSubscriberSession stompSubscriberSession = this._subSessions.get(string);
        if (stompSubscriberSession != null) {
            throw new StompProtocolException("Subscriber with id " + string + " already exist");
        }
        stompSubscriberSession = new StompSubscriberSession(string, n, this);
        this._subSessions.put(string, stompSubscriberSession);
        return stompSubscriberSession;
    }

    public synchronized StompSubscriberSession getSubscriberSession(String string) throws Exception {
        this.checkConnection();
        if (string == null) {
            throw new IllegalArgumentException("No subscription id");
        }
        StompSubscriberSession stompSubscriberSession = this._subSessions.get(string);
        return stompSubscriberSession;
    }

    public synchronized String closeSubscriber(String string, String string2) throws Exception {
        String string3;
        this.checkConnection();
        StompSubscriberSession stompSubscriberSession = null;
        if (string2 == null) {
            stompSubscriberSession = this._subSessions.get(string);
            if (stompSubscriberSession != null) {
                stompSubscriberSession.close();
                this._subSessions.remove(string);
                return null;
            }
        } else {
            if (this._clientid == null) {
                throw new StompProtocolException("Can't unsubscribe durable subscription " + string2 + " for the connection has no client-id");
            }
            string3 = null;
            for (String string4 : this._subSessions.keySet()) {
                stompSubscriberSession = this._subSessions.get(string4);
                string3 = stompSubscriberSession.getDuraName();
                if (string3 == null || !string3.equals(string2)) continue;
                stompSubscriberSession.closeSubscriber();
                stompSubscriberSession.getJMSSession().unsubscribe(string2);
                stompSubscriberSession.close();
                this._subSessions.remove(string4);
                return string4;
            }
        }
        if (this._txSession != null) {
            string3 = this._txSession.closeSubscriber(string, string2);
            if (string2 != null) {
                return string3;
            }
            if (string3 != null) {
                return string3;
            }
        } else if (string2 != null) {
            this.getSenderSession().getJMSSession().unsubscribe(string2);
            return null;
        }
        throw new StompProtocolException("Subscriber with id " + string + " not found !");
    }

    public synchronized void ackNonTransacted(String string, String string2) throws Exception {
        this.checkConnection();
        StompSubscriberSession stompSubscriberSession = null;
        for (String string3 : this._subSessions.keySet()) {
            if (!string3.startsWith(string)) continue;
            stompSubscriberSession = this._subSessions.get(string3);
            stompSubscriberSession.ack(string2);
            return;
        }
        throw new StompProtocolException("Can't determine subscriber to ack message " + string2 + ". Please specify " + "subscription".toString() + " header");
    }

    private synchronized void checkConnection() throws Exception {
        this.checkConnection(this._connection);
        if (this._connectionException) {
            this.disconnect(false);
            this._connectionException = false;
        }
    }

    private synchronized void checkConnection(Connection connection) throws Exception {
        if (connection == null) {
            throw new NotConnectedException("not connected !");
        }
    }

    public void onException(JMSException jMSException) {
        this._logger.log(Level.SEVERE, "JMS connection " + this._connectionUID + " got exception: " + jMSException.getMessage(), jMSException);
        this._connectionException = true;
    }

    protected StompFrameMessage toStompFrameMessage(Message message, String string, Session session) throws Exception {
        return this._sph.toStompFrameMessage(message, string, session);
    }
}

