/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.grizzly.Context;
import com.sun.messaging.bridge.service.MessageTransformer;
import com.sun.messaging.bridge.service.stomp.FrameParseException;
import com.sun.messaging.bridge.service.stomp.NotConnectedException;
import com.sun.messaging.bridge.service.stomp.StompConnection;
import com.sun.messaging.bridge.service.stomp.StompFrameMessage;
import com.sun.messaging.bridge.service.stomp.StompOutputHandler;
import com.sun.messaging.bridge.service.stomp.StompProtocolException;
import com.sun.messaging.bridge.service.stomp.StompSenderSession;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.StompSubscriberSession;
import com.sun.messaging.bridge.service.stomp.StompTransactedSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;

public class StompProtocolHandler {
    public static Logger _logger = StompServer.getLogger();
    private static final String DEFAULT_SUBID_PREFIX = "/subscription-to/";
    private static final String MQ_TEMP_QUEUE_PREFIX = "temporary_destination://queue/";
    private static final String MQ_TEMP_TOPIC_PREFIX = "temporary_destination://topic/";
    private StompConnection _stompConnection = null;
    private Map<String, TemporaryQueue> _tempQueues = Collections.synchronizedMap(new HashMap());
    private Map<String, TemporaryTopic> _tempTopics = Collections.synchronizedMap(new HashMap());
    private Map<String, TemporaryQueue> _mqtempQueues = Collections.synchronizedMap(new HashMap());
    private Map<String, TemporaryTopic> _mqtempTopics = Collections.synchronizedMap(new HashMap());
    private List<String> _subids = Collections.synchronizedList(new ArrayList());

    public StompProtocolHandler(ConnectionFactory connectionFactory) {
        this._stompConnection = new StompConnection(connectionFactory, this);
    }

    public void close(boolean bl) {
        _logger.log(Level.INFO, "Closing stomp connection " + this._stompConnection + " ...");
        if (!bl) {
            try {
                this._stompConnection.disconnect(false);
            }
            catch (Throwable throwable) {
                _logger.log(Level.WARNING, "Closing stomp connection failed: " + throwable.getMessage());
            }
            return;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    StompProtocolHandler.this._stompConnection.disconnect(false);
                }
                catch (Throwable throwable) {
                    _logger.log(Level.WARNING, "Closing stomp connection " + StompProtocolHandler.this._stompConnection + " failed: " + throwable.getMessage());
                }
            }
        });
        thread.setName("SpawnedClosingThread");
        thread.setDaemon(true);
        thread.start();
    }

    public void onCONNECT(StompFrameMessage stompFrameMessage, StompOutputHandler stompOutputHandler, Context context) {
        StompFrameMessage stompFrameMessage2 = null;
        try {
            String string = stompFrameMessage.getHeader("login".toString());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "on" + (Object)((Object)stompFrameMessage.getCommand()) + ", login=" + string);
            }
            String string2 = stompFrameMessage.getHeader("passcode".toString());
            String string3 = stompFrameMessage.getHeader("client-id".toString());
            String string4 = this._stompConnection.connect(string, string2, string3);
            stompFrameMessage2 = new StompFrameMessage(StompFrameMessage.Command.CONNECTED);
            stompFrameMessage2.addHeader("session".toString(), string4);
            String string5 = stompFrameMessage.getHeader("receipt".toString());
            if (string5 != null) {
                stompFrameMessage2.addHeader("receipt-id".toString(), string5);
            }
            stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, (Object)((Object)stompFrameMessage.getCommand()) + " failed: " + exception.getMessage(), exception);
            try {
                stompFrameMessage2 = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.CONNECT.toString(), exception);
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
            catch (Exception exception2) {
                _logger.log(Level.WARNING, (Object)((Object)stompFrameMessage.getCommand()) + ": Unable to send error message to client for exception: " + exception.getMessage(), exception);
                return;
            }
        }
    }

    public void onDISCONNECT(StompFrameMessage stompFrameMessage, StompOutputHandler stompOutputHandler, Context context) {
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "on" + (Object)((Object)stompFrameMessage.getCommand()));
            }
            this._stompConnection.disconnect(true);
            StompFrameMessage stompFrameMessage2 = StompProtocolHandler.getStompReceiptMessage(stompFrameMessage);
            if (stompFrameMessage2 != null) {
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
        }
        catch (Exception exception) {
            if (exception instanceof NotConnectedException) {
                _logger.log(Level.INFO, (Object)((Object)stompFrameMessage.getCommand()) + ": " + exception.getMessage());
                return;
            }
            _logger.log(Level.SEVERE, (Object)((Object)stompFrameMessage.getCommand()) + " failed: " + exception.getMessage(), exception);
            try {
                StompFrameMessage stompFrameMessage3 = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.DISCONNECT.toString(), exception);
                stompOutputHandler.sendToClient(stompFrameMessage3, context, this);
            }
            catch (Exception exception2) {
                _logger.log(Level.WARNING, (Object)((Object)stompFrameMessage.getCommand()) + ": Unable to create error message for exception: " + exception.getMessage(), exception);
                return;
            }
        }
    }

    public void onSEND(StompFrameMessage stompFrameMessage, StompOutputHandler stompOutputHandler, Context context) {
        StompFrameMessage stompFrameMessage2 = null;
        Message message = null;
        StompSenderSession stompSenderSession = null;
        try {
            String string;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.putAll(stompFrameMessage.getHeaders());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "on" + (Object)((Object)stompFrameMessage.getCommand()) + ", headers=" + hashMap);
            }
            if ((string = (String)hashMap.remove("transaction".toString())) != null) {
                stompSenderSession = this._stompConnection.getTransactedSession(string);
                _logger.log(Level.FINE, "Sending message on transacted session: " + stompSenderSession + " for transaction " + string);
            } else {
                stompSenderSession = this._stompConnection.getSenderSession();
            }
            if (stompFrameMessage.getContentLength() != -1) {
                hashMap.remove("content-length".toString());
                message = stompSenderSession.getJMSSession().createBytesMessage();
                ((BytesMessage)message).writeBytes(stompFrameMessage.getBody());
            } else {
                message = stompSenderSession.getJMSSession().createTextMessage();
                message.setText(stompFrameMessage.getBodyText());
            }
            String string2 = (String)hashMap.remove("destination".toString());
            Destination destination = this.toJMSDestination(string2, stompSenderSession.getJMSSession(), false);
            MessageProducer messageProducer = stompSenderSession.getJMSProducer();
            int n = messageProducer.getPriority();
            String string3 = (String)hashMap.remove("priority".toString());
            if (string3 != null) {
                n = Integer.parseInt(string3);
            }
            int n2 = messageProducer.getDeliveryMode();
            string3 = (String)hashMap.remove("persistent".toString());
            if (string3 != null) {
                n2 = Boolean.valueOf(string3) != false ? 2 : 1;
            }
            long l = messageProducer.getTimeToLive();
            string3 = (String)hashMap.remove("expires".toString());
            if (string3 != null) {
                l = Long.parseLong(string3);
            }
            message.setJMSCorrelationID((String)hashMap.remove("correlation-id".toString()));
            string3 = (String)hashMap.remove("type".toString());
            if (string3 != null) {
                message.setJMSType(string3);
            }
            if ((string3 = (String)hashMap.remove("reply-to".toString())) != null) {
                message.setJMSReplyTo(this.toJMSDestination(string3, stompSenderSession.getJMSSession(), false));
            }
            string3 = (String)hashMap.remove("receipt");
            for (String string4 : hashMap.keySet()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Set header " + string4 + ":" + (String)hashMap.get(string4) + " as JMS Message property");
                }
                message.setStringProperty(string4, (String)hashMap.get(string4));
            }
            MessageTransformer<Message, Message> messageTransformer = StompServer.getMessageTransformer();
            if (messageTransformer != null) {
                messageTransformer.init(stompSenderSession.getJMSSession());
                message = (Message)messageTransformer.transform(message, false, "UTF-8", "STOMP", "SUN_MQ", null);
            }
            messageProducer.send(destination, message, n2, n, l);
            _logger.log(Level.FINE, "Sent message " + message.getJMSMessageID());
            stompFrameMessage2 = StompProtocolHandler.getStompReceiptMessage(stompFrameMessage);
            if (stompFrameMessage2 != null) {
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, (Object)((Object)stompFrameMessage.getCommand()) + " failed: " + exception.getMessage(), exception);
            try {
                stompFrameMessage2 = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.SEND.toString(), exception);
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
            catch (Exception exception2) {
                _logger.log(Level.WARNING, (Object)((Object)stompFrameMessage.getCommand()) + ": Unable to send error message to client for exception: " + exception.getMessage(), exception);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSUBSCRIBE(StompFrameMessage stompFrameMessage, StompOutputHandler stompOutputHandler, Context context, StompOutputHandler stompOutputHandler2) throws Exception {
        StompFrameMessage stompFrameMessage2 = null;
        String string = null;
        String string2 = null;
        boolean bl = false;
        try {
            HashMap<String, String> hashMap = stompFrameMessage.getHeaders();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "on" + (Object)((Object)stompFrameMessage.getCommand()) + ", headers=" + hashMap);
            }
            String string3 = hashMap.get("transaction".toString());
            string = hashMap.get("id".toString());
            String string4 = hashMap.get("ack".toString());
            int n = 1;
            if (string4 != null && string4.equals("client".toString())) {
                n = 2;
            }
            String string5 = hashMap.get("selector".toString());
            String string6 = hashMap.get("destination".toString());
            if (string6 == null) {
                throw new FrameParseException("SUBSCRIBE without destination header!");
            }
            if (string == null) {
                string = StompProtocolHandler.makeDefaultSubscriberId(string6);
            }
            if (this._subids.contains(string)) {
                throw new FrameParseException("Subscriber with id " + string + " already exists !");
            }
            boolean bl2 = false;
            String string7 = hashMap.get("no-local".toString());
            if (string7 != null && string7.equalsIgnoreCase("true")) {
                bl2 = true;
            }
            string2 = hashMap.get("durable-subscriber-name".toString());
            if (string3 == null) {
                StompSubscriberSession stompSubscriberSession = this._stompConnection.createSubscriberSession(string, n);
                bl = true;
                stompSubscriberSession.createSubscriber(this.toJMSDestination(string6, stompSubscriberSession.getJMSSession(), true), string5, string2, bl2, stompOutputHandler2);
            } else {
                StompTransactedSession stompTransactedSession = this._stompConnection.getTransactedSession(string3);
                bl = true;
                stompTransactedSession.createSubscriber(string, this.toJMSDestination(string6, stompTransactedSession.getJMSSession(), true), string5, string2, bl2, stompOutputHandler2);
            }
            this._subids.add(string);
            stompFrameMessage2 = StompProtocolHandler.getStompReceiptMessage(stompFrameMessage);
            if (stompFrameMessage2 != null) {
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, (Object)((Object)stompFrameMessage.getCommand()) + " failed: " + exception.getMessage(), exception);
            try {
                if (bl) {
                    this._stompConnection.closeSubscriber(string, null);
                    this._subids.remove(string);
                }
            }
            catch (Exception exception2) {
                _logger.log(Level.FINEST, (Object)((Object)stompFrameMessage.getCommand()) + ": Unable to close subscriber (subid=" + string + ", duraname=" + string2 + "): " + exception2.getMessage() + " after creation failure: " + exception.getMessage(), exception2);
            }
            finally {
                try {
                    stompFrameMessage2 = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.SUBSCRIBE.toString(), exception);
                    stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
                }
                catch (Exception exception3) {
                    _logger.log(Level.WARNING, (Object)((Object)stompFrameMessage.getCommand()) + ": Unable to send error message to client for exception: " + exception.getMessage(), exception);
                }
            }
            return;
        }
    }

    public void onUNSUBSCRIBE(StompFrameMessage stompFrameMessage, StompOutputHandler stompOutputHandler, Context context) throws Exception {
        StompFrameMessage stompFrameMessage2 = null;
        try {
            HashMap<String, String> hashMap = stompFrameMessage.getHeaders();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "on" + (Object)((Object)stompFrameMessage.getCommand()) + ", headers=" + hashMap);
            }
            String string = hashMap.get("id".toString());
            String string2 = hashMap.get("destination".toString());
            String string3 = hashMap.get("durable-subscriber-name".toString());
            if (string == null && string3 == null) {
                if (string2 == null) {
                    throw new FrameParseException("UNSUBSCRIBE without destination or id header!");
                }
                string = StompProtocolHandler.makeDefaultSubscriberId(string2);
            }
            String string4 = this._stompConnection.closeSubscriber(string, string3);
            if (string3 == null) {
                this._subids.remove(string);
            } else if (string4 != null) {
                this._subids.remove(string4);
            }
            stompFrameMessage2 = StompProtocolHandler.getStompReceiptMessage(stompFrameMessage);
            if (stompFrameMessage2 != null) {
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, (Object)((Object)stompFrameMessage.getCommand()) + " failed: " + exception.getMessage(), exception);
            try {
                stompFrameMessage2 = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.UNSUBSCRIBE.toString(), exception);
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
            catch (Exception exception2) {
                _logger.log(Level.WARNING, (Object)((Object)stompFrameMessage.getCommand()) + ": Unable to send error message to client for exception: " + exception.getMessage(), exception);
            }
            return;
        }
    }

    public void onBEGIN(StompFrameMessage stompFrameMessage, StompOutputHandler stompOutputHandler, Context context) throws Exception {
        StompFrameMessage stompFrameMessage2 = null;
        try {
            String string;
            HashMap<String, String> hashMap = stompFrameMessage.getHeaders();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "on" + (Object)((Object)stompFrameMessage.getCommand()) + ", headers=" + hashMap);
            }
            if ((string = hashMap.get("transaction".toString())) == null) {
                throw new FrameParseException(StompFrameMessage.Command.BEGIN.toString() + ": " + "transaction".toString() + " not specified !");
            }
            this._stompConnection.beginTransactedSession(string);
            stompFrameMessage2 = StompProtocolHandler.getStompReceiptMessage(stompFrameMessage);
            if (stompFrameMessage2 != null) {
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, (Object)((Object)stompFrameMessage.getCommand()) + " failed: " + exception.getMessage(), exception);
            try {
                stompFrameMessage2 = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.BEGIN.toString(), exception);
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
            catch (Exception exception2) {
                _logger.log(Level.WARNING, (Object)((Object)stompFrameMessage.getCommand()) + ": Unable to send error message to client for exception: " + exception.getMessage(), exception);
            }
            return;
        }
    }

    public void onCOMMIT(StompFrameMessage stompFrameMessage, StompOutputHandler stompOutputHandler, Context context) throws Exception {
        StompFrameMessage stompFrameMessage2 = null;
        try {
            String string;
            HashMap<String, String> hashMap = stompFrameMessage.getHeaders();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "on" + (Object)((Object)stompFrameMessage.getCommand()) + ", headers=" + hashMap);
            }
            if ((string = hashMap.get("transaction".toString())) == null) {
                throw new FrameParseException(StompFrameMessage.Command.COMMIT.toString() + ": " + "transaction".toString() + " not specified !");
            }
            this._stompConnection.commitTransactedSession(string);
            stompFrameMessage2 = StompProtocolHandler.getStompReceiptMessage(stompFrameMessage);
            if (stompFrameMessage2 != null) {
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, (Object)((Object)stompFrameMessage.getCommand()) + " failed: " + exception.getMessage(), exception);
            try {
                stompFrameMessage2 = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.COMMIT.toString(), exception);
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
            catch (Exception exception2) {
                _logger.log(Level.WARNING, (Object)((Object)stompFrameMessage.getCommand()) + ": Unable to send error message to client for exception: " + exception.getMessage(), exception);
            }
            return;
        }
    }

    public void onABORT(StompFrameMessage stompFrameMessage, StompOutputHandler stompOutputHandler, Context context) throws Exception {
        StompFrameMessage stompFrameMessage2 = null;
        try {
            String string;
            HashMap<String, String> hashMap = stompFrameMessage.getHeaders();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "on" + (Object)((Object)stompFrameMessage.getCommand()) + ", headers=" + hashMap);
            }
            if ((string = hashMap.get("transaction".toString())) == null) {
                throw new FrameParseException(StompFrameMessage.Command.COMMIT.toString() + ": " + "transaction".toString() + " not specified !");
            }
            this._stompConnection.abortTransactedSession(string);
            stompFrameMessage2 = StompProtocolHandler.getStompReceiptMessage(stompFrameMessage);
            if (stompFrameMessage2 != null) {
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, (Object)((Object)stompFrameMessage.getCommand()) + " failed: " + exception.getMessage(), exception);
            try {
                stompFrameMessage2 = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.ABORT.toString(), exception);
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
            catch (Exception exception2) {
                _logger.log(Level.WARNING, (Object)((Object)stompFrameMessage.getCommand()) + ": Unable to send error message to client for exception: " + exception.getMessage(), exception);
            }
            return;
        }
    }

    public void onACK(StompFrameMessage stompFrameMessage, StompOutputHandler stompOutputHandler, Context context) throws Exception {
        StompFrameMessage stompFrameMessage2 = null;
        try {
            String string;
            HashMap<String, String> hashMap = stompFrameMessage.getHeaders();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "on" + (Object)((Object)stompFrameMessage.getCommand()) + ", headers=" + hashMap);
            }
            if ((string = hashMap.get("message-id")) == null) {
                throw new FrameParseException(StompFrameMessage.Command.ACK.toString() + ": " + "message-id" + " not specified !");
            }
            String string2 = hashMap.get("transaction".toString());
            String string3 = hashMap.get("subscription".toString());
            if (string3 != null && !this._subids.contains(string3)) {
                throw new StompProtocolException("Subscription id " + string3 + " not found");
            }
            if (string2 != null) {
                StompTransactedSession stompTransactedSession = this._stompConnection.getTransactedSession(string2);
                if (string3 != null) {
                    stompTransactedSession.ack(string3, string);
                } else {
                    _logger.log(Level.WARNING, "No " + "subscription".toString() + " header specified, ACK in transaction " + string2 + " for all subscriptions ids with prefix " + DEFAULT_SUBID_PREFIX + " for message " + string);
                    stompTransactedSession.ack(DEFAULT_SUBID_PREFIX, string, true);
                }
            } else if (string3 != null) {
                StompSubscriberSession stompSubscriberSession = this._stompConnection.getSubscriberSession(string3);
                if (stompSubscriberSession != null) {
                    stompSubscriberSession.ack(string);
                } else {
                    StompTransactedSession stompTransactedSession = this._stompConnection.getTransactedSession();
                    if (stompTransactedSession == null) {
                        throw new StompProtocolException("No session found for subscription id " + string3);
                    }
                    stompTransactedSession.ack(string3, string);
                }
            } else {
                _logger.log(Level.WARNING, "No " + "subscription".toString() + " header specified, ACK all non-transacted subscription ids with prefix " + DEFAULT_SUBID_PREFIX + " for message " + string);
                this._stompConnection.ackNonTransacted(DEFAULT_SUBID_PREFIX, string);
            }
            stompFrameMessage2 = StompProtocolHandler.getStompReceiptMessage(stompFrameMessage);
            if (stompFrameMessage2 != null) {
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, (Object)((Object)stompFrameMessage.getCommand()) + " failed: " + exception.getMessage(), exception);
            try {
                stompFrameMessage2 = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.ACK.toString(), exception);
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
            catch (Exception exception2) {
                _logger.log(Level.WARNING, (Object)((Object)stompFrameMessage.getCommand()) + ": Unable to send error message to client for exception: " + exception.getMessage(), exception);
            }
            return;
        }
    }

    public static StompFrameMessage getStompReceiptMessage(StompFrameMessage stompFrameMessage) throws Exception {
        StompFrameMessage stompFrameMessage2 = null;
        String string = stompFrameMessage.getHeader("receipt".toString());
        if (string != null) {
            stompFrameMessage2 = new StompFrameMessage(StompFrameMessage.Command.RECEIPT);
            stompFrameMessage2.addHeader("receipt-id".toString(), string);
        }
        return stompFrameMessage2;
    }

    public static StompFrameMessage toStompErrorMessage(String string, Throwable throwable) throws Exception {
        StompFrameMessage stompFrameMessage = new StompFrameMessage(StompFrameMessage.Command.ERROR);
        stompFrameMessage.addHeader("message".toString(), string + ": " + throwable.getMessage());
        stompFrameMessage.writeExceptionToBody(throwable);
        return stompFrameMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination toJMSDestination(String string, Session session, boolean bl) throws Exception {
        if (string.startsWith("/queue/")) {
            String string2 = string.substring("/queue/".length(), string.length()).trim();
            return session.createQueue(string2);
        }
        if (string.startsWith("/topic/")) {
            String string3 = string.substring("/topic/".length(), string.length()).trim();
            return session.createTopic(string3);
        }
        if (string.startsWith("/temp-queue/")) {
            String string4 = string.substring("/temp-queue/".length(), string.length()).trim();
            if (string4.startsWith(MQ_TEMP_QUEUE_PREFIX)) {
                if (bl) {
                    throw new JMSException("Can't subscribe " + string);
                }
                Map<String, TemporaryQueue> map = this._mqtempQueues;
                synchronized (map) {
                    Destination destination = this._mqtempQueues.get(string4);
                    if (destination == null) {
                        throw new JMSException("MQ TemporaryQueue not found: " + string);
                    }
                    return destination;
                }
            }
            Map<String, TemporaryQueue> map = this._tempQueues;
            synchronized (map) {
                TemporaryQueue temporaryQueue = this._tempQueues.get(string4);
                if (temporaryQueue != null) {
                    return temporaryQueue;
                }
                temporaryQueue = session.createTemporaryQueue();
                this._tempQueues.put(string4, temporaryQueue);
                return temporaryQueue;
            }
        }
        if (string.startsWith("/temp-topic/")) {
            String string5 = string.substring("/temp-topic/".length(), string.length()).trim();
            if (string5.startsWith(MQ_TEMP_TOPIC_PREFIX)) {
                if (bl) {
                    throw new JMSException("Can't subscribe " + string);
                }
                Map<String, TemporaryTopic> map = this._mqtempTopics;
                synchronized (map) {
                    Destination destination = this._mqtempTopics.get(string5);
                    if (destination == null) {
                        throw new JMSException("MQ TemporaryTopic not found: " + string);
                    }
                    return destination;
                }
            }
            Map<String, TemporaryTopic> map = this._tempTopics;
            synchronized (map) {
                TemporaryTopic temporaryTopic = this._tempTopics.get(string5);
                if (temporaryTopic != null) {
                    return temporaryTopic;
                }
                temporaryTopic = session.createTemporaryTopic();
                this._tempTopics.put(string5, temporaryTopic);
                return temporaryTopic;
            }
        }
        throw new FrameParseException("Invalid header destination value:" + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStompDestination(Destination destination, boolean bl) throws Exception {
        if (destination == null) {
            throw new JMSException("JMS destination null !");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (destination instanceof TemporaryQueue) {
            String string = ((Queue)destination).getQueueName();
            stringBuffer.append("/temp-queue/").append(string);
            if (bl) {
                Map<String, TemporaryQueue> map = this._mqtempQueues;
                synchronized (map) {
                    if (this._mqtempQueues.get(string) == null) {
                        this._mqtempQueues.put(string, (TemporaryQueue)destination);
                    }
                }
            }
            return stringBuffer.toString();
        }
        if (destination instanceof TemporaryTopic) {
            String string = ((Topic)destination).getTopicName();
            stringBuffer.append("/temp-topic/").append(string);
            if (bl) {
                Map<String, TemporaryTopic> map = this._mqtempTopics;
                synchronized (map) {
                    if (this._mqtempTopics.get(string) == null) {
                        this._mqtempTopics.put(string, (TemporaryTopic)destination);
                    }
                }
            }
            return stringBuffer.toString();
        }
        if (destination instanceof Queue) {
            stringBuffer.append("/queue/").append(((Queue)destination).getQueueName());
            return stringBuffer.toString();
        }
        if (destination instanceof Topic) {
            stringBuffer.append("/topic/").append(((Topic)destination).getTopicName());
            return stringBuffer.toString();
        }
        throw new JMSException("Unknow destination type: " + destination);
    }

    private static String makeDefaultSubscriberId(String string) {
        return DEFAULT_SUBID_PREFIX + string;
    }

    protected StompFrameMessage toStompFrameMessage(Message message, String string, Session session) throws Exception {
        MessageTransformer<Message, Message> messageTransformer = StompServer.getMessageTransformer();
        if (messageTransformer != null) {
            messageTransformer.init(session);
            message = messageTransformer.transform(message, true, null, "SUN_MQ", "STOMP", null);
        }
        StompFrameMessage stompFrameMessage = new StompFrameMessage(StompFrameMessage.Command.MESSAGE);
        HashMap<String, String> hashMap = stompFrameMessage.getHeaders();
        hashMap.put("subscription", string);
        Destination destination = message.getJMSDestination();
        hashMap.put("destination".toString(), this.toStompDestination(destination, false));
        destination = message.getJMSReplyTo();
        if (destination != null) {
            hashMap.put("reply-to".toString(), this.toStompDestination(destination, true));
        }
        hashMap.put("message-id".toString(), message.getJMSMessageID());
        String string2 = message.getJMSCorrelationID();
        if (string2 != null) {
            hashMap.put("correlation-id".toString(), string2);
        }
        hashMap.put("expires".toString(), String.valueOf(message.getJMSExpiration()));
        hashMap.put("redelivered", String.valueOf(message.getJMSRedelivered()));
        hashMap.put("priority".toString(), String.valueOf(message.getJMSPriority()));
        hashMap.put("timestamp".toString(), String.valueOf(message.getJMSTimestamp()));
        string2 = message.getJMSType();
        if (string2 != null) {
            hashMap.put("type".toString(), string2);
        }
        Enumeration enumeration = message.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = message.getObjectProperty(string3).toString();
            hashMap.put(string3, string4);
        }
        if (message instanceof TextMessage) {
            String string5 = ((TextMessage)message).getText();
            if (string5 != null) {
                byte[] byArray = string5.getBytes("UTF-8");
                stompFrameMessage.setBody(byArray);
                hashMap.put("content-length", String.valueOf(byArray.length));
            } else {
                hashMap.put("content-length", String.valueOf(0));
            }
        } else if (message instanceof BytesMessage) {
            BytesMessage bytesMessage = (BytesMessage)message;
            byte[] byArray = new byte[(int)bytesMessage.getBodyLength()];
            bytesMessage.readBytes(byArray);
            stompFrameMessage.setBody(byArray);
            hashMap.put("content-length", String.valueOf(byArray.length));
        } else {
            throw new JMSException("Message type is not supported: " + message);
        }
        return stompFrameMessage;
    }
}

