/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms;

import com.sun.messaging.bridge.service.jms.EventListener;
import com.sun.messaging.bridge.service.jms.EventNotifier;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.SharedConnection;
import com.sun.messaging.bridge.service.jms.SharedConnectionImpl;
import com.sun.messaging.bridge.service.jms.SharedXAConnectionImpl;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;

public class SharedConnectionFactory
implements Runnable {
    private Logger _logger = null;
    private Object _cf = null;
    private int _idleTimeout = 0;
    private int _maxRetries = 0;
    private int _retryInterval = 0;
    private final int _closeWaittime = 15;
    private ScheduledExecutorService _scheduler = null;
    private final ReentrantLock _lock = new ReentrantLock();
    private final Condition _refcnt0 = this._lock.newCondition();
    private SharedConnection _conn = null;
    private int _refcnt = 0;
    private ScheduledFuture _future = null;
    private boolean _closed = false;
    private EventNotifier _notifier = new EventNotifier();

    public SharedConnectionFactory(Object object, Properties properties, Logger logger) throws Exception {
        this._cf = object;
        this._logger = logger;
        this._idleTimeout = Integer.valueOf(properties.getProperty("idle-timeout-in-seconds", "1800"));
        if (this._idleTimeout < 0) {
            this._idleTimeout = 0;
        }
        this._maxRetries = Integer.valueOf(properties.getProperty("connect-attempts", "-1"));
        this._retryInterval = Integer.valueOf(properties.getProperty("connect-attempt-interval-in-seconds", "5"));
        if (this._retryInterval < 0) {
            this._retryInterval = 0;
        }
        this._scheduler = Executors.newSingleThreadScheduledExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection obtainConnection(Connection connection, String string, Object object, boolean bl) throws Exception {
        this._lock.lockInterruptibly();
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Obtaining shared connection from shared connection factory " + this);
        }
        if (this._closed) {
            if (connection == null) {
                throw new JMSException("Shared connection factory " + this + " is closed");
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                this._logger.log(Level.WARNING, "Unable to close conneciton from shared connection factory " + this);
            }
            throw new JMSException("Shared connection factory " + this + " is closed");
        }
        if (connection != null) {
            this._conn = connection instanceof XAConnection ? new SharedXAConnectionImpl((XAConnection)connection) : new SharedConnectionImpl(connection);
        }
        if (this._conn != null && !this._conn.isValid()) {
            try {
                ((Connection)((Object)this._conn)).close();
            }
            catch (Exception exception) {
                this._logger.log(Level.WARNING, "Unable to close invalid connection " + this._conn + " from shared connection factory " + this);
            }
            this._conn = null;
        }
        try {
            if (this._conn == null) {
                Connection connection2 = null;
                EventListener eventListener = new EventListener();
                try {
                    this._notifier.addEventListener(EventListener.EventType.CONN_CLOSE, eventListener);
                    connection2 = JMSBridge.openConnection(this._cf, this._maxRetries, this._retryInterval, string, object, eventListener, this._logger, bl);
                }
                finally {
                    this._notifier.removeEventListener(eventListener);
                }
                this._conn = this._cf instanceof XAConnectionFactory ? new SharedXAConnectionImpl((XAConnection)connection2) : new SharedConnectionImpl(connection2);
            }
            if (this._closed) {
                try {
                    ((Connection)((Object)this._conn)).close();
                }
                catch (Exception exception) {
                    this._logger.log(Level.FINE, "Exception on closing connection " + this._conn + ": " + exception.getMessage());
                }
                this._conn = null;
                throw new JMSException("Shared connection factory closed");
            }
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Increment refcnt in shared connection factory " + this);
            }
            ++this._refcnt;
            if (this._future != null) {
                this._future.cancel(true);
                this._future = null;
            }
        }
        finally {
            this._lock.unlock();
        }
        return (Connection)((Object)this._conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(Connection connection) throws Exception {
        this._lock.lock();
        try {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Decrement refcnt in shared connection factory " + this);
            }
            --this._refcnt;
            assert (this._refcnt >= 0);
            if (this._refcnt == 0 && this._idleTimeout > 0) {
                if (this._future != null) {
                    this._future.cancel(true);
                }
                this._logger.log(Level.INFO, "Schedule idle shared connection timeout [" + this._idleTimeout + " secs] in shared connection factory " + this);
                this._future = this._scheduler.schedule(this, (long)this._idleTimeout, TimeUnit.SECONDS);
            }
            if (this._refcnt == 0) {
                this._refcnt0.signalAll();
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this._logger.log(Level.INFO, "Check idle timeout in shared connection factory " + this);
        try {
            this._lock.lockInterruptibly();
        }
        catch (Throwable throwable) {
            this._logger.log(Level.WARNING, "Unable to get lock for idle connection check in shared connection factory " + this + ": " + throwable.getMessage());
            return;
        }
        try {
            if (this._refcnt > 0) {
                return;
            }
            this._logger.log(Level.INFO, "Closing idle timed out shared connection " + this._conn + " in shared connection factory " + this);
            try {
                ((Connection)((Object)this._conn)).close();
                this._conn = null;
            }
            catch (Throwable throwable) {
                try {
                    this._logger.log(Level.WARNING, "Exception in closing idle timed out shared connection: " + throwable.getMessage() + " in shared connection factory " + this);
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    this._conn = null;
                }
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        this._closed = true;
        this._logger.log(Level.INFO, "Closing shared connection factory " + this);
        this._notifier.notifyEvent(EventListener.EventType.CONN_CLOSE, this);
        this._scheduler.shutdownNow();
        boolean bl = false;
        try {
            this._lock.lockInterruptibly();
            try {
                if (this._conn == null) {
                    return;
                }
                if (this._refcnt > 0) {
                    this._logger.log(Level.WARNING, "Force close shared connection factory " + this + " with outstanding reference count " + this._refcnt);
                }
                ((Connection)((Object)this._conn)).close();
                bl = true;
            }
            catch (Exception exception) {
                this._logger.log(Level.WARNING, "Exception in closing shared connection " + exception.getMessage());
            }
            finally {
                this._lock.unlock();
            }
        }
        finally {
            Connection connection = (Connection)((Object)this._conn);
            try {
                if (connection != null && !bl) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                this._logger.log(Level.FINE, "Exception in closing shared connection " + connection + ": " + exception.getMessage());
            }
        }
    }

    public Object getCF() {
        return this._cf;
    }

    public int getIdleTimeout() {
        return this._idleTimeout;
    }

    public int getMaxRetries() {
        return this._maxRetries;
    }

    public int getRetryInterval() {
        return this._retryInterval;
    }

    public int getRefCount() {
        return this._refcnt;
    }

    public String toString() {
        return this._cf + "[" + this._refcnt + "]";
    }
}

