/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.DestMetricsCounters;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.core.cluster.RemoteConsumer;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.FeatureUnavailableException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.SimpleNFLHashMap;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Topic
extends Destination {
    static final long serialVersionUID = -5748515630523651753L;
    private static boolean DEBUG = false;
    private transient Map selectorToInterest;
    private transient List selectors;
    private transient Map remoteConsumers;
    private static int TOPIC_DEFAULT_PREFETCH = Globals.getConfig().getIntProperty("imq.autocreate.topic.consumerFlowLimit", 1000);
    private boolean hasNoLocalConsumers = false;
    int maxSharedConsumers = 0;
    int sharedPrefetch = 0;
    public static final String MAX_SHARE_CONSUMERS = "max_shared_consumers";
    public static final String SHARED_PREFETCH = "sharedPrefetch";
    public static final int AUTO_MAX_SHARED_CONSUMER_LIMIT = Globals.getConfig().getIntProperty("imq.autocreate.topic.maxNumSharedConsumers", -1);
    public static final int AUTO_MAX_SHARED_FLOW_LIMIT = Globals.getConfig().getIntProperty("imq.autocreate.topic.sharedConsumerFlowLimit", 5);
    public static final int ADMIN_MAX_SHARED_CONSUMER_LIMIT = Globals.getConfig().getIntProperty("imq.admincreate.topic.maxNumSharedConsumers", -1);
    public static final int ADMIN_MAX_SHARED_FLOW_LIMIT = Globals.getConfig().getIntProperty("imq.admincreate.topic.sharedConsumerFlowLimit", 5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable hashtable = super.getDebugState();
        Hashtable hashtable2 = new Hashtable();
        Map map = this.selectorToInterest;
        synchronized (map) {
            for (Selector selector : this.selectorToInterest.keySet()) {
                Set set = (Set)this.selectorToInterest.get(selector);
                Vector<String> vector = new Vector<String>();
                Set set2 = set;
                synchronized (set2) {
                    for (Consumer consumer : set) {
                        vector.add(String.valueOf(consumer.getConsumerUID().longValue()));
                    }
                }
                hashtable2.put(selector == null ? "no selector" : selector.toString(), vector);
            }
        }
        hashtable.put("selectorInfo", hashtable2);
        hashtable.put(MAX_SHARE_CONSUMERS, new Integer(this.maxSharedConsumers));
        hashtable.put(SHARED_PREFETCH, new Integer(this.sharedPrefetch));
        return hashtable;
    }

    protected Topic(DestinationUID destinationUID) {
        super(destinationUID);
    }

    protected Topic(String string, int n, boolean bl, ConnectionUID connectionUID, boolean bl2) throws FeatureUnavailableException, BrokerException, IOException {
        super(string, n, bl, connectionUID, bl2);
        this.maxPrefetch = TOPIC_DEFAULT_PREFETCH;
        if (bl2) {
            this.maxSharedConsumers = AUTO_MAX_SHARED_CONSUMER_LIMIT;
            this.sharedPrefetch = AUTO_MAX_SHARED_FLOW_LIMIT;
        } else {
            this.maxSharedConsumers = ADMIN_MAX_SHARED_CONSUMER_LIMIT;
            this.sharedPrefetch = ADMIN_MAX_SHARED_FLOW_LIMIT;
        }
    }

    protected void initVar() {
        this.selectorToInterest = new HashMap();
        this.selectors = new ArrayList();
        this.remoteConsumers = new HashMap();
    }

    public void unload(boolean bl) {
        super.unload(bl);
        if (bl) {
            for (Consumer consumer : this.consumers.values()) {
                consumer.unloadMessages();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnackSize() {
        HashSet hashSet = null;
        SimpleNFLHashMap simpleNFLHashMap = this.destMessages;
        synchronized (simpleNFLHashMap) {
            hashSet = new HashSet(this.destMessages.values());
        }
        int n = 0;
        for (PacketReference packetReference : hashSet) {
            if (packetReference.isInvalid() || packetReference.isDestroyed() || packetReference.getDeliverCnt() - packetReference.getCompleteCnt() <= 0) continue;
            ++n;
        }
        return n;
    }

    public Set routeAndMoveMessage(PacketReference packetReference, PacketReference packetReference2) throws IOException, BrokerException {
        throw new RuntimeException("XXX not implemented");
    }

    public boolean queueMessage(PacketReference packetReference, boolean bl) throws BrokerException {
        if (!bl && this.consumers.size() == 0) {
            return false;
        }
        return super.queueMessage(packetReference, bl);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.initVar();
        objectInputStream.defaultReadObject();
    }

    public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
        super.eventOccured(eventType, reason, object, object2, object3, object4);
    }

    public void routeNewMessage(SysMessageID sysMessageID) throws BrokerException, SelectorFormatException {
        PacketReference packetReference = (PacketReference)this.destMessages.get(sysMessageID);
        Set set = this.routeNewMessage(packetReference);
        this.forwardMessage(set, packetReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConsumerCount() {
        int n = super.getConsumerCount();
        Map map = this.remoteConsumers;
        synchronized (map) {
            for (RemoteConsumer remoteConsumer : this.remoteConsumers.values()) {
                n += remoteConsumer.getConsumerCount();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set matchRemoteConsumers(PacketReference packetReference, Set set) throws BrokerException, SelectorFormatException {
        Map map = this.remoteConsumers;
        synchronized (map) {
            if (this.remoteConsumers.isEmpty()) {
                return set;
            }
            HashSet hashSet = new HashSet(set);
            for (RemoteConsumer remoteConsumer : this.remoteConsumers.values()) {
                if (!remoteConsumer.match(packetReference, hashSet)) continue;
                set.add(remoteConsumer);
            }
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConsumerUID[] routeLoadedTransactionMessage(PacketReference packetReference) throws BrokerException, SelectorFormatException {
        Object object;
        Object object22;
        HashSet hashSet = new HashSet();
        Map map = null;
        HashMap hashMap = null;
        Object object3 = this.selectorToInterest;
        synchronized (object3) {
            for (Object object22 : this.selectorToInterest.keySet()) {
                boolean bl;
                if (object22 != null) {
                    if (map == null && ((Selector)object22).usesProperties()) {
                        try {
                            map = packetReference.getProperties();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            this.logger.logStack(32, "INTERNAL ERROR", classNotFoundException);
                            map = new HashMap();
                        }
                    }
                    if (hashMap == null && ((Selector)object22).usesFields()) {
                        hashMap = packetReference.getHeaders();
                    }
                }
                if (!(bl = object22 == null || ((Selector)object22).match(map, hashMap))) continue;
                if (DEBUG) {
                    this.logger.log(8, "Selector " + object22 + " Matches " + packetReference.getSysMessageID());
                }
                if ((object = (Set)this.selectorToInterest.get(object22)) == null) continue;
                Object object4 = object;
                synchronized (object4) {
                    hashSet.addAll(object);
                }
            }
        }
        object3 = new HashSet();
        Iterator<Object> iterator = hashSet.iterator();
        object22 = packetReference.getProducingConnectionUID();
        String string = packetReference.getClientID();
        while (iterator.hasNext()) {
            object = (Consumer)iterator.next();
            if (((Consumer)object).getNoLocal()) {
                if (object instanceof Subscription && string != null && ((Subscription)object).getClientID() != null && ((Subscription)object).getClientID().equals(string)) {
                    iterator.remove();
                    continue;
                }
                if (((Consumer)object).getConsumerUID().getConnectionUID() == object22) {
                    iterator.remove();
                    continue;
                }
                ((HashSet)object3).add(((Consumer)object).getConsumerUID());
                continue;
            }
            ((HashSet)object3).add(((Consumer)object).getConsumerUID());
        }
        return ((HashSet)object3).toArray(new ConsumerUID[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set routeNewMessage(PacketReference packetReference) throws BrokerException, SelectorFormatException {
        Object object;
        Object object2;
        Object object3;
        HashSet hashSet = new HashSet();
        Map map = null;
        HashMap hashMap = null;
        for (int i = 0; i < this.selectors.size(); ++i) {
            object3 = null;
            try {
                object3 = (Selector)this.selectors.get(i);
            }
            catch (Exception exception) {
                continue;
            }
            if (object3 == null) {
                object2 = (Set)this.selectorToInterest.get(object3);
                if (object2 == null) continue;
                object = object2;
                synchronized (object) {
                    hashSet.addAll(object2);
                    continue;
                }
            }
            if (map == null && ((Selector)object3).usesProperties()) {
                try {
                    map = packetReference.getProperties();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logger.logStack(32, "INTERNAL ERROR", classNotFoundException);
                    map = new HashMap();
                }
            }
            if (hashMap == null && ((Selector)object3).usesFields()) {
                hashMap = packetReference.getHeaders();
            }
            if (!((Selector)object3).match(map, hashMap) || (object2 = (Set)this.selectorToInterest.get(object3)) == null) continue;
            object = object2;
            synchronized (object) {
                hashSet.addAll(object2);
                continue;
            }
        }
        if (this.hasNoLocalConsumers) {
            Iterator iterator = hashSet.iterator();
            object3 = packetReference.getProducingConnectionUID();
            object2 = packetReference.getClientID();
            while (iterator.hasNext()) {
                object = (Consumer)iterator.next();
                if (!((Consumer)object).getNoLocal()) continue;
                if (object instanceof Subscription && object2 != null && ((Subscription)object).getClientID() != null && ((Subscription)object).getClientID().equals(object2)) {
                    iterator.remove();
                    continue;
                }
                if (((Consumer)object).getConsumerUID().getConnectionUID() != object3) continue;
                iterator.remove();
            }
        }
        if (hashSet.isEmpty()) {
            this.removeMessage(packetReference.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
            return null;
        }
        packetReference.store(hashSet);
        return hashSet;
    }

    public void forwardOrphanMessages(Collection collection, ConsumerUID consumerUID) throws BrokerException {
        BrokerException brokerException = new BrokerException("INTERNAL ERROR: Unexpected call");
        this.logger.logStack(32, brokerException.getMessage(), brokerException);
        throw brokerException;
    }

    public void forwardOrphanMessage(PacketReference packetReference, ConsumerUID consumerUID) throws BrokerException {
        Consumer consumer = this.getConsumer(consumerUID);
        if (consumer == null) {
            this.logger.log(4, "Dumping orphan message " + packetReference);
            try {
                if (packetReference.acknowledged(consumerUID, consumerUID, false, false)) {
                    this.removeMessage(packetReference.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                }
            }
            catch (Exception exception) {
                this.logger.logStack(4, "Error forwarding orphan", exception);
            }
        }
        HashSet<Consumer> hashSet = new HashSet<Consumer>();
        hashSet.add(consumer);
        this.forwardMessage(hashSet, packetReference);
    }

    public void forwardMessage(Set set, PacketReference packetReference) throws BrokerException {
        HashSet<Consumer> hashSet = null;
        if (set == null || set.isEmpty()) {
            this.removeMessage(packetReference.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
        } else {
            for (Consumer consumer : set) {
                if (consumer.isFalconRemote()) {
                    if (hashSet == null) {
                        hashSet = new HashSet<Consumer>();
                    }
                    hashSet.add(consumer);
                    continue;
                }
                if (consumer.routeMessage(packetReference, false)) continue;
                boolean bl = false;
                try {
                    ConsumerUID consumerUID = consumer.getConsumerUID();
                    bl = packetReference.acknowledged(consumerUID, consumer.getStoredConsumerUID(), !consumerUID.isUnsafeAck(), true);
                    if (!bl) continue;
                    this.removeMessage(packetReference.getSysMessageID(), null);
                }
                catch (IOException iOException) {}
            }
        }
        if (hashSet != null && !hashSet.isEmpty()) {
            Globals.getClusterBroadcast().forwardMessage(packetReference, hashSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Consumer addConsumer(Consumer consumer, boolean bl) throws BrokerException, SelectorFormatException {
        if (consumer instanceof Subscription && this.consumers.get(consumer.getConsumerUID()) != null) {
            return null;
        }
        super.addConsumer(consumer, bl);
        this.hasNoLocalConsumers |= consumer.getNoLocal();
        Selector selector = consumer.getSelector();
        HashSet<Consumer> hashSet = null;
        Object object = this.selectorToInterest;
        synchronized (object) {
            hashSet = (HashSet<Consumer>)this.selectorToInterest.get(selector);
            if (hashSet == null) {
                hashSet = new HashSet<Consumer>();
                this.selectorToInterest.put(selector, hashSet);
                this.selectors.add(selector);
            }
        }
        object = hashSet;
        synchronized (object) {
            hashSet.add(consumer);
        }
        return null;
    }

    public void removeConsumer(ConsumerUID consumerUID, boolean bl) throws BrokerException {
        this.removeConsumer(consumerUID, null, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(ConsumerUID consumerUID, Map map, boolean bl, boolean bl2) throws BrokerException {
        Consumer consumer = (Consumer)this.consumers.get(consumerUID);
        if (consumer == null) {
            return;
        }
        Set set = null;
        Map map2 = this.selectorToInterest;
        synchronized (map2) {
            set = (Set)this.selectorToInterest.get(consumer.getSelector());
            if (set != null) {
                Set set2 = set;
                synchronized (set2) {
                    set.remove(consumer);
                    if (set.isEmpty()) {
                        this.selectorToInterest.remove(consumer.getSelector());
                        this.selectors.remove(consumer.getSelector());
                    }
                }
            }
        }
        super.removeConsumer(consumerUID, map, bl, bl2);
    }

    public void sort(Comparator comparator) {
    }

    protected void getDestinationProps(Map map) {
        super.getDestinationProps(map);
        map.put(MAX_SHARE_CONSUMERS, new Integer(this.maxSharedConsumers));
        map.put(SHARED_PREFETCH, new Integer(this.sharedPrefetch));
    }

    public void setDestinationProperties(Map map) throws BrokerException {
        super.setDestinationProperties(map);
        if (map.get(MAX_SHARE_CONSUMERS) != null) {
            try {
                this.setMaxSharedConsumers((Integer)map.get(MAX_SHARE_CONSUMERS));
            }
            catch (Exception exception) {
                this.logger.log(8, "Internal Error ", exception);
            }
        }
        if (map.get(SHARED_PREFETCH) != null) {
            try {
                this.setSharedFlowLimit((Integer)map.get(SHARED_PREFETCH));
            }
            catch (Exception exception) {
                this.logger.log(8, "Internal Error ", exception);
            }
        }
    }

    public DestMetricsCounters getMetrics() {
        DestMetricsCounters destMetricsCounters = super.getMetrics();
        return destMetricsCounters;
    }

    public void setMaxSharedConsumers(int n) {
        this.maxSharedConsumers = n;
    }

    public void setSharedFlowLimit(int n) {
        this.sharedPrefetch = n;
    }

    public int getMaxNumSharedConsumers() {
        return this.maxSharedConsumers;
    }

    public int getSharedConsumerFlowLimit() {
        return this.sharedPrefetch;
    }
}

