/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class LocalTransaction
extends BaseTransaction {
    public LocalTransaction() {
        super(1);
    }

    public LocalTransaction(TransactionUID transactionUID, int n, JMQXid jMQXid, TransactionWork transactionWork) {
        super(1);
        this.setTransactionWork(transactionWork);
        this.transactionDetails.setTid(transactionUID);
        this.transactionDetails.setState(n);
        this.transactionDetails.setXid(jMQXid);
    }

    public void readFromBytes(byte[] byArray) throws IOException, BrokerException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.readData(dataInputStream);
        dataInputStream.close();
        byteArrayInputStream.close();
    }

    public void readData(DataInputStream dataInputStream) throws IOException, BrokerException {
        this.transactionDetails.readContent(dataInputStream);
        this.transactionWork.readWork(dataInputStream);
    }

    public void readObjects(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public byte[] writeToBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.writeData(dataOutputStream);
        dataOutputStream.close();
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    public void writeData(DataOutputStream dataOutputStream) throws IOException {
        this.transactionDetails.writeContent(dataOutputStream);
        this.transactionWork.writeWork(dataOutputStream);
    }

    public void writeObjects(ObjectOutputStream objectOutputStream) throws IOException {
    }

    String getPrefix() {
        return "LocalTransaction: " + Thread.currentThread().getName() + " " + this.getTid();
    }
}

