/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.PacketProperties;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Hashtable;

public class ClusterDestInfo {
    private Destination d = null;
    private GPacket pkt = null;
    private String destName = null;
    private int destType = -1;

    private ClusterDestInfo(Destination destination) {
        this.d = destination;
    }

    private ClusterDestInfo(GPacket gPacket) {
        assert (gPacket.getType() == 15 || gPacket.getType() == 13);
        this.pkt = gPacket;
        this.destName = (String)gPacket.getProp("N");
        this.destType = (Integer)gPacket.getProp("DT");
    }

    public static ClusterDestInfo newInstance(Destination destination) {
        return new ClusterDestInfo(destination);
    }

    public static ClusterDestInfo newInstance(GPacket gPacket) {
        return new ClusterDestInfo(gPacket);
    }

    public GPacket getGPacket(short s, boolean bl) {
        assert (this.d != null);
        assert (s == 15 || s == 13);
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType(s);
        gPacket.putProp("N", this.d.getDestinationName());
        gPacket.putProp("DT", new Integer(this.d.getType()));
        switch (s) {
            case 15: {
                break;
            }
            case 13: {
                HashMap hashMap;
                if (DestType.isTemporary(this.d.getType())) {
                    gPacket.putProp("connectionUID", new Long(this.d.getConnectionUID().longValue()));
                }
                if ((hashMap = this.d.getDestinationProperties()) == null) {
                    hashMap = new HashMap();
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    PacketProperties.write(hashMap, byteArrayOutputStream);
                    byteArrayOutputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                gPacket.setPayload(ByteBuffer.wrap(byArray));
            }
        }
        if (bl) {
            gPacket.putProp("M", true);
        }
        return gPacket;
    }

    public DestinationUID getDestUID() throws BrokerException {
        assert (this.destName != null);
        return DestinationUID.getUID(this.destName, DestType.isQueue(this.destType));
    }

    public int getDestType() {
        assert (this.pkt != null);
        return this.destType;
    }

    public String getDestName() {
        assert (this.pkt != null);
        return this.destName;
    }

    public Hashtable getDestProps() throws IOException, ClassNotFoundException {
        assert (this.pkt != null);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.pkt.getPayload().array());
        return PacketProperties.parseProperties(byteArrayInputStream);
    }
}

