/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class BrokerDAOImpl
extends BaseDAOImpl
implements BrokerDAO {
    public static final String STORE_SESSION_ID_COLUMN = "STORE_SESSION_ID";
    protected String tableName;
    protected String insertSQL;
    protected String updateSQL;
    protected String updateHeartbeatSQL;
    protected String updateHeartbeatAndCheckStateSQL;
    protected String updateStateSQL;
    protected String takeoverSQL;
    protected String deleteSQL;
    protected String selectSQL;
    protected String selectAllSQL;
    protected String selectAllByStateSQL;
    protected String selectHeartbeatSQL;
    protected String selectAllHeartbeatsSQL;
    protected String selectStateSQL;
    protected String selectAllStatesSQL;
    protected String selectIsBeingTakenOverSQL;

    BrokerDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQBKR41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("URL").append(", ").append("VERSION").append(", ").append("STATE").append(", ").append("TAKEOVER_BROKER").append(", ").append("HEARTBEAT_TS").append(") VALUES ( ?, ?, ?, ?, ?, ? )").toString();
        this.updateSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("URL").append(" = ?, ").append("VERSION").append(" = ?, ").append("STATE").append(" = ?, ").append("TAKEOVER_BROKER").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.updateHeartbeatSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("HEARTBEAT_TS").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.updateHeartbeatAndCheckStateSQL = new StringBuffer(this.updateHeartbeatSQL).append(" AND ").append("HEARTBEAT_TS").append(" = ?").append(" AND ").append("STATE").append(" NOT IN (").append(9).append(", ").append(7).append(", ").append(8).append(", ").append(10).append(")").toString();
        this.updateStateSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ?").append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("STATE").append(" = ?").toString();
        this.takeoverSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TAKEOVER_BROKER").append(" = ?, ").append("STATE").append(" = ?, ").append("HEARTBEAT_TS").append(" = ?").append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("STATE").append(" = ?").append(" AND ").append("HEARTBEAT_TS").append(" = ?").append(" AND ").append("TAKEOVER_BROKER").append(" is NULL").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT bTbl.").append("ID").append(", ").append("URL").append(", ").append("VERSION").append(", ").append("STATE").append(", ").append("TAKEOVER_BROKER").append(", ").append("HEARTBEAT_TS").append(", sTbl.").append("ID").append(" ").append(STORE_SESSION_ID_COLUMN).append(" FROM ").append(this.tableName).append(" bTbl LEFT JOIN ").append(dBManager.getTableName("MQSES41")).append(" sTbl ON bTbl.").append("ID").append(" = sTbl.").append("BROKER_ID").append(" AND sTbl.").append("IS_CURRENT").append(" = 1").toString();
        this.selectAllByStateSQL = new StringBuffer(128).append(this.selectAllSQL).append(" WHERE bTbl.").append("STATE").append(" = ?").toString();
        this.selectSQL = new StringBuffer(128).append(this.selectAllSQL).append(" WHERE bTbl.").append("ID").append(" = ?").toString();
        this.selectHeartbeatSQL = new StringBuffer(128).append("SELECT ").append("HEARTBEAT_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAllHeartbeatsSQL = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("HEARTBEAT_TS").append(" FROM ").append(this.tableName).toString();
        this.selectStateSQL = new StringBuffer(128).append("SELECT ").append("STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAllStatesSQL = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("STATE").append(" FROM ").append(this.tableName).toString();
        this.selectIsBeingTakenOverSQL = new StringBuffer(128).append("SELECT 1 FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ? AND ").append("STATE").append(" IN (").append(9).append(", ").append(7).append(", ").append(8).append(", ").append(10).append(")").toString();
    }

    public final String getTableNamePrefix() {
        return "MQBKR41";
    }

    public final String getTableName() {
        return this.tableName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(Connection connection, String string, String string2, String string3, int n, int n2, long l, long l2) throws BrokerException {
        PreparedStatement preparedStatement;
        block14: {
            boolean bl = false;
            preparedStatement = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.insertSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, string3);
                    preparedStatement.setInt(3, n);
                    preparedStatement.setInt(4, n2);
                    Util.setString(preparedStatement, 5, string2);
                    Util.setLong(preparedStatement, 6, l2);
                    preparedStatement.executeUpdate();
                    preparedStatement.close();
                    if (l > 0L) {
                        dBManager.getDAOFactory().getStoreSessionDAO().insert(connection, string, l);
                    }
                    if (bl) {
                        connection.commit();
                    }
                }
                catch (Exception exception) {
                    Exception exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4217", string), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4217", string), exception2);
                }
                Object var16_13 = null;
                if (!bl) break block14;
            }
            catch (Throwable throwable) {
                Object var16_14 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection);
            return;
        }
        Util.close(null, preparedStatement, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(Connection connection, String string, String string2, String string3, int n, int n2, long l) throws BrokerException {
        PreparedStatement preparedStatement;
        block13: {
            boolean bl = false;
            preparedStatement = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.updateSQL);
                    preparedStatement.setString(1, string3);
                    preparedStatement.setInt(2, n);
                    preparedStatement.setInt(3, n2);
                    Util.setString(preparedStatement, 4, string2);
                    preparedStatement.setString(5, string);
                    preparedStatement.executeUpdate();
                    preparedStatement.close();
                    dBManager.getDAOFactory().getStoreSessionDAO().insert(connection, string, l);
                    if (bl) {
                        connection.commit();
                    }
                }
                catch (Exception exception) {
                    Exception exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.updateSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4217", string), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4217", string), exception2);
                }
                Object var14_12 = null;
                if (!bl) break block13;
            }
            catch (Throwable throwable) {
                Object var14_13 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection);
            return;
        }
        Util.close(null, preparedStatement, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateHeartbeat(Connection connection, String string, long l) throws BrokerException {
        PreparedStatement preparedStatement;
        boolean bl;
        block13: {
            bl = false;
            boolean bl2 = false;
            preparedStatement = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.updateHeartbeatSQL);
                    preparedStatement.setLong(1, l);
                    preparedStatement.setString(2, string);
                    if (preparedStatement.executeUpdate() == 1) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    Exception exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.updateHeartbeatSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4222", string), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4222", string), exception2);
                }
                Object var11_7 = null;
                if (!bl2) break block13;
            }
            catch (Throwable throwable) {
                Object var11_8 = null;
                if (bl2) {
                    Util.close(null, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection);
            return bl;
        }
        Util.close(null, preparedStatement, null);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateHeartbeat(Connection connection, String string, long l, long l2) throws BrokerException {
        PreparedStatement preparedStatement;
        boolean bl;
        block16: {
            bl = false;
            boolean bl2 = false;
            preparedStatement = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.updateHeartbeatAndCheckStateSQL);
                    preparedStatement.setLong(1, l);
                    preparedStatement.setString(2, string);
                    preparedStatement.setLong(3, l2);
                    if (preparedStatement.executeUpdate() == 0) {
                        HABrokerInfo hABrokerInfo = this.getBrokerInfo(connection, string);
                        if (hABrokerInfo == null) {
                            String string2 = this.br.getKString("B3169", string);
                            throw new BrokerException(this.br.getKString("B4223", string, string2));
                        }
                        String string3 = hABrokerInfo.getTakeoverBrokerID();
                        int n = hABrokerInfo.getState();
                        if (string3 != null && string3.length() > 0 && (n == 9 || n == 7 || n == 8 || n == 10)) {
                            StoreBeingTakenOverException storeBeingTakenOverException = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                            this.logger.log(32, this.br.getKString("B4223", string, hABrokerInfo.toString()), storeBeingTakenOverException);
                            throw storeBeingTakenOverException;
                        }
                    } else {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateHeartbeatAndCheckStateSQL + "]", (SQLException)exception) : exception;
                    String string4 = "Expected last heartbeat " + l2;
                    throw new BrokerException(this.br.getKString("B4223", string, string4), exception2);
                }
                Object var15_17 = null;
                if (!bl2) break block16;
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                if (bl2) {
                    Util.close(null, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection);
            return bl;
        }
        Util.close(null, preparedStatement, null);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateState(Connection connection, String string, BrokerState brokerState, BrokerState brokerState2) throws BrokerException {
        PreparedStatement preparedStatement;
        boolean bl;
        block13: {
            bl = false;
            boolean bl2 = false;
            preparedStatement = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.updateStateSQL);
                    preparedStatement.setInt(1, brokerState.intValue());
                    preparedStatement.setString(2, string);
                    preparedStatement.setInt(3, brokerState2.intValue());
                    if (preparedStatement.executeUpdate() == 1) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    Exception exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.updateStateSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4217", string), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4217", string), exception2);
                }
                Object var11_8 = null;
                if (!bl2) break block13;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                if (bl2) {
                    Util.close(null, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection);
            return bl;
        }
        Util.close(null, preparedStatement, null);
        return bl;
    }

    public HABrokerInfo takeover(Connection connection, String string, String string2, long l, BrokerState brokerState, long l2, BrokerState brokerState2) throws BrokerException {
        HABrokerInfo hABrokerInfo = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                hABrokerInfo = this.getBrokerInfo(connection, string2);
                if (hABrokerInfo == null) {
                    String string3 = this.br.getKString("B3169", string2);
                    throw new BrokerException(this.br.getKString("B3100", string3));
                }
                preparedStatement = connection.prepareStatement(this.takeoverSQL);
                preparedStatement.setString(1, string);
                preparedStatement.setInt(2, brokerState2.intValue());
                preparedStatement.setLong(3, l2);
                preparedStatement.setString(4, string2);
                preparedStatement.setInt(5, brokerState.intValue());
                preparedStatement.setLong(6, l);
                if (preparedStatement.executeUpdate() != 1) {
                    String string4 = this.br.getKString("B3170", string2);
                    TakeoverLockException takeoverLockException = new TakeoverLockException(string4);
                    takeoverLockException.setBrokerInfo(hABrokerInfo);
                    throw takeoverLockException;
                }
                Object var15_16 = null;
            }
            catch (Exception exception) {
                try {
                    if (connection != null && !connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    this.logger.log(32, "B4080", sQLException);
                }
                if (exception instanceof BrokerException) {
                    throw (BrokerException)exception;
                }
                Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.takeoverSQL + "]", (SQLException)exception) : exception;
                throw new BrokerException(this.br.getKString("B3172", string2), exception2);
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            Util.close(null, preparedStatement, null);
            throw throwable;
        }
        Util.close(null, preparedStatement, null);
        return hABrokerInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(Connection connection, String string) throws BrokerException {
        PreparedStatement preparedStatement;
        block12: {
            boolean bl = false;
            preparedStatement = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.deleteSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.executeUpdate();
                }
                catch (Exception exception) {
                    Exception exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4220", string), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4220", string), exception2);
                }
                Object var8_5 = null;
                if (!bl) break block12;
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection);
            return;
        }
        Util.close(null, preparedStatement, null);
    }

    public void deleteAll(Connection connection) throws BrokerException {
        if (Globals.getHAEnabled()) {
            return;
        }
        super.deleteAll(connection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getHeartbeat(Connection connection, String string) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        long l;
        block10: {
            l = -1L;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectHeartbeatSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        l = resultSet.getLong(1);
                    }
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectHeartbeatSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4218", string), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4218", string), exception2);
                }
                Object var11_7 = null;
                if (!bl) break block10;
            }
            catch (Throwable throwable) {
                Object var11_8 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return l;
        }
        Util.close(resultSet, preparedStatement, null);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getAllHeartbeats(Connection connection) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        HashMap<String, Long> hashMap;
        block10: {
            hashMap = new HashMap<String, Long>();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllHeartbeatsSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        long l = resultSet.getLong(2);
                        hashMap.put(string, new Long(l));
                    }
                    Object var10_10 = null;
                    if (!bl) break block10;
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectAllHeartbeatsSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4221"), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4221"), exception2);
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return hashMap;
        }
        Util.close(resultSet, preparedStatement, null);
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BrokerState getState(Connection connection, String string) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        BrokerState brokerState;
        block9: {
            brokerState = null;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectStateSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) throw new BrokerException(this.br.getKString("B3169", string), 404);
                    brokerState = BrokerState.getState(resultSet.getInt(1));
                    Object var10_7 = null;
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectStateSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4218", string), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4218", string), exception2);
                }
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return brokerState;
        }
        Util.close(resultSet, preparedStatement, null);
        return brokerState;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getAllStates(Connection connection) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Object[] objectArray;
        block10: {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<BrokerState> arrayList2 = new ArrayList<BrokerState>();
            objectArray = new Object[]{arrayList, arrayList2};
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllStatesSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        int n = resultSet.getInt(2);
                        arrayList.add(string);
                        arrayList2.add(BrokerState.getState(n));
                    }
                    Object var11_12 = null;
                    if (!bl) break block10;
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectAllStatesSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4221"), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4221"), exception2);
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return objectArray;
        }
        Util.close(resultSet, preparedStatement, null);
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HABrokerInfo getBrokerInfo(Connection connection, String string) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        HABrokerInfo hABrokerInfo;
        block10: {
            hABrokerInfo = null;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        hABrokerInfo = this.loadData(resultSet);
                    }
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4218", string), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4218", string), exception2);
                }
                Object var10_9 = null;
                if (!bl) break block10;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return hABrokerInfo;
        }
        Util.close(resultSet, preparedStatement, null);
        return hABrokerInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getAllBrokerInfos(Connection connection, boolean bl) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        HashMap<String, HABrokerInfo> hashMap;
        block12: {
            hashMap = new HashMap<String, HABrokerInfo>();
            boolean bl2 = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    Object object;
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        object = this.loadData(resultSet);
                        hashMap.put(((HABrokerInfo)object).getId(), (HABrokerInfo)object);
                    }
                    if (bl) {
                        resultSet.close();
                        preparedStatement.close();
                        object = dBManager.getDAOFactory().getStoreSessionDAO().getAllStoreSessions(connection);
                        for (Map.Entry entry : object.entrySet()) {
                            String string = (String)entry.getKey();
                            HABrokerInfo hABrokerInfo = (HABrokerInfo)hashMap.get(string);
                            if (hABrokerInfo == null) continue;
                            hABrokerInfo.setSessionList((List)entry.getValue());
                        }
                    }
                    Object var14_15 = null;
                    if (!bl2) break block12;
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4221"), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4221"), exception2);
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                if (bl2) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return hashMap;
        }
        Util.close(resultSet, preparedStatement, null);
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getAllBrokerInfosByState(Connection connection, BrokerState brokerState) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        HashMap<String, HABrokerInfo> hashMap;
        block10: {
            hashMap = new HashMap<String, HABrokerInfo>();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllByStateSQL);
                    preparedStatement.setInt(1, brokerState.intValue());
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        HABrokerInfo hABrokerInfo = this.loadData(resultSet);
                        hashMap.put(hABrokerInfo.getId(), hABrokerInfo);
                    }
                    Object var10_11 = null;
                    if (!bl) break block10;
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectAllByStateSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4221"), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4221"), exception2);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return hashMap;
        }
        Util.close(resultSet, preparedStatement, null);
        return hashMap;
    }

    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringBuffer stringBuffer = new StringBuffer(512);
        try {
            Collection collection = this.getAllBrokerInfos(connection, false).values();
            for (Object v : collection) {
                stringBuffer.append(v.toString()).append(BrokerResources.NL);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        hashMap.put("Broker(" + this.tableName + ")", stringBuffer.toString());
        return hashMap;
    }

    public boolean isBeingTakenOver(Connection connection, String string) throws BrokerException {
        BrokerState brokerState = this.getState(connection, string);
        int n = brokerState.intValue();
        return n == 9 || n == 7 || n == 8 || n == 10;
    }

    protected HABrokerInfo loadData(ResultSet resultSet) throws SQLException {
        HABrokerInfo hABrokerInfo = new HABrokerInfo(resultSet.getString("ID"), resultSet.getString("TAKEOVER_BROKER"), resultSet.getString("URL"), resultSet.getInt("VERSION"), resultSet.getInt("STATE"), resultSet.getLong(STORE_SESSION_ID_COLUMN), resultSet.getLong("HEARTBEAT_TS"));
        return hABrokerInfo;
    }
}

