/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.Destination;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MessageConvert;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.TemporaryDestination;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;

public class MessageProducerImpl
implements MessageProducer {
    protected boolean isClosed = false;
    protected boolean disableMessageId = false;
    protected boolean disableMessageTimestamp = false;
    protected int deliveryMode = 2;
    protected int priority = 4;
    protected long timeToLive = 0L;
    protected javax.jms.Destination destination = null;
    protected SessionImpl session = null;
    protected MessageConvert messageConvert = null;
    protected javax.jms.Destination addProducerDest = null;
    protected Hashtable destinations = new Hashtable();
    protected Hashtable producerStates = new Hashtable();
    private boolean debug = Debug.debug;
    private static final Logger sessionLogger = SessionImpl.sessionLogger;

    public MessageProducerImpl(SessionImpl sessionImpl, javax.jms.Destination destination) throws JMSException {
        try {
            this.session = sessionImpl;
            this.destination = destination;
            if (destination != null) {
                sessionImpl.getProtocolHandler().createMessageProducer(this);
            }
            sessionImpl.addMessageProducer(this);
            if (sessionLogger.isLoggable(Level.FINE)) {
                this.logLifeCycle("I400");
            }
        }
        catch (JMSException jMSException) {
            ExceptionHandler.throwJMSException(jMSException);
        }
    }

    public void recreateProducer() throws JMSException {
        if (this.destination != null) {
            this.session.getProtocolHandler().createMessageProducer(this);
        } else {
            Enumeration enumeration = this.destinations.elements();
            while (enumeration.hasMoreElements()) {
                ProducerState producerState = (ProducerState)enumeration.nextElement();
                this.session.connection.removeMessageProducer(new Long(producerState.getProducerID()));
            }
            this.destinations.clear();
            this.producerStates.clear();
        }
    }

    protected Message checkJMQMessage(Message message) throws JMSException {
        if (message instanceof MessageImpl) {
            return message;
        }
        if (this.messageConvert == null) {
            this.messageConvert = MessageConvert.getInstance();
        }
        return this.messageConvert.convertJMSMessage(message);
    }

    protected void checkState() throws JMSException {
        if (this.isClosed) {
            String string = AdministeredObject.cr.getKString("C4064");
            IllegalStateException illegalStateException = new IllegalStateException(string, "C4064");
            ExceptionHandler.throwJMSException(illegalStateException);
        }
    }

    protected void resetForeignMessageHeader(Message message, Message message2) throws JMSException {
        this.messageConvert.resetForeignMessageHeader(message, message2);
    }

    protected void writeJMSMessage(Message message) throws JMSException {
        this.writeJMSMessage(this.destination, message);
    }

    protected void writeJMSMessage(javax.jms.Destination destination, Message message) throws JMSException {
        this.session.connection.checkReconnecting(null);
        this.checkFlowControl(destination, message);
        try {
            this.session.writeJMSMessage(message);
            if (sessionLogger.isLoggable(Level.FINER)) {
                this.logMessageProduced(destination, message);
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4038");
        }
    }

    private void logMessageProduced(javax.jms.Destination destination, Message message) throws JMSException {
        if (sessionLogger.isLoggable(Level.FINER)) {
            Destination destination2 = (Destination)destination;
            String string = destination2.isQueue() ? "Queue" : "Topic";
            String string2 = PacketType.getString(((MessageImpl)message).getPacket().getPacketType());
            ProducerState producerState = (ProducerState)this.destinations.get(destination2.getName());
            long l = producerState.getProducerID();
            String string3 = "MQTrace=MessageProducer, ThreadID=" + Thread.currentThread().getId() + ", ClientID=" + this.session.connection.getClientID() + ", ConnectionID=" + this.session.connection.getConnectionID() + ", SessionID=" + this.session.getBrokerSessionID() + ", ProducerID=" + l + ", Destination=" + destination2.getName() + ", Domain=" + string + ", MessageID=" + message.getJMSMessageID() + ", MessageType=" + string2;
            sessionLogger.log(Level.FINER, "I402", string3);
            if (sessionLogger.isLoggable(Level.FINEST)) {
                string3 = "MQTrace=MessageProducer, ProducerID=" + l + ", Message=" + message.toString();
                sessionLogger.log(Level.FINEST, "I402", string3);
            }
        }
    }

    public javax.jms.Destination getDestination() throws JMSException {
        this.checkState();
        return this.destination;
    }

    public void setDisableMessageID(boolean bl) throws JMSException {
        this.checkState();
        this.disableMessageId = bl;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkState();
        return this.disableMessageId;
    }

    public void setDisableMessageTimestamp(boolean bl) throws JMSException {
        this.checkState();
        this.disableMessageTimestamp = bl;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkState();
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int n) throws JMSException {
        this.checkState();
        if (n != 1 && n != 2) {
            String string = AdministeredObject.cr.getKString("C4051", "DeliveryMode", String.valueOf(n));
            ExceptionHandler.throwJMSException(new JMSException(string, "C4051"));
        }
        this.deliveryMode = n;
    }

    public int getDeliveryMode() throws JMSException {
        this.checkState();
        return this.deliveryMode;
    }

    public void setPriority(int n) throws JMSException {
        this.checkState();
        if (n < 0 || n > 9) {
            String string = AdministeredObject.cr.getKString("C4051", "DeliveryPriority", String.valueOf(n));
            ExceptionHandler.throwJMSException(new JMSException(string, "C4051"));
        }
        this.priority = n;
    }

    public int getPriority() throws JMSException {
        this.checkState();
        return this.priority;
    }

    public void setTimeToLive(long l) throws JMSException {
        this.checkState();
        if (l < 0L) {
            String string = AdministeredObject.cr.getKString("C4051", "TimeToLive", String.valueOf(l));
            ExceptionHandler.throwJMSException(new JMSException(string, "C4051"));
        }
        this.timeToLive = l;
    }

    public long getTimeToLive() throws JMSException {
        this.checkState();
        return this.timeToLive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        try {
            ProducerState producerState;
            Enumeration enumeration = this.producerStates.elements();
            while (enumeration.hasMoreElements()) {
                producerState = (ProducerState)enumeration.nextElement();
                producerState.close();
            }
            if (this.session.connection.getBrokerProtocolLevel() >= 350 && this.session.getProtocolHandler() != null) {
                enumeration = this.producerStates.elements();
                while (enumeration.hasMoreElements()) {
                    producerState = (ProducerState)enumeration.nextElement();
                    this.session.connection.removeMessageProducer(new Long(producerState.getProducerID()));
                    if (this.session.connection.isBroken()) continue;
                    this.session.getProtocolHandler().deleteMessageProducer(producerState.getProducerID());
                }
            }
            this.session.removeMessageProducer(this);
            this.destinations.clear();
            this.producerStates.clear();
            Object var4_3 = null;
            this.isClosed = true;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.isClosed = true;
            if (SessionImpl.sessionLogger.isLoggable(Level.FINE)) {
                this.logLifeCycle("I401");
            }
            throw throwable;
        }
        if (SessionImpl.sessionLogger.isLoggable(Level.FINE)) {
            this.logLifeCycle("I401");
        }
    }

    public void send(Message message) throws JMSException {
        Message message2 = null;
        this.checkState();
        if (this.destination == null) {
            throw new UnsupportedOperationException();
        }
        this.checkTemporaryDestination(this.destination);
        if (!(message instanceof MessageImpl)) {
            message2 = message;
        }
        message = this.checkJMQMessage(message);
        message.setJMSDestination(this.destination);
        message.setJMSDeliveryMode(this.getDeliveryMode());
        message.setJMSPriority(this.getPriority());
        message.setJMSExpiration(this.getTimeToLive());
        if (this.session.connection.jmqOverrideJMSMsgHeaders) {
            javax.jms.Destination destination = message.getJMSDestination();
            if (this.session.connection.jmqOverrideMsgsToTempDests || !(destination instanceof TemporaryQueue) && !(destination instanceof TemporaryTopic)) {
                if (this.session.connection.jmqOverrideJMSDeliveryMode) {
                    message.setJMSDeliveryMode(this.session.connection.jmqJMSDeliveryMode);
                }
                if (this.session.connection.jmqOverrideJMSPriority) {
                    message.setJMSPriority(this.session.connection.jmqJMSPriority);
                }
                if (this.session.connection.jmqOverrideJMSExpiration) {
                    message.setJMSExpiration(this.session.connection.jmqJMSExpiration);
                }
            }
        }
        this.writeJMSMessage(message);
        if (message2 != null) {
            this.resetForeignMessageHeader(message, message2);
        }
    }

    public void send(Message message, int n, int n2, long l) throws JMSException {
        Message message2 = null;
        this.checkState();
        if (this.destination == null) {
            throw new UnsupportedOperationException();
        }
        this.checkTemporaryDestination(this.destination);
        if (!(message instanceof MessageImpl)) {
            message2 = message;
        }
        message = this.checkJMQMessage(message);
        message.setJMSDestination(this.destination);
        message.setJMSDeliveryMode(n);
        message.setJMSPriority(n2);
        message.setJMSExpiration(l);
        if (this.session.connection.jmqOverrideJMSMsgHeaders) {
            javax.jms.Destination destination = message.getJMSDestination();
            if (this.session.connection.jmqOverrideMsgsToTempDests || !(destination instanceof TemporaryQueue) && !(destination instanceof TemporaryTopic)) {
                if (this.session.connection.jmqOverrideJMSDeliveryMode) {
                    message.setJMSDeliveryMode(this.session.connection.jmqJMSDeliveryMode);
                }
                if (this.session.connection.jmqOverrideJMSPriority) {
                    message.setJMSPriority(this.session.connection.jmqJMSPriority);
                }
                if (this.session.connection.jmqOverrideJMSExpiration) {
                    message.setJMSExpiration(this.session.connection.jmqJMSExpiration);
                }
            }
        }
        this.writeJMSMessage(message);
        if (message2 != null) {
            this.resetForeignMessageHeader(message, message2);
        }
    }

    public void send(javax.jms.Destination destination, Message message) throws JMSException {
        Object object;
        Message message2 = null;
        this.checkState();
        if (destination == null) {
            object = AdministeredObject.cr.getKString("C4019", "null");
            ExceptionHandler.throwJMSException(new InvalidDestinationException((String)object, "C4019"));
        }
        if (this.destination != null) {
            throw new UnsupportedOperationException();
        }
        this.checkTemporaryDestination(destination);
        if (!(message instanceof MessageImpl)) {
            message2 = message;
        }
        this.checkForUnspecifiedProducer(destination);
        message = this.checkJMQMessage(message);
        message.setJMSDestination(destination);
        message.setJMSDeliveryMode(this.getDeliveryMode());
        message.setJMSPriority(this.getPriority());
        message.setJMSExpiration(this.getTimeToLive());
        if (this.session.connection.jmqOverrideJMSMsgHeaders) {
            object = message.getJMSDestination();
            if (this.session.connection.jmqOverrideMsgsToTempDests || !(object instanceof TemporaryQueue) && !(object instanceof TemporaryTopic)) {
                if (this.session.connection.jmqOverrideJMSDeliveryMode) {
                    message.setJMSDeliveryMode(this.session.connection.jmqJMSDeliveryMode);
                }
                if (this.session.connection.jmqOverrideJMSPriority) {
                    message.setJMSPriority(this.session.connection.jmqJMSPriority);
                }
                if (this.session.connection.jmqOverrideJMSExpiration) {
                    message.setJMSExpiration(this.session.connection.jmqJMSExpiration);
                }
            }
        }
        this.writeJMSMessage(destination, message);
        if (message2 != null) {
            this.resetForeignMessageHeader(message, message2);
        }
    }

    public void send(javax.jms.Destination destination, Message message, int n, int n2, long l) throws JMSException {
        Object object;
        Message message2 = null;
        this.checkState();
        if (destination == null) {
            object = AdministeredObject.cr.getKString("C4019", "null");
            ExceptionHandler.throwJMSException(new InvalidDestinationException((String)object, "C4019"));
        }
        if (this.destination != null) {
            throw new UnsupportedOperationException();
        }
        this.checkTemporaryDestination(destination);
        if (!(message instanceof MessageImpl)) {
            message2 = message;
        }
        this.checkForUnspecifiedProducer(destination);
        message = this.checkJMQMessage(message);
        message.setJMSDestination(destination);
        message.setJMSDeliveryMode(n);
        message.setJMSPriority(n2);
        message.setJMSExpiration(l);
        if (this.session.connection.jmqOverrideJMSMsgHeaders) {
            object = message.getJMSDestination();
            if (this.session.connection.jmqOverrideMsgsToTempDests || !(object instanceof TemporaryQueue)) {
                if (this.session.connection.jmqOverrideJMSDeliveryMode) {
                    message.setJMSDeliveryMode(this.session.connection.jmqJMSDeliveryMode);
                }
                if (this.session.connection.jmqOverrideJMSPriority) {
                    message.setJMSPriority(this.session.connection.jmqJMSPriority);
                }
                if (this.session.connection.jmqOverrideJMSExpiration) {
                    message.setJMSExpiration(this.session.connection.jmqJMSExpiration);
                }
            }
        }
        this.writeJMSMessage(destination, message);
        if (message2 != null) {
            this.resetForeignMessageHeader(message, message2);
        }
    }

    protected void setProducerID(javax.jms.Destination destination, long l) {
        String string = ((Destination)destination).getName();
        ProducerState producerState = (ProducerState)this.destinations.get(string);
        if (producerState == null) {
            producerState = new ProducerState();
            this.destinations.put(string, producerState);
        } else {
            if (this.debug) {
                Debug.println("Replacing ProducerID. old = " + producerState.getProducerID() + ", new = " + l);
            }
            this.producerStates.remove(new Long(producerState.getProducerID()));
            this.session.connection.removeMessageProducer(new Long(producerState.getProducerID()));
        }
        producerState.setProducerID(l);
        this.producerStates.put(new Long(l), producerState);
        this.session.connection.addMessageProducer(new Long(l), this);
    }

    protected void setFlowLimit(long l, int n) {
        if (this.debug) {
            Debug.println("Setting flowLimit = " + n + " for producerID = " + l);
        }
        ProducerState producerState = (ProducerState)this.producerStates.get(new Long(l));
        producerState.setFlowLimit(n);
    }

    protected void setFlowBytesLimit(long l, long l2) {
        if (this.debug) {
            Debug.println("Setting flowBytesLimit = " + l2 + " for producerID = " + l);
        }
        ProducerState producerState = (ProducerState)this.producerStates.get(new Long(l));
        producerState.setFlowBytesLimit(l2);
    }

    private void checkFlowControl(javax.jms.Destination destination, Message message) {
        String string = ((Destination)destination).getName();
        ProducerState producerState = (ProducerState)this.destinations.get(string);
        if (producerState != null) {
            producerState.checkFlowControl(message);
        }
    }

    protected SessionImpl getSession() {
        return this.session;
    }

    public String toString() {
        long l;
        String string;
        block3: {
            string = null;
            l = -1L;
            try {
                if (this.destination != null) {
                    string = ((Destination)this.destination).getName();
                    ProducerState producerState = (ProducerState)this.destinations.get(string);
                    l = producerState.getProducerID();
                }
            }
            catch (Exception exception) {
                if (!this.debug) break block3;
                Debug.printStackTrace(exception);
            }
        }
        return this.session.toString() + ", ProducerID=" + l + ", DestName=" + string;
    }

    protected void checkForUnspecifiedProducer(javax.jms.Destination destination) throws JMSException {
        Destination destination2 = (Destination)destination;
        String string = destination2.getName();
        if (this.destinations.get(string) == null) {
            this.session.getProtocolHandler().createMessageProducer(this, destination2);
        }
    }

    protected void checkTemporaryDestination(javax.jms.Destination destination) throws JMSException {
        ConnectionImpl connectionImpl;
        if (destination instanceof TemporaryDestination && (connectionImpl = ((TemporaryDestination)destination).connection) != null && connectionImpl.isClosed) {
            String string = AdministeredObject.cr.getKString("C4020", ((TemporaryDestination)destination).getName());
            ExceptionHandler.throwJMSException(new InvalidDestinationException(string, "C4020"));
        }
    }

    public void logLifeCycle(String string) {
        if (sessionLogger.isLoggable(Level.FINE)) {
            sessionLogger.log(Level.FINE, string, this);
        }
    }

    private String getDestInfo(javax.jms.Destination destination) {
        String string;
        block3: {
            long l = -1L;
            string = null;
            try {
                if (destination != null) {
                    String string2 = ((Destination)destination).getName();
                    ProducerState producerState = (ProducerState)this.destinations.get(string2);
                    l = producerState.getProducerID();
                    string = ", destName=" + string2 + ", producerID=" + l;
                }
            }
            catch (Exception exception) {
                if (!this.debug) break block3;
                Debug.printStackTrace(exception);
            }
        }
        return string;
    }

    protected Hashtable getDebugState(boolean bl) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("isClosed", String.valueOf(this.isClosed));
        hashtable.put("deliveryMode", String.valueOf(this.deliveryMode));
        hashtable.put("priority", String.valueOf(this.priority));
        hashtable.put("timeToLive", String.valueOf(this.timeToLive));
        hashtable.put("disableMessageId", String.valueOf(this.disableMessageId));
        hashtable.put("disableTimestamp", String.valueOf(this.disableMessageTimestamp));
        if (this.destination != null) {
            hashtable.put("Destination Class", this.destination.getClass().getName());
            if (this.destination instanceof Destination) {
                hashtable.put("Destination", ((Destination)this.destination).getName());
            }
            Enumeration enumeration = this.producerStates.elements();
            while (enumeration.hasMoreElements()) {
                ProducerState producerState = (ProducerState)enumeration.nextElement();
                hashtable.putAll(producerState.getDebugState(bl));
            }
        } else {
            hashtable.put("isBound", "false");
            hashtable.put("# Destinations", String.valueOf(this.destinations.size()));
            int n = 0;
            Enumeration enumeration = this.destinations.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                ProducerState producerState = (ProducerState)this.destinations.get(string);
                Hashtable hashtable2 = producerState.getDebugState(bl);
                hashtable2.put("Destination", string);
                hashtable.put("ProducerState[" + n + "]", hashtable2);
                ++n;
            }
        }
        return hashtable;
    }

    class ProducerState {
        private long flowBytesLimit;
        private int flowLimit;
        private long producerID;
        private boolean blocked = false;
        private int TEST_minResume = Integer.MAX_VALUE;
        private int TEST_maxResume = -1;
        private int TEST_resumeCount = 0;
        private int TEST_pauseCount = 0;
        private int TEST_forcePauseCount = 0;

        ProducerState() {
        }

        protected long getFlowBytesLimit() {
            return this.flowBytesLimit;
        }

        protected synchronized void setFlowBytesLimit(long l) {
            this.flowBytesLimit = l;
        }

        protected int getFlowLimit() {
            return this.flowLimit;
        }

        protected synchronized void setFlowLimit(int n) {
            this.flowLimit = n;
            if (n < this.TEST_minResume) {
                this.TEST_minResume = n;
            }
            if (n > this.TEST_maxResume) {
                this.TEST_maxResume = n;
            }
            if (n != 0) {
                ++this.TEST_resumeCount;
            } else {
                ++this.TEST_forcePauseCount;
            }
            this.notifyAll();
        }

        protected long getProducerID() {
            return this.producerID;
        }

        protected void setProducerID(long l) {
            this.producerID = l;
        }

        protected synchronized void close() {
            this.notifyAll();
        }

        private synchronized void checkFlowControl(Message message) {
            while (this.flowLimit == 0 && !MessageProducerImpl.this.isClosed) {
                try {
                    this.blocked = true;
                    this.wait();
                    this.blocked = false;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.flowLimit > 0) {
                --this.flowLimit;
            }
            if (this.flowLimit == 0) {
                ++this.TEST_pauseCount;
            }
            ReadWritePacket readWritePacket = ((MessageImpl)message).getPacket();
            readWritePacket.setProducerID(this.producerID);
            readWritePacket.setConsumerFlow(this.flowLimit == 0);
        }

        protected Hashtable getDebugState(boolean bl) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("producerID", String.valueOf(this.producerID));
            hashtable.put("flowLimit", String.valueOf(this.flowLimit));
            hashtable.put("flowBytesLimit", String.valueOf(this.flowBytesLimit));
            hashtable.put("blocked", String.valueOf(this.blocked));
            hashtable.put("pauseCount", String.valueOf(this.TEST_pauseCount));
            hashtable.put("resumeCount", String.valueOf(this.TEST_resumeCount));
            hashtable.put("maxResume", String.valueOf(this.TEST_maxResume));
            hashtable.put("minResume", String.valueOf(this.TEST_minResume));
            hashtable.put("forcedPauses", String.valueOf(this.TEST_forcePauseCount));
            return hashtable;
        }
    }
}

