/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListenerAdapter;
import com.sun.grizzly.DefaultCallbackHandler;
import com.sun.grizzly.DefaultSelectionKeyHandler;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.SSLCallbackHandler;
import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.SSLSelectorHandler;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.async.AsyncQueueReadUnit;
import com.sun.grizzly.async.AsyncQueueReadable;
import com.sun.grizzly.async.AsyncQueueWritable;
import com.sun.grizzly.async.AsyncQueueWriteUnit;
import com.sun.grizzly.async.AsyncReadCallbackHandler;
import com.sun.grizzly.async.AsyncReadCondition;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.async.ByteBufferCloner;
import com.sun.grizzly.util.DefaultThreadPool;
import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.SSLOutputWriter;
import com.sun.grizzly.util.SSLUtils;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLConnectorHandler
implements ConnectorHandler<SSLSelectorHandler, SSLCallbackHandler>,
AsyncQueueWritable,
AsyncQueueReadable {
    private static Logger logger = Logger.getLogger("grizzly");
    protected SSLSelectorHandler selectorHandler;
    private SSLCallbackHandler callbackHandler;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private ByteBuffer securedInputBuffer;
    private ByteBuffer securedOutputBuffer;
    private ByteBuffer asyncHandshakeBuffer;
    private SocketChannel socketChannel;
    private static volatile SSLContext defaultSSLContext;
    private volatile boolean isConnected;
    private volatile boolean isHandshakeDone;
    private Controller controller;
    private CountDownLatch isConnectedLatch;
    private boolean isStandalone = false;
    private boolean isProcessingAsyncHandshake;
    private SSLEngineResult sslLastOperationResult;
    private SSLEngineResult.HandshakeStatus handshakeStatus;
    private SSLEngineResult.Status sslEngineStatus = null;
    private boolean delegateSSLTasks;
    private SSLEngine sslEngine;
    private SSLContext sslContext;
    private volatile AsyncQueueDataProcessor sslReadPostProcessor;
    private volatile AsyncQueueDataProcessor sslWritePreProcessor;
    private boolean isAsyncWriteQueueMode;
    private boolean isAsyncReadQueueMode;
    private Object lock = new Object();

    public SSLConnectorHandler() {
        this(defaultSSLContext);
    }

    public SSLConnectorHandler(SSLConfig sslConfig) {
        this(sslConfig.createSSLContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public SSLConnectorHandler(SSLContext sslContext) {
        if (sslContext == null) {
            if (defaultSSLContext == null) {
                Class<SSLConnectorHandler> clazz = SSLConnectorHandler.class;
                // MONITORENTER : com.sun.grizzly.SSLConnectorHandler.class
                if (defaultSSLContext == null) {
                    defaultSSLContext = SSLConfig.DEFAULT_CONFIG.createSSLContext();
                }
                // MONITOREXIT : clazz
            }
            sslContext = defaultSSLContext;
        }
        this.sslContext = sslContext;
    }

    public boolean getDelegateSSLTasks() {
        return this.delegateSSLTasks;
    }

    public void setDelegateSSLTasks(boolean delegateSSLTasks) {
        this.delegateSSLTasks = delegateSSLTasks;
    }

    @Override
    public void connect(SocketAddress remoteAddress, SSLCallbackHandler callbackHandler) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null, callbackHandler);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, SSLCallbackHandler callbackHandler) throws IOException {
        if (this.controller == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        this.connect(remoteAddress, localAddress, callbackHandler, (SSLSelectorHandler)this.controller.getSelectorHandler(this.protocol()));
    }

    @Override
    public void connect(SocketAddress remoteAddress, SSLCallbackHandler callbackHandler, SSLSelectorHandler selectorHandler) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null, callbackHandler, selectorHandler);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, SSLCallbackHandler callbackHandler, SSLSelectorHandler selectorHandler) throws IOException {
        if (this.isConnected) {
            throw new AlreadyConnectedException();
        }
        if (this.controller == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        if (selectorHandler == null) {
            throw new IllegalStateException("SelectorHandler cannot be null");
        }
        this.selectorHandler = selectorHandler;
        if (callbackHandler == null) {
            callbackHandler = new DefaultCallbackHandler(this);
        } else {
            this.callbackHandler = callbackHandler;
        }
        this.isConnectedLatch = new CountDownLatch(1);
        selectorHandler.connect(remoteAddress, localAddress, new SSLInternalCallbackHandler());
        try {
            this.isConnectedLatch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public void connect(SocketAddress remoteAddress) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        if (this.isConnected) {
            throw new AlreadyConnectedException();
        }
        if (this.controller == null) {
            this.isStandalone = true;
            this.controller = new Controller();
            this.controller.setSelectorHandler(new SSLSelectorHandler(true));
            DefaultThreadPool threadPool = new DefaultThreadPool();
            this.controller.setThreadPool(threadPool);
            final CountDownLatch latch = new CountDownLatch(1);
            this.controller.addStateListener(new ControllerStateListenerAdapter(){

                public void onReady() {
                    latch.countDown();
                }

                public void onException(Throwable e) {
                    if (latch.getCount() > 0L) {
                        logger.log(Level.SEVERE, "Error occured on Controller startup: ", e);
                    }
                    latch.countDown();
                }
            });
            this.callbackHandler = new DefaultCallbackHandler(this, false);
            new WorkerThreadImpl("GrizzlySSLConnectorHandler-Controller", (Runnable)this.controller).start();
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        this.connect(remoteAddress, localAddress, this.callbackHandler, (SSLSelectorHandler)this.controller.getSelectorHandler(this.protocol()));
    }

    public boolean handshake(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        this.sslEngine.beginHandshake();
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        if (blocking) {
            SSLUtils.doHandshake(this.socketChannel, byteBuffer, this.securedInputBuffer, this.securedOutputBuffer, this.sslEngine, this.handshakeStatus);
            this.securedOutputBuffer.limit(this.securedOutputBuffer.position());
            this.finishHandshake();
            return true;
        }
        return this.doAsyncHandshake(byteBuffer);
    }

    @Override
    public long read(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        if (!this.isConnected) {
            throw new NotYetConnectedException();
        }
        if (blocking) {
            return SSLUtils.doSecureRead(this.socketChannel, this.sslEngine, byteBuffer, this.securedInputBuffer);
        }
        this.isAsyncReadQueueMode = false;
        int nRead = this.doReadAsync(byteBuffer);
        if (nRead == 0) {
            this.registerSelectionKeyFor(1);
        }
        return nRead;
    }

    @Override
    public long write(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        if (!this.isConnected) {
            throw new NotYetConnectedException();
        }
        if (blocking) {
            long nWrite = SSLOutputWriter.flushChannel(this.socketChannel, byteBuffer, this.securedOutputBuffer, this.sslEngine);
            this.securedOutputBuffer.position(this.securedOutputBuffer.limit());
            return nWrite;
        }
        if (this.callbackHandler == null) {
            throw new IllegalStateException("Non blocking write needs a CallbackHandler");
        }
        this.isAsyncWriteQueueMode = false;
        int nWrite = 1;
        int totalWrite = 0;
        while (nWrite > 0 && (byteBuffer.hasRemaining() || this.securedOutputBuffer.hasRemaining())) {
            nWrite = this.doWriteAsync(byteBuffer);
            totalWrite += nWrite;
        }
        if (byteBuffer.hasRemaining() || this.securedOutputBuffer.hasRemaining()) {
            this.registerSelectionKeyFor(4);
        }
        return totalWrite;
    }

    @Override
    public Future<AsyncQueueReadUnit> readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler) throws IOException {
        return this.readFromAsyncQueue(buffer, callbackHandler, null);
    }

    @Override
    public Future<AsyncQueueReadUnit> readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition) throws IOException {
        return this.readFromAsyncQueue(buffer, callbackHandler, condition, this.obtainSSLReadPostProcessor());
    }

    @Override
    public Future<AsyncQueueReadUnit> readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition, AsyncQueueDataProcessor readPostProcessor) throws IOException {
        this.isAsyncReadQueueMode = true;
        return this.selectorHandler.getAsyncQueueReader().read(this.socketChannel.keyFor(this.selectorHandler.getSelector()), buffer, callbackHandler, condition, readPostProcessor);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer) throws IOException {
        return this.writeToAsyncQueue(buffer, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
        return this.writeToAsyncQueue(buffer, callbackHandler, this.obtainSSLWritePreProcessor());
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        return this.writeToAsyncQueue(buffer, callbackHandler, writePreProcessor, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, ByteBufferCloner cloner) throws IOException {
        this.isAsyncWriteQueueMode = true;
        return this.selectorHandler.getAsyncQueueWriter().write(this.socketChannel.keyFor(this.selectorHandler.getSelector()), buffer, callbackHandler, writePreProcessor, cloner);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer) throws IOException {
        return this.writeToAsyncQueue(dstAddress, buffer, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
        return this.writeToAsyncQueue(dstAddress, buffer, callbackHandler, this.obtainSSLWritePreProcessor());
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        return this.writeToAsyncQueue(dstAddress, buffer, callbackHandler, writePreProcessor);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, ByteBufferCloner cloner) throws IOException {
        this.isAsyncWriteQueueMode = true;
        return this.selectorHandler.getAsyncQueueWriter().write(this.socketChannel.keyFor(this.selectorHandler.getSelector()), dstAddress, buffer, callbackHandler, writePreProcessor, cloner);
    }

    @Override
    public void close() throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            IOException ioe = new IOException("Logging stacktrace...");
            logger.log(Level.FINE, "Closing SSLConnectorHandler " + this + " Channel: " + this.socketChannel + " engine: " + this.sslEngine, ioe);
        }
        if (this.socketChannel != null) {
            if (this.isConnected) {
                try {
                    if (this.securedOutputBuffer.hasRemaining()) {
                        OutputWriter.flushChannel((SelectableChannel)this.socketChannel, this.securedOutputBuffer);
                    }
                    this.sslEngine.closeOutbound();
                    SSLUtils.wrap(EMPTY_BUFFER, this.securedOutputBuffer, this.sslEngine);
                    OutputWriter.flushChannel((SelectableChannel)this.socketChannel, this.securedOutputBuffer);
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "IOException during closing the connector.", e);
                }
            }
            if (this.selectorHandler != null) {
                SelectionKey key = this.socketChannel.keyFor(this.selectorHandler.getSelector());
                if (key == null) {
                    return;
                }
                this.selectorHandler.getSelectionKeyHandler().close(key);
            }
            this.socketChannel.close();
        }
        if (this.controller != null && this.isStandalone) {
            this.controller.stop();
            this.controller = null;
        }
        this.sslEngine = null;
        this.asyncHandshakeBuffer = null;
        this.isStandalone = false;
        this.isConnected = false;
        this.isHandshakeDone = false;
    }

    @Override
    public void finishConnect(SelectionKey key) throws IOException {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Finish connect");
            }
            this.socketChannel = (SocketChannel)key.channel();
            this.socketChannel.finishConnect();
            this.isConnected = this.socketChannel.isConnected();
            if (this.isConnected) {
                this.initSSLEngineIfRequired();
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.isConnectedLatch.countDown();
        }
    }

    public void finishHandshake() {
        this.isProcessingAsyncHandshake = false;
        this.isHandshakeDone = true;
    }

    @Override
    public Controller.Protocol protocol() {
        return Controller.Protocol.TLS;
    }

    public boolean isConnected() {
        return this.isConnected && this.socketChannel.isOpen();
    }

    public boolean isHandshakeDone() {
        return this.isHandshakeDone && !this.isProcessingAsyncHandshake;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void configure(SSLConfig sslConfig) {
        this.sslContext = sslConfig.createSSLContext();
    }

    public SSLEngine getSSLEngine() {
        return this.sslEngine;
    }

    public void setSSLEngine(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    public ByteBuffer getSecuredInputBuffer() {
        return this.securedInputBuffer;
    }

    public ByteBuffer getSecuredOutputBuffer() {
        return this.securedOutputBuffer;
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    @Override
    public void setController(Controller controller) {
        this.controller = controller;
    }

    @Override
    public SelectableChannel getUnderlyingChannel() {
        return this.socketChannel;
    }

    protected void setUnderlyingChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    @Override
    public SSLCallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    @Override
    public void setCallbackHandler(SSLCallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public SSLSelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }

    public int getApplicationBufferSize() {
        this.initSSLEngineIfRequired();
        return this.sslEngine.getSession().getApplicationBufferSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doReadAsync(ByteBuffer byteBuffer) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "SSLConnectorHandler compactBuffer securedInputBuffer: " + this.securedInputBuffer);
        }
        SSLConnectorHandler.clearOrCompactBuffer(this.securedInputBuffer);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "SSLConnectorHandler read securedInputBuffer: " + this.securedInputBuffer);
        }
        int bytesRead = -1;
        try {
            bytesRead = this.socketChannel.read(this.securedInputBuffer);
        }
        finally {
            SelectionKeyHandler skh;
            if (bytesRead == -1 && (skh = this.selectorHandler.getSelectionKeyHandler()) instanceof BaseSelectionKeyHandler) {
                ((DefaultSelectionKeyHandler)skh).notifyRemotlyClose(this.getSelectionKey());
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "SSLConnectorHandler done read securedInputBuffer: " + this.securedInputBuffer + " bytesRead: " + bytesRead);
        }
        if (bytesRead == -1) {
            try {
                this.sslEngine.closeInbound();
                if (this.securedInputBuffer.position() == 0 || this.sslEngineStatus == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    return -1;
                }
            }
            catch (SSLException e) {
                return -1;
            }
        }
        this.securedInputBuffer.flip();
        if (bytesRead == 0 && !this.securedInputBuffer.hasRemaining()) {
            return 0;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "SSLConnectorHandler unwrapall securedInputBuffer: " + this.securedInputBuffer);
        }
        int bytesProduced = this.unwrapAll(byteBuffer);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "SSLConnectorHandler unwrapall done securedInputBuffer: " + this.securedInputBuffer, " produced: " + bytesProduced + " status: " + (Object)((Object)this.sslEngineStatus));
        }
        if (bytesProduced == 0) {
            if (this.sslEngineStatus == SSLEngineResult.Status.CLOSED) {
                return -1;
            }
            if (this.sslEngineStatus == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                throw new BufferOverflowException();
            }
        }
        return bytesRead;
    }

    private int unwrapAll(ByteBuffer byteBuffer) throws SSLException {
        SSLEngineResult result = null;
        int bytesProduced = 0;
        do {
            result = this.sslEngine.unwrap(this.securedInputBuffer, byteBuffer);
            bytesProduced += result.bytesProduced();
        } while (result.getStatus() == SSLEngineResult.Status.OK && (this.isHandshakeDone || result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && result.bytesProduced() == 0));
        this.updateSSLEngineStatus(result);
        return bytesProduced;
    }

    private int doWriteAsync(ByteBuffer byteBuffer) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "asyncWrite. securedBuffer: " + this.securedOutputBuffer);
        }
        if (this.securedOutputBuffer.hasRemaining() && !this.flushSecuredOutputBuffer()) {
            return 0;
        }
        this.securedOutputBuffer.clear();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "asyncWrite. wrap sslEngine: " + this.sslEngine + " securedOutputBuffer: " + this.securedOutputBuffer + " byteBuffer: " + byteBuffer);
        }
        SSLEngineResult result = SSLUtils.wrap(byteBuffer, this.securedOutputBuffer, this.sslEngine);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "asyncWrite. wrap done sslEngine: " + this.sslEngine + " securedOutputBuffer: " + this.securedOutputBuffer + " byteBuffer: " + byteBuffer + " status: " + result);
        }
        this.updateSSLEngineStatus(result);
        int count = this.socketChannel.write(this.securedOutputBuffer);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "asyncWrite. written: " + count + " securedOutputBuffer: " + this.securedOutputBuffer);
        }
        return count;
    }

    private boolean doAsyncHandshake(ByteBuffer byteBuffer) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "SSLConnectorHandler.doAsyncHandshake");
        }
        this.isProcessingAsyncHandshake = true;
        this.asyncHandshakeBuffer = byteBuffer;
        block10: while (this.handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
            switch (this.handshakeStatus) {
                case NEED_WRAP: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "SSLConnectorHandler NEED_WRAP sslEngine: " + this.sslEngine + " securedBuffer: " + this.securedOutputBuffer);
                    }
                    SSLEngineResult result = SSLUtils.wrap(EMPTY_BUFFER, this.securedOutputBuffer, this.sslEngine);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "SSLConnectorHandler NEED_WRAP done sslEngine: " + this.sslEngine + " securedBuffer: " + this.securedOutputBuffer + " result: " + result + " handshakeStatus: " + (Object)((Object)result.getHandshakeStatus()));
                    }
                    this.updateSSLEngineStatus(result);
                    switch (result.getStatus()) {
                        case OK: {
                            if (this.flushSecuredOutputBuffer()) break;
                            if (logger.isLoggable(Level.FINER)) {
                                logger.log(Level.FINER, "SSLConnectorHandler pending secured buffer flush: " + this.sslEngine + " securedBuffer: " + this.securedOutputBuffer);
                            }
                            return false;
                        }
                        default: {
                            throw new IOException("Handshaking error: " + (Object)((Object)result.getStatus()));
                        }
                    }
                    if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) break;
                }
                case NEED_UNWRAP: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "SSLConnectorHandler NEED_UNWRAP sslEngine: " + this.sslEngine + " byteBuffer: " + byteBuffer);
                    }
                    int bytesRead = this.doReadAsync(byteBuffer);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "SSLConnectorHandler NEED_UNWRAP done sslEngine: " + this.sslEngine + " byteBuffer: " + byteBuffer + " bytesRead: " + bytesRead + " handshakeStatus: " + (Object)((Object)this.handshakeStatus));
                    }
                    if (bytesRead == -1) {
                        try {
                            this.sslEngine.closeInbound();
                        }
                        catch (IOException e) {
                            logger.log(Level.FINE, "Exception occured when closing sslEngine inbound.", e);
                        }
                        throw new EOFException("Connection closed");
                    }
                    if (bytesRead == 0 && this.sslLastOperationResult.bytesConsumed() == 0) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "SSLConnectorHandler NEED_UNWRAP reregister key sslEngine: " + this.sslEngine);
                        }
                        this.registerSelectionKeyFor(1);
                        return false;
                    }
                    if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) break;
                }
                case NEED_TASK: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "SSLConnectorHandler NEED_TASK sslEngine: " + this.sslEngine);
                    }
                    this.handshakeStatus = this.executeDelegatedTask();
                    if (!logger.isLoggable(Level.FINE)) continue block10;
                    logger.log(Level.FINE, "SSLConnectorHandler NEED_TASK sslEngine: " + this.sslEngine + " handshakeStatus: " + (Object)((Object)this.handshakeStatus));
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid Handshaking State" + (Object)((Object)this.handshakeStatus));
                }
            }
        }
        if (this.isProcessingAsyncHandshake) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "SSLConnectorHandler finishHandshake sslEngine: " + this.sslEngine);
            }
            this.finishHandshake();
        }
        this.asyncHandshakeBuffer = null;
        return true;
    }

    private SSLEngineResult.HandshakeStatus executeDelegatedTask() {
        Runnable runnable;
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    private void updateSSLEngineStatus(SSLEngineResult result) {
        this.sslLastOperationResult = result;
        this.sslEngineStatus = result.getStatus();
        this.handshakeStatus = result.getHandshakeStatus();
    }

    private static void clearOrCompactBuffer(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            buffer.clear();
        } else if (buffer.remaining() < buffer.capacity()) {
            buffer.compact();
        }
    }

    private SelectionKey getSelectionKey() {
        return this.socketChannel.keyFor(this.selectorHandler.getSelector());
    }

    private void registerSelectionKeyFor(int ops) {
        SelectionKey key = this.getSelectionKey();
        this.selectorHandler.register(key, ops);
    }

    private boolean flushSecuredOutputBuffer() throws IOException {
        int nWrite = 1;
        try {
            while (nWrite > 0 && this.securedOutputBuffer.hasRemaining()) {
                nWrite = this.socketChannel.write(this.securedOutputBuffer);
            }
        }
        catch (IOException ex) {
            nWrite = -1;
            throw ex;
        }
        finally {
            SelectionKeyHandler skh;
            if (nWrite == -1 && (skh = this.selectorHandler.getSelectionKeyHandler()) instanceof BaseSelectionKeyHandler) {
                ((DefaultSelectionKeyHandler)skh).notifyRemotlyClose(this.getSelectionKey());
            }
        }
        if (this.securedOutputBuffer.hasRemaining()) {
            SelectionKey key = this.socketChannel.keyFor(this.selectorHandler.getSelector());
            this.selectorHandler.register(key, 4);
            return false;
        }
        return true;
    }

    private void initSSLEngineIfRequired() {
        if (this.sslEngine == null) {
            this.sslEngine = this.sslContext.createSSLEngine();
            this.sslEngine.setUseClientMode(true);
        }
        int bbSize = this.sslEngine.getSession().getPacketBufferSize();
        this.securedInputBuffer = ByteBuffer.allocate(bbSize * 2);
        this.securedOutputBuffer = ByteBuffer.allocate(bbSize * 2);
        this.securedOutputBuffer.limit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncQueueDataProcessor obtainSSLReadPostProcessor() {
        if (this.sslReadPostProcessor == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.sslReadPostProcessor == null) {
                    this.sslReadPostProcessor = new SSLReadPostProcessor();
                }
            }
        }
        return this.sslReadPostProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncQueueDataProcessor obtainSSLWritePreProcessor() {
        if (this.sslWritePreProcessor == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.sslWritePreProcessor == null) {
                    this.sslWritePreProcessor = new SSLWritePreProcessor();
                }
            }
        }
        return this.sslWritePreProcessor;
    }

    private class SSLWritePreProcessor
    implements AsyncQueueDataProcessor {
        private SSLWritePreProcessor() {
        }

        public ByteBuffer getInternalByteBuffer() {
            return SSLConnectorHandler.this.securedOutputBuffer;
        }

        public void process(ByteBuffer byteBuffer) throws SSLException {
            if (!byteBuffer.hasRemaining() || SSLConnectorHandler.this.securedOutputBuffer.hasRemaining()) {
                return;
            }
            SSLConnectorHandler.this.securedOutputBuffer.clear();
            SSLEngineResult result = SSLConnectorHandler.this.sslEngine.wrap(byteBuffer, SSLConnectorHandler.this.securedOutputBuffer);
            SSLConnectorHandler.this.updateSSLEngineStatus(result);
            SSLConnectorHandler.this.securedOutputBuffer.flip();
        }
    }

    private class SSLReadPostProcessor
    implements AsyncQueueDataProcessor {
        private SSLReadPostProcessor() {
        }

        public ByteBuffer getInternalByteBuffer() {
            return SSLConnectorHandler.this.securedInputBuffer;
        }

        public void process(ByteBuffer byteBuffer) throws SSLException {
            SSLConnectorHandler.this.securedInputBuffer.flip();
            SSLConnectorHandler.this.unwrapAll(byteBuffer);
            SSLConnectorHandler.clearOrCompactBuffer(SSLConnectorHandler.this.securedInputBuffer);
        }
    }

    private class SSLInternalCallbackHandler
    implements CallbackHandler {
        private SSLInternalCallbackHandler() {
        }

        public void onConnect(IOEvent ioEvent) {
            SSLConnectorHandler.this.callbackHandler.onConnect(ioEvent);
        }

        public void onRead(IOEvent ioEvent) {
            if (!SSLConnectorHandler.this.isAsyncReadQueueMode) {
                try {
                    if (SSLConnectorHandler.this.isProcessingAsyncHandshake) {
                        if (SSLConnectorHandler.this.doAsyncHandshake(SSLConnectorHandler.this.asyncHandshakeBuffer)) {
                            SSLConnectorHandler.this.callbackHandler.onHandshake(ioEvent);
                        }
                        return;
                    }
                    SSLConnectorHandler.this.callbackHandler.onRead(ioEvent);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Exception occured when reading from SSL channel.", e);
                }
            }
        }

        public void onWrite(IOEvent ioEvent) {
            if (!SSLConnectorHandler.this.isAsyncWriteQueueMode) {
                try {
                    if (!SSLConnectorHandler.this.securedOutputBuffer.hasRemaining() || SSLConnectorHandler.this.flushSecuredOutputBuffer()) {
                        if (SSLConnectorHandler.this.isProcessingAsyncHandshake) {
                            if (SSLConnectorHandler.this.doAsyncHandshake(SSLConnectorHandler.this.asyncHandshakeBuffer)) {
                                SSLConnectorHandler.this.callbackHandler.onHandshake(ioEvent);
                            }
                            return;
                        }
                        SSLConnectorHandler.this.callbackHandler.onWrite(ioEvent);
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Exception occured when writing to SSL channel.", e);
                }
            }
        }
    }
}

