/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class Packet {
    private static final short VERSION = 100;
    private static final int HEADER_SIZE = 16;
    public static final int UNICAST = 1;
    public static final int BROADCAST = 2;
    public static final int BROKER_INFO = 3;
    public static final int LINK_INIT = 4;
    public static final int STOP_FLOW = 5;
    public static final int RESUME_FLOW = 6;
    public static final int PING = 7;
    public static final int BROKER_INFO_REPLY = 9;
    public static final int USE_FLOW_CONTROL = 1;
    private short version = (short)100;
    private short packetType = 0;
    private int packetSize = 0;
    private int destId = 0;
    private int bitFlags = 0;
    private byte[] packetBuffer = null;

    Packet() {
    }

    public void readPacket(InputStream inputStream) throws IOException, EOFException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.version = dataInputStream.readShort();
        this.packetType = dataInputStream.readShort();
        this.packetSize = dataInputStream.readInt();
        this.destId = dataInputStream.readInt();
        this.bitFlags = dataInputStream.readInt();
        try {
            this.packetBuffer = new byte[this.packetSize - 16];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            dataInputStream.skip(this.packetSize - 16);
            throw outOfMemoryError;
        }
        dataInputStream.readFully(this.packetBuffer);
    }

    public void writePacket(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeShort(this.version);
        dataOutputStream.writeShort(this.packetType);
        dataOutputStream.writeInt(this.packetSize);
        dataOutputStream.writeInt(this.destId);
        dataOutputStream.writeInt(this.bitFlags);
        dataOutputStream.flush();
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        outputStream.write(byArray, 0, 16);
        if (this.packetBuffer != null) {
            outputStream.write(this.packetBuffer, 0, this.packetSize - 16);
        }
        outputStream.flush();
    }

    public int getPacketType() {
        return this.packetType;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public int getDestId() {
        return this.destId;
    }

    public byte[] getPacketBody() {
        return this.packetBuffer;
    }

    public boolean getFlag(int n) {
        return (this.bitFlags & n) == n;
    }

    public void setPacketType(int n) {
        this.packetType = (short)n;
    }

    public void setDestId(int n) {
        this.destId = n;
    }

    public void setPacketBody(byte[] byArray) {
        this.packetBuffer = byArray;
        this.packetSize = 16;
        if (this.packetBuffer != null) {
            this.packetSize += this.packetBuffer.length;
        }
    }

    public void setFlag(int n, boolean bl) {
        this.bitFlags = bl ? (this.bitFlags |= n) : (this.bitFlags &= ~n);
    }

    public String toString() {
        return "PacketType = " + this.packetType + ", DestId = " + this.destId + ", DATA :\n" + Packet.hexdump(this.packetBuffer, 128);
    }

    public static String hexdump(byte[] byArray, int n) {
        if (byArray == null) {
            return "";
        }
        String string = "";
        int n2 = 0;
        int n3 = byArray.length;
        if (n3 > n) {
            n3 = n;
        }
        while (n3 > 0) {
            int n4;
            int n5 = n3 < 16 ? n3 : 16;
            string = string + "\n" + Packet.i2hex(n2, 6, "0");
            String string2 = "";
            for (n4 = 0; n4 < n5; ++n4) {
                byte by = byArray[n2 + n4];
                string = n4 == 8 ? string + "-" : string + " ";
                string = string + Packet.i2hex(by, 2, "0");
                string2 = by >= 32 && by < 128 ? string2 + (char)by : string2 + ".";
            }
            while (n4 < 16) {
                string = string + "   ";
                ++n4;
            }
            string = string + "   " + string2;
            n2 += n5;
            n3 -= n5;
        }
        return string + "\n";
    }

    public static String i2hex(int n, int n2, String string) {
        String string2 = Integer.toHexString(n);
        if (string2.length() == n2) {
            return string2;
        }
        if (string2.length() > n2) {
            return string2.substring(string2.length() - n2);
        }
        while (string2.length() < n2) {
            string2 = string + string2;
        }
        return string2;
    }
}

