/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.xml;

import java.util.Properties;

public class DestinationElement {
    private Properties _attrs = null;
    private Properties _props = null;
    private String _type = null;

    public void setAttributes(Properties properties) throws IllegalArgumentException {
        if (properties != null) {
            String string = properties.getProperty("ref-name");
            if (string.equals("imq.bridge.jms.dmq") || string.equals("built-in-dmq")) {
                throw new IllegalArgumentException("ref-name " + string + " is reserved");
            }
            if (properties.getProperty("lookup-name") == null) {
                String string2 = properties.getProperty("name");
                if (string2 == null) {
                    throw new IllegalArgumentException("Neither lookup-name nor name is specified for a destination element");
                }
                if (string2.equals("imq.bridge.jms.dmq")) {
                    throw new IllegalArgumentException("name " + string2 + " is reserved");
                }
            }
        }
        this._attrs = properties;
    }

    public void setProperties(Properties properties) {
        this._props = properties;
    }

    public Properties getAttributes() {
        return this._attrs;
    }

    public Properties getProperties() {
        return this._props;
    }

    public String getName() throws Exception {
        String string = this._attrs.getProperty("name");
        String string2 = this._attrs.getProperty("lookup-name");
        if (string2 != null) {
            throw new UnsupportedOperationException("Called when lookup-name is specified");
        }
        if (string == null) {
            throw new IllegalArgumentException("Destination name not specified");
        }
        return string;
    }

    public String getLookupName() {
        return this._attrs.getProperty("lookup-name");
    }

    public String getRefName() {
        return this._attrs.getProperty("ref-name");
    }

    public boolean isQueue() throws Exception {
        if (this._type == null) {
            this._type = this._attrs.getProperty("type");
        }
        if (this.getLookupName() != null) {
            throw new UnsupportedOperationException("Called when lookup-name is specified");
        }
        if (this._type == null) {
            throw new IllegalArgumentException("Destination type not specified");
        }
        this._type = this._type.trim().toLowerCase();
        return !this._type.equals("topic");
    }

    public String toString() {
        return "destination[" + this.getRefName() + "]";
    }
}

