/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx;

import com.sun.messaging.bridge.service.FaultInjection;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.resources.JMSBridgeResources;
import com.sun.messaging.bridge.service.jms.tx.BranchXid;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class XAParticipant {
    private Logger _logger = null;
    private FaultInjection _fi = FaultInjection.getInjection();
    private XAState _state = XAState.NOT_STARTED;
    private String _rm = null;
    private XAResource _xar = null;
    private BranchXid _bxid = null;
    private boolean _recovery = false;
    private static JMSBridgeResources _jbr = JMSBridge.getJMSBridgeResources();

    public XAParticipant(String string, XAResource xAResource, BranchXid branchXid) throws SystemException {
        this(string, xAResource, branchXid, false);
    }

    public XAParticipant(String string, XAResource xAResource, BranchXid branchXid, boolean bl) throws SystemException {
        if (string == null) {
            throw new SystemException("null RM name");
        }
        if (xAResource == null) {
            throw new SystemException("null XAResource object");
        }
        if (branchXid == null) {
            throw new SystemException("null branch xid");
        }
        this._bxid = branchXid;
        this._xar = xAResource;
        this._rm = string;
        this._recovery = bl;
        this._state = XAState.NOT_STARTED;
    }

    protected void setLogger(Logger logger) {
        this._logger = logger;
    }

    public BranchXid getBranchXid() {
        return this._bxid;
    }

    public void start(int n) throws RollbackException, SystemException {
        if (this._state != XAState.NOT_STARTED) {
            this._logger.log(Level.SEVERE, "start called at an illegal state " + this);
            throw new IllegalStateException(this.toString());
        }
        Object object = null;
        try {
            HashMap<String, String> hashMap;
            if (this._fi.FAULT_INJECTION) {
                hashMap = new HashMap<String, String>();
                hashMap.put("cfref", this._rm);
                this._fi.setLogger(this._logger);
                this._fi.checkFaultAndThrowException("xa.start.1", hashMap, "javax.transaction.xa.XAException", true);
            }
            this._xar.start(this._bxid, n);
            if (this._fi.FAULT_INJECTION) {
                hashMap = new HashMap();
                hashMap.put("cfref", this._rm);
                this._fi.setLogger(this._logger);
                this._fi.checkFaultAndThrowException("xa.start.2", hashMap, "javax.transaction.xa.XAException", true);
            }
            this._state = XAState.STARTED;
        }
        catch (XAException xAException) {
            switch (xAException.errorCode) {
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    this._state = XAState.NOT_STARTED;
                    this._logger.log(Level.SEVERE, "start returns XA_RB exception from " + this, xAException);
                    object = new RollbackException(this.xaEString(xAException.errorCode) + ": " + xAException.getMessage() + " on start tranaction from " + this);
                    ((Throwable)object).initCause(xAException);
                    throw (RollbackException)((Object)object);
                }
            }
            this._state = XAState.START_FAILED;
            this._logger.log(Level.SEVERE, "start failed from " + this, xAException);
            object = new RollbackException(this.xaEString(xAException.errorCode) + ": " + xAException.getMessage() + " on start transaction from " + this);
            ((Throwable)object).initCause(xAException);
            throw (RollbackException)((Object)object);
        }
        catch (Throwable throwable) {
            this._state = XAState.START_FAILED;
            this._logger.log(Level.SEVERE, "start failed from " + this, throwable);
            String string = throwable.getMessage();
            if (throwable instanceof XAException) {
                string = this.xaEString(((XAException)throwable).errorCode) + ": " + throwable.getMessage();
            }
            object = new SystemException(string + " on start transaction from " + this);
            ((Throwable)object).initCause(throwable);
            throw object;
        }
    }

    public void end(int n) throws IllegalStateException, RollbackException, SystemException {
        if (this._state != XAState.STARTED && this._state != XAState.START_FAILED) {
            this._logger.log(Level.SEVERE, "end called at an illegal state " + this);
            throw new IllegalStateException(this.toString());
        }
        Object object = null;
        try {
            HashMap<String, String> hashMap;
            if (this._fi.FAULT_INJECTION) {
                hashMap = new HashMap<String, String>();
                hashMap.put("cfref", this._rm);
                this._fi.setLogger(this._logger);
                this._fi.checkFaultAndThrowException("xa.end.1", hashMap, "javax.transaction.xa.XAException", true);
            }
            this._xar.end(this._bxid, n);
            if (this._fi.FAULT_INJECTION) {
                hashMap = new HashMap();
                hashMap.put("cfref", this._rm);
                this._fi.setLogger(this._logger);
                this._fi.checkFaultAndThrowException("xa.end.2", hashMap, "javax.transaction.xa.XAException", true);
            }
            this._state = XAState.ENDED;
        }
        catch (XAException xAException) {
            switch (xAException.errorCode) {
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    this._state = XAState.ENDED;
                    if (this._logger.isLoggable(Level.FINEST)) {
                        this._logger.log(Level.INFO, "XAResource.end() returned XA_RB exception from " + this, xAException);
                    } else {
                        this._logger.log(Level.INFO, "XAResource.end() returned XA_RB exception from " + this);
                    }
                    object = new RollbackException(this.xaEString(xAException.errorCode) + ": " + xAException.getMessage() + " on end transaction from " + this);
                    ((Throwable)object).initCause(xAException);
                    throw (RollbackException)((Object)object);
                }
            }
            this._state = XAState.END_FAILED;
            this._logger.log(Level.SEVERE, "end failed from " + this, xAException);
            object = new SystemException(this.xaEString(xAException.errorCode) + ": " + xAException.getMessage() + " on end transaction from " + this);
            ((Throwable)object).initCause(xAException);
            throw object;
        }
        catch (Throwable throwable) {
            this._logger.log(Level.SEVERE, "end failed from " + this, throwable);
            this._state = XAState.END_FAILED;
            String string = throwable.getMessage();
            if (throwable instanceof XAException) {
                string = this.xaEString(((XAException)throwable).errorCode) + ": " + throwable.getMessage();
            }
            object = new SystemException(string + " on end transaction from " + this);
            ((Throwable)object).initCause(throwable);
            throw object;
        }
    }

    public void rollback() throws IllegalStateException, SystemException, HeuristicCommitException, HeuristicRollbackException, HeuristicMixedException {
        if (!this._recovery && this._state != XAState.ENDED && this._state != XAState.END_FAILED && this._state != XAState.PREPARED && this._state != XAState.PREPARE_FAILED && this._state != XAState.ROLLEDBACK && this._state != XAState.ROLLBACK_FAILED) {
            this._logger.log(Level.SEVERE, "rollback called at an illegal state " + this);
            throw new IllegalStateException(this.toString());
        }
        if (this._state == XAState.ROLLEDBACK) {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1052", this.toString()));
            return;
        }
        Object object = null;
        try {
            HashMap<String, String> hashMap;
            if (this._fi.FAULT_INJECTION) {
                hashMap = new HashMap<String, String>();
                hashMap.put("cfref", this._rm);
                this._fi.setLogger(this._logger);
                this._fi.checkFaultAndThrowException("xa.rollback.1", hashMap, "javax.transaction.xa.XAException", true);
            }
            this._xar.rollback(this._bxid);
            if (this._fi.FAULT_INJECTION) {
                hashMap = new HashMap();
                hashMap.put("cfref", this._rm);
                this._fi.setLogger(this._logger);
                this._fi.checkFaultAndThrowException("xa.rollback.2", hashMap, "javax.transaction.xa.XAException", true);
            }
            this._state = XAState.ROLLEDBACK;
        }
        catch (XAException xAException) {
            switch (xAException.errorCode) {
                case 7: {
                    this._logger.log(Level.SEVERE, this._bxid + " has been heuristically committed by " + this);
                    this._state = XAState.COMMITTED_ONROLLBACK;
                    object = new HeuristicCommitException(this.xaEString(xAException.errorCode) + ": " + xAException.getMessage() + " on rollback transaction from " + this);
                    ((Throwable)object).initCause(xAException);
                    throw (HeuristicCommitException)((Object)object);
                }
                case 8: {
                    this._logger.log(Level.SEVERE, this._bxid + " may have been heuristically completed by " + this);
                }
                case 5: {
                    this._logger.log(Level.SEVERE, this._bxid + " has been heuristically partialy committed or partially rolledback by " + this);
                    this._state = XAState.ROLLBACK_FAILED;
                    object = new HeuristicMixedException(this.xaEString(xAException.errorCode) + ": " + xAException.getMessage() + " on rollback transaction from " + this);
                    ((Throwable)object).initCause(xAException);
                    throw (HeuristicMixedException)((Object)object);
                }
                case 6: {
                    this._state = XAState.ROLLEDBACK;
                    try {
                        this._xar.forget(this._bxid);
                        return;
                    }
                    catch (Throwable throwable) {
                        String string = "Failed to forget heuristically rolledback transaction from " + this;
                        this._logger.log(Level.WARNING, string, throwable);
                        object = new HeuristicRollbackException(string);
                        ((Throwable)object).initCause(xAException);
                        throw (HeuristicRollbackException)((Object)object);
                    }
                }
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    this._state = XAState.ROLLEDBACK;
                    this._logger.log(Level.INFO, this._bxid + " reported already rolled back by " + this);
                    return;
                }
            }
            this._state = XAState.ROLLBACK_FAILED;
            object = new SystemException(this.xaEString(xAException.errorCode) + ": " + xAException.getMessage() + " on rollback transaction from " + this);
            ((Throwable)object).initCause(xAException);
            throw (SystemException)object;
        }
        catch (Throwable throwable) {
            this._state = XAState.ROLLBACK_FAILED;
            String string = throwable.getMessage();
            if (throwable instanceof XAException) {
                string = this.xaEString(((XAException)throwable).errorCode) + ": " + throwable.getMessage();
            }
            object = new SystemException(string + " on rollback transaction from " + this);
            ((Throwable)object).initCause(throwable);
            throw object;
        }
    }

    public void prepare() throws IllegalStateException, RollbackException, SystemException {
        block13: {
            if (this._state != XAState.ENDED) {
                throw new IllegalStateException(this.toString());
            }
            Object object = null;
            try {
                HashMap<String, String> hashMap;
                if (this._fi.FAULT_INJECTION) {
                    hashMap = new HashMap<String, String>();
                    hashMap.put("cfref", this._rm);
                    this._fi.setLogger(this._logger);
                    this._fi.checkFaultAndThrowException("xa.prepare.1", hashMap, "javax.transaction.xa.XAException", true);
                }
                int n = this._xar.prepare(this._bxid);
                if (this._fi.FAULT_INJECTION) {
                    hashMap = new HashMap();
                    hashMap.put("cfref", this._rm);
                    this._fi.setLogger(this._logger);
                    this._fi.checkFaultAndThrowException("xa.prepare.2", hashMap, "javax.transaction.xa.XAException", true);
                }
                if (n == 0) {
                    this._state = XAState.PREPARED;
                    break block13;
                }
                if (n == 3) {
                    this._state = XAState.COMMITTED;
                    break block13;
                }
                throw new SystemException("Unexpected prepare return :" + n + " from " + this);
            }
            catch (XAException xAException) {
                switch (xAException.errorCode) {
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: {
                        this._state = XAState.ROLLEDBACK;
                        object = new RollbackException(this.xaEString(xAException.errorCode) + ": " + xAException.getMessage() + " on prepare transaction from " + this);
                        ((Throwable)object).initCause(xAException);
                        throw (RollbackException)((Object)object);
                    }
                }
                this._state = XAState.PREPARE_FAILED;
                object = new SystemException(this.xaEString(xAException.errorCode) + ": " + xAException.getMessage() + "on prepare transaction from " + this);
                ((Throwable)object).initCause(xAException);
                throw (SystemException)object;
            }
            catch (Throwable throwable) {
                this._state = XAState.PREPARE_FAILED;
                if (throwable instanceof SystemException) {
                    throw (SystemException)throwable;
                }
                String string = throwable.getMessage();
                if (throwable instanceof XAException) {
                    string = this.xaEString(((XAException)throwable).errorCode) + ": " + throwable.getMessage();
                }
                object = new SystemException(string + "on prepare transaction from " + this);
                ((Throwable)object).initCause(throwable);
                throw (SystemException)object;
            }
        }
    }

    public void commit(boolean bl) throws IllegalStateException, RollbackException, HeuristicCommitException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        if (bl ? this._state != XAState.ENDED : !this._recovery && this._state != XAState.PREPARED && this._state != XAState.COMMITTED) {
            throw new IllegalStateException(this.toString());
        }
        if (this._state == XAState.COMMITTED) {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1053", this.toString()));
        }
        Object object = null;
        try {
            HashMap<String, String> hashMap;
            if (this._fi.FAULT_INJECTION) {
                hashMap = new HashMap<String, String>();
                hashMap.put("cfref", this._rm);
                this._fi.setLogger(this._logger);
                this._fi.checkFaultAndThrowException("xa.commit.1", hashMap, "javax.transaction.xa.XAException", true);
            }
            this._xar.commit(this._bxid, bl);
            if (this._fi.FAULT_INJECTION) {
                hashMap = new HashMap();
                hashMap.put("cfref", this._rm);
                this._fi.setLogger(this._logger);
                this._fi.checkFaultAndThrowException("xa.commit.2", hashMap, "javax.transaction.xa.XAException", true);
            }
            this._state = XAState.COMMITTED;
        }
        catch (XAException xAException) {
            switch (xAException.errorCode) {
                case 7: {
                    this._state = XAState.COMMITTED;
                    this._logger.log(Level.INFO, this._bxid + " has been heuristically committed by " + this);
                    try {
                        this._xar.forget(this._bxid);
                        return;
                    }
                    catch (Throwable throwable) {
                        String string = "Failed to forget heuristically committed transaction from " + this;
                        this._logger.log(Level.WARNING, string, throwable);
                        object = new HeuristicCommitException(string);
                        ((Throwable)object).initCause(xAException);
                        throw (HeuristicCommitException)((Object)object);
                    }
                }
                case 8: {
                    this._logger.log(Level.SEVERE, this._bxid + " may have been heuristically completed by " + this);
                }
                case 5: {
                    this._logger.log(Level.SEVERE, this._bxid + " has been heuristically partialy committed or partially rolledback by " + this);
                    this._state = XAState.COMMIT_FAILED;
                    object = new HeuristicMixedException(this.xaEString(xAException.errorCode) + ": " + xAException.getMessage() + " on commit transaction from " + this);
                    ((Throwable)object).initCause(xAException);
                    throw (HeuristicMixedException)((Object)object);
                }
                case 6: {
                    this._state = XAState.ROLLEDBACK_ONCOMMIT;
                    this._logger.log(Level.SEVERE, this._bxid + " has been heuristically rolledback by " + this);
                    object = new HeuristicRollbackException(this.xaEString(xAException.errorCode) + ": " + xAException.getMessage() + " on commit transaction from " + this);
                    ((Throwable)object).initCause(xAException);
                    throw (HeuristicRollbackException)((Object)object);
                }
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    this._state = XAState.ROLLEDBACK_ONCOMMIT;
                    if (!bl) {
                        this._logger.log(Level.SEVERE, "Unexpected rollback exception on commit from " + this);
                        object = new SystemException("Unexpected " + this.xaEString(xAException.errorCode) + ": " + xAException.getMessage() + " on commit transaction from " + this);
                        ((Throwable)object).initCause(xAException);
                        throw (SystemException)object;
                    }
                    object = new RollbackException(this.xaEString(xAException.errorCode) + ": " + xAException.getMessage() + " on commit transation from " + this);
                    ((Throwable)object).initCause(xAException);
                    throw (RollbackException)((Object)object);
                }
            }
            this._state = XAState.COMMIT_FAILED;
            object = new SystemException(this.xaEString(xAException.errorCode) + ": " + xAException.getMessage() + " on commit transation from " + this);
            ((Throwable)object).initCause(xAException);
            throw (SystemException)object;
        }
        catch (Throwable throwable) {
            this._state = XAState.START_FAILED;
            String string = throwable.getMessage();
            if (throwable instanceof XAException) {
                string = this.xaEString(((XAException)throwable).errorCode) + ": " + throwable.getMessage();
            }
            object = new SystemException(string + " on commit transaction from " + this);
            ((Throwable)object).initCause(throwable);
            throw object;
        }
    }

    public String getRM() {
        return this._rm;
    }

    public boolean equals(Object object) {
        if (!(object instanceof XAParticipant)) {
            return false;
        }
        XAParticipant xAParticipant = (XAParticipant)object;
        if (xAParticipant == this) {
            return true;
        }
        return this._rm.equals(xAParticipant._rm) && this._bxid.equals(xAParticipant._bxid) && this._xar.equals(xAParticipant._xar);
    }

    public int hashCode() {
        return this._xar.hashCode();
    }

    public String toString() {
        return this._bxid + "[" + this._rm + ":" + this._xar + "]" + XAParticipant.toString(this._state);
    }

    public static String toString(XAState xAState) {
        switch (xAState) {
            case NOT_STARTED: {
                return "NOT_STARTED";
            }
            case START_FAILED: {
                return "STARTED_FAILED";
            }
            case STARTED: {
                return "STARTED";
            }
            case END_FAILED: {
                return "END_FAILED";
            }
            case ENDED: {
                return "ENDED";
            }
            case PREPARE_FAILED: {
                return "PREPARE_FAILED";
            }
            case PREPARED: {
                return "PREPARED";
            }
            case COMMIT_FAILED: {
                return "COMMIT_FAILED";
            }
            case COMMITTED: {
                return "COMMITTED";
            }
            case ROLLBACK_FAILED: {
                return "ROLLBACK_FAILED";
            }
            case ROLLEDBACK: {
                return "ROLLEDBACK";
            }
        }
        return "UNKNOWN";
    }

    private String xaEString(int n) {
        switch (n) {
            case 100: {
                return "XA_RBROLLBACK";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBDEADLOCK";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 107: {
                return "XA_RBTRANSIENT";
            }
            case 7: {
                return "XA_HEURCOM";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case 9: {
                return "XA_NOMIGRATE";
            }
            case 4: {
                return "XA_RETRY";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case -2: {
                return "XAER_ASYNC";
            }
            case -3: {
                return "XAER_RMERR";
            }
            case -4: {
                return "XAER_NOTA";
            }
            case -5: {
                return "XAER_INVAL";
            }
            case -6: {
                return "XAER_PROTO";
            }
            case -7: {
                return "XAER_RMFAIL";
            }
            case -8: {
                return "XAER_DUPID";
            }
            case -9: {
                return "XAER_OUTSIDE";
            }
        }
        return "UNKNOWN";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum XAState {
        NOT_STARTED,
        START_FAILED,
        STARTED,
        END_FAILED,
        ENDED,
        PREPARE_FAILED,
        PREPARED,
        COMMIT_FAILED,
        COMMITTED,
        ROLLBACK_FAILED,
        ROLLEDBACK,
        ROLLEDBACK_ONCOMMIT,
        ROLLEDBACK_ONCOMMIT_1PHASE,
        COMMITTED_ONROLLBACK;

    }
}

