/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.xml;

import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.xml.ConnectionFactoryElement;
import com.sun.messaging.bridge.service.jms.xml.DMQElement;
import com.sun.messaging.bridge.service.jms.xml.DestinationElement;
import com.sun.messaging.bridge.service.jms.xml.LinkElement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class JMSBridgeElement {
    private Properties _attrs = null;
    private LinkedHashMap<String, LinkElement> _links = new LinkedHashMap();
    private LinkedHashMap<String, DMQElement> _dmqs = new LinkedHashMap();
    private LinkedHashMap<String, DestinationElement> _dests = new LinkedHashMap();
    private LinkedHashMap<String, ConnectionFactoryElement> _cfs = new LinkedHashMap();

    public void setAttributes(Properties properties) {
        this._attrs = properties;
        if (properties != null && (this.getName().equals("imq.bridge.jms.dmq") || this.getName().equals("built-in-dmq"))) {
            throw new IllegalArgumentException("jmsbridge name " + this.getName() + " is reserved.");
        }
    }

    public String getName() {
        return this._attrs.getProperty("name");
    }

    public void addLink(LinkElement linkElement) throws Exception {
        String string = linkElement.getName();
        if (string.equals("imq.bridge.jms.dmq") || string.equals("built-in-dmq")) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4029", "link name", string));
        }
        LinkElement linkElement2 = this._links.get(string);
        if (linkElement2 != null) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4032", "link name", string));
        }
        this._links.put(string, linkElement);
    }

    public Map getLinks() {
        return this._links;
    }

    public void addDMQ(DMQElement dMQElement) throws Exception {
        String string = dMQElement.getName();
        if (string.equals("imq.bridge.jms.dmq")) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4029", "dmq name", string));
        }
        DMQElement dMQElement2 = this._dmqs.get(string);
        if (dMQElement2 != null) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4032", "dmq name", string));
        }
        this._dmqs.put(string, dMQElement);
    }

    public DMQElement getBuiltInDMQ() throws Exception {
        DMQElement dMQElement = this._dmqs.get("built-in-dmq");
        if (dMQElement == null) {
            dMQElement = new DMQElement();
            Properties properties = new Properties();
            properties.setProperty("name", "built-in-dmq");
            dMQElement.setAttributes(properties);
        }
        return dMQElement;
    }

    public Map getDMQs() {
        return this._dmqs;
    }

    public void addCF(String string, ConnectionFactoryElement connectionFactoryElement) throws Exception {
        if (string == null) {
            throw new IllegalArgumentException("ref-name null for " + connectionFactoryElement);
        }
        if (string.equals("built-in-dmq") || string.equals("imq.bridge.jms.dmq")) {
            throw new IllegalArgumentException("connection-factory ref-name " + string + " is reserved.");
        }
        ConnectionFactoryElement connectionFactoryElement2 = this._cfs.get(string);
        if (connectionFactoryElement2 != null) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4032", "connection-factory ref-name", string));
        }
        this._cfs.put(string, connectionFactoryElement);
    }

    public ConnectionFactoryElement getCF(String string) throws Exception {
        ConnectionFactoryElement connectionFactoryElement = this._cfs.get(string);
        if (connectionFactoryElement == null) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4033", "connection-factory ref-name", string));
        }
        return connectionFactoryElement;
    }

    public Map getAllCF() {
        return this._cfs;
    }

    public void addDestination(String string, DestinationElement destinationElement) throws Exception {
        if (string == null) {
            throw new IllegalArgumentException("ref-name null for " + destinationElement);
        }
        if (string.equals("built-in-dmq") || string.equals("imq.bridge.jms.dmq")) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4029", "destination ref-name", string));
        }
        DestinationElement destinationElement2 = this._dests.get(string);
        if (destinationElement2 != null) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4032", "destination ref-name", string));
        }
        this._dests.put(string, destinationElement);
    }

    public DestinationElement getDestination(String string) throws Exception {
        DestinationElement destinationElement = this._dests.get(string);
        if (destinationElement == null) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4033", "destination ref-name", string));
        }
        return destinationElement;
    }
}

