/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import java.util.Hashtable;

public class DestroyDestinationHandler
extends AdminCmdHandler {
    private static boolean DEBUG = DestroyDestinationHandler.getDEBUG();

    public DestroyDestinationHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "Destroying destination: " + hashtable);
        }
        String string = (String)hashtable.get("JMQDestination");
        Integer n = (Integer)hashtable.get("JMQDestType");
        int n2 = 200;
        String string2 = null;
        HAMonitorService hAMonitorService = Globals.getHAMonitorService();
        if (hAMonitorService != null && hAMonitorService.inTakeover()) {
            n2 = 500;
            string2 = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + string2);
        } else {
            try {
                boolean bl;
                if (n == null) {
                    throw new Exception("B4088");
                }
                Globals.getAuditSession().destinationOperation(iMQConnection.getUserName(), iMQConnection.remoteHostString(), "destroy destination", DestType.isQueue(n) ? "queue" : "topic", string);
                boolean bl2 = bl = Destination.removeDestination(string, DestType.isQueue(n), this.rb.getString("B0066")) != null;
                if (!bl) {
                    n2 = 500;
                    String string3 = this.rb.getString("B3128", DestType.toString(n), string);
                    string2 = this.rb.getString("B4087", string, string3);
                }
            }
            catch (Exception exception) {
                n2 = 500;
                string2 = this.rb.getString("B4087", string, DestroyDestinationHandler.getMessageFromException(exception));
                if (exception instanceof BrokerException) {
                    this.logger.logStack(16, "B4087", string, "", exception);
                }
                this.logger.logStack(16, "B4087", string, "", exception);
            }
        }
        Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
        packet2.setPacketType(5);
        DestroyDestinationHandler.setProperties(packet2, 13, n2, string2);
        this.parent.sendReply(iMQConnection, packet, packet2);
        return true;
    }
}

