/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.DeleteAllMessages;
import com.sun.messaging.jmq.jmsserver.service.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.lists.Filter;
import java.util.Hashtable;

public class PurgeDestinationHandler
extends AdminCmdHandler {
    private static boolean DEBUG = PurgeDestinationHandler.getDEBUG();
    private Filter deleteAll = new DeleteAllMessages();

    public PurgeDestinationHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        Object object;
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "Purging: " + hashtable);
        }
        assert (hashtable != null);
        String string = (String)hashtable.get("JMQDestination");
        Integer n = (Integer)hashtable.get("JMQDestType");
        assert (string != null);
        assert (n != null);
        int n2 = 200;
        String string2 = null;
        HAMonitorService hAMonitorService = Globals.getHAMonitorService();
        if (hAMonitorService != null && hAMonitorService.inTakeover()) {
            n2 = 500;
            string2 = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + string2);
        } else {
            object = Globals.getBrokerResources().getKString("B1035");
            this.logger.log(8, "B1034", (Object)string, object);
            try {
                Destination destination = Destination.getDestination(string, DestType.isQueue(n));
                if (destination == null) {
                    string2 = Globals.getBrokerResources().getKString("B3128", DestType.toString(n), string);
                    BrokerException brokerException = new BrokerException(string2);
                    brokerException.fillInStackTrace();
                    n2 = 500;
                    this.logger.log(16, "B2025", brokerException);
                } else {
                    Globals.getAuditSession().destinationOperation(iMQConnection.getUserName(), iMQConnection.remoteHostString(), "purge destination", destination.isQueue() ? "queue" : "topic", destination.getDestinationName());
                    destination.purgeDestination();
                }
            }
            catch (BrokerException brokerException) {
                n2 = 500;
                string2 = PurgeDestinationHandler.getMessageFromException(brokerException);
                this.logger.log(16, "B2025", brokerException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw outOfMemoryError;
            }
            catch (Throwable throwable) {
                n2 = 500;
                string2 = Globals.getBrokerResources().getString("B4117", throwable);
                this.logger.log(16, "B2025", throwable);
            }
        }
        object = new Packet(iMQConnection.useDirectBuffers());
        ((Packet)object).setPacketType(5);
        PurgeDestinationHandler.setProperties((Packet)object, 33, n2, string2);
        this.parent.sendReply(iMQConnection, packet, (Packet)object);
        return true;
    }
}

