/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.grizzly.Context;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.util.SSLOutputWriter;
import com.sun.messaging.bridge.service.BridgeContext;
import com.sun.messaging.bridge.service.stomp.StompFrameMessage;
import com.sun.messaging.bridge.service.stomp.StompOutputHandler;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandler;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

public class AsyncStompOutputHandler
implements StompOutputHandler {
    private Logger _logger = StompServer.getLogger();
    private SelectionKey _selectionkey = null;
    private SelectorHandler _selectorhandler = null;
    private SSLEngine _sslengine = null;
    private StompProtocolHandler _sph = null;
    private BridgeContext _bc = null;

    public AsyncStompOutputHandler(SelectionKey selectionKey, SelectorHandler selectorHandler, SSLEngine sSLEngine, StompProtocolHandler stompProtocolHandler, BridgeContext bridgeContext) {
        this._selectionkey = selectionKey;
        this._selectorhandler = selectorHandler;
        this._sslengine = sSLEngine;
        this._sph = stompProtocolHandler;
        this._bc = bridgeContext;
    }

    public void sendToClient(StompFrameMessage stompFrameMessage, Context context, StompProtocolHandler stompProtocolHandler) throws Exception {
        throw new UnsupportedOperationException("sendToClient(msg, ctx)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToClient(StompFrameMessage stompFrameMessage) throws Exception {
        block6: {
            try {
                SelectableChannel selectableChannel;
                ByteBuffer byteBuffer = stompFrameMessage.marshall();
                if (this._sslengine == null) {
                    this._selectorhandler.getAsyncQueueWriter().write(this._selectionkey, byteBuffer);
                    break block6;
                }
                int n = Math.max(8192, this._sslengine.getSession().getPacketBufferSize());
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n);
                byteBuffer2.position(0);
                SelectableChannel selectableChannel2 = selectableChannel = this._selectionkey.channel();
                synchronized (selectableChannel2) {
                    SSLOutputWriter.flushChannel((SelectableChannel)selectableChannel, (ByteBuffer)byteBuffer, (ByteBuffer)byteBuffer2, (SSLEngine)this._sslengine);
                }
            }
            catch (ClosedChannelException closedChannelException) {
                StompBridgeResources stompBridgeResources = StompServer.getStompBridgeResources();
                StompServer.getStompBridgeResources();
                this._logger.log(Level.WARNING, stompBridgeResources.getKString("BSS2000", stompFrameMessage.toString(), closedChannelException.toString()));
                this._sph.close(true);
                throw closedChannelException;
            }
        }
    }
}

