/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolChainInstruction;
import com.sun.grizzly.ProtocolParser;
import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.filter.ReadFilter;
import com.sun.grizzly.filter.SSLReadFilter;
import com.sun.grizzly.util.AttributeHolder;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;

public abstract class ParserProtocolFilter
extends ReadFilter {
    private static final String SSL_READ_RESULT = "PPF-SSL-ReadResult";
    protected boolean isSkipRead;
    private SSLReadFilter sslReadFilter;

    public void setSSLConfig(SSLConfig sslConfig) {
        if (sslConfig == null) {
            this.sslReadFilter = null;
            return;
        }
        this.sslReadFilter = new SSLReadFilter();
        this.sslReadFilter.configure(sslConfig);
    }

    public boolean execute(Context ctx) throws IOException {
        boolean isExpectingMoreData;
        ProtocolParser parser = null;
        AttributeHolder connectionAttrs = ctx.getAttributeHolderByScope(Context.AttributeScope.CONNECTION);
        if (connectionAttrs != null) {
            parser = (ProtocolParser)connectionAttrs.removeAttribute("ProtocolParser");
        }
        if (parser == null) {
            parser = (ProtocolParser)ctx.getAttribute("ProtocolParser");
            if (parser == null) {
                parser = this.newProtocolParser();
                ctx.setAttribute("ProtocolParser", parser);
            }
        } else {
            ctx.setAttribute("ProtocolParser", parser);
        }
        if ((isExpectingMoreData = parser.isExpectingMoreData()) || !parser.hasMoreBytesToParse()) {
            if (isExpectingMoreData) {
                ((WorkerThread)Thread.currentThread()).updateAttachment(this.sslReadFilter == null ? ThreadAttachment.Mode.ATTRIBUTES_ONLY : ThreadAttachment.Mode.SSL_ENGINE);
            }
            boolean continueExecution = this.isSkipRead || this.superExecute(ctx);
            WorkerThread workerThread = (WorkerThread)Thread.currentThread();
            ByteBuffer byteBuffer = workerThread.getByteBuffer();
            parser.startBuffer(byteBuffer);
            if (!continueExecution) {
                return continueExecution;
            }
        }
        if (!parser.hasNextMessage()) {
            return false;
        }
        return this.invokeProtocolParser(ctx, parser);
    }

    protected boolean invokeProtocolParser(Context ctx, ProtocolParser parser) {
        if (parser == null) {
            throw new IllegalStateException("ProcotolParser cannot be null");
        }
        Object o = parser.getNextMessage();
        ctx.setAttribute("ProtocolMessage", o);
        return true;
    }

    public boolean postExecute(Context context) throws IOException {
        ProtocolParser parser = (ProtocolParser)context.getAttribute("ProtocolParser");
        if (parser == null) {
            return true;
        }
        if (parser.hasMoreBytesToParse()) {
            context.setAttribute("ChainPostInstruction", (Object)ProtocolChainInstruction.REINVOKE);
            return true;
        }
        if (context.getKeyRegistrationState() != Context.KeyRegistrationState.CANCEL) {
            SelectionKey key = context.getSelectionKey();
            if (parser.isExpectingMoreData()) {
                if (parser.releaseBuffer()) {
                    this.saveParser(key, parser);
                }
                this.saveByteBuffer(key);
                this.superPostExecute(context);
                return false;
            }
            if (parser.releaseBuffer()) {
                this.saveParser(key, parser);
            }
        } else {
            parser.releaseBuffer();
        }
        return this.superPostExecute(context);
    }

    private boolean superExecute(Context context) throws IOException {
        if (this.sslReadFilter == null) {
            return super.execute(context);
        }
        boolean result = this.sslReadFilter.execute(context);
        if (result) {
            context.setAttribute(SSL_READ_RESULT, true);
        }
        return result;
    }

    private boolean superPostExecute(Context context) throws IOException {
        if (this.sslReadFilter == null) {
            return super.postExecute(context);
        }
        Boolean readResult = (Boolean)context.removeAttribute(SSL_READ_RESULT);
        Controller.logger().log(Level.INFO, "SSL ReadResult: " + readResult);
        if (readResult != null && Boolean.TRUE.equals(readResult)) {
            ByteBuffer secureBuffer = ((WorkerThread)Thread.currentThread()).getInputBB();
            Controller.logger().log(Level.INFO, "SSL secureBuffer: " + secureBuffer);
            if (secureBuffer != null && secureBuffer.position() > 0) {
                context.setAttribute("ChainPostInstruction", (Object)ProtocolChainInstruction.REINVOKE);
                return true;
            }
        }
        return this.sslReadFilter.postExecute(context);
    }

    public abstract ProtocolParser newProtocolParser();

    private void saveByteBuffer(SelectionKey key) {
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        ThreadAttachment threadAttachment = this.sslReadFilter == null ? workerThread.updateAttachment(ThreadAttachment.Mode.BYTE_BUFFER) : workerThread.updateAttachment(ThreadAttachment.Mode.SSL_ARTIFACTS);
        key.attach(threadAttachment);
    }

    private void saveParser(SelectionKey key, ProtocolParser parser) {
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        ThreadAttachment threadAttachment = workerThread.getAttachment();
        threadAttachment.setAttribute("ProtocolParser", parser);
        key.attach(threadAttachment);
    }

    protected boolean isSkipRead() {
        return this.isSkipRead;
    }

    protected void setSkipRead(boolean isSkipRead) {
        this.isSkipRead = isSkipRead;
    }
}

