/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.util.memory;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.util.memory.MemoryCallback;
import com.sun.messaging.jmq.jmsserver.util.memory.MemoryCallbackEntry;
import com.sun.messaging.jmq.jmsserver.util.memory.MemoryLevelHandler;
import com.sun.messaging.jmq.util.DiagDictionaryEntry;
import com.sun.messaging.jmq.util.DiagManager;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import java.util.Vector;

public class MemoryManager
implements DiagManager.Data {
    private static boolean NO_GC_DEFAULT = false;
    private static final String GC_JAVA_VERSION = "1.4.2";
    private static final String PACKAGE = "com.sun.messaging.jmq.jmsserver.util.memory.levels.";
    protected static final Logger logger = Globals.getLogger();
    public boolean NO_GC = Globals.getConfig().getBooleanProperty("imq.memory_management.nogc", NO_GC_DEFAULT);
    private static boolean DEBUG;
    ArrayList diagDictionary = null;
    MemoryLevelHandler[] levelHandlers = null;
    long[] byteLevels = null;
    protected int currentLevel = 0;
    protected String currentLevelString = "";
    protected long baseMemory;
    protected long maxMessageSize;
    protected long maxAvailableMemory;
    protected long maxSizeOfVM;
    protected long totalMemory;
    protected long freeMemory;
    protected long allocatedMemory;
    protected long availMemory;
    protected int producerCount = 0;
    protected int JMQSizeValue = 0;
    protected long JMQBytesValue = 0L;
    protected long JMQMaxMessageSize = 0L;
    protected long averageMemUsage = 0L;
    protected long highestMemUsage = 0L;
    protected long memoryCheckCount = 0L;
    protected long timeInLevel = 0L;
    protected long cumulativeTimeInLevel = 0L;
    protected long startTime = 0L;
    private static final int GC_DELTA_DEFAULT = 1024;
    private static int GC_DELTA;
    private static long OVERHEAD_MEMORY_DEFAULT;
    private static long OVERHEAD_MEMORY;
    private boolean turnOffMemory = !Globals.getConfig().getBooleanProperty("imq.memory_management.enabled", true);
    private static int THRESHOLD_DELTA_DEFAULT;
    private static int THRESHOLD_DELTA;
    private HashMap callbacklist = new HashMap();
    private List pausedList = new ArrayList();
    private boolean active = false;
    private Object stateChangeLock = new Object();
    private Object valuesObjectLock = new Object();
    private Object timerObjectLock = new Object();
    private MyTimerTask mytimer = null;
    boolean completedRunningCleanup = true;
    int cleanupCnt = 0;

    private static boolean getNoGCDefault() {
        boolean bl = false;
        Version version = Globals.getVersion();
        int n = Version.compareVersions((String)System.getProperties().get("java.version"), GC_JAVA_VERSION, true);
        bl = n < 0;
        logger.log(1, "NoGC commuted from JDK:  " + bl);
        return bl;
    }

    public Hashtable getDebugState() {
        int n;
        Vector<Object> vector;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("turnOffMemory", this.turnOffMemory);
        hashtable.put("active", this.active);
        hashtable.put("noForcedGC", this.NO_GC);
        hashtable.put("baseMemory", new Long(this.baseMemory));
        hashtable.put("maxMessageSize", new Long(this.maxMessageSize));
        hashtable.put("maxAvailableMemory", new Long(this.maxAvailableMemory));
        hashtable.put("maxSizeOfVM", new Long(this.maxSizeOfVM));
        hashtable.put("totalMemory", new Long(this.totalMemory));
        hashtable.put("freeMemory", new Long(this.freeMemory));
        hashtable.put("allocatedMemory", new Long(this.allocatedMemory));
        hashtable.put("availMemory", new Long(this.availMemory));
        hashtable.put("allocatedMemory", new Long(this.allocatedMemory));
        hashtable.put("JMQBytesValue", new Long(this.JMQBytesValue));
        hashtable.put("JMQMaxMessageSize", new Long(this.JMQMaxMessageSize));
        hashtable.put("averageMemUsage", new Long(this.averageMemUsage));
        hashtable.put("highestMemUsage", new Long(this.highestMemUsage));
        hashtable.put("memoryCheckCount", new Long(this.memoryCheckCount));
        hashtable.put("timeInLevel", new Long(this.timeInLevel));
        hashtable.put("cumulativeTimeInLevel", new Long(this.cumulativeTimeInLevel));
        hashtable.put("startTime", new Long(this.startTime));
        hashtable.put("OVERHEAD_MEMORY", new Long(OVERHEAD_MEMORY));
        hashtable.put("currentLevel", new Integer(this.currentLevel));
        hashtable.put("producerCount", new Integer(this.producerCount));
        hashtable.put("JMQSizeValue", new Integer(this.JMQSizeValue));
        hashtable.put("GC_DELTA", new Integer(GC_DELTA));
        hashtable.put("THRESHOLD_DELTA", new Integer(THRESHOLD_DELTA));
        hashtable.put("currentLevelString", this.currentLevelString);
        if (this.byteLevels != null) {
            hashtable.put("byteLevels#", new Integer(this.byteLevels.length));
            vector = new Vector();
            for (n = 0; n < this.byteLevels.length; ++n) {
                vector.add(new Long(this.byteLevels[n]));
            }
            hashtable.put("byteLevels", vector);
        }
        if (this.levelHandlers != null) {
            vector = new Vector<Object>();
            hashtable.put("levelHandlers#", new Integer(this.levelHandlers.length));
            for (n = 0; n < this.levelHandlers.length; ++n) {
                vector.add(this.levelHandlers[n].getDebugState());
            }
            hashtable.put("levelHandlers", vector);
        }
        hashtable.put("pausedList#", new Integer(this.pausedList.size()));
        hashtable.put("callbacklist#", new Integer(this.callbacklist.size()));
        if (this.pausedList.size() > 0) {
            vector = new Vector();
            for (n = 0; n < this.pausedList.size(); ++n) {
                vector.add(this.pausedList.get(n).toString());
            }
            hashtable.put("pausedList", vector);
        }
        if (this.callbacklist.size() > 0) {
            vector = new Vector();
            Iterator iterator = this.callbacklist.values().iterator();
            while (iterator.hasNext()) {
                vector.add(iterator.next().toString());
            }
            hashtable.put("callbacklist", vector);
        }
        return hashtable;
    }

    public MemoryManager() {
        if (this.turnOffMemory) {
            this.JMQSizeValue = -1;
            this.JMQBytesValue = -1L;
            this.JMQMaxMessageSize = -1L;
            return;
        }
        this.maxSizeOfVM = Runtime.getRuntime().maxMemory() - 0L;
        this.maxAvailableMemory = this.maxSizeOfVM - OVERHEAD_MEMORY_DEFAULT;
        String[] stringArray = Globals.getConfig().getArray("imq.memory.levels");
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        try {
            this.levelHandlers = new MemoryLevelHandler[stringArray.length];
            this.byteLevels = new long[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Serializable serializable;
                String string = Globals.getConfig().getProperty("imq." + stringArray[i] + ".classname");
                if (string == null) {
                    serializable = new StringBuffer(stringArray[i]);
                    char c = ((StringBuffer)serializable).charAt(0);
                    char c2 = Character.toUpperCase(c);
                    ((StringBuffer)serializable).setCharAt(0, c2);
                    string = PACKAGE + serializable;
                }
                if (DEBUG) {
                    logger.log(4, "Loading level " + stringArray[i] + " as " + string);
                }
                serializable = Class.forName(string);
                Class[] classArray = new Class[]{String.class};
                Constructor constructor = ((Class)serializable).getConstructor(classArray);
                Object[] objectArray = new Object[]{stringArray[i]};
                this.levelHandlers[i] = (MemoryLevelHandler)constructor.newInstance(objectArray);
                this.byteLevels[i] = (long)this.levelHandlers[i].getThresholdPercent() * this.maxAvailableMemory / 100L;
            }
        }
        catch (Exception exception) {
            logger.logStack(16, "B3100", "loading memory manager", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopManagement() {
        this.active = false;
        Object object = this.timerObjectLock;
        synchronized (object) {
            if (this.mytimer != null) {
                this.mytimer.cancel();
                this.mytimer = null;
            }
        }
    }

    public void startManagement() {
        if (this.turnOffMemory) {
            logger.log(4, "Memory Management turned off");
            return;
        }
        if (this.active) {
            logger.log(4, "Memory Management already active");
            return;
        }
        this.active = true;
        logger.log(4, "Starting Memory Management: adjusted available memory is " + this.maxAvailableMemory / 1024L + "K");
        logger.log(4, "Explicitly GC : " + !this.NO_GC);
        for (int i = 0; i < this.levelHandlers.length; ++i) {
            logger.log(4, "LEVEL:" + this.levelHandlers[i].levelName() + "[percent = " + this.levelHandlers[i].getThresholdPercent() + "%" + ", bytes = " + this.byteLevels[i] / 1024L + "K]");
        }
        DiagManager.register(this);
        this.startTime = System.currentTimeMillis();
        this.baseMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this.currentLevel = this.calculateState();
        MemoryLevelHandler memoryLevelHandler = this.levelHandlers[this.currentLevel];
        this.currentLevelString = memoryLevelHandler.levelName();
        memoryLevelHandler.enter(false);
        this.JMQSizeValue = memoryLevelHandler.getMessageCount(this.availMemory, this.producerCount);
        this.JMQBytesValue = memoryLevelHandler.getMemory(this.availMemory, this.producerCount);
        this.JMQMaxMessageSize = this.maxAvailableMemory / 2L;
        this.updateMaxMessageSize(-2L);
        this.mytimer = new MyTimerTask();
        long l = memoryLevelHandler.getTimeBetweenChecks();
        try {
            Globals.getTimer().schedule((TimerTask)this.mytimer, l, l);
        }
        catch (IllegalStateException illegalStateException) {
            logger.log(4, "Timer canceled ", illegalStateException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJMQSize() {
        Object object = this.valuesObjectLock;
        synchronized (object) {
            return this.JMQSizeValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getJMQBytes() {
        Object object = this.valuesObjectLock;
        synchronized (object) {
            return this.JMQBytesValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getJMQMaxMsgBytes() {
        Object object = this.valuesObjectLock;
        synchronized (object) {
            return this.JMQMaxMessageSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifyWhenAvailable(MemoryCallback memoryCallback, long l) {
        if (DEBUG) {
            logger.log(4, "Registering notifyWhenAvailable at " + l + " for " + memoryCallback);
        }
        if (this.turnOffMemory || !this.active) {
            memoryCallback.resumeMemory(this.JMQSizeValue, this.JMQBytesValue, this.JMQMaxMessageSize);
            return;
        }
        this.checkMemoryState();
        Object object = this.valuesObjectLock;
        synchronized (object) {
            if ((l == 0L || l < this.JMQBytesValue) && this.JMQSizeValue > 1) {
                memoryCallback.resumeMemory(this.JMQSizeValue, this.JMQBytesValue, this.JMQMaxMessageSize);
                return;
            }
        }
        object = (MemoryCallbackEntry)this.callbacklist.get(memoryCallback);
        if (memoryCallback == null) {
            object = new MemoryCallbackEntry();
            this.callbacklist.put(memoryCallback, object);
            ((MemoryCallbackEntry)object).cb = memoryCallback;
            ((MemoryCallbackEntry)object).keepAfterNotify = false;
        }
        ((MemoryCallbackEntry)object).paused = true;
        ((MemoryCallbackEntry)object).bytes = l;
        List list = this.pausedList;
        synchronized (list) {
            this.pausedList.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMemoryCallback(MemoryCallback memoryCallback) {
        if (DEBUG) {
            logger.log(4, "Registering registerMemoryCallback  for " + memoryCallback);
        }
        MemoryCallbackEntry memoryCallbackEntry = new MemoryCallbackEntry();
        memoryCallbackEntry.cb = memoryCallback;
        memoryCallbackEntry.keepAfterNotify = true;
        memoryCallbackEntry.paused = false;
        memoryCallbackEntry.bytes = 0L;
        HashMap hashMap = this.callbacklist;
        synchronized (hashMap) {
            this.callbacklist.put(memoryCallback, memoryCallbackEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemoryCallback(MemoryCallback memoryCallback) {
        HashMap hashMap = this.callbacklist;
        synchronized (hashMap) {
            this.callbacklist.remove(memoryCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentLevel() {
        Object object = this.stateChangeLock;
        synchronized (object) {
            return this.currentLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentLevelName() {
        Object object = this.stateChangeLock;
        synchronized (object) {
            return this.levelHandlers[this.currentLevel].localizedLevelName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAllOfStateChange(boolean bl) {
        if (this.turnOffMemory || !this.active) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = this.callbacklist;
        synchronized (hashMap) {
            arrayList.addAll(this.callbacklist.values());
        }
        long l = 0L;
        int n = 0;
        long l2 = 0L;
        Iterator iterator = this.valuesObjectLock;
        synchronized (iterator) {
            l = this.JMQBytesValue;
            n = this.JMQSizeValue;
            l2 = this.JMQMaxMessageSize;
        }
        if (DEBUG) {
            logger.log(2, "notifyAllOfStateChange [size,bytes,max] = [" + this.JMQSizeValue + "," + this.JMQBytesValue + "," + this.JMQMaxMessageSize + "]");
        }
        for (MemoryCallbackEntry memoryCallbackEntry : arrayList) {
            if (!bl && memoryCallbackEntry.paused) continue;
            if (memoryCallbackEntry.paused) {
                if (memoryCallbackEntry.bytes == 0L && memoryCallbackEntry.bytes < l) {
                    memoryCallbackEntry.paused = false;
                    List list = this.pausedList;
                    synchronized (list) {
                        this.pausedList.remove(memoryCallbackEntry);
                    }
                    memoryCallbackEntry.cb.resumeMemory(n, l, l2);
                    if (!DEBUG) continue;
                    logger.log(2, "\tresumeMemory for  " + memoryCallbackEntry.bytes + " bytes on " + memoryCallbackEntry.cb);
                    continue;
                }
                if (DEBUG) {
                    logger.log(2, "\tupdateMemory for  " + memoryCallbackEntry.cb);
                }
                memoryCallbackEntry.cb.updateMemory(n, l, l2);
                continue;
            }
            if (DEBUG) {
                logger.log(2, "\tupdateMemory for  " + memoryCallbackEntry.cb);
            }
            memoryCallbackEntry.cb.updateMemory(n, l, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndNotifyPaused() {
        if (DEBUG) {
            logger.log(2, "checkAndNotifyPaused [size,bytes,max] = [" + this.JMQSizeValue + "," + this.JMQBytesValue + "," + this.JMQMaxMessageSize + "]");
        }
        ArrayList arrayList = null;
        List list = this.pausedList;
        synchronized (list) {
            if (this.pausedList.isEmpty()) {
                return;
            }
            arrayList = new ArrayList();
            arrayList.addAll(this.pausedList);
        }
        long l = 0L;
        int n = 0;
        long l2 = 0L;
        Iterator iterator = this.valuesObjectLock;
        synchronized (iterator) {
            l = this.JMQBytesValue;
            n = this.JMQSizeValue;
            l2 = this.JMQMaxMessageSize;
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            MemoryCallbackEntry memoryCallbackEntry = (MemoryCallbackEntry)iterator.next();
            if (memoryCallbackEntry.bytes != 0L || memoryCallbackEntry.bytes >= l) continue;
            memoryCallbackEntry.paused = false;
            iterator.remove();
            List list2 = this.pausedList;
            synchronized (list2) {
                this.pausedList.remove(memoryCallbackEntry);
            }
            if (DEBUG) {
                logger.log(2, "\tresumeMemory for  " + memoryCallbackEntry.bytes + " bytes on " + memoryCallbackEntry.cb);
            }
            memoryCallbackEntry.cb.resumeMemory(n, l, l2);
        }
    }

    public String toString() {
        return "MemoryManager";
    }

    public synchronized void addProducer() {
        ++this.producerCount;
        if (DEBUG) {
            logger.log(4, "addProducer " + this.producerCount);
        }
    }

    public synchronized void removeProducer() {
        --this.producerCount;
        if (DEBUG) {
            logger.log(4, "removeProducer " + this.producerCount);
        }
    }

    public synchronized void removeProducer(int n) {
        this.producerCount -= n;
        if (DEBUG) {
            logger.log(4, "removeProducer(" + n + ") " + this.producerCount);
        }
    }

    private boolean quickState(int n) {
        if (this.turnOffMemory || !this.active) {
            return false;
        }
        this.freeMemory = Runtime.getRuntime().freeMemory();
        this.totalMemory = Runtime.getRuntime().totalMemory();
        this.allocatedMemory = this.totalMemory - this.freeMemory;
        return n < this.byteLevels.length - 1 && this.allocatedMemory > this.byteLevels[n + 1];
    }

    public boolean allocateMemCheck(long l) {
        int n;
        if (DEBUG) {
            n = this.currentLevel;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.byteLevels.length; ++i) {
                stringBuffer.append("byteLevel[" + i + "]=" + this.byteLevels[i] + ", ");
            }
            long l2 = Runtime.getRuntime().freeMemory();
            long l3 = Runtime.getRuntime().totalMemory();
            long l4 = l3 - l2;
            logger.log(8, "MemoryManager: turnOffMemory=" + this.turnOffMemory + ", active=" + this.active + ", check size=" + l + ", currentLevel=" + n + "(" + this.byteLevels.length + "), " + stringBuffer.toString() + ", freemem=" + l2 + ", totalmem=" + l3 + ", allocatedmem=" + l4);
        }
        if (this.turnOffMemory || !this.active) {
            return true;
        }
        n = this.currentLevel;
        if (n >= this.byteLevels.length - 1) {
            return false;
        }
        long l5 = Runtime.getRuntime().freeMemory();
        long l6 = Runtime.getRuntime().totalMemory();
        long l7 = l6 - l5 + l;
        return l7 <= this.byteLevels[this.byteLevels.length - 1];
    }

    private int calculateState() {
        int n;
        if (this.turnOffMemory || !this.active) {
            return 0;
        }
        this.freeMemory = Runtime.getRuntime().freeMemory();
        this.totalMemory = Runtime.getRuntime().totalMemory();
        this.allocatedMemory = this.totalMemory - this.freeMemory;
        long l = Runtime.getRuntime().maxMemory();
        if (this.allocatedMemory > this.maxAvailableMemory) {
            this.recalcMemory();
        }
        this.availMemory = this.maxAvailableMemory - this.allocatedMemory;
        int n2 = 0;
        for (n = this.byteLevels.length - 1; n >= 0; --n) {
            if (this.allocatedMemory <= this.byteLevels[n]) continue;
            n2 = n;
            break;
        }
        n = n2;
        if (n2 < this.byteLevels.length - 1 && this.allocatedMemory > this.byteLevels[n2 + 1] - (long)THRESHOLD_DELTA) {
            if (DEBUG) {
                logger.log(2, "calculateState:didnt meet delta requirements");
            }
            n = n2 + 1;
        }
        if (DEBUG) {
            logger.log(2, "calculateState [oldstate, calcstate, returnstate] = [" + this.currentLevel + "," + n2 + "," + n + "]");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMaxMessageSize(long l) {
        Object object = this.valuesObjectLock;
        synchronized (object) {
            if (l != -2L) {
                this.maxMessageSize = l;
            }
            this.JMQMaxMessageSize = this.maxAvailableMemory / 2L;
            if (this.maxMessageSize > -1L && this.maxMessageSize < this.JMQMaxMessageSize) {
                this.JMQMaxMessageSize = this.maxMessageSize;
            }
            if (DEBUG) {
                logger.log(4, "updateMaxMessageSize [size, JMQMaxMessageSize] = [" + l + "," + this.JMQMaxMessageSize + "]");
            }
        }
    }

    public void quickMemoryCheck() {
        if (this.quickState(this.currentLevel)) {
            this.checkMemoryState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMemoryState() {
        if (this.turnOffMemory || !this.active) {
            return;
        }
        if (DEBUG) {
            logger.log(4, "checkMemoryState  " + this.memoryCheckCount);
        }
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        Object object = this.stateChangeLock;
        synchronized (object) {
            n2 = this.calculateState();
            n = this.currentLevel;
            this.currentLevel = n2;
        }
        object = this.levelHandlers[n];
        if (n2 != n) {
            int n3;
            MemoryLevelHandler memoryLevelHandler = this.levelHandlers[n2];
            if (n2 > n) {
                this.gc(memoryLevelHandler.gcCount());
                n2 = this.calculateState();
            }
            for (n3 = n; n3 < n2; ++n3) {
                bl = this.levelHandlers[n3 + 1].enter(false);
                bl |= this.levelHandlers[n3].leave(true);
            }
            for (n3 = n; n3 > n2; --n3) {
                bl |= this.levelHandlers[n3 - 1].enter(true);
                bl |= this.levelHandlers[n3].leave(false);
            }
            memoryLevelHandler = this.levelHandlers[n2];
            Object[] objectArray = this.valuesObjectLock;
            synchronized (this.valuesObjectLock) {
                this.JMQSizeValue = memoryLevelHandler.getMessageCount(this.availMemory, this.producerCount);
                this.JMQBytesValue = memoryLevelHandler.getMemory(this.availMemory, this.producerCount);
                // ** MonitorExit[var6_9] (shouldn't be in output)
                if (bl) {
                    this.notifyAllOfStateChange(true);
                }
                this.currentLevel = n2;
                if (n2 > n) {
                    this.completedRunningCleanup = false;
                    this.cleanupCnt = 0;
                    this.completedRunningCleanup = this.levelHandlers[n2].cleanup(this.cleanupCnt++);
                } else if (n2 < n) {
                    this.completedRunningCleanup = true;
                    this.cleanupCnt = 0;
                }
                if (n2 != n) {
                    objectArray = new String[]{this.levelHandlers[n2].localizedLevelName(), this.levelHandlers[n].localizedLevelName(), String.valueOf(this.allocatedMemory / 1024L), String.valueOf(this.allocatedMemory * 100L / this.maxAvailableMemory)};
                    logger.log(8, "B1088", objectArray);
                    Agent agent = Globals.getAgent();
                    if (agent != null) {
                        agent.notifyResourceStateChange(this.levelHandlers[n].localizedLevelName(), this.levelHandlers[n2].localizedLevelName(), null);
                    }
                    this.currentLevel = n2;
                    object = memoryLevelHandler;
                    this.currentLevelString = ((MemoryLevelHandler)object).levelName();
                    Object object2 = this.timerObjectLock;
                    synchronized (object2) {
                        if (this.mytimer != null) {
                            this.mytimer.cancel();
                            this.mytimer = null;
                        }
                        this.mytimer = new MyTimerTask();
                        long l = ((MemoryLevelHandler)object).getTimeBetweenChecks();
                        try {
                            Globals.getTimer(true).schedule((TimerTask)this.mytimer, l, l);
                        }
                        catch (IllegalStateException illegalStateException) {
                            logger.log(4, "Timer canceled ", illegalStateException);
                        }
                    }
                }
            }
        } else {
            if (!this.completedRunningCleanup) {
                this.completedRunningCleanup = this.levelHandlers[n].cleanup(this.cleanupCnt++);
            }
            if (((MemoryLevelHandler)object).gcIteration() != 0 && this.memoryCheckCount % (long)((MemoryLevelHandler)object).gcIteration() == 0L) {
                this.gc();
            }
            Object object3 = this.valuesObjectLock;
            synchronized (object3) {
                this.JMQSizeValue = ((MemoryLevelHandler)object).getMessageCount(this.availMemory, this.producerCount);
                this.JMQBytesValue = ((MemoryLevelHandler)object).getMemory(this.availMemory, this.producerCount);
            }
            if (this.JMQSizeValue > 0) {
                this.checkAndNotifyPaused();
            }
        }
        {
            if (this.allocatedMemory > this.highestMemUsage) {
                this.highestMemUsage = this.allocatedMemory;
            }
            this.averageMemUsage = (this.averageMemUsage * this.memoryCheckCount + this.allocatedMemory) / (this.memoryCheckCount + 1L);
            ++this.memoryCheckCount;
            return;
        }
    }

    public void forceRedState() {
        long l = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().freeMemory();
        logger.log(16, "B2075", (Object)String.valueOf(l), String.valueOf(Runtime.getRuntime().maxMemory()));
        this.recalcMemory();
        this.checkMemoryState();
    }

    public void recalcMemory() {
        this.maxAvailableMemory = Runtime.getRuntime().totalMemory();
        this.updateMaxMessageSize(-2L);
        for (int i = 0; i < this.byteLevels.length; ++i) {
            this.byteLevels[i] = (long)this.levelHandlers[i].getThresholdPercent() * this.maxAvailableMemory / 100L;
        }
    }

    protected void gc() {
        this.gc(1, GC_DELTA);
    }

    protected void gc(int n) {
        this.gc(n, GC_DELTA);
    }

    protected void gc(int n, long l) {
        if (!this.NO_GC) {
            long l2 = Runtime.getRuntime().freeMemory();
            int n2 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                Runtime.getRuntime().gc();
                long l3 = Runtime.getRuntime().freeMemory();
                if (l2 - l3 > l) break;
            }
        }
    }

    public synchronized List getDictionary() {
        if (this.diagDictionary == null) {
            this.diagDictionary = new ArrayList();
            this.diagDictionary.add(new DiagDictionaryEntry("currentLevelString", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("allocatedMemory", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("timeInLevel", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("cumulativeTimeInLevel", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("JMQSizeValue", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("JMQBytesValue", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("JMQMaxMessageSize", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("totalMemory", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("freeMemory", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("availMemory", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("maxAvailableMemory", 2));
            this.diagDictionary.add(new DiagDictionaryEntry("producerCount", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("averageMemUsage", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("memoryCheckCount", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("highestMemUsage", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("maxSizeOfVM", 2));
        }
        return this.diagDictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        this.calculateState();
        MemoryLevelHandler memoryLevelHandler = null;
        Object object = this.stateChangeLock;
        synchronized (object) {
            memoryLevelHandler = this.levelHandlers[this.currentLevel];
        }
        this.timeInLevel = memoryLevelHandler.getCurrentTimeInLevel();
        this.cumulativeTimeInLevel = memoryLevelHandler.getTotalTimeInLevel();
    }

    public String getPrefix() {
        return "mem_mgr";
    }

    public String getTitle() {
        return "MemoryManager";
    }

    public String toDebugString() {
        int n;
        String string = "MemoryManager: [" + this.currentLevel + "]" + "\n";
        for (n = 0; n < this.levelHandlers.length; ++n) {
            string = string + "\t" + n + "\t" + this.levelHandlers[n].levelName() + "\t" + this.levelHandlers[n].getThresholdPercent() + "\t" + this.byteLevels[n] + "\n";
        }
        for (n = 0; n < this.levelHandlers.length; ++n) {
            string = string + "-------------------------------\n";
            string = string + this.levelHandlers[n].toDebugString() + " \n\n";
        }
        return string;
    }

    static {
        NO_GC_DEFAULT = MemoryManager.getNoGCDefault();
        DEBUG = false;
        GC_DELTA = Globals.getConfig().getIntProperty("imq.memory.gcdelta", 1024);
        OVERHEAD_MEMORY_DEFAULT = 10240L;
        OVERHEAD_MEMORY = Globals.getConfig().getLongProperty("imq.memory.overhead", OVERHEAD_MEMORY_DEFAULT);
        THRESHOLD_DELTA_DEFAULT = 1024;
        THRESHOLD_DELTA = Globals.getConfig().getIntProperty("imq.memory.hysteresis", THRESHOLD_DELTA_DEFAULT);
    }

    private class MyTimerTask
    extends TimerTask {
        private MyTimerTask() {
        }

        public void run() {
            MemoryManager.this.checkMemoryState();
        }
    }
}

