/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ClusterTxnInfoInfo {
    protected Logger logger = Globals.getLogger();
    private Long transactionID = null;
    private int transactionState;
    private BrokerAddress[] brokers;
    private BrokerAddress[] waitfor;
    private BrokerAddress txnHome;
    private boolean owner = false;
    private Cluster c = null;
    private Long xid = null;
    private GPacket pkt = null;

    private ClusterTxnInfoInfo(Long l, int n, BrokerAddress[] brokerAddressArray, BrokerAddress[] brokerAddressArray2, BrokerAddress brokerAddress, boolean bl, Cluster cluster, Long l2) {
        this.transactionID = l;
        this.transactionState = n;
        this.brokers = brokerAddressArray;
        this.waitfor = brokerAddressArray2;
        this.txnHome = brokerAddress;
        this.owner = bl;
        this.c = cluster;
        this.xid = l2;
    }

    private ClusterTxnInfoInfo(GPacket gPacket, Cluster cluster) {
        this.pkt = gPacket;
        this.c = cluster;
    }

    public static ClusterTxnInfoInfo newInstance(Long l, int n, BrokerAddress[] brokerAddressArray, BrokerAddress[] brokerAddressArray2, BrokerAddress brokerAddress, boolean bl, Cluster cluster, Long l2) {
        return new ClusterTxnInfoInfo(l, n, brokerAddressArray, brokerAddressArray2, brokerAddress, bl, cluster, l2);
    }

    public static ClusterTxnInfoInfo newInstance(GPacket gPacket, Cluster cluster) {
        return new ClusterTxnInfoInfo(gPacket, cluster);
    }

    public GPacket getGPacket() throws IOException {
        int n;
        StringBuffer stringBuffer;
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)48);
        gPacket.putProp("transactionID", this.transactionID);
        gPacket.putProp("transactionState", new Integer(this.transactionState));
        if (this.owner) {
            gPacket.putProp("owner", true);
            this.c.marshalBrokerAddress(this.c.getSelfAddress(), gPacket);
        }
        if (this.brokers != null) {
            stringBuffer = new StringBuffer();
            for (n = 0; n < this.brokers.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.brokers[n].toProtocolString());
            }
            gPacket.putProp("brokers", stringBuffer.toString());
        }
        if (this.waitfor != null) {
            stringBuffer = new StringBuffer();
            for (n = 0; n < this.waitfor.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.waitfor[n].toProtocolString());
            }
            gPacket.putProp("waitfor", stringBuffer.toString());
        }
        if (this.txnHome != null) {
            gPacket.putProp("transactionHome", this.txnHome.toProtocolString());
        }
        if (this.xid != null) {
            gPacket.putProp("X", this.xid);
        }
        gPacket.setBit(1, false);
        return gPacket;
    }

    public boolean isOwner() {
        assert (this.pkt != null);
        Boolean bl = (Boolean)this.pkt.getProp("owner");
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public BrokerAddress getOwnerBrokerAddress() throws Exception {
        assert (this.pkt != null);
        if (!this.isOwner()) {
            return null;
        }
        return this.c.unmarshalBrokerAddress(this.pkt);
    }

    public int getTransactionState() {
        assert (this.pkt != null);
        return (Integer)this.pkt.getProp("transactionState");
    }

    public Long getTransactionID() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp("transactionID");
    }

    public BrokerAddress[] getWaitfor() throws Exception {
        assert (this.pkt != null);
        String string = (String)this.pkt.getProp("waitfor");
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        ArrayList<BrokerAddress> arrayList = new ArrayList<BrokerAddress>();
        String string2 = null;
        while (stringTokenizer.hasMoreElements()) {
            string2 = (String)stringTokenizer.nextElement();
            arrayList.add(Globals.getMyAddress().fromProtocolString(string2));
        }
        return arrayList.toArray(new BrokerAddress[0]);
    }

    public BrokerAddress[] getBrokers() throws Exception {
        assert (this.pkt != null);
        String string = (String)this.pkt.getProp("brokers");
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        ArrayList<BrokerAddress> arrayList = new ArrayList<BrokerAddress>();
        String string2 = null;
        while (stringTokenizer.hasMoreElements()) {
            string2 = (String)stringTokenizer.nextElement();
            arrayList.add(Globals.getMyAddress().fromProtocolString(string2));
        }
        return arrayList.toArray(new BrokerAddress[0]);
    }

    public BrokerAddress getTransactionHome() {
        assert (this.pkt != null);
        String string = (String)this.pkt.getProp("transactionHome");
        if (string == null) {
            return null;
        }
        try {
            return Globals.getMyAddress().fromProtocolString(string);
        }
        catch (Exception exception) {
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.log(16, "Unable to get transaction home broker address for TID=" + this.getTransactionID() + ":" + exception.getMessage());
            return null;
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer;
        BrokerAddress[] brokerAddressArray;
        if (this.pkt == null) {
            int n2;
            StringBuffer stringBuffer2;
            StringBuffer stringBuffer3 = new StringBuffer();
            stringBuffer3.append("\n\tTransactionID = ").append(this.transactionID);
            stringBuffer3.append("\n\tTransactionState = ").append(TransactionState.toString(this.transactionState));
            if (this.txnHome != null) {
                stringBuffer3.append("\n\tTransactionHome = ").append(this.txnHome);
            }
            if (this.brokers != null) {
                stringBuffer2 = new StringBuffer();
                for (n2 = 0; n2 < this.brokers.length; ++n2) {
                    if (n2 > 0) {
                        stringBuffer2.append(",");
                    }
                    stringBuffer2.append(this.brokers[n2].toProtocolString());
                }
                stringBuffer3.append("\n\tBrokers = ").append(stringBuffer2.toString());
            }
            if (this.waitfor != null) {
                stringBuffer2 = new StringBuffer();
                for (n2 = 0; n2 < this.waitfor.length; ++n2) {
                    if (n2 > 0) {
                        stringBuffer2.append(",");
                    }
                    stringBuffer2.append(this.waitfor[n2].toProtocolString());
                }
                stringBuffer3.append("\n\tWaitfor = ").append(stringBuffer2.toString());
            }
            if (this.xid != null) {
                stringBuffer3.append("\n\tXID = ").append(this.xid);
            }
            stringBuffer3.append("\n");
            return stringBuffer3.toString();
        }
        StringBuffer stringBuffer4 = new StringBuffer();
        stringBuffer4.append("\n\tTransactionID = ").append(this.getTransactionID());
        stringBuffer4.append("\n\tTransactionState = ").append(TransactionState.toString(this.getTransactionState()));
        try {
            brokerAddressArray = this.getTransactionHome();
            if (brokerAddressArray != null) {
                stringBuffer4.append("\n\tTransactionHome = ").append(brokerAddressArray);
            }
        }
        catch (Exception exception) {
            stringBuffer4.append("\n\tTransactionHome = ERROR:").append(exception.toString());
        }
        brokerAddressArray = null;
        try {
            brokerAddressArray = this.getBrokers();
            if (brokerAddressArray != null) {
                stringBuffer = new StringBuffer();
                for (n = 0; n < brokerAddressArray.length; ++n) {
                    if (n > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(brokerAddressArray[n].toProtocolString());
                }
                stringBuffer4.append("\n\tBrokers = ").append(stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            stringBuffer4.append("\n\tBrokers = ERROR:").append(exception.toString());
        }
        try {
            brokerAddressArray = this.getWaitfor();
            if (brokerAddressArray != null) {
                stringBuffer = new StringBuffer();
                for (n = 0; n < brokerAddressArray.length; ++n) {
                    if (n > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(brokerAddressArray[n].toProtocolString());
                }
                stringBuffer4.append("\n\tWaitfor = ").append(stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            stringBuffer4.append("\n\tWaitfor = ERROR:").append(exception.toString());
        }
        if (this.pkt.getProp("X") != null) {
            stringBuffer4.append("\n\tXID = ").append(this.pkt.getProp("X"));
        }
        stringBuffer4.append("\n");
        return stringBuffer4.toString();
    }
}

