/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionWork {
    List<TransactionWorkMessage> sentMessages = new ArrayList<TransactionWorkMessage>();
    List<TransactionWorkMessageAck> messageAcknowledgments;

    public void addMesage(TransactionWorkMessage transactionWorkMessage) {
        if (this.sentMessages == null) {
            this.sentMessages = new ArrayList<TransactionWorkMessage>();
        }
        this.sentMessages.add(transactionWorkMessage);
    }

    public void addMessageAcknowledgement(TransactionWorkMessageAck transactionWorkMessageAck) {
        if (this.messageAcknowledgments == null) {
            this.messageAcknowledgments = new ArrayList<TransactionWorkMessageAck>();
        }
        this.messageAcknowledgments.add(transactionWorkMessageAck);
    }

    public List<TransactionWorkMessage> getSentMessages() {
        return this.sentMessages;
    }

    public void setMessages(List<TransactionWorkMessage> list) {
        this.sentMessages = list;
    }

    public List<TransactionWorkMessageAck> getMessageAcknowledgments() {
        return this.messageAcknowledgments;
    }

    public void setMessageAcknowledgments(List<TransactionWorkMessageAck> list) {
        this.messageAcknowledgments = list;
    }

    public int numSentMessages() {
        if (this.sentMessages == null) {
            return 0;
        }
        return this.sentMessages.size();
    }

    public int numMessageAcknowledgments() {
        if (this.messageAcknowledgments == null) {
            return 0;
        }
        return this.messageAcknowledgments.size();
    }

    public void readWork(DataInputStream dataInputStream) throws IOException, BrokerException {
        Object object;
        Object object2;
        Object object3;
        int n;
        int n2 = dataInputStream.readInt();
        if (Store.getDEBUG()) {
            Globals.getLogger().log(4, this.getPrefix() + "readWork numSentMessages=" + n2);
        }
        ArrayList<TransactionWorkMessage> arrayList = new ArrayList<TransactionWorkMessage>(n2);
        for (n = 0; n < n2; ++n) {
            object3 = new Packet(false);
            ((Packet)object3).generateTimestamp(false);
            ((Packet)object3).generateSequenceNumber(false);
            ((Packet)object3).readPacket(dataInputStream);
            Destination destination = Destination.getDestination(((Packet)object3).getDestination(), ((Packet)object3).getIsQueue() ? 1 : 2, true, true);
            object2 = destination.getDestinationUID();
            object = new TransactionWorkMessage((DestinationUID)object2, (Packet)object3);
            arrayList.add((TransactionWorkMessage)object);
        }
        this.setMessages(arrayList);
        n = dataInputStream.readInt();
        object3 = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            object2 = dataInputStream.readUTF();
            object = new SysMessageID();
            ((SysMessageID)object).readID(dataInputStream);
            long l = dataInputStream.readLong();
            ConsumerUID consumerUID = new ConsumerUID(l);
            TransactionWorkMessageAck transactionWorkMessageAck = new TransactionWorkMessageAck((String)object2, (SysMessageID)object, consumerUID);
            object3.add(transactionWorkMessageAck);
        }
        this.setMessageAcknowledgments((List<TransactionWorkMessageAck>)object3);
    }

    public void writeWork(DataOutputStream dataOutputStream) throws IOException {
        Object object;
        dataOutputStream.writeInt(this.numSentMessages());
        if (Store.getDEBUG()) {
            Globals.getLogger().log(4, this.getPrefix() + "writeWork numSentMessages=" + this.numSentMessages());
        }
        if (this.numSentMessages() > 0) {
            for (TransactionWorkMessage object2 : this.getSentMessages()) {
                object = object2.getMessage().getBytes();
                if (Store.getDEBUG()) {
                    Globals.getLogger().log(4, this.getPrefix() + "writeWork write packet data len = =" + ((Object)object).length);
                }
                dataOutputStream.write((byte[])object);
            }
        }
        dataOutputStream.writeInt(this.numMessageAcknowledgments());
        if (this.numMessageAcknowledgments() > 0) {
            for (TransactionWorkMessageAck transactionWorkMessageAck : this.getMessageAcknowledgments()) {
                dataOutputStream.writeUTF(transactionWorkMessageAck.getDest());
                object = transactionWorkMessageAck.getSysMessageID();
                ((SysMessageID)object).writeID(dataOutputStream);
                ConsumerUID consumerUID = transactionWorkMessageAck.getConsumerID();
                dataOutputStream.writeLong(consumerUID.longValue());
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" num messages ").append(this.numSentMessages());
        stringBuffer.append(" num acks ").append(this.numMessageAcknowledgments());
        String string = super.toString() + new String(stringBuffer);
        return string;
    }

    String getPrefix() {
        return "TransactionWork: " + Thread.currentThread().getName();
    }
}

