/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.util;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.util.HashMap;
import java.util.Hashtable;

public class SelectorFilter
implements Filter {
    private static boolean DEBUG = false;
    Selector selector = null;
    String selectorstr = null;

    public SelectorFilter(String string) throws SelectorFormatException {
        this.selectorstr = string;
        this.selector = Selector.compile(string);
    }

    public SelectorFilter(String string, Selector selector) {
        this.selectorstr = string;
        this.selector = selector;
    }

    public synchronized boolean matches(Object object) {
        if (this.selector == null) {
            return false;
        }
        if (object instanceof PacketReference) {
            PacketReference packetReference = (PacketReference)object;
            Hashtable hashtable = null;
            HashMap hashMap = null;
            try {
                if (this.selector.usesProperties()) {
                    hashtable = packetReference.getProperties();
                }
                if (this.selector.usesFields()) {
                    hashMap = packetReference.getHeaders();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                assert (false) : packetReference;
                throw new RuntimeException("error with properties", classNotFoundException);
            }
            try {
                boolean bl = this.selector.match(hashtable, hashMap);
                if (DEBUG && bl) {
                    Globals.getLogger().log(4, "Match " + object + "against " + this.selector + " got " + bl);
                }
                return bl;
            }
            catch (SelectorFormatException selectorFormatException) {
                Globals.getLogger().log(8, "Bad selector format, can not match against  " + this.selector, selectorFormatException);
                return false;
            }
        }
        assert (false) : " weird ";
        return false;
    }

    public String toString() {
        return "SelectorFilter[" + this.selector + "]" + this.hashCode();
    }
}

