/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.heartbeat;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterListener;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.heartbeat.HeartbeatInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.heartbeat.spi.Heartbeat;
import com.sun.messaging.jmq.jmsserver.multibroker.heartbeat.spi.HeartbeatCallback;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.MQThreadGroup;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class HeartbeatService
implements HeartbeatCallback,
ClusterListener,
ConfigListener {
    private static boolean DEBUG = false;
    public static final String SERVICE_NAME = "heartbeat";
    public static final String SERVICE_TYPE = "HEARTBEAT";
    public static final short HEARTBEAT_ALIVE = 0;
    public static final int HEARTBEAT_PROTOCOL_VERSION = 400;
    public static final String HEARTBEAT_CLASS_PROP = "imq.cluster.heartbeat.class";
    public static final String HEARTBEAT_HOST_PROP = "imq.cluster.heartbeat.hostname";
    public static final String HEARTBEAT_PORT_PROP = "imq.cluster.heartbeat.port";
    public static final String HEARTBEAT_INTERVAL_PROP = "imq.cluster.heartbeat.interval";
    public static final String HEARTBEAT_THRESHOLD_PROP = "imq.cluster.heartbeat.threshold";
    private static final int HEARTBEAT_INTERVAL_DEFAULT = 2;
    private static final int HEARTBEAT_THRESHOLD_DEFAULT = 3;
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private ClusterManager clsmgr = null;
    private Heartbeat hb = null;
    private Map brokers = Collections.synchronizedMap(new LinkedHashMap());
    private TimeoutTimer timeoutTimer = null;
    private FaultInjection fi = FaultInjection.getInjection();
    private static final int MAX_PORTMAPPER_CONNECT_RETRY = 3;

    public HeartbeatService() throws Exception {
        this.clsmgr = Globals.getClusterManager();
        if (this.clsmgr == null) {
            throw new BrokerException("No cluster manager");
        }
        if (!this.clsmgr.isHA()) {
            throw new BrokerException("Non HA cluster");
        }
        this.initHeartbeat();
        this.clsmgr.addEventListener(this);
    }

    private void initHeartbeat() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnknownHostException, IOException {
        String string = Globals.getConfig().getProperty(HEARTBEAT_CLASS_PROP);
        Class<?> clazz = Class.forName(string);
        this.hb = (Heartbeat)clazz.newInstance();
        this.hb.setHeartbeatInterval(Globals.getConfig().getIntProperty(HEARTBEAT_INTERVAL_PROP, 2));
        this.hb.setTimeoutThreshold(Globals.getConfig().getIntProperty(HEARTBEAT_THRESHOLD_PROP, 3));
        int n = Globals.getConfig().getIntProperty(HEARTBEAT_PORT_PROP, this.clsmgr.getMQAddress().getPort());
        String string2 = Globals.getConfig().getProperty(HEARTBEAT_HOST_PROP);
        if (string2 == null) {
            string2 = Globals.getBrokerHostName();
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getByName(string2), n);
        this.hb.init(inetSocketAddress, this);
        this.timeoutTimer = new TimeoutTimer();
        this.timeoutTimer.setPriority(10);
        this.timeoutTimer.setDaemon(true);
        this.timeoutTimer.start();
        Object[] objectArray = new Object[]{SERVICE_NAME + (this.hb.getName() == null ? "" : " [" + this.hb.getName() + "]"), this.hb.getProtocol() + " ( " + inetSocketAddress + " )", new Integer(1), new Integer(1)};
        this.logger.log(8, "B1004", objectArray);
    }

    public String getHeartbeatHostAddress() {
        return this.hb.getBindEndpoint().getAddress().getHostAddress();
    }

    public int getHeartbeatPort() {
        return this.hb.getBindEndpoint().getPort();
    }

    public int getHeartbeatInterval() {
        return this.hb.getHeartbeatInterval();
    }

    public void stopService() {
        try {
            this.hb.stop();
        }
        catch (IOException iOException) {
            this.logger.logStack(16, this.br.getKString("B2124"), iOException);
        }
        this.timeoutTimer.destroy();
        this.clsmgr.removeEventListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addBroker(HAClusteredBroker hAClusteredBroker, UID uID, BrokerInfo brokerInfo) {
        HeartbeatEntry heartbeatEntry2 = null;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        Object object = this.brokers;
        synchronized (object) {
            for (HeartbeatEntry heartbeatEntry2 : this.brokers.keySet()) {
                if (!hAClusteredBroker.getBrokerName().equals(heartbeatEntry2.brokerID)) continue;
                arrayList.add(new Long(heartbeatEntry2.sessionUID));
            }
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            this.removeBroker(hAClusteredBroker, new UID((Long)object.next()));
        }
        heartbeatEntry2 = new HeartbeatEntry();
        try {
            heartbeatEntry2.brokerID = hAClusteredBroker.getBrokerName();
            heartbeatEntry2.sessionUID = uID.longValue();
            heartbeatEntry2.endpoint = new InetSocketAddress(InetAddress.getByName(brokerInfo.getHeartbeatHostAddress()), brokerInfo.getHeartbeatPort());
            Object object2 = HeartbeatInfo.newInstance();
            HAClusteredBroker hAClusteredBroker2 = (HAClusteredBroker)this.clsmgr.getLocalBroker();
            ((HeartbeatInfo)object2).setBrokerID(hAClusteredBroker2.getBrokerName());
            ((HeartbeatInfo)object2).setBrokerSession(hAClusteredBroker2.getBrokerSessionUID().longValue());
            ((HeartbeatInfo)object2).setBrokerAddress((BrokerMQAddress)hAClusteredBroker2.getBrokerURL());
            ((HeartbeatInfo)object2).setToBrokerID(hAClusteredBroker.getBrokerName());
            ((HeartbeatInfo)object2).setToBrokerSession(uID.longValue());
            ((HeartbeatInfo)object2).setSequence(0L);
            heartbeatEntry2.gp = ((HeartbeatInfo)object2).getGPacket();
            object2 = HeartbeatInfo.newInstance();
            ((HeartbeatInfo)object2).setBrokerID(hAClusteredBroker.getBrokerName());
            ((HeartbeatInfo)object2).setBrokerSession(uID.longValue());
            ((HeartbeatInfo)object2).setBrokerAddress((BrokerMQAddress)hAClusteredBroker.getBrokerURL());
            ((HeartbeatInfo)object2).setToBrokerID(hAClusteredBroker2.getBrokerName());
            ((HeartbeatInfo)object2).setToBrokerSession(hAClusteredBroker2.getBrokerSessionUID().longValue());
            heartbeatEntry2.dataLength = HeartbeatInfo.toByteArray(((HeartbeatInfo)object2).getGPacket()).length;
            heartbeatEntry2.heartbeatInterval = brokerInfo.getHeartbeatInterval();
            heartbeatEntry2.lastTimestamp = System.currentTimeMillis();
            heartbeatEntry2.lastSequence = 0L;
            this.brokers.put(heartbeatEntry2, heartbeatEntry2);
            this.hb.addEndpoint(heartbeatEntry2, heartbeatEntry2.endpoint, heartbeatEntry2.dataLength + 500);
            this.logger.log(8, this.br.getKString("B1181", heartbeatEntry2));
        }
        catch (Exception exception) {
            this.logger.logStack(32, this.br.getKString("B3193", heartbeatEntry2), exception);
        }
    }

    private synchronized void removeBroker(HAClusteredBroker hAClusteredBroker, UID uID) {
        HeartbeatEntry heartbeatEntry = new HeartbeatEntry();
        try {
            heartbeatEntry.brokerID = hAClusteredBroker.getBrokerName();
            heartbeatEntry.sessionUID = uID.longValue();
            HeartbeatEntry heartbeatEntry2 = (HeartbeatEntry)this.brokers.remove(heartbeatEntry);
            if (heartbeatEntry2 == null) {
                this.logger.log(16, this.br.getKString("B2121", heartbeatEntry));
                return;
            }
            this.hb.removeEndpoint(heartbeatEntry2, heartbeatEntry2.endpoint);
            this.logger.log(8, this.br.getKString("B1182", heartbeatEntry2));
        }
        catch (Exception exception) {
            this.logger.logStack(32, this.br.getKString("B3194", heartbeatEntry), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsuspect(HAClusteredBroker hAClusteredBroker, UID uID) {
        HeartbeatEntry heartbeatEntry = new HeartbeatEntry();
        heartbeatEntry.brokerID = hAClusteredBroker.getBrokerName();
        heartbeatEntry.sessionUID = uID.longValue();
        HeartbeatEntry heartbeatEntry2 = (HeartbeatEntry)this.brokers.get(heartbeatEntry);
        if (heartbeatEntry2 == null) {
            if (DEBUG) {
                this.logger.log(8, "Unsuspect " + heartbeatEntry + " not exist");
            }
            return;
        }
        HeartbeatEntry heartbeatEntry3 = heartbeatEntry2;
        synchronized (heartbeatEntry3) {
            heartbeatEntry2.lastTimestamp = System.currentTimeMillis();
            heartbeatEntry2.lastSequence = 0L;
        }
        this.logger.log(8, this.br.getKString("B1184", heartbeatEntry2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void heartbeatReceived(InetSocketAddress inetSocketAddress, byte[] byArray) throws IOException {
        if (byArray == null) {
            if (DEBUG) {
                this.logger.log(8, "HEARTBEAT: Ignore null data from " + inetSocketAddress);
            }
            throw new IOException("No data");
        }
        HeartbeatInfo heartbeatInfo = null;
        HeartbeatEntry heartbeatEntry = new HeartbeatEntry();
        try {
            heartbeatInfo = HeartbeatInfo.newInstance(byArray);
        }
        catch (Exception exception) {
            if (DEBUG) {
                this.logger.logStack(8, "HEARTBEAT: Ignore data from " + inetSocketAddress + " because " + exception.getMessage(), exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception.getMessage());
        }
        heartbeatEntry.brokerID = heartbeatInfo.getBrokerID();
        heartbeatEntry.sessionUID = heartbeatInfo.getBrokerSession();
        heartbeatEntry.lastSequence = heartbeatInfo.getSequence();
        HeartbeatEntry heartbeatEntry2 = (HeartbeatEntry)this.brokers.get(heartbeatEntry);
        if (heartbeatEntry2 == null) {
            if (DEBUG) {
                this.logger.log(8, "HEARTBEAT: Ignore heartbeat from " + inetSocketAddress + " " + heartbeatEntry.toStringKS());
            }
            throw new IOException("Ignore heartbeat because of not found " + heartbeatEntry.toStringK());
        }
        HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)this.clsmgr.getLocalBroker();
        if (!heartbeatInfo.getToBrokerID().equals(hAClusteredBroker.getBrokerName()) || heartbeatInfo.getToBrokerSession() != hAClusteredBroker.getBrokerSessionUID().longValue()) {
            if (DEBUG) {
                this.logger.log(8, "HEARTBEAT: Ignore heartbeat not for me. " + heartbeatInfo);
            }
            throw new IOException("Ignore heartbeat not for me. " + heartbeatInfo);
        }
        boolean bl = false;
        Object object = heartbeatEntry2;
        synchronized (object) {
            bl = heartbeatEntry.lastSequence > heartbeatEntry2.lastSequence;
        }
        if (!bl) {
            if (DEBUG) {
                this.logger.log(8, "HEARTBEAT: Ignore duplicate or out-of-order heartbeat " + heartbeatEntry.toStringKS() + "[" + heartbeatEntry2 + "] from " + inetSocketAddress);
            }
            throw new IOException("Ignore duplicate or out-of-order heartbeat " + heartbeatEntry.toStringKS());
        }
        if (DEBUG) {
            this.logger.log(8, "HEARTBEAT: Received heartbeat #" + heartbeatEntry.lastSequence + " from " + heartbeatEntry2);
        }
        if (this.fi.FAULT_INJECTION) {
            object = new HashMap();
            ((HashMap)object).put("mqBrokerID", heartbeatInfo.getBrokerID());
            if (this.fi.checkFault("hb.recv", null) || this.fi.checkFault("hb.recv.brokerid", (Map)object)) {
                this.logger.log(8, "DISCARD heartbeat from " + heartbeatEntry2 + " because of FAULT");
                return;
            }
        }
        object = heartbeatEntry2;
        synchronized (object) {
            heartbeatEntry2.lastTimestamp = System.currentTimeMillis();
            heartbeatEntry2.lastSequence = heartbeatInfo.getSequence();
        }
        heartbeatEntry2.sender = inetSocketAddress;
    }

    public byte[] getBytesToSend(Object object, InetSocketAddress inetSocketAddress) throws IOException {
        HeartbeatEntry heartbeatEntry = (HeartbeatEntry)object;
        assert (heartbeatEntry.endpoint.equals(inetSocketAddress));
        if (this.fi.FAULT_INJECTION) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("mqBrokerID", heartbeatEntry.brokerID);
            if (this.fi.checkFault("hb.send", null) || this.fi.checkFault("hb.send.brokerid", hashMap)) {
                this.logger.log(8, "NOT SEND heartbeat to " + heartbeatEntry + " because of FAULT");
                return null;
            }
        }
        heartbeatEntry.gp.setSequence(heartbeatEntry.gp.getSequence() + 1L);
        return HeartbeatInfo.toByteArray(heartbeatEntry.gp);
    }

    public void heartbeatIOException(Object object, InetSocketAddress inetSocketAddress, IOException iOException) {
        this.heartbeatTimeout(object, inetSocketAddress, iOException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void heartbeatTimeout(Object object, InetSocketAddress inetSocketAddress, IOException iOException) {
        HeartbeatEntry heartbeatEntry = (HeartbeatEntry)object;
        assert (inetSocketAddress.equals(heartbeatEntry.endpoint));
        HeartbeatEntry heartbeatEntry2 = (HeartbeatEntry)this.brokers.get(heartbeatEntry);
        if (heartbeatEntry2 == null) {
            if (DEBUG) {
                this.logger.logStack(8, "HEARTBEAT: NotFound: Heart beat timeout because " + (iOException == null ? "" : iOException.getMessage()) + ": " + heartbeatEntry + ". Ignore.", iOException);
            }
            return;
        }
        long l = 0L;
        int n = 0;
        HeartbeatEntry heartbeatEntry3 = heartbeatEntry2;
        synchronized (heartbeatEntry3) {
            l = heartbeatEntry2.indoubtTimestamp;
            n = heartbeatEntry2.heartbeatInterval;
        }
        long l2 = n * this.hb.getTimeoutThreshold() * 1000;
        if (l < System.currentTimeMillis() - l2) {
            if (DEBUG) {
                this.logger.logStack(8, "Heart beat timeout because " + (iOException == null ? "" : iOException.getMessage()) + ": " + heartbeatEntry2, iOException);
            } else {
                this.logger.log(16, this.br.getKString("B2122", heartbeatEntry2) + ": " + (iOException == null ? "" : iOException.getMessage()), iOException);
            }
            HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)this.clsmgr.getBroker(heartbeatEntry2.brokerID);
            hAClusteredBroker.setBrokerInDoubt(true, new UID(heartbeatEntry.sessionUID));
            HeartbeatEntry heartbeatEntry4 = heartbeatEntry2;
            synchronized (heartbeatEntry4) {
                heartbeatEntry2.indoubtTimestamp = System.currentTimeMillis();
            }
        }
    }

    public void clusterPropertyChanged(String string, String string2) {
    }

    public void brokerAdded(ClusteredBroker clusteredBroker, UID uID) {
    }

    public void brokerRemoved(ClusteredBroker clusteredBroker, UID uID) {
    }

    public void masterBrokerChanged(ClusteredBroker clusteredBroker, ClusteredBroker clusteredBroker2) {
    }

    public void brokerStatusChanged(String string, int n, int n2, UID uID, Object object) {
        HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)this.clsmgr.getBroker(string);
        if (hAClusteredBroker.isLocalBroker()) {
            return;
        }
        if ((BrokerStatus.getBrokerIsDown(n) || BrokerStatus.getBrokerLinkIsDown(n)) && BrokerStatus.getBrokerIsUp(n2) && BrokerStatus.getBrokerLinkIsUp(n2)) {
            this.logger.log(8, this.br.getKString("B1185", string));
            this.addBroker(hAClusteredBroker, uID, (BrokerInfo)object);
        }
        if (BrokerStatus.getBrokerInDoubt(n) && BrokerStatus.getBrokerNotInDoubt(n2)) {
            this.logger.log(8, this.br.getKString("B1183", string));
            this.unsuspect(hAClusteredBroker, uID);
        }
        if (BrokerStatus.getBrokerIsDown(n2)) {
            this.logger.log(8, this.br.getKString("B1186", string));
            this.removeBroker(hAClusteredBroker, uID);
        }
    }

    public void brokerStateChanged(String string, BrokerState brokerState, BrokerState brokerState2) {
        ClusteredBroker clusteredBroker = this.clsmgr.getBroker(string);
        if (clusteredBroker.isLocalBroker() && (brokerState2 == BrokerState.SHUTDOWN_COMPLETE || brokerState2 == BrokerState.SHUTDOWN_FAILOVER)) {
            this.stopService();
        }
    }

    public void brokerVersionChanged(String string, int n, int n2) {
    }

    public void brokerURLChanged(String string, MQAddress mQAddress, MQAddress mQAddress2) {
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
        if (string.equals(HEARTBEAT_HOST_PROP) || string.equals(HEARTBEAT_PORT_PROP)) {
            throw new PropertyUpdateException(this.br.getKString("B4248", string));
        }
        if (string.equals(HEARTBEAT_INTERVAL_PROP)) {
            throw new PropertyUpdateException(this.br.getKString("B4248", string));
        }
        if (string.equals(HEARTBEAT_THRESHOLD_PROP)) {
            // empty if block
        }
    }

    public boolean update(String string, String string2) {
        return true;
    }

    class HeartbeatEntry {
        String brokerID = null;
        long sessionUID = 0L;
        InetSocketAddress endpoint = null;
        InetSocketAddress sender = null;
        int heartbeatInterval = 0;
        long lastTimestamp = 0L;
        long lastSequence = 0L;
        int dataLength = 0;
        long indoubtTimestamp = 0L;
        GPacket gp = null;

        HeartbeatEntry() {
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof HeartbeatEntry)) {
                return false;
            }
            HeartbeatEntry heartbeatEntry = (HeartbeatEntry)object;
            return this.brokerID.equals(heartbeatEntry.brokerID) && this.sessionUID == heartbeatEntry.sessionUID;
        }

        public int hashCode() {
            return this.brokerID.hashCode() + String.valueOf(this.sessionUID).hashCode();
        }

        public String toString() {
            return (this.endpoint == null ? "" : this.endpoint.toString()) + " [brokerID=" + this.brokerID + ", brokerSession=" + String.valueOf(this.sessionUID) + "] (seq#=" + this.lastSequence + ", ts=" + this.lastTimestamp + ", interval=" + this.heartbeatInterval + ", len=" + this.dataLength + ")" + (this.sender == null ? "" : " sender=" + this.sender.toString());
        }

        public String toStringKS() {
            return "#" + this.lastSequence + " [brokerID=" + this.brokerID + ", brokerSession=" + String.valueOf(this.sessionUID) + "]";
        }

        public String toStringK() {
            return "[brokerID=" + this.brokerID + ", brokerSession=" + String.valueOf(this.sessionUID) + "]";
        }
    }

    class TimeoutTimer
    extends Thread {
        private Object lock;
        private boolean stopped;

        public TimeoutTimer() {
            super((ThreadGroup)new MQThreadGroup("HeartbeatService"), "Heartbeat Timeout Timer");
            this.lock = new Object();
            this.stopped = false;
            this.setPriority(10);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HeartbeatEntry[] heartbeatEntryArray = null;
            HeartbeatEntry heartbeatEntry = null;
            HeartbeatEntry heartbeatEntry2 = null;
            while (!this.stopped) {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.stopped) {
                            break;
                        }
                        try {
                            this.lock.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.stopped) {
                            break;
                        }
                        Set set = HeartbeatService.this.brokers.keySet();
                        heartbeatEntryArray = set.toArray(new HeartbeatEntry[0]);
                    }
                    if (DEBUG) {
                        Logger logger = HeartbeatService.this.logger;
                        HeartbeatService.this.logger;
                        logger.log(1, this.getName() + " checking " + heartbeatEntryArray.length + " endpoints");
                    }
                    for (int i = 0; i < heartbeatEntryArray.length; ++i) {
                        heartbeatEntry = heartbeatEntryArray[i];
                        long l = heartbeatEntry.heartbeatInterval * HeartbeatService.this.hb.getTimeoutThreshold() * 1000;
                        if (heartbeatEntry.lastTimestamp >= System.currentTimeMillis() - l || heartbeatEntry.indoubtTimestamp >= System.currentTimeMillis() - l) continue;
                        Logger logger = HeartbeatService.this.logger;
                        HeartbeatService.this.logger;
                        BrokerResources brokerResources = HeartbeatService.this.br;
                        HeartbeatService.this.br;
                        logger.log(16, brokerResources.getKString("B2122", heartbeatEntry));
                        ClusteredBroker clusteredBroker = HeartbeatService.this.clsmgr.getBroker(heartbeatEntry.brokerID);
                        clusteredBroker.setBrokerInDoubt(true, new UID(heartbeatEntry.sessionUID));
                        heartbeatEntry2 = (HeartbeatEntry)HeartbeatService.this.brokers.get(heartbeatEntry);
                        if (heartbeatEntry2 == null) continue;
                        heartbeatEntry2.indoubtTimestamp = System.currentTimeMillis();
                    }
                }
                catch (Throwable throwable) {
                    Logger logger = HeartbeatService.this.logger;
                    HeartbeatService.this.logger;
                    logger.logStack(16, this.getName() + ": " + throwable.getMessage(), throwable);
                }
            }
            if (!this.stopped) {
                Logger logger = HeartbeatService.this.logger;
                HeartbeatService.this.logger;
                BrokerResources brokerResources = HeartbeatService.this.br;
                HeartbeatService.this.br;
                logger.log(16, brokerResources.getKString("B0074", this.getName()));
            } else if (DEBUG) {
                Logger logger = HeartbeatService.this.logger;
                HeartbeatService.this.logger;
                BrokerResources brokerResources = HeartbeatService.this.br;
                HeartbeatService.this.br;
                logger.log(8, brokerResources.getKString("B0074", this.getName()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            Object object = this.lock;
            synchronized (object) {
                this.stopped = true;
                this.lock.notify();
            }
        }
    }
}

