/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.migration;

import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Hashtable;

public class TransactionState
implements Serializable {
    static final long serialVersionUID = -6848527428749630176L;
    public static final int CREATED = 0;
    public static final int STARTED = 1;
    public static final int FAILED = 2;
    public static final int INCOMPLETE = 3;
    public static final int COMPLETE = 4;
    public static final int PREPARED = 5;
    public static final int COMMITTED = 6;
    public static final int ROLLEDBACK = 7;
    public static final int LAST = 7;
    private static final String[] names = new String[]{"CREATED", "STARTED", "FAILED", "INCOMPLETE", "COMPLETE", "PREPARED", "COMMITED", "ROLLEDBACK"};
    private JMQXid xid = null;
    private int state = 0;
    private String user = null;
    private String clientID = null;
    private String connectionString = null;

    public TransactionState() {
        this.state = 0;
    }

    public TransactionState(TransactionState transactionState) {
        this.xid = new JMQXid(transactionState.xid);
        this.state = transactionState.state;
        this.user = transactionState.user;
        this.clientID = transactionState.clientID;
        this.connectionString = transactionState.connectionString;
    }

    public Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("xid", this.xid == null ? "none" : this.xid.toString());
        hashtable.put("state", names[this.state]);
        hashtable.put("user", this.user == null ? "none" : this.user);
        hashtable.put("connectionString", this.connectionString == null ? "none" : this.connectionString);
        hashtable.put("clientID", this.clientID == null ? "none" : this.clientID);
        return hashtable;
    }

    public void setState(int n) throws BrokerException {
        if (n < 0 || n > 7) {
            throw new BrokerException("Illegal state " + n + ". Should be between " + 0 + " and " + 7 + " inclusive.");
        }
        this.state = n;
    }

    public int getState() {
        return this.state;
    }

    public void setXid(JMQXid jMQXid) {
        this.xid = jMQXid;
    }

    public JMQXid getXid() {
        return this.xid;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setClientID(String string) {
        this.clientID = string;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setConnectionString(String string) {
        this.connectionString = string;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public int nextState(int n, Integer n2) throws BrokerException {
        switch (n) {
            case 44: {
                if (!(TransactionState.isFlagSet(0, n2) ? this.state == 0 || this.state == 4 || this.state == 1 : (TransactionState.isFlagSet(0x200000, n2) ? this.state == 1 || this.state == 4 : TransactionState.isFlagSet(0x8000000, n2) && (this.state == 3 || this.state == 1)))) break;
                return 1;
            }
            case 58: {
                if (TransactionState.isFlagSet(0x2000000, n2)) {
                    if (this.state != 1 && this.state != 3) break;
                    return 3;
                }
                if (TransactionState.isFlagSet(0x20000000, n2)) {
                    if (this.state != 1 && this.state != 3 && this.state != 2) break;
                    return 2;
                }
                if (!TransactionState.isFlagSet(0x4000000, n2) && !TransactionState.isFlagSet(0x40000000, n2) || this.state != 1 && this.state != 3 && this.state != 4) break;
                return 4;
            }
            case 56: {
                if (this.state != 4 && this.state != 5) break;
                return 5;
            }
            case 46: {
                if (!(TransactionState.isFlagSet(0x40000000, n2) ? this.state == 4 || this.state == 6 : this.state == 5 || this.state == 6)) break;
                return 6;
            }
            case 48: {
                if (this.state == 4 || this.state == 3) {
                    return 7;
                }
                if (this.state == 5) {
                    return 7;
                }
                if (this.state != 2 && this.state != 7) break;
                return 7;
            }
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = PacketType.getString(n);
        objectArray[1] = TransactionState.xaFlagToString(n2);
        objectArray[2] = TransactionState.toString(this.state);
        Object[] objectArray2 = objectArray;
        throw new BrokerException(Globals.getBrokerResources().getString("B4132", objectArray2));
    }

    public static boolean isFlagSet(int n, Integer n2) {
        if (n2 == null) {
            return n == 0;
        }
        if (n == 0 || n2 == 0) {
            return n == n2;
        }
        return (n2 & n) == n;
    }

    public static String toString(int n) {
        if (n < 0 || n > 7) {
            return "UNKNOWN(" + n + ")";
        }
        return names[n] + "(" + n + ")";
    }

    public static String xaFlagToString(Integer n) {
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = false;
        if (n == null) {
            return "null";
        }
        stringBuffer.append("0x" + Integer.toHexString(n) + ":");
        if (TransactionState.isFlagSet(0, n)) {
            stringBuffer.append("TMNOFLAGS");
            return stringBuffer.toString();
        }
        if (TransactionState.isFlagSet(0x800000, n)) {
            stringBuffer.append("TMENDRSCAN");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x20000000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMFAIL");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x200000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMJOIN");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x40000000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMONEPHASE");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x8000000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMRESUME");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x1000000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMSTARTSCAN");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x4000000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMSUCCESS");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x2000000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMSUSPEND");
            bl = true;
        }
        if (!bl) {
            stringBuffer.append("???");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        if (this.xid == null) {
            return this.user + "@" + this.clientID + ":" + TransactionState.toString(this.state);
        }
        return this.user + "@" + this.clientID + ":" + TransactionState.toString(this.state) + ":xid=" + this.xid.toString();
    }

    public Object readResolve() throws ObjectStreamException {
        try {
            com.sun.messaging.jmq.jmsserver.data.TransactionState transactionState = new com.sun.messaging.jmq.jmsserver.data.TransactionState(AutoRollbackType.NOT_PREPARED, 0L, true);
            transactionState.setXid(this.xid);
            transactionState.setState(this.state);
            transactionState.setUser(this.user);
            transactionState.setClientID(this.clientID);
            transactionState.setConnectionString(this.connectionString);
            return transactionState;
        }
        catch (BrokerException brokerException) {
            brokerException.printStackTrace();
            return null;
        }
    }
}

