/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.xml;

import java.util.Arrays;
import java.util.List;

public class JMSBridgeXMLConstant {
    private static List<String> _reservedNames = Arrays.asList("built-in-dmq", "imq.bridge.jms.dmq", "AS_SOURCE");

    public static void checkReserved(String string) throws IllegalArgumentException {
        if (string == null) {
            return;
        }
        if (_reservedNames.contains(string.trim()) || _reservedNames.contains(string.trim().toUpperCase()) || _reservedNames.contains(string.trim().toLowerCase())) {
            throw new IllegalArgumentException(string + " is reserved");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Element {

        public static final String JMSBRIDGE = "jmsbridge";
        public static final String LINK = "link";
        public static final String SOURCE = "source";
        public static final String TARGET = "target";
        public static final String DMQ = "dmq";
        public static final String DESTINATION = "destination";
        public static final String CF = "connection-factory";
        public static final String PROPERTY = "property";
        public static final String DESCRIPTION = "description";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DMQ {

        public static final String CFREF = "connection-factory-ref";
        public static final String DESTINATIONREF = "destination-ref";
        public static final String TIMETOLIVE = "time-to-live-in-millis";
        public static final String STAYCONNECTED = "stay-connected";
        public static final String CLIENTID = "clientid";
        public static final String ENABLED = "enabled";
        public static final String MTFCLASS = "message-transformer-class";
        public static final String SENDATTEMPTS = "send-attempts";
        public static final String SENDATTEMPTINTERVAL = "send-attempt-interval-in-seconds";
        public static final String STAYCONNECTED_DEFAULT = "true";
        public static final String TIMETOLIVE_DEFAULT = "0";
        public static final String ENABLED_DEFAULT = "true";
        public static final String SENDATTEMPTS_DEFAULT = "3";
        public static final String SENDATTEMPTINTERVAL_DEFAULT = "5";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Destination {

        public static final String TYPE = "type";
        public static final String NAME = "name";
        public static final String LOOKUPNAME = "lookup-name";
        public static final String REFNAME = "ref-name";
        public static final String QUEUE = "queue";
        public static final String TOPIC = "topic";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Target {

        public static final String CFREF = "connection-factory-ref";
        public static final String DESTINATIONREF = "destination-ref";
        public static final String STAYCONNECTED = "stay-connected";
        public static final String RETAINREPLYTO = "retain-replyto";
        public static final String MTFCLASS = "message-transformer-class";
        public static final String CONSUMEONTRANSFORMERROR = "consume-no-transfer-on-transform-error";
        public static final String CLIENTID = "clientid";
        public static final String STAYCONNECTED_DEFAULT = "true";
        public static final String RETAINREPLYTO_DEFAULT = "false";
        public static final String CONSUMEONTRANSFORMERROR_DEFAULT = "false";
        public static final String DESTINATIONREF_AS_SOURCE = "AS_SOURCE";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Source {

        public static final String CFREF = "connection-factory-ref";
        public static final String DESTINATIONREF = "destination-ref";
        public static final String SELECTOR = "selector";
        public static final String DURABLESUB = "durable-sub";
        public static final String CLIENTID = "clientid";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Link {

        public static final String NAME = "name";
        public static final String ENABLED = "enabled";
        public static final String TRANSACTED = "transacted";
        public static final String ENABLED_DEFAULT = "true";
        public static final String TRANSACTED_DEFAULT = "true";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CF {

        public static final String CFREF = "connection-factory-ref";
        public static final String REFNAME = "ref-name";
        public static final String LOOKUPNAME = "lookup-name";
        public static final String MULTIRM = "multi-rm";
        public static final String CLIENTID = "clientid";
        public static final String CONNECTATTEMPTS = "connect-attempts";
        public static final String CONNECTATTEMPTINTERVAL = "connect-attempt-interval-in-seconds";
        public static final String IDLETIMEOUT = "idle-timeout-in-seconds";
        public static final String MULTIRM_DEFAULT = "false";
        public static final String CONNECTATTEMPTS_DEFAULT = "-1";
        public static final String CONNECTATTEMPTINTERVAL_DEFAULT = "5";
        public static final String IDLETIMEOUT_DEFAULT = "1800";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Common {

        public static final String NAME = "name";
        public static final String VALUE = "vaule";
        public static final String REFNAME = "ref-name";
    }
}

