/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;

public class SessionHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    public Session createSession(int n, String string, IMQConnection iMQConnection, boolean bl) throws BrokerException {
        Session session = null;
        if (bl) {
            session = Session.getSession(string);
        }
        if (session == null) {
            session = Session.createSession(iMQConnection.getConnectionUID(), string);
            session.setAckType(n);
            iMQConnection.attachSession(session);
        }
        return session;
    }

    public void closeSession(SessionUID sessionUID, IMQConnection iMQConnection, boolean bl) throws BrokerException {
        if (!bl || Session.getSession(sessionUID) != null) {
            assert (iMQConnection.getSession(sessionUID) != null);
            Session.closeSession(sessionUID);
            iMQConnection.closeSession(sessionUID);
        }
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Object object;
        int n = 200;
        String string = null;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        boolean bl = packet.getIndempotent();
        try {
            object = packet.getProperties();
            Session session = null;
            if (packet.getPacketType() == 68) {
                Integer n2 = object == null ? null : (Integer)((Hashtable)object).get("JMQAckMode");
                int n3 = n2 == null ? 0 : n2;
                session = this.createSession(n3, packet.getSysMessageID().toString(), iMQConnection, bl);
                hashtable.put("JMQSessionID", new Long(session.getSessionUID().longValue()));
            } else {
                assert (packet.getPacketType() == 70);
                Long l = (Long)((Hashtable)object).get("JMQSessionID");
                if (l == null) {
                    throw new BrokerException(Globals.getBrokerResources().getString("B4117", "protocol error, no session"));
                }
                SessionUID sessionUID = new SessionUID(l);
                this.closeSession(sessionUID, iMQConnection, bl);
            }
        }
        catch (Exception exception) {
            boolean bl2 = false;
            string = exception.getMessage();
            if (exception instanceof BrokerException) {
                n = ((BrokerException)exception).getStatusCode();
                bl2 = false;
            } else {
                n = 500;
                bl2 = true;
            }
            if (bl2) {
                this.logger.logStack(8, Globals.getBrokerResources().getString("B4117", " session "), exception);
            }
            this.logger.log(8, exception.getMessage());
        }
        hashtable.put("JMQStatus", new Integer(n));
        if (string != null) {
            hashtable.put("JMQReason", string);
        }
        if (packet.getSendAcknowledge()) {
            object = new Packet(iMQConnection.useDirectBuffers());
            ((Packet)object).setConsumerID(packet.getConsumerID());
            ((Packet)object).setPacketType(packet.getPacketType() + 1);
            ((Packet)object).setProperties(hashtable);
            iMQConnection.sendControlMessage((Packet)object);
        }
        return true;
    }
}

