/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.ToTxnLogConverter;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.persist.file.FromTxnLogConverter;
import com.sun.messaging.jmq.jmsserver.persist.file.TidList;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.jmsserver.persist.file.TxnAckList;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;

public class TxnConversionUtil {
    static String convertingToTxnLogMode = "convertingToTxnLogMode";
    static String convertingFromTxnLogMode = "convertingFromTxnLogMode";
    static boolean txnConversionRequired;
    public static final Logger logger;

    public static String getPrefix() {
        return "TxnConversionUtil.";
    }

    public static void resetAllTransactionState(File file) throws BrokerException {
        logger.log(8, TxnConversionUtil.getPrefix() + "resetAllTransactionState");
        TxnConversionUtil.deleteConversionFile(file, convertingToTxnLogMode);
        TxnConversionUtil.deleteConversionFile(file, convertingFromTxnLogMode);
        TransactionLogManager.deleteAllFileState(file);
        TidList.deleteAllFiles(file);
        TxnAckList.deleteAllFiles(file);
    }

    public static void checkForIncompleteTxnConversion(File file) throws BrokerException {
        logger.log(8, TxnConversionUtil.getPrefix() + "checkForIncompleteTxnConversion");
        File file2 = new File(convertingToTxnLogMode);
        File file3 = new File(convertingFromTxnLogMode);
        if (file2.exists()) {
            if (file3.exists()) {
                throw new BrokerException("Inconsistent state. Both " + file2 + " and " + file3 + " exist.");
            }
            TxnConversionUtil.resolveIncompleteConversionToTxnLog(file, file2);
        }
        if (file3.exists()) {
            TxnConversionUtil.resolveIncompleteConversionFromTxnLog(file, file3);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (TransactionLogManager.transactionLogExists(file)) {
            bl2 = true;
        }
        if (TidList.txFileExists(file)) {
            bl = true;
        }
        if (bl2 && bl) {
            throw new BrokerException("ack file and txnlog file both exist: transaction state exists in both txn-log and non-txn-log formats");
        }
        if (Globals.isNewTxnLogEnabled()) {
            if (bl) {
                TxnConversionUtil.setTxnConversionRequired(true);
            }
        } else if (bl2) {
            TxnConversionUtil.setTxnConversionRequired(true);
        }
    }

    public static boolean isTxnConversionRequired() {
        return txnConversionRequired;
    }

    public static void setTxnConversionRequired(boolean bl) {
        txnConversionRequired = bl;
    }

    static void resolveIncompleteConversionToTxnLog(File file, File file2) throws BrokerException {
        String string = "Found incomplete conversion of transactions to txnLog format on startup. Will redo or complete conversion";
        logger.log(16, string);
        if (TidList.txFileExists(file) && TidList.txAckFileExists(file)) {
            TransactionLogManager.deleteAllFileState(file);
            TxnConversionUtil.deleteConversionFile(file, convertingToTxnLogMode);
            return;
        }
        if (!TidList.txFileExists(file) || !TidList.txAckFileExists(file)) {
            TransactionLogManager.assertAllFilesExist(file);
            TidList.deleteAllFiles(file);
            TxnAckList.deleteAllFiles(file);
            TxnConversionUtil.deleteConversionFile(file, convertingToTxnLogMode);
            return;
        }
        TransactionLogManager.deleteAllFileState(file);
        TxnConversionUtil.deleteConversionFile(file, convertingToTxnLogMode);
    }

    static void resolveIncompleteConversionFromTxnLog(File file, File file2) throws BrokerException {
        String string = "Found incomplete conversion of transactions from txnLog format on startup. Will redo or complete conversion";
        logger.log(16, string);
        if (TransactionLogManager.transactionLogExists(file) && TransactionLogManager.incompleteTxnStoreExists(file)) {
            TidList.deleteAllFiles(file);
            TxnAckList.deleteAllFiles(file);
            TxnConversionUtil.deleteConversionFile(file, convertingFromTxnLogMode);
            return;
        }
        if (!TransactionLogManager.transactionLogExists(file) || !TransactionLogManager.incompleteTxnStoreExists(file)) {
            TidList.assertAllFilesExists(file);
            TransactionLogManager.deleteAllFileState(file);
            TxnConversionUtil.deleteConversionFile(file, convertingFromTxnLogMode);
            return;
        }
        TidList.deleteAllFiles(file);
        TxnAckList.deleteAllFiles(file);
        TxnConversionUtil.deleteConversionFile(file, convertingFromTxnLogMode);
    }

    public static void convertTxnFormats(FileStore fileStore, File file, TransactionList transactionList) throws BrokerException, IOException {
        if (Globals.isNewTxnLogEnabled()) {
            if (Store.getDEBUG()) {
                String string = "ConvertingTxnData :loading transactions from txn and txnack";
                logger.log(4, string);
            }
            TxnConversionUtil.createConversionFile(file, convertingToTxnLogMode);
            transactionList.loadTransactions();
            ToTxnLogConverter.convertToTxnLogFormat(transactionList, fileStore);
            fileStore.closeTidList();
            TidList.deleteAllFiles(file);
            TxnAckList.deleteAllFiles(file);
            TxnConversionUtil.deleteConversionFile(file, convertingToTxnLogMode);
        } else {
            TxnConversionUtil.createConversionFile(file, convertingFromTxnLogMode);
            FromTxnLogConverter fromTxnLogConverter = new FromTxnLogConverter(fileStore);
            fromTxnLogConverter.convertFromTxnLogFormat();
            transactionList.loadTransactions();
            fileStore.closeTxnLogManager();
            TransactionLogManager.deleteAllFileState(file);
            TxnConversionUtil.deleteConversionFile(file, convertingFromTxnLogMode);
        }
    }

    public static void createConversionFile(File file, String string) throws BrokerException {
        File file2 = new File(file, string);
        try {
            file2.createNewFile();
        }
        catch (IOException iOException) {
            throw new BrokerException("can not create transaction conversion file " + file2, iOException);
        }
    }

    public static void deleteConversionFile(File file, String string) throws BrokerException {
        boolean bl;
        File file2 = new File(file, string);
        if (file2.exists() && !(bl = file2.delete())) {
            throw new BrokerException("can not delete transaction conversion file " + file2);
        }
    }

    static {
        logger = Globals.getLogger();
    }
}

