/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.ActionManager;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

class ExplorerMouseAdapter
extends MouseAdapter {
    private ActionManager actionMgr;
    private JTree tree;

    public ExplorerMouseAdapter(ActionManager actionManager, JTree jTree) {
        this.tree = jTree;
        this.actionMgr = actionManager;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.doPopup(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.doPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.doPopup(mouseEvent);
    }

    private void doPopup(MouseEvent mouseEvent) {
        int n = this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        if (n != -1) {
            Object object = treePath.getLastPathComponent();
            String string = treePath.getLastPathComponent().toString();
            if (!(object instanceof ConsoleObj)) {
                return;
            }
            ConsoleObj consoleObj = (ConsoleObj)object;
            this.tree.addSelectionPath(treePath);
            JPopupMenu jPopupMenu = consoleObj.getExporerPopupMenu(this.actionMgr);
            if (jPopupMenu != null) {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

