/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth;

import com.sun.messaging.jmq.auth.api.server.AccessControlContext;
import com.sun.messaging.jmq.auth.api.server.AuthenticationProtocolHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.JMQAccessControlContext;
import com.sun.messaging.jmq.jmsserver.auth.JMQAdminKeyAuthenticationHandler;
import com.sun.messaging.jmq.jmsserver.auth.JMQBasicAuthenticationHandler;
import com.sun.messaging.jmq.jmsserver.auth.JMQDigestAuthenticationHandler;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.ServiceType;
import com.sun.messaging.jmq.util.log.Logger;
import java.security.AccessControlException;
import java.security.Policy;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Refreshable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class AccessController {
    public static final String PROP_SERVICE_NAME = "imq.servicename";
    public static final String PROP_SERVICE_TYPE = "imq.servicetype";
    public static final String PROP_AUTHENTICATION_AREA = "authentication";
    public static final String PROP_ACCESSCONTROL_AREA = "accesscontrol";
    public static final String PROP_USER_REPOSITORY_AREA = "user_repository";
    public static final String PROP_AUTHENTICATION_PREFIX = "imq.authentication.";
    public static final String PROP_ACCESSCONTROL_PREFIX = "imq.accesscontrol.";
    public static final String PROP_USER_REPOSITORY_PREFIX = "imq.user_repository.";
    public static final String PROP_USER_REPOSITORY_SUFFIX = ".user_repository";
    public static final String PROP_USER_PRINCIPAL_CLASS_SUFFIX = ".userPrincipalClass";
    public static final String PROP_GROUP_PRINCIPAL_CLASS_SUFFIX = ".groupPrincipalClass";
    public static final String PROP_CLIENTIP = "imq.authentication.clientip";
    public static final String PROP_AUTHENTICATION_TYPE = "imq.authentication.type";
    public static final String PROP_AUTHENTICATION_TYPE_SUFFIX = ".authentication.type";
    public static final String PROP_ACCESSCONTROL_TYPE = "imq.accesscontrol.type";
    public static final String PROP_ACCESSCONTROL_TYPE_SUFFIX = ".accesscontrol.type";
    public static final String PROP_ACCESSCONTROL_ENABLED = "imq.accesscontrol.enabled";
    public static final String PROP_ACCESSCONTROL_ENABLED_SUFFIX = ".accesscontrol.enabled";
    public static final String PROP_SERVICE_PREFIX = "imq.";
    public static final String PROP_ADMINKEY = "imq.adminkey";
    public static final String AUTHTYPE_BASIC = "basic";
    public static final String AUTHTYPE_DIGEST = "digest";
    public static final String AUTHTYPE_JMQADMINKEY = "jmqadminkey";
    public static final String BAD_AUTHTYPE = "client";
    private String authType = "basic";
    private String accesscontrolType = "";
    private String userRepository = "";
    private boolean accessControlEnabled = true;
    private Properties authprops = new Properties();
    private Logger logger = Globals.getLogger();
    private AuthenticationProtocolHandler aph = null;
    private AccessControlContext acc = null;
    private String serviceName = null;
    private int serviceType = 0;
    private String clientIP = null;

    private AccessController() {
    }

    private void init() throws BrokerException {
        this.acc = null;
        if (this.authType.equals(AUTHTYPE_BASIC)) {
            this.aph = new JMQBasicAuthenticationHandler();
            return;
        }
        if (this.authType.equals(AUTHTYPE_DIGEST)) {
            this.aph = new JMQDigestAuthenticationHandler();
            return;
        }
        if (this.authType.equals(AUTHTYPE_JMQADMINKEY)) {
            this.aph = new JMQAdminKeyAuthenticationHandler();
            return;
        }
        String string = this.authprops.getProperty(PROP_AUTHENTICATION_PREFIX + this.authType + ".class");
        if (string == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4077", this.authType));
        }
        try {
            this.aph = (AuthenticationProtocolHandler)Class.forName(string).newInstance();
            if (!this.aph.getType().equals(this.authType)) {
                Object[] objectArray = new String[]{this.authType, this.aph.getType(), string};
                throw new BrokerException(Globals.getBrokerResources().getKString("B4078", objectArray));
            }
        }
        catch (BrokerException brokerException) {
            throw brokerException;
        }
        catch (Throwable throwable) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4040", this.authType) + " - " + throwable.getMessage());
        }
    }

    public boolean isAuthenticated() {
        return this.acc != null;
    }

    public String getAuthType() {
        return this.authType;
    }

    private void setAuthType(String string) {
        this.authType = string;
    }

    private void setAccessControlType(String string) {
        this.accesscontrolType = string;
    }

    public String getAccessControlType() {
        return this.accesscontrolType;
    }

    public String getUserRepository() {
        return this.userRepository;
    }

    private void setUserRepository(String string) {
        this.userRepository = string;
    }

    public boolean isAccessControlEnabled() {
        return this.accessControlEnabled;
    }

    private void setAccessControlEnabled(boolean bl) {
        this.accessControlEnabled = bl;
    }

    public Properties getAuthProperties() {
        return this.authprops;
    }

    public AccessControlContext getAccessControlContext() {
        return this.acc;
    }

    private void setAccessControlContext(AccessControlContext accessControlContext) {
        this.acc = accessControlContext;
    }

    private void setServiceName(String string) {
        this.serviceName = string;
    }

    private String getServiceName() {
        return this.serviceName;
    }

    private void setServiceType(int n) {
        this.serviceType = n;
    }

    private int getServiceType() {
        return this.serviceType;
    }

    public void setClientIP(String string) {
        this.clientIP = string;
    }

    private String getClientIP() {
        return this.clientIP;
    }

    public boolean isRestrictedAdmin() {
        return this.authType.equals(AUTHTYPE_JMQADMINKEY);
    }

    public static AccessController getInstance(String string, int n) throws BrokerException {
        return AccessController.getInstance(string, n, false);
    }

    public static AccessController getInstance(String string, int n, boolean bl) throws BrokerException {
        AccessController accessController = new AccessController();
        accessController.setServiceName(string);
        accessController.setServiceType(n);
        String string2 = null;
        BrokerConfig brokerConfig = Globals.getConfig();
        string2 = brokerConfig.getProperty(PROP_ACCESSCONTROL_ENABLED);
        if (string2 != null && string2.equals("false")) {
            accessController.setAccessControlEnabled(false);
        }
        if ((string2 = brokerConfig.getProperty(PROP_SERVICE_PREFIX + string + PROP_ACCESSCONTROL_ENABLED_SUFFIX)) != null && !string2.trim().equals("")) {
            if (string2.equals("false")) {
                accessController.setAccessControlEnabled(false);
            } else {
                accessController.setAccessControlEnabled(true);
            }
        }
        accessController.getAuthProperties().setProperty(PROP_ACCESSCONTROL_ENABLED, accessController.isAccessControlEnabled() ? "true" : "false");
        string2 = brokerConfig.getProperty(PROP_SERVICE_PREFIX + string + PROP_AUTHENTICATION_TYPE_SUFFIX);
        if (string2 == null || string2.trim().equals("")) {
            string2 = brokerConfig.getProperty(PROP_AUTHENTICATION_TYPE);
        }
        if (string2 != null && !string2.trim().equals("")) {
            accessController.setAuthType(string2);
        }
        if (bl) {
            accessController.setAuthType(AUTHTYPE_BASIC);
        }
        if (accessController.getAuthType().equals(AUTHTYPE_JMQADMINKEY) || accessController.getAuthType().equals(BAD_AUTHTYPE)) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4040", accessController.getAuthType()));
        }
        accessController.getAuthProperties().setProperty(PROP_AUTHENTICATION_TYPE, accessController.getAuthType());
        AccessController.loadProps(accessController);
        return accessController;
    }

    private static void loadProps(AccessController accessController) throws BrokerException {
        BrokerConfig brokerConfig = Globals.getConfig();
        String string = accessController.getServiceName();
        accessController.getAuthProperties().setProperty(PROP_SERVICE_NAME, accessController.getServiceName());
        accessController.getAuthProperties().setProperty(PROP_SERVICE_TYPE, ServiceType.getServiceTypeString(accessController.getServiceType()));
        AccessController.getProps(accessController.getAuthProperties(), PROP_AUTHENTICATION_PREFIX, accessController.getAuthType(), null, null);
        AccessController.getProps(accessController.getAuthProperties(), PROP_AUTHENTICATION_PREFIX, accessController.getAuthType(), PROP_AUTHENTICATION_AREA, string);
        String string2 = brokerConfig.getProperty(PROP_SERVICE_PREFIX + string + PROP_ACCESSCONTROL_TYPE_SUFFIX);
        if (string2 == null || string2.trim().equals("")) {
            string2 = brokerConfig.getProperty(PROP_ACCESSCONTROL_TYPE);
        }
        if (string2 == null || string2.trim().equals("")) {
            if (accessController.isAccessControlEnabled()) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4044"));
            }
        } else {
            accessController.setAccessControlType(string2);
            accessController.getAuthProperties().setProperty(PROP_ACCESSCONTROL_TYPE, string2);
            AccessController.getProps(accessController.getAuthProperties(), PROP_ACCESSCONTROL_PREFIX, string2, null, null);
            AccessController.getProps(accessController.getAuthProperties(), PROP_ACCESSCONTROL_PREFIX, string2, PROP_ACCESSCONTROL_AREA, string);
        }
        if ((string2 = accessController.getAuthProperties().getProperty(PROP_AUTHENTICATION_PREFIX + accessController.getAuthType() + PROP_USER_REPOSITORY_SUFFIX)) != null && !string2.trim().equals("")) {
            accessController.setUserRepository(string2);
            AccessController.getProps(accessController.getAuthProperties(), PROP_USER_REPOSITORY_PREFIX, string2, null, null);
            AccessController.getProps(accessController.getAuthProperties(), PROP_USER_REPOSITORY_PREFIX, string2, PROP_USER_REPOSITORY_AREA, string);
        }
        accessController.init();
    }

    private static List getPropNames(String string, String string2) {
        return Globals.getConfig().getList(string + string2 + ".properties");
    }

    private static void getProps(Properties properties, String string, String string2, String string3, String string4) {
        List list;
        String string5 = string;
        if (string4 != null) {
            string5 = PROP_SERVICE_PREFIX + string4 + "." + string3 + ".";
        }
        if ((list = AccessController.getPropNames(string, string2)) == null) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string6 = (String)list.get(i);
            String string7 = Globals.getConfig().getProperty(string5 + string2 + "." + string6);
            if (string7 == null) continue;
            properties.setProperty(string + string2 + "." + string6, string7);
            properties.setProperty(string5 + string2 + "." + string6, string7);
        }
    }

    public synchronized byte[] getChallenge(int n, Properties properties, Refreshable refreshable, String string) throws BrokerException, LoginException {
        Object object;
        if (this.aph == null) {
            throw new LoginException(Globals.getBrokerResources().getKString("B4108"));
        }
        this.acc = null;
        if (string != null) {
            if (!string.equals(AUTHTYPE_JMQADMINKEY) || this.serviceType != 1) {
                Object[] objectArray = new String[]{string, this.serviceName, ServiceType.getServiceTypeString(this.serviceType)};
                throw new LoginException(Globals.getBrokerResources().getKString("B4101", objectArray));
            }
            object = Globals.getConfig().getProperty(PROP_ADMINKEY);
            if (object == null) {
                throw new LoginException(Globals.getBrokerResources().getKString("B4099"));
            }
            this.authprops = new Properties();
            this.setAuthType(AUTHTYPE_JMQADMINKEY);
            this.authprops.setProperty(PROP_AUTHENTICATION_TYPE, AUTHTYPE_JMQADMINKEY);
            this.setAccessControlEnabled(false);
            this.authprops.setProperty(PROP_ACCESSCONTROL_ENABLED, "false");
            this.authprops.setProperty(PROP_ADMINKEY, (String)object);
            AccessController.loadProps(this);
        }
        object = (Properties)this.getAuthProperties().clone();
        ((Properties)object).putAll((Map<?, ?>)properties);
        if (this.getClientIP() != null) {
            ((Properties)object).setProperty(PROP_CLIENTIP, this.getClientIP());
        }
        return this.aph.init(n, (Properties)object, refreshable);
    }

    public byte[] handleResponse(byte[] byArray, int n) throws LoginException {
        if (this.aph == null) {
            throw new LoginException(Globals.getBrokerResources().getKString("B4108"));
        }
        byte[] byArray2 = this.aph.handleResponse(byArray, n);
        if (byArray2 == null) {
            this.acc = this.aph.getAccessControlContext();
        }
        return byArray2;
    }

    public synchronized Refreshable getCacheData() {
        if (this.isAuthenticated() && this.aph != null) {
            return this.aph.getCacheData();
        }
        return null;
    }

    public synchronized void logout() {
        try {
            this.acc = null;
            if (this.aph != null) {
                this.aph.logout();
            }
        }
        catch (LoginException loginException) {
            this.logger.log(16, "Logout exception : " + loginException.getMessage(), loginException);
        }
    }

    public synchronized Subject getAuthenticatedSubject() throws BrokerException {
        if (this.isAuthenticated()) {
            return ((JMQAccessControlContext)this.acc).getSubject();
        }
        throw new BrokerException(Globals.getBrokerResources().getKString("B4043"));
    }

    public synchronized Principal getAuthenticatedName() throws BrokerException {
        if (this.isAuthenticated()) {
            return this.acc.getClientUser();
        }
        throw new BrokerException(Globals.getBrokerResources().getKString("B4043"));
    }

    public synchronized void checkConnectionPermission(String string, String string2) throws AccessControlException {
        if (!this.isAuthenticated()) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4043"));
        }
        if (!this.isAccessControlEnabled() && !string2.equals("ADMIN")) {
            return;
        }
        this.acc.checkConnectionPermission(string, string2);
    }

    public synchronized void checkDestinationPermission(String string, String string2, String string3, String string4, String string5) throws AccessControlException {
        if (!this.isAuthenticated()) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4043"));
        }
        if (!this.isAccessControlEnabled()) {
            return;
        }
        this.acc.checkDestinationPermission(string, string2, string3, string4, string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSecurityManagerIfneed() throws SecurityException, BrokerException {
        boolean bl = false;
        String string5 = null;
        String string2 = null;
        AccessController accessController = null;
        BrokerConfig brokerConfig = Globals.getConfig();
        Logger logger = Globals.getLogger();
        String string3 = null;
        String string4 = null;
        List list = ServiceManager.getAllActiveServiceNames();
        for (String string5 : list) {
            string2 = ServiceManager.getServiceTypeString(string5);
            if (string2 == null) {
                throw new BrokerException("Can't get service type for service " + string5);
            }
            accessController = AccessController.getInstance(string5, ServiceType.getServiceType(string2));
            if (!accessController.isAccessControlEnabled() || !accessController.getAccessControlType().equals("jaas")) continue;
            bl = true;
            string4 = accessController.getAuthProperties().getProperty("imq.accesscontrol.jaas.policyProvider");
            if (string3 == null) {
                string3 = string4;
                continue;
            }
            if (string4 == null || string3.equals(string4)) continue;
            throw new BrokerException("XI18N - Multiple Java policy providers is not allowed:" + string3 + ", " + string4);
        }
        if (!bl) {
            return;
        }
        Policy policy = null;
        if (string3 != null) {
            try {
                policy = (Policy)Class.forName(string3).newInstance();
            }
            catch (Exception exception) {
                throw new BrokerException(exception.getClass().getName() + ": " + exception.getMessage() + " - " + PROP_ACCESSCONTROL_PREFIX + "jaas.policyProvider" + "=" + string3);
            }
        }
        Class<System> clazz = System.class;
        synchronized (System.class) {
            if (System.getSecurityManager() == null) {
                String string6 = System.getProperty("java.security.policy");
                if (string6 != null) {
                    logger.log(8, "java.security.policy=" + string6);
                }
                System.setSecurityManager(new SecurityManager());
                logger.log(8, Globals.getBrokerResources().getKString("B1307"));
            }
            // ** MonitorExit[var11_12] (shouldn't be in output)
            if (policy != null) {
                logger.log(8, "imq.accesscontrol.jaas.policyProvider=" + string3);
                Policy.setPolicy(policy);
                logger.log(8, Globals.getBrokerResources().getKString("B1308", policy.getClass().getName()));
            }
            return;
        }
    }
}

