/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.WakeupableTimer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

class TransactionReaper
implements Runnable {
    TransactionList translist = null;
    Logger logger = Globals.getLogger();
    Vector committed = new Vector();
    Vector noremoves = new Vector();
    Map clusterPCommitted = Collections.synchronizedMap(new LinkedHashMap());
    Vector remoteCommitted = new Vector();
    Vector remoteRCommitted = new Vector();
    WakeupableTimer reapTimer = null;

    public TransactionReaper(TransactionList transactionList) {
        this.translist = transactionList;
    }

    public void addLocalTransaction(TransactionUID transactionUID, boolean bl) {
        if (bl) {
            this.noremoves.add(transactionUID);
        }
        this.committed.add(transactionUID);
        this.createTimer();
        if (this.committed.size() > TransactionList.TXN_REAPLIMIT) {
            this.reapTimer.wakeup();
        }
    }

    public void addClusterTransaction(TransactionUID transactionUID, boolean bl) {
        this.addClusterTransaction(transactionUID, bl, false);
    }

    public void addClusterTransaction(TransactionUID transactionUID, boolean bl, boolean bl2) {
        if (!bl2) {
            this.clusterPCommitted.put(transactionUID, ClusterPCommittedState.UNPROCCESSED);
        } else {
            this.clusterPCommitted.put(transactionUID, ClusterPCommittedState.TAKEOVER);
        }
        if (bl) {
            this.noremoves.add(transactionUID);
        }
        this.createTimer();
        this.reapTimer.wakeup();
    }

    public void addCompletedClusterTransaction(TransactionUID transactionUID) {
        this.committed.add(transactionUID);
        this.createTimer();
        if (this.committed.size() > TransactionList.TXN_REAPLIMIT) {
            this.reapTimer.wakeup();
        }
    }

    public void addRemoteTransaction(TransactionUID transactionUID, boolean bl) {
        if (!bl) {
            this.remoteCommitted.add(transactionUID);
        } else {
            this.remoteRCommitted.add(transactionUID);
        }
        this.createTimer();
        if (this.remoteCommitted.size() > TransactionList.TXN_REAPLIMIT || this.remoteRCommitted.size() > TransactionList.TXN_REAPLIMIT) {
            this.reapTimer.wakeup();
        }
    }

    public boolean hasRemoteTransaction(TransactionUID transactionUID) {
        if (this.remoteCommitted.contains(transactionUID)) {
            return true;
        }
        return this.remoteRCommitted.contains(transactionUID);
    }

    public synchronized void wakeupReaperTimer() {
        if (this.reapTimer != null) {
            this.reapTimer.wakeup();
        }
    }

    private synchronized void createTimer() {
        if (this.reapTimer == null) {
            try {
                String string = Globals.getBrokerResources().getKString("B1285", TransactionList.TXN_REAPLIMIT, TransactionList.TXN_REAPINTERVAL / 1000L);
                String string2 = Globals.getBrokerResources().getKString("B1286");
                this.reapTimer = new WakeupableTimer("TransactionReaper", this, TransactionList.TXN_REAPINTERVAL, TransactionList.TXN_REAPINTERVAL, string, string2, this.logger);
            }
            catch (Exception exception) {
                this.logger.log(16, "B3100", (Object)"Unable to start transaction reaper thread ", (Throwable)exception);
            }
        }
    }

    public synchronized void destroy() {
        if (this.reapTimer != null) {
            this.reapTimer.cancel();
            this.reapTimer = null;
        }
        this.committed.clear();
        this.remoteCommitted.clear();
        this.remoteRCommitted.clear();
    }

    public Hashtable getDebugState(TransactionUID transactionUID) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.committed.contains(transactionUID)) {
            hashtable.put(transactionUID.toString(), TransactionState.toString(6));
            return hashtable;
        }
        if (this.clusterPCommitted.get(transactionUID) != null) {
            hashtable.put(transactionUID.toString() + "(cluster)", TransactionState.toString(6));
            return hashtable;
        }
        if (this.remoteCommitted.contains(transactionUID)) {
            hashtable.put(transactionUID.toString() + "(remote)", TransactionState.toString(6));
            return hashtable;
        }
        if (this.remoteRCommitted.contains(transactionUID)) {
            hashtable.put(transactionUID.toString() + "(remote-r)", TransactionState.toString(6));
            return hashtable;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Serializable serializable2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("comittedCount", new Integer(this.committed.size()));
        for (Serializable serializable2 : this.committed) {
            hashtable.put(((TransactionUID)serializable2).toString(), TransactionState.toString(6));
        }
        serializable2 = null;
        Object object2 = this.clusterPCommitted;
        synchronized (object2) {
            serializable2 = new ArrayList(this.clusterPCommitted.keySet());
            Iterator iterator = serializable2.iterator();
            while (iterator.hasNext()) {
                TransactionUID transactionUID = (TransactionUID)iterator.next();
                hashtable.put(transactionUID.toString() + "(cluster)", TransactionState.toString(6));
            }
        }
        hashtable.put("noremovesCount", new Integer(this.noremoves.size()));
        for (Object object2 : this.noremoves) {
            hashtable.put(((TransactionUID)object2).toString(), TransactionState.toString(6));
        }
        for (Object object2 : this.remoteCommitted) {
            hashtable.put(((TransactionUID)object2).toString() + "(remote)", TransactionState.toString(6));
        }
        for (Object object2 : this.remoteRCommitted) {
            hashtable.put(((TransactionUID)object2).toString() + "(remote-r)", TransactionState.toString(6));
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void run() {
        void var3_13;
        void var3_11;
        if (!this.translist.isLoadComplete()) {
            try {
                this.logger.log(8, Globals.getBrokerResources().getString("B1327"));
                this.translist.loadCompleteLatch.await();
            }
            catch (InterruptedException interruptedException) {
                this.logger.log(16, "Transaction reaper thread is interrupted in waiting for transaction loading completion");
                return;
            }
        }
        ArrayList arrayList = null;
        TransactionUID[] transactionUIDArray = this.translist.newlyActivatedBrokers;
        synchronized (transactionUIDArray) {
            arrayList = new ArrayList(this.translist.newlyActivatedBrokers);
            this.translist.newlyActivatedBrokers.clear();
        }
        if (arrayList.size() > 0 || this.clusterPCommitted.containsValue((Object)ClusterPCommittedState.UNPROCCESSED) || this.clusterPCommitted.containsValue((Object)ClusterPCommittedState.TAKEOVER)) {
            transactionUIDArray = null;
            Map object2 = this.clusterPCommitted;
            synchronized (object2) {
                transactionUIDArray = new ArrayList(this.clusterPCommitted.keySet());
            }
            Object n = null;
            for (TransactionUID transactionUID : transactionUIDArray) {
                ClusterPCommittedState clusterPCommittedState = (ClusterPCommittedState)((Object)this.clusterPCommitted.get(transactionUID));
                if (clusterPCommittedState != null && clusterPCommittedState == ClusterPCommittedState.UNPROCCESSED) {
                    Globals.getConnectionManager().removeFromClientDataList("transaction", transactionUID);
                }
                try {
                    TransactionBroker[] transactionBrokerArray = this.translist.getClusterTransactionBrokers(transactionUID);
                    if (transactionBrokerArray == null) continue;
                    boolean bl = true;
                    BrokerAddress brokerAddress = null;
                    for (int i = 0; i < transactionBrokerArray.length; ++i) {
                        if (transactionBrokerArray[i].isCompleted()) continue;
                        bl = false;
                        brokerAddress = transactionBrokerArray[i].getCurrentBrokerAddress();
                        if (brokerAddress != null) {
                            if (brokerAddress.equals(Globals.getMyAddress()) && brokerAddress.equals(transactionBrokerArray[i].getBrokerAddress())) {
                                try {
                                    this.translist.completeClusterTransactionBrokerState(transactionUID, 6, brokerAddress, true);
                                }
                                catch (Exception exception) {
                                    this.logger.logStack(16, "Unable to update transaction broker state for " + brokerAddress + ", TUID=" + transactionUID, exception);
                                }
                                if (!Globals.getHAEnabled()) continue;
                            }
                            if (arrayList.size() == 0 && clusterPCommittedState != null && clusterPCommittedState == ClusterPCommittedState.PROCCESSED || arrayList.size() == 0 && !brokerAddress.equals(Globals.getMyAddress()) && clusterPCommittedState != null && clusterPCommittedState != ClusterPCommittedState.TAKEOVER || arrayList.size() > 0 && !arrayList.contains(brokerAddress.getMQAddress()) && !brokerAddress.equals(Globals.getMyAddress()) && clusterPCommittedState != null && clusterPCommittedState != ClusterPCommittedState.TAKEOVER) continue;
                            if (TransactionList.DEBUG_CLUSTER_TXN) {
                                this.logger.log(8, "txnReaperThread: sendClusterTransactionInfo for TID=" + transactionUID + " to " + brokerAddress);
                            }
                            Globals.getClusterBroadcast().sendClusterTransactionInfo(transactionUID.longValue(), brokerAddress);
                            continue;
                        }
                        if (clusterPCommittedState == null || clusterPCommittedState == ClusterPCommittedState.PROCCESSED) continue;
                        this.logger.log(8, Globals.getBrokerResources().getKString("B2205", transactionUID.toString(), transactionBrokerArray[i].toString()));
                    }
                    this.clusterPCommitted.put(transactionUID, ClusterPCommittedState.PROCCESSED);
                    if (!bl) continue;
                    this.committed.add(transactionUID);
                    this.clusterPCommitted.remove(transactionUID);
                }
                catch (Exception exception) {
                    this.logger.logStack(16, exception.getMessage(), exception);
                }
            }
        }
        transactionUIDArray = this.committed.toArray(new TransactionUID[0]);
        int n = transactionUIDArray.length - TransactionList.TXN_REAPLIMIT;
        for (int i = 0; i < n; ++i) {
            if (TransactionList.DEBUG_CLUSTER_TXN) {
                this.logger.log(8, "Cleaning up committed transaction " + transactionUIDArray[i]);
            }
            try {
                this.translist.reapTransactionID(transactionUIDArray[i], this.noremoves.contains(transactionUIDArray[i]));
                this.committed.remove(transactionUIDArray[i]);
                this.noremoves.remove(transactionUIDArray[i]);
                continue;
            }
            catch (Exception exception) {
                this.logger.logStack(16, "Failed to cleanup committed transaction " + transactionUIDArray[i], exception);
            }
        }
        int n2 = this.remoteCommitted.size() - TransactionList.TXN_REAPLIMIT;
        while (var3_11 > 0) {
            TransactionUID transactionUID = (TransactionUID)this.remoteCommitted.firstElement();
            this.remoteCommitted.remove(transactionUID);
            --var3_11;
            if (!TransactionList.DEBUG_CLUSTER_TXN) continue;
            this.logger.log(8, "Cleaned up committed remote transaction " + transactionUID);
        }
        int n3 = this.remoteRCommitted.size() - TransactionList.TXN_REAPLIMIT;
        while (var3_13 > 0) {
            TransactionUID transactionUID = (TransactionUID)this.remoteRCommitted.firstElement();
            this.remoteRCommitted.remove(transactionUID);
            --var3_13;
            if (!TransactionList.DEBUG_CLUSTER_TXN) continue;
            this.logger.log(8, "Cleaned up committed remote transaction " + transactionUID + ".");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ClusterPCommittedState {
        UNPROCCESSED,
        PROCCESSED,
        TAKEOVER;

    }
}

