/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.RefCompare;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class RedeliverHandler
extends PacketHandler {
    private static boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn");
    static final int REDELIVER_BLOCK_SIZE = 40;
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Hashtable hashtable = null;
        try {
            hashtable = packet.getProperties();
        }
        catch (Exception exception) {
            this.logger.log(8, "Internal Error: unable to retrieve  properties from redeliver message " + packet, exception);
            hashtable = new Hashtable();
        }
        boolean bl = false;
        TransactionUID transactionUID = null;
        if (hashtable != null) {
            long l;
            Object v;
            Boolean bl2 = (Boolean)hashtable.get("JMQSetRedelivered");
            if (bl2 != null) {
                bl = bl2;
            }
            if ((v = hashtable.get("JMQTransactionID")) != null) {
                transactionUID = v instanceof Integer ? new TransactionUID(((Integer)v).intValue()) : new TransactionUID((Long)v);
            }
            if (transactionUID == null && (l = packet.getTransactionID()) != 0L) {
                transactionUID = new TransactionUID(l);
            }
        }
        int n = packet.getMessageBodySize();
        int n2 = n / 40;
        int n3 = n % 40;
        if (n2 == 0) {
            return true;
        }
        if (n3 != 0) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Invalid Redeliver Message Size: " + n + ". Not multiple of " + 40));
        }
        if (DEBUG) {
            this.logger.log(4, "RedeliverMessage: processing message {0} {1}", (Object)packet.toString(), iMQConnection.getConnectionUID().toString());
        }
        DataInputStream dataInputStream = new DataInputStream(packet.getMessageBodyStream());
        ConsumerUID[] consumerUIDArray = new ConsumerUID[n2];
        SysMessageID[] sysMessageIDArray = new SysMessageID[n2];
        try {
            for (int i = 0; i < n2; ++i) {
                consumerUIDArray[i] = new ConsumerUID(dataInputStream.readLong());
                sysMessageIDArray[i] = new SysMessageID();
                sysMessageIDArray[i].readID(dataInputStream);
            }
            this.redeliver(consumerUIDArray, sysMessageIDArray, iMQConnection, transactionUID, bl);
        }
        catch (Exception exception) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Invalid Redeliver Packet", exception), exception);
        }
        return true;
    }

    public void redeliver(ConsumerUID[] consumerUIDArray, SysMessageID[] sysMessageIDArray, IMQConnection iMQConnection, TransactionUID transactionUID, boolean bl) throws BrokerException, IOException {
        Object object;
        Object object2;
        SysMessageID sysMessageID = null;
        HashSet<Object> hashSet = new HashSet<Object>();
        HashMap hashMap = new HashMap();
        HashMap<ConsumerUID, TreeSet<Object>> hashMap2 = new HashMap<ConsumerUID, TreeSet<Object>>();
        HashMap<ConsumerUID, Serializable> hashMap3 = new HashMap<ConsumerUID, Serializable>();
        boolean bl2 = false;
        for (int i = 0; i < consumerUIDArray.length; ++i) {
            TreeSet<Object> treeSet;
            Serializable serializable;
            ConsumerUID object3 = consumerUIDArray[i];
            object3.setConnectionUID(iMQConnection.getConnectionUID());
            sysMessageID = sysMessageIDArray[i];
            object2 = Destination.get(sysMessageID, false);
            if (object2 == null || ((PacketReference)object2).isInvalid()) continue;
            object = Session.getSession(object3);
            Consumer consumer = null;
            if (object != null) {
                if (!hashSet.contains(object)) {
                    ((Session)object).pause("redeliver");
                    hashSet.add(object);
                }
                consumer = ((Session)object).getConsumerOnSession(object3);
            }
            if (consumer == null) {
                consumer = Consumer.getConsumer(object3);
                if (consumer != null) {
                    this.logger.log(16, "Internal Error  consumer with id of " + object3 + " is unavailable " + " on session " + object + "[conuid,sess conuid] =" + "[" + iMQConnection.getConnectionUID().longValue() + "," + (object == null ? 0L : ((Session)object).getConnectionUID().longValue()) + "] consumer session is : " + consumer.getSessionUID());
                    continue;
                }
                if (object != null && ((Session)object).isClientAck(object3) && !((Session)object).isTransacted() && bl && transactionUID == null && (serializable = ((Session)object).getStoredIDForDetatchedConsumer(object3)) != null && !((UID)serializable).equals(object3)) {
                    hashMap3.put(object3, serializable);
                    treeSet = (SortedSet)hashMap2.get(object3);
                    if (treeSet == null) {
                        treeSet = new TreeSet<Object>(new RefCompare());
                        hashMap2.put(object3, treeSet);
                    }
                    treeSet.add(object2);
                }
                this.logger.log(4, " consumer with id of " + object3 + " is unavailable " + " on session " + object + "[conuid,sess conuid] =" + "[" + iMQConnection.getConnectionUID().longValue() + "," + (object == null ? 0L : ((Session)object).getConnectionUID().longValue()) + "] it has been closed");
                continue;
            }
            if (bl && (transactionUID != null || ((Session)object).isTransacted())) {
                List list;
                if (transactionUID == null) {
                    transactionUID = ((Session)object).getCurrentTransactionID();
                }
                if ((treeSet = ((TransactionList)((Object)(serializable = Globals.getTransactionList()))).retrieveRemovedConsumedMessages(transactionUID)) != null && ((HashMap)((Object)treeSet)).size() > 0 && (list = (List)((HashMap)((Object)treeSet)).get(sysMessageID)) != null && list.size() > 0) {
                    boolean bl3 = false;
                    for (int j = 0; j < list.size(); ++j) {
                        TransactionState transactionState;
                        ConsumerUID consumerUID = (ConsumerUID)list.get(j);
                        if (!consumerUID.equals(object3) || (transactionState = ((TransactionList)((Object)serializable)).retrieveState(transactionUID)) == null || transactionState.getState() != 2) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) {
                        if (!DEBUG_CLUSTER_TXN) continue;
                        this.logger.log(8, "Ignore redeliver request for [" + sysMessageID + ":" + object3 + "], removed with transaction " + transactionUID);
                        continue;
                    }
                }
            }
            if ((serializable = (Set)hashMap.get(consumer)) == null) {
                serializable = new LinkedHashSet<Object>();
                hashMap.put(consumer, serializable);
            }
            if (!serializable.contains(object2)) {
                serializable.add(object2);
            } else if (DEBUG_CLUSTER_TXN) {
                this.logger.log(8, "Ignore duplicated redeliver request [" + sysMessageID + ":" + object3 + "]");
            }
            if (bl) {
                ((PacketReference)object2).consumed(consumer.getStoredConsumerUID(), ((Session)object).isDupsOK(consumer.getConsumerUID()), false);
                continue;
            }
            ((PacketReference)object2).removeDelivered(consumer.getStoredConsumerUID(), true);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = (Consumer)entry.getKey();
            object = (Set)entry.getValue();
            ((Consumer)object2).pause("start redeliver");
            ((Consumer)object2).routeMessages((Collection)object, true);
            ((Consumer)object2).resume("end redeliver");
        }
        hashMap.clear();
        if (hashMap2.size() > 0) {
            try {
                this.logger.log(4, "REDELIVER unacked for closed consumers: " + hashMap2);
                TransactionHandler.redeliverUnackedNoConsumer(hashMap2, hashMap3, bl, null, null);
            }
            catch (Exception exception) {
                this.logger.logStack(16, "Exception in redelivering unacked messages for closed consumers", exception);
            }
        }
        for (Session session : hashSet) {
            session.resume("redeliver");
        }
    }
}

