/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;

public class AdminCmdHandler {
    AdminDataHandler parent = null;
    private static boolean DEBUG = false;
    protected Logger logger = Globals.getLogger();
    protected BrokerConfig props = Globals.getConfig();
    protected BrokerResources rb = Globals.getBrokerResources();

    public static boolean getDEBUG() {
        return DEBUG;
    }

    public AdminCmdHandler() {
    }

    public AdminCmdHandler(AdminDataHandler adminDataHandler) {
        this.parent = adminDataHandler;
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        Integer n = (Integer)hashtable.get("JMQMessageType");
        Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
        packet2.setPacketType(5);
        AdminCmdHandler.setProperties(packet2, n + 1, 500, "Not Implemented");
        this.parent.sendReply(iMQConnection, packet, packet2);
        return true;
    }

    public static void setProperties(Packet packet, int n, int n2, String string) {
        AdminCmdHandler.setProperties(packet, n, n2, string, null);
    }

    public static void setProperties(Packet packet, int n, int n2, String string, Hashtable hashtable) {
        Hashtable<String, Object> hashtable2 = null;
        hashtable2 = hashtable != null ? new Hashtable(hashtable) : new Hashtable<String, Object>();
        hashtable2.put("JMQMessageType", new Integer(n));
        hashtable2.put("JMQStatus", new Integer(n2));
        if (string != null) {
            hashtable2.put("JMQErrorString", string);
        }
        packet.setProperties(hashtable2);
    }

    protected Object getBodyObject(Packet packet) {
        Object object = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(packet.getMessageBodyStream());
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            this.logger.log(32, "B3100", this.getClass().getName() + " : Got exception reading body of administration message:\n" + exception + "\n" + packet.dumpPacketString());
        }
        return object;
    }

    protected void setBodyObject(Packet packet, Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            packet.setMessageBody(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            this.logger.log(32, "B3100", this.getClass().getName() + " : Got exception writing Vector to admin reply message:\n" + exception + "\n" + object.toString());
        }
    }

    public static String getMessageFromException(Exception exception) {
        String string = exception.getMessage();
        if (exception instanceof BrokerException) {
            Throwable throwable = ((BrokerException)exception).getCause();
            if (throwable == null) {
                return string;
            }
            String string2 = throwable.getMessage();
            if (string2 != null) {
                string = string + "\n" + string2;
            }
        }
        return string;
    }

    public void waitForHandlersToComplete(int n) {
        this.parent.waitForHandlersToComplete(n);
    }

    public String getDestinationType(int n) {
        if (DestType.isTopic(n)) {
            return this.rb.getString("B0044");
        }
        if (DestType.isQueue(n)) {
            return this.rb.getString("B0043");
        }
        return "?????";
    }
}

