/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.ClusterTransaction;
import com.sun.messaging.jmq.jmsserver.data.RemoteTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.BaseTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

public class FromTxnLogConverter {
    Store store;
    FileStore fileStore;
    Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    public FromTxnLogConverter(Store store) {
        this.store = store;
    }

    public void convertFromTxnLogFormat() {
        if (DEBUG) {
            this.logger.log(4, this.getPrefix() + " convertFromTxnLogFormat");
        }
        this.fileStore = (FileStore)this.store;
        TransactionLogManager transactionLogManager = this.fileStore.getTxnLogManager();
        this.convert(transactionLogManager.getLocalTransactionManager(), new LocalTxnConverter());
        this.convert(transactionLogManager.getClusterTransactionManager(), new ClusterTxnConverter());
        this.convert(transactionLogManager.getRemoteTransactionManager(), new RemoteTxnConverter());
    }

    void convert(BaseTransactionManager baseTransactionManager, TxnConverter txnConverter) {
        if (DEBUG) {
            this.logger.log(4, this.getPrefix() + " converting trxns from TxnManager");
        }
        List<BaseTransaction> list = baseTransactionManager.getAllIncompleteTransactions();
        for (BaseTransaction baseTransaction : list) {
            try {
                txnConverter.convert(baseTransaction);
            }
            catch (BrokerException brokerException) {
                this.logger.logStack(32, brokerException.getMessage(), brokerException);
            }
            catch (IOException iOException) {
                this.logger.logStack(32, iOException.getMessage(), iOException);
            }
        }
    }

    private String getPrefix() {
        return Thread.currentThread() + " TransactionConverter.";
    }

    static {
        if (Globals.getLogger().getLevel() <= 4) {
            DEBUG = true;
        }
    }

    class RemoteTxnConverter
    extends TxnConverter {
        RemoteTxnConverter() {
        }

        void convert(BaseTransaction baseTransaction) throws BrokerException, IOException {
            RemoteTransaction remoteTransaction = (RemoteTransaction)baseTransaction;
            TransactionUID transactionUID = baseTransaction.getTid();
            TransactionState transactionState = baseTransaction.getTransactionState();
            FromTxnLogConverter.this.store.storeRemoteTransaction(transactionUID, transactionState, remoteTransaction.getTxnAcks(), remoteTransaction.getTxnHomeBroker(), Destination.PERSIST_SYNC);
        }
    }

    class ClusterTxnConverter
    extends TxnConverter {
        ClusterTxnConverter() {
        }

        void convert(BaseTransaction baseTransaction) throws BrokerException, IOException {
            ClusterTransaction clusterTransaction = (ClusterTransaction)baseTransaction;
            TransactionUID transactionUID = baseTransaction.getTid();
            TransactionState transactionState = baseTransaction.getTransactionState();
            int n = transactionState.getState();
            transactionState.setState(1);
            FromTxnLogConverter.this.fileStore.storeTransaction(transactionUID, transactionState, true);
            TransactionWork transactionWork = baseTransaction.getTransactionWork();
            if (transactionWork != null) {
                this.convertWork(transactionWork, transactionState, transactionUID);
            }
            FromTxnLogConverter.this.store.updateClusterTransaction(transactionUID, clusterTransaction.getTransactionBrokers(), Destination.PERSIST_SYNC);
            transactionState.setState(5);
            FromTxnLogConverter.this.fileStore.updateTransactionState(transactionUID, transactionState, true);
        }
    }

    class LocalTxnConverter
    extends TxnConverter {
        LocalTxnConverter() {
        }
    }

    class TxnConverter {
        TxnConverter() {
        }

        void convert(BaseTransaction baseTransaction) throws BrokerException, IOException {
            if (DEBUG) {
                FromTxnLogConverter.this.logger.log(4, FromTxnLogConverter.this.getPrefix() + " convert txn " + baseTransaction);
            }
            TransactionUID transactionUID = baseTransaction.getTid();
            TransactionState transactionState = baseTransaction.getTransactionState();
            int n = transactionState.getState();
            transactionState.setState(1);
            FromTxnLogConverter.this.fileStore.storeTransaction(transactionUID, transactionState, true);
            TransactionWork transactionWork = baseTransaction.getTransactionWork();
            if (transactionWork != null) {
                this.convertWork(transactionWork, transactionState, transactionUID);
            }
            transactionState.setState(5);
            FromTxnLogConverter.this.fileStore.updateTransactionState(transactionUID, transactionState, true);
        }

        void convertWork(TransactionWork transactionWork, TransactionState transactionState, TransactionUID transactionUID) throws BrokerException, IOException {
            Object object;
            Serializable serializable;
            if (DEBUG) {
                FromTxnLogConverter.this.logger.log(4, FromTxnLogConverter.this.getPrefix() + " convertWork ");
            }
            List<TransactionWorkMessage> list = transactionWork.getSentMessages();
            for (TransactionWorkMessage object32 : list) {
                Object object2;
                if (DEBUG) {
                    FromTxnLogConverter.this.logger.log(4, FromTxnLogConverter.this.getPrefix() + " convert sent msg " + object32);
                }
                int transactionWorkMessageAck = ((DestinationUID)(object2 = object32.getDestUID())).isQueue() ? 1 : 2;
                serializable = Destination.getDestination(((DestinationUID)object2).getName(), transactionWorkMessageAck, true, true);
                Packet n = object32.getMessage();
                object = object32.getStoredInterests();
                FromTxnLogConverter.this.fileStore.storeMessage((DestinationUID)object2, n, true);
            }
            List<TransactionWorkMessageAck> list2 = transactionWork.getMessageAcknowledgments();
            for (TransactionWorkMessageAck transactionWorkMessageAck : list2) {
                if (DEBUG) {
                    FromTxnLogConverter.this.logger.log(4, FromTxnLogConverter.this.getPrefix() + " convert consumed msg " + transactionWorkMessageAck);
                }
                int n = ((DestinationUID)(serializable = transactionWorkMessageAck.getDestUID())).isQueue() ? 1 : 2;
                object = Destination.getDestination(((DestinationUID)serializable).getName(), n, true, true);
                ((Destination)object).load();
                SysMessageID sysMessageID = transactionWorkMessageAck.getSysMessageID();
                ConsumerUID consumerUID = transactionWorkMessageAck.getConsumerID();
                boolean bl = true;
                boolean bl2 = false;
                TransactionAcknowledgement transactionAcknowledgement = new TransactionAcknowledgement(sysMessageID, consumerUID, consumerUID);
                FromTxnLogConverter.this.fileStore.storeTransactionAck(transactionUID, transactionAcknowledgement, false);
            }
        }
    }
}

