/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.BaseTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.CheckpointManager;
import com.sun.messaging.jmq.jmsserver.persist.file.ClusterTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.LocalTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.LoggedMessageHelper;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgRemovalEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgStore;
import com.sun.messaging.jmq.jmsserver.persist.file.NonTransactedMsgAckEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.NonTransactedMsgEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.PreparedTxnStore;
import com.sun.messaging.jmq.jmsserver.persist.file.RemoteTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogReplayer;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.txnlog.CheckPointListener;
import com.sun.messaging.jmq.util.txnlog.TransactionLogRecord;
import com.sun.messaging.jmq.util.txnlog.TransactionLogWriter;
import com.sun.messaging.jmq.util.txnlog.file.FileTransactionLogWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionLogManager
implements CheckPointListener {
    static final String TXNLOG_PROP_PREFIX = "imq.persist.file.txnLog";
    static final String TXNLOG_FILE_SIZE_PROP = "imq.persist.file.txnLog.file.size";
    static final String SYNC_TXNLOG_WRITES_PROP = "imq.persist.file.txnLog.syncWrites";
    static final long DEFAULT_TXNLOG_FILE_SIZE = 10240L;
    static final String MSG_LOG_FILENAME = "txnlog";
    static final String INCOMPLETE_TXN_STORE = "incompleteTxnStore";
    public static final BrokerResources br = Globals.getBrokerResources();
    Store store;
    MsgStore msgStore;
    File rootDir;
    private TransactionLogWriter msgLogWriter = null;
    TransactionLogReplayer transactionLogReplayer;
    LocalTransactionManager localTransactionManager;
    ClusterTransactionManager clusterTransactionManager;
    RemoteTransactionManager remoteTransactionManager;
    LoggedMessageHelper loggedMessageHelper;
    CheckpointManager checkpointManager;
    PreparedTxnStore preparedTxnStore;
    public static final Logger logger = Globals.getLogger();

    public TransactionLogManager(Store store, MsgStore msgStore, File file, boolean bl) throws BrokerException {
        this.rootDir = file;
        this.store = store;
        File file2 = new File(file, INCOMPLETE_TXN_STORE);
        if (bl) {
            this.clearPreparedTxnStore(file2);
            this.resetTransactionLogOnStartUp();
        }
        this.preparedTxnStore = new PreparedTxnStore(msgStore, file2, false);
        this.msgStore = msgStore;
        this.transactionLogReplayer = new TransactionLogReplayer(msgStore);
        this.localTransactionManager = new LocalTransactionManager(this);
        this.clusterTransactionManager = new ClusterTransactionManager(this);
        this.remoteTransactionManager = new RemoteTransactionManager(this);
        this.checkpointManager = new CheckpointManager(this);
        this.loggedMessageHelper = new LoggedMessageHelper(this);
    }

    public void startup() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " startup");
        }
        this.processStoredTxnsOnStartup();
        this.initTransactionLogOnStartUp();
        this.replayTransactionLogOnStartup();
        this.localTransactionManager.writePreparedTransactionsToPreparedTxnStoreOnCheckpoint();
        this.clusterTransactionManager.writePreparedTransactionsToPreparedTxnStoreOnCheckpoint();
        this.remoteTransactionManager.writePreparedTransactionsToPreparedTxnStoreOnCheckpoint();
        this.preparedTxnStore.sync();
        this.store.syncDestination(null);
        try {
            this.msgLogWriter.reset();
        }
        catch (IOException iOException) {
            throw new BrokerException("failed to reset transaction log", iOException);
        }
        this.removeCommittedTransactionsOnStartup();
    }

    public void close() {
        try {
            this.msgLogWriter.close();
            this.preparedTxnStore.close(true);
        }
        catch (IOException iOException) {
            logger.logStack(32, "caught exception closing", iOException);
        }
    }

    public static void deleteAllFileState(File file) throws BrokerException {
        logger.log(4, "deleteAllFileState " + file);
        File file2 = new File(file, MSG_LOG_FILENAME);
        boolean bl = false;
        if (file2.exists() && !(bl = file2.delete())) {
            throw new BrokerException("Could not delete txnLog file " + file2);
        }
        File file3 = new File(file, INCOMPLETE_TXN_STORE);
        try {
            FileUtil.removeFiles(file3, true);
        }
        catch (IOException iOException) {
            throw new BrokerException("Can not delete incomplete txn store " + file3);
        }
    }

    public static boolean txnLogExists(File file) {
        File file2 = new File(file, MSG_LOG_FILENAME);
        return file2.exists();
    }

    public static boolean incompleteTxnStoreExists(File file) {
        File file2 = new File(file, INCOMPLETE_TXN_STORE);
        return file2.exists();
    }

    public static void assertAllFilesExist(File file) throws BrokerException {
        if (!TransactionLogManager.txnLogExists(file)) {
            throw new BrokerException("assertion failure: txnlog file does not exist");
        }
        if (!TransactionLogManager.incompleteTxnStoreExists(file)) {
            throw new BrokerException("assertion failure: incompleteTxnStore file does not exist");
        }
    }

    List<BaseTransaction> getAllIncompleteTransactions() {
        List<BaseTransaction> list = this.localTransactionManager.getAllIncompleteTransactions();
        List<BaseTransaction> list2 = this.clusterTransactionManager.getAllIncompleteTransactions();
        List<BaseTransaction> list3 = this.remoteTransactionManager.getAllIncompleteTransactions();
        ArrayList<BaseTransaction> arrayList = new ArrayList<BaseTransaction>();
        arrayList.addAll(list);
        arrayList.addAll(list2);
        arrayList.addAll(list3);
        return arrayList;
    }

    void processStoredTxnsOnStartup() throws BrokerException {
        Object object;
        if (Store.getDEBUG()) {
            object = this.getPrefix() + " processStoredTxnsOnStartup";
            logger.log(4, (String)object);
        }
        this.preparedTxnStore.loadTransactions();
        object = this.preparedTxnStore.txnEnumeration();
        while (object.hasMoreElements()) {
            BaseTransaction baseTransaction = (BaseTransaction)object.nextElement();
            int n = baseTransaction.getType();
            BaseTransactionManager baseTransactionManager = this.getTransactionManager(n);
            baseTransactionManager.processStoredTxnOnStartup(baseTransaction);
        }
    }

    void removeCommittedTransactionsOnStartup() throws BrokerException {
        Object object;
        if (Store.getDEBUG()) {
            object = this.getPrefix() + " removeCommitedTransactionsInPreparedTxnStore";
            logger.log(4, (String)object);
        }
        object = this.preparedTxnStore.txnEnumeration();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (object.hasMoreElements()) {
            BaseTransaction baseTransaction = (BaseTransaction)object.nextElement();
            if (baseTransaction.getState() != 6) continue;
            arrayList.add(baseTransaction);
        }
        for (BaseTransaction baseTransaction : arrayList) {
            TransactionUID transactionUID = baseTransaction.getTid();
            this.preparedTxnStore.removeTransaction(transactionUID, true);
            if (!Store.getDEBUG()) continue;
            String string = this.getPrefix() + " removed committed transaction from preparedTxnStore. Tid=" + transactionUID;
            logger.log(4, string);
        }
    }

    private void resetTransactionLogOnStartUp() {
        String string = MSG_LOG_FILENAME;
        File file = new File(this.rootDir, string);
        logger.log(8, "resetting txn Log file " + file);
        boolean bl = file.delete();
        if (!bl) {
            String string2 = this.getPrefix() + " could not delete " + file;
            logger.log(4, string2);
        }
    }

    private void clearPreparedTxnStore(File file) throws BrokerException {
        try {
            FileUtil.removeFiles(file, false);
        }
        catch (IOException iOException) {
            logger.log(32, "B4149", (Object)file, (Throwable)iOException);
            throw new BrokerException(br.getString("B4149", file), iOException);
        }
    }

    public static boolean transactionLogExists(File file) {
        boolean bl = false;
        String string = MSG_LOG_FILENAME;
        File file2 = new File(file, string);
        bl = file2.exists();
        return bl;
    }

    private void initTransactionLogOnStartUp() throws BrokerException {
        String string;
        if (Store.getDEBUG()) {
            string = this.getPrefix() + " initTransactionLogOnStartUp";
            logger.log(4, string);
        }
        logger.log(8, "B1269");
        string = null;
        try {
            BrokerConfig brokerConfig = Globals.getConfig();
            SizeString sizeString = brokerConfig.getSizeProperty(TXNLOG_FILE_SIZE_PROP, 10240L);
            boolean bl = brokerConfig.getBooleanProperty(SYNC_TXNLOG_WRITES_PROP, true);
            if (Store.getDEBUG()) {
                logger.log(4, "syncAllTxnWrites = " + bl);
            }
            string = MSG_LOG_FILENAME;
            String string2 = "rwd";
            boolean bl2 = true;
            if (!bl) {
                string2 = "rw";
                bl2 = false;
            }
            logger.log(8, "opening transaction log with file mode=" + string2);
            FileTransactionLogWriter fileTransactionLogWriter = new FileTransactionLogWriter(this.rootDir, string, sizeString.getBytes(), string2, bl2, 1L);
            long l = fileTransactionLogWriter.getExistingAppCookie();
            if (l != 1L) {
                throw new BrokerException("Unexpected transaction log format. Format on file = " + l + " Current software version = " + 1L);
            }
            this.msgLogWriter = fileTransactionLogWriter;
            this.msgLogWriter.setCheckPointListener(this);
            if (Store.getDEBUG()) {
                logger.log(4, "created txn log");
            }
        }
        catch (IOException iOException) {
            logger.logStack(32, "B3225", string, (Throwable)iOException);
            throw new BrokerException(br.getString("B3225", string), iOException);
        }
    }

    private void shutdownTransactionLog() throws IOException {
    }

    public void replayTransactionLogOnStartup() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " replayTransactionLogOnStartup");
        }
        try {
            if (this.msgLogWriter.playBackRequired()) {
                Object object;
                if (Store.getDEBUG()) {
                    object = this.getPrefix() + " replayTransactionLogOnStartup: playBackRequired";
                    logger.log(4, (String)object);
                }
                logger.log(64, "B1270");
                Destination.init();
                Subscription.initSubscriptions();
                object = new HashSet();
                int n = 0;
                Iterator iterator = this.msgLogWriter.iterator();
                while (iterator.hasNext()) {
                    Object object2;
                    ++n;
                    TransactionLogRecord transactionLogRecord = (TransactionLogRecord)iterator.next();
                    byte[] byArray = transactionLogRecord.getBody();
                    TransactionEvent transactionEvent = this.readTransactionEvent(byArray);
                    int n2 = transactionEvent.getType();
                    if (Store.getDEBUG()) {
                        object2 = this.getPrefix() + " replayTransactionLogOnStartup() read " + transactionEvent;
                        logger.log(4, (String)object2);
                    }
                    if (n2 == 4) {
                        this.transactionLogReplayer.replayNonTxnMsg((NonTransactedMsgEvent)transactionEvent, (Set)object);
                        continue;
                    }
                    if (n2 == 5) {
                        this.transactionLogReplayer.replayNonTxnMsgAck((NonTransactedMsgAckEvent)transactionEvent, (Set)object);
                        continue;
                    }
                    if (n2 == 6) {
                        this.transactionLogReplayer.replayMessageRemoval((MsgRemovalEvent)transactionEvent, (Set)object);
                        continue;
                    }
                    object2 = this.getTransactionManager(n2);
                    ((BaseTransactionManager)object2).replayTransactionEvent(transactionEvent, (HashSet)object);
                }
            } else if (Store.getDEBUG()) {
                logger.log(4, "no playBackRequired");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    TransactionEvent readTransactionEvent(byte[] byArray) throws IOException, BrokerException {
        TransactionEvent transactionEvent = TransactionEvent.createFromBytes(byArray);
        return transactionEvent;
    }

    public void loggedCommitWrittenToMessageStore(TransactionUID transactionUID, int n) {
        BaseTransactionManager baseTransactionManager = this.getTransactionManager(n);
        baseTransactionManager.playingToMessageStoreComplete(transactionUID);
    }

    BaseTransactionManager getTransactionManager(int n) {
        BaseTransactionManager baseTransactionManager = null;
        switch (n) {
            case 1: {
                baseTransactionManager = this.localTransactionManager;
                break;
            }
            case 3: {
                baseTransactionManager = this.clusterTransactionManager;
                break;
            }
            case 2: {
                baseTransactionManager = this.remoteTransactionManager;
                break;
            }
            case 0: {
                throw new UnsupportedOperationException("UNDEFINED_TRANSACTION_TYPE");
            }
            default: {
                throw new UnsupportedOperationException("unknown type:" + n);
            }
        }
        return baseTransactionManager;
    }

    public void logMsgRemoval(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        Object object;
        if (Store.getDEBUG()) {
            object = this.getPrefix() + " logMsgRemoval() dstID=" + destinationUID + " mid=" + sysMessageID;
            logger.log(4, (String)object);
        }
        try {
            try {
                this.store.txnLogSharedLock.lock();
                object = new MsgRemovalEvent(destinationUID, sysMessageID);
                byte[] byArray = ((MsgRemovalEvent)object).writeToBytes();
                TransactionLogRecord transactionLogRecord = this.msgLogWriter.newTransactionLogRecord();
                transactionLogRecord.setBody(byArray);
                this.msgLogWriter.write(transactionLogRecord);
            }
            catch (IOException iOException) {
                throw new BrokerException("error logging transaction", iOException);
            }
            Object var7_7 = null;
            this.store.txnLogSharedLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.store.txnLogSharedLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logNonTxnMessage(TransactionWorkMessage transactionWorkMessage) throws BrokerException {
        Object object;
        if (Store.getDEBUG()) {
            object = this.getPrefix() + " logNonTxnMessage() " + transactionWorkMessage;
            logger.log(4, (String)object);
        }
        try {
            this.store.txnLogSharedLock.lock();
            object = new NonTransactedMsgEvent(transactionWorkMessage);
            this.writeTransactionEvent((TransactionEvent)object);
            this.loggedMessageHelper.messageLogged(transactionWorkMessage);
            Object var4_3 = null;
            this.store.txnLogSharedLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.store.txnLogSharedLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logNonTxnMessageAck(TransactionWorkMessageAck transactionWorkMessageAck) throws BrokerException {
        Object object;
        if (Store.getDEBUG()) {
            object = this.getPrefix() + " logNonTxnMessage() " + transactionWorkMessageAck;
            logger.log(4, (String)object);
        }
        try {
            this.store.txnLogSharedLock.lock();
            object = new NonTransactedMsgAckEvent(transactionWorkMessageAck);
            this.writeTransactionEvent((TransactionEvent)object);
            Object var4_3 = null;
            this.store.txnLogSharedLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.store.txnLogSharedLock.unlock();
            throw throwable;
        }
    }

    public void logTxn(BaseTransaction baseTransaction) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " logTxn() " + baseTransaction);
        }
        try {
            try {
                this.store.txnLogSharedLock.lock();
                int n = baseTransaction.getType();
                BaseTransactionManager baseTransactionManager = this.getTransactionManager(n);
                baseTransactionManager.processTxn(baseTransaction);
                TransactionEvent transactionEvent = baseTransactionManager.generateEvent(baseTransaction, false);
                this.writeTransactionEvent(transactionEvent);
            }
            catch (IOException iOException) {
                throw new BrokerException("error logging transaction", iOException);
            }
            Object var6_6 = null;
            this.store.txnLogSharedLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.store.txnLogSharedLock.unlock();
            throw throwable;
        }
    }

    public void logTxnCompletion(TransactionUID transactionUID, int n, int n2) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " logTxnCompletion() " + transactionUID);
        }
        try {
            try {
                this.store.txnLogSharedLock.lock();
                BaseTransactionManager baseTransactionManager = this.getTransactionManager(n2);
                BaseTransaction baseTransaction = baseTransactionManager.processTxnCompletion(transactionUID, n);
                TransactionEvent transactionEvent = baseTransactionManager.generateEvent(baseTransaction, true);
                this.writeTransactionEvent(transactionEvent);
            }
            catch (IOException iOException) {
                throw new BrokerException("error logging transaction", iOException);
            }
            Object var8_8 = null;
            this.store.txnLogSharedLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.store.txnLogSharedLock.unlock();
            throw throwable;
        }
    }

    public void writeTransactionEvent(TransactionEvent transactionEvent) throws BrokerException {
        try {
            byte[] byArray = transactionEvent.writeToBytes();
            TransactionLogRecord transactionLogRecord = this.msgLogWriter.newTransactionLogRecord();
            transactionLogRecord.setBody(byArray);
            this.msgLogWriter.write(transactionLogRecord);
        }
        catch (IOException iOException) {
            throw new BrokerException("error logging transaction", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doCheckpoint() {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " doCheckpoint");
        }
        Store store = null;
        try {
            store = Globals.getStore();
        }
        catch (Throwable throwable) {
            logger.logStack(32, "failed to getStore", throwable);
        }
        try {
            try {
                store.txnLogExclusiveLock.lock();
                this.localTransactionManager.waitForPlayingToMessageStoreCompletion();
                this.clusterTransactionManager.waitForPlayingToMessageStoreCompletion();
                this.remoteTransactionManager.waitForPlayingToMessageStoreCompletion();
                this.loggedMessageHelper.waitForPendingRemoveCompletion();
                store.syncStoreOnCheckpoint();
                this.localTransactionManager.writePreparedTransactionsToPreparedTxnStoreOnCheckpoint();
                this.clusterTransactionManager.writePreparedTransactionsToPreparedTxnStoreOnCheckpoint();
                this.remoteTransactionManager.writePreparedTransactionsToPreparedTxnStoreOnCheckpoint();
                this.preparedTxnStore.sync();
                this.msgLogWriter.checkpoint();
                this.localTransactionManager.removeCompleteTransactionsAfterCheckpoint();
                this.clusterTransactionManager.removeCompleteTransactionsAfterCheckpoint();
                this.remoteTransactionManager.removeCompleteTransactionsAfterCheckpoint();
                this.loggedMessageHelper.onCheckpoint();
            }
            catch (Throwable throwable) {
                String string = this.getPrefix() + "Failed to synchronize persistence store for transaction log checkpoint";
                logger.logStack(32, "B3100", string, throwable);
                Object var5_5 = null;
                store.txnLogExclusiveLock.unlock();
                if (!Store.getDEBUG()) return;
                String string2 = this.getPrefix() + " doCheckpoint complete";
                logger.log(4, string2);
                return;
            }
            Object var5_4 = null;
            store.txnLogExclusiveLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            store.txnLogExclusiveLock.unlock();
            if (!Store.getDEBUG()) throw throwable;
            String string = this.getPrefix() + " doCheckpoint complete";
            logger.log(4, string);
            throw throwable;
        }
        if (!Store.getDEBUG()) return;
        String string = this.getPrefix() + " doCheckpoint complete";
        logger.log(4, string);
    }

    @Override
    public final void checkpoint() {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " request a checkpoint");
        }
        this.checkpointManager.enqueueCheckpoint();
    }

    String getPrefix() {
        return "TransactionLogManager: " + Thread.currentThread().getName();
    }

    public LocalTransactionManager getLocalTransactionManager() {
        return this.localTransactionManager;
    }

    public ClusterTransactionManager getClusterTransactionManager() {
        return this.clusterTransactionManager;
    }

    public RemoteTransactionManager getRemoteTransactionManager() {
        return this.remoteTransactionManager;
    }

    public LoggedMessageHelper getLoggedMessageHelper() {
        return this.loggedMessageHelper;
    }
}

