/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx.log;

import com.sun.messaging.bridge.service.jms.tx.GlobalXid;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class GlobalXidDecision
implements Externalizable {
    public static final int COMMIT = 0;
    public static final int ROLLBACK = 1;
    private GlobalXid _xid = null;
    private int _decision = 0;

    public GlobalXidDecision() {
    }

    public GlobalXidDecision(GlobalXid globalXid, int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid global decision value: " + n);
        }
        this._xid = globalXid;
        this._decision = n;
    }

    public GlobalXid getGlobalXid() {
        return this._xid;
    }

    public int getGlobalDecision() {
        return this._decision;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this._xid.write(objectOutput);
        objectOutput.writeInt(this._decision);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this._xid = GlobalXid.read(objectInput);
        this._decision = objectInput.readInt();
    }

    private static String decisionString(int n) {
        if (n == 0) {
            return "COMMIT";
        }
        if (n == 1) {
            return "ROLLBACK";
        }
        return "UNKNOWN";
    }

    public String toString() {
        return this._xid.toString() + "(" + GlobalXidDecision.decisionString(this._decision) + ")";
    }
}

