/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class DBConnectionPool
implements DBConstants {
    private static boolean DEBUG = false;
    public static final String REAP_INTERVAL_PROP = "imq.persist.jdbc.connection.reaptime";
    public static final int DEFAULT_REAP_INTERVAL = 300;
    public static final String NUM_CONN_PROP = "imq.persist.jdbc.connection.limit";
    public static final String MIN_CONN_PROP = "imq.persist.jdbc.min_connections";
    public static final String MAX_CONN_PROP = "imq.persist.jdbc.max_connections";
    static final int DEFAULT_NUM_CONN = 5;
    private static int minConnections;
    private static int maxConnections;
    private static boolean initialized;
    private static ReentrantLock lock;
    private static LinkedBlockingQueue idleConnections;
    private static ConcurrentHashMap activeConnections;
    private static ConnectionReaperTask connectionReaper;
    private static long reapInterval;
    private static DBManager dbmgr;
    private static Logger logger;
    private static BrokerResources br;
    private static ConfigListener cfgListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init(DBManager dBManager) throws BrokerException {
        if (!initialized) {
            lock.lock();
            try {
                long l;
                if (initialized) {
                    Object var7_1 = null;
                    lock.unlock();
                    return;
                }
                dbmgr = dBManager;
                int n = Globals.getConfig().getIntProperty(NUM_CONN_PROP, 5);
                if (n < 1) {
                    n = 5;
                    logger.log(16, "Invalid number of connections specified, set to default of " + n);
                }
                if ((minConnections = Globals.getConfig().getIntProperty(MIN_CONN_PROP, n)) < 1) {
                    minConnections = n;
                    logger.log(16, "Invalid number of minimum connections specified, set to default of " + minConnections);
                }
                if ((maxConnections = Globals.getConfig().getIntProperty(MAX_CONN_PROP, n)) < minConnections) {
                    maxConnections = minConnections;
                    logger.log(16, "Invalid number of maximum connections specified, set to default of " + maxConnections);
                }
                if ((l = Globals.getConfig().getLongProperty(REAP_INTERVAL_PROP, 300L)) < 60L) {
                    l = 300L;
                    logger.log(16, "Invalid reap time interval for pool maintenance thread specified, set to default of " + l);
                }
                reapInterval = l * 1000L;
                if (dbmgr.getCreateDBURL() != null && Globals.getConfig().getBooleanProperty("imq.persist.storecreate.all", false)) {
                    try {
                        Connection connection = dbmgr.connectToCreate();
                        connection.close();
                    }
                    catch (Exception exception) {
                        String string = dbmgr.getCreateDBURL();
                        logger.log(32, "B3073", (Object)string, (Throwable)exception);
                        throw new BrokerException(br.getString("B3073", string, exception));
                    }
                }
                for (int i = 0; i < minConnections; ++i) {
                    Connection connection = dbmgr.newConnection(true);
                    idleConnections.offer(connection);
                }
                Globals.getConfig().addListener(MIN_CONN_PROP, cfgListener);
                Globals.getConfig().addListener(MAX_CONN_PROP, cfgListener);
                Globals.getConfig().addListener(REAP_INTERVAL_PROP, cfgListener);
                if (maxConnections > minConnections) {
                    if (connectionReaper != null) {
                        connectionReaper.cancel();
                    }
                    connectionReaper = new ConnectionReaperTask();
                    Globals.getTimer().schedule((TimerTask)connectionReaper, reapInterval, reapInterval);
                }
                initialized = true;
            }
            catch (Throwable throwable) {
                Object var7_3 = null;
                lock.unlock();
                throw throwable;
            }
            Object var7_2 = null;
            lock.unlock();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void close() {
        if (!initialized) {
            return;
        }
        lock.lock();
        try {
            if (connectionReaper != null) {
                connectionReaper.cancel();
                connectionReaper = null;
            }
            Globals.getConfig().removeListener(MIN_CONN_PROP, cfgListener);
            Globals.getConfig().removeListener(MAX_CONN_PROP, cfgListener);
            Globals.getConfig().removeListener(REAP_INTERVAL_PROP, cfgListener);
            for (Connection connection : idleConnections) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    logger.log(16, "B4103", sQLException);
                }
            }
            idleConnections.clear();
            initialized = false;
            Object var4_3 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "DBConnectionPool.reset(): reset connection pool");
        }
        if (!initialized) {
            return;
        }
        ArrayList arrayList = new ArrayList(maxConnections);
        lock.lock();
        try {
            activeConnections.clear();
            idleConnections.drainTo(arrayList);
            for (int i = 0; i < minConnections; ++i) {
                Connection connection = dbmgr.newConnection(true);
                idleConnections.offer(connection);
            }
            for (Connection connection : arrayList) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
            Object var5_5 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    static Connection getConnection() throws BrokerException {
        if (Store.getDEBUG() || DEBUG) {
            logger.log(8, "[" + Thread.currentThread() + "]DBConnectionPool.getConnection()[" + idleConnections.size() + ", " + activeConnections.size() + "]");
        }
        if (DEBUG) {
            FaultInjection faultInjection = FaultInjection.getInjection();
            if (faultInjection.FAULT_INJECTION) {
                faultInjection.checkFaultAndSleep("jdbc.getconn.1", null);
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        Connection connection = (Connection)idleConnections.poll();
        if (connection == null && activeConnections.size() < maxConnections) {
            connection = dbmgr.newConnection(true);
            if (Store.getDEBUG() || DEBUG) {
                bl = true;
            }
        } else {
            while (connection == null) {
                try {
                    if ((Store.getDEBUG() || DEBUG) && !bl2) {
                        bl2 = true;
                    }
                    if ((connection = (Connection)idleConnections.poll(60L, TimeUnit.SECONDS)) != null) continue;
                    StringBuffer stringBuffer = new StringBuffer(1024);
                    for (Map.Entry entry : activeConnections.entrySet()) {
                        Thread thread = (Thread)entry.getValue();
                        stringBuffer.append("\n").append(thread.getName()).append(": using connection: ").append(entry.getKey());
                        StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
                        for (int i = 0; i < stackTraceElementArray.length; ++i) {
                            stringBuffer.append("\n\tat " + stackTraceElementArray[i]);
                        }
                    }
                    logger.log(8, "Unable to obtain database connection after waiting for 60 secs [pool size: min=" + minConnections + ", max=" + maxConnections + "]: stack trace of connection pool:" + stringBuffer.toString());
                }
                catch (Exception exception) {
                    logger.log(4, "DBConnectionPool.getConnection(): " + exception);
                }
            }
            boolean bl3 = false;
            try {
                bl3 = connection.isClosed();
            }
            catch (SQLException sQLException) {
                try {
                    logger.log(8, "exception calling isClosed on connection. Will close");
                    connection.close();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                bl3 = true;
            }
            if (bl3) {
                try {
                    Connection connection2 = dbmgr.newConnection(true);
                    connection = connection2;
                    logger.log(8, br.getString("B1149", dbmgr.getOpenDBURL()));
                }
                catch (BrokerException brokerException) {
                    logger.log(32, br.getString("B4206", dbmgr.getOpenDBURL()), brokerException);
                    idleConnections.add(connection);
                    throw brokerException;
                }
            }
        }
        Thread thread = Thread.currentThread();
        activeConnections.put(connection, thread);
        if (Store.getDEBUG() || DEBUG) {
            logger.log(8, "DBConnectionPool.getConnection()[" + bl + "," + bl2 + "]: " + thread.getName() + " [" + new Date() + "]: check out connection: " + connection);
        }
        return connection;
    }

    static void freeConnection(Connection connection) {
        if (Store.getDEBUG()) {
            logger.log(4, "DBConnectionPool.freeConnection(): check in connection: " + connection);
        }
        if (activeConnections.remove(connection) == null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                logger.logStack(16, Globals.getBrokerResources().getKString("B3100", "Unable to close JDBC resources", sQLException), sQLException);
            }
        } else {
            idleConnections.offer(connection);
        }
    }

    static void reapExcessConnection() {
        int n = idleConnections.size();
        int n2 = activeConnections.size();
        if (Store.getDEBUG()) {
            logger.log(4, "DBConnectionPool.reapExcessConnection(): pool size: min=" + minConnections + ", max=" + maxConnections + ", active=" + n2 + ", idle=" + n);
        }
        while (n > 0 && n2 + n > minConnections) {
            try {
                Connection connection = (Connection)idleConnections.poll();
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                logger.logStack(16, Globals.getBrokerResources().getKString("B3100", "Unable to close JDBC resources", sQLException), sQLException);
            }
            n = idleConnections.size();
            n2 = activeConnections.size();
        }
    }

    static boolean validate(Connection connection) {
        try {
            connection.getMetaData();
        }
        catch (Exception exception) {
            logger.log(4, "DBConnectionPool.validate(): Lost database connection to " + dbmgr.getOpenDBURL(), exception);
            return false;
        }
        return true;
    }

    static boolean handleException(Connection connection, Throwable throwable) {
        if (DBConnectionPool.validate(connection)) {
            logger.log(4, "connection is good; return false (no need to retry)");
            return false;
        }
        return true;
    }

    static {
        initialized = false;
        lock = new ReentrantLock();
        idleConnections = new LinkedBlockingQueue();
        activeConnections = new ConcurrentHashMap();
        connectionReaper = null;
        dbmgr = null;
        logger = Globals.getLogger();
        br = Globals.getBrokerResources();
        cfgListener = new ConfigListener(){

            public void validate(String string, String string2) throws PropertyUpdateException {
                if (string.equals(DBConnectionPool.MIN_CONN_PROP)) {
                    int n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        throw new PropertyUpdateException(2, br.getString("B4027", string + "=" + string2), exception);
                    }
                    if (n < 1) {
                        throw new PropertyUpdateException(2, "A minimum value of 1 connection is required");
                    }
                    if (n > maxConnections) {
                        throw new PropertyUpdateException(2, "Minimum connections " + n + " is greater than maximum connections " + maxConnections);
                    }
                } else if (string.equals(DBConnectionPool.MAX_CONN_PROP)) {
                    int n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        throw new PropertyUpdateException(2, br.getString("B4027", string + "=" + string2), exception);
                    }
                    if (n < minConnections) {
                        throw new PropertyUpdateException(2, "Maximum connections " + n + " is less than minimum connections " + minConnections);
                    }
                } else if (string.equals(DBConnectionPool.REAP_INTERVAL_PROP)) {
                    int n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        throw new PropertyUpdateException(2, br.getString("B4027", string + "=" + string2), exception);
                    }
                    if (n < 60) {
                        throw new PropertyUpdateException(2, "A minimum value of 60 seconds is required for reap time interval");
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean update(String string, String string2) {
                BrokerConfig brokerConfig = Globals.getConfig();
                lock.lock();
                try {
                    if (string.equals(DBConnectionPool.MAX_CONN_PROP)) {
                        maxConnections = brokerConfig.getIntProperty(DBConnectionPool.MAX_CONN_PROP);
                    } else if (string.equals(DBConnectionPool.MIN_CONN_PROP)) {
                        minConnections = brokerConfig.getIntProperty(DBConnectionPool.MIN_CONN_PROP);
                    } else if (string.equals(DBConnectionPool.REAP_INTERVAL_PROP)) {
                        reapInterval = brokerConfig.getLongProperty(DBConnectionPool.REAP_INTERVAL_PROP) * 1000L;
                    }
                    Object var5_4 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    lock.unlock();
                    throw throwable;
                }
                if (maxConnections > minConnections) {
                    if (connectionReaper != null) {
                        connectionReaper.cancel();
                    }
                    connectionReaper = new ConnectionReaperTask();
                    Globals.getTimer().schedule((TimerTask)connectionReaper, reapInterval, reapInterval);
                }
                return true;
            }
        };
    }

    static class ConnectionReaperTask
    extends TimerTask {
        private volatile boolean canceled = false;

        ConnectionReaperTask() {
        }

        public boolean cancel() {
            this.canceled = true;
            return super.cancel();
        }

        public void run() {
            if (this.canceled) {
                return;
            }
            try {
                DBConnectionPool.reapExcessConnection();
            }
            catch (Exception exception) {
                Globals.getLogger().logStack(32, "B3177", exception);
            }
        }
    }
}

