/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.cluster.RemoteTransactionAckEntry;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.RemoteTransaction;
import com.sun.messaging.jmq.jmsserver.data.ToTxnLogConverter;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionInformation;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TxnConverter;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.ArrayList;

class RemoteTxnConverter
extends TxnConverter {
    RemoteTxnConverter(TransactionList transactionList, Store store) {
        super(transactionList, store);
    }

    String getPrefix() {
        return Thread.currentThread() + " ToTxnLogConverter.RemoteTxnConverter.";
    }

    void convert(TransactionInformation transactionInformation) throws BrokerException {
        Object object;
        int n;
        if (ToTxnLogConverter.DEBUG) {
            logger.log(4, this.getPrefix() + " convert " + transactionInformation);
        }
        if ((n = transactionInformation.getState().getState()) != 5) {
            object = this.getPrefix() + " convert: unknown state  " + n + " for " + transactionInformation;
            logger.log(32, (String)object);
        }
        object = transactionInformation.getTID();
        TransactionState transactionState = new TransactionState(transactionInformation.getState());
        RemoteTransactionAckEntry[] remoteTransactionAckEntryArray = this.transactionList.getRecoveryRemoteTransactionAcks((TransactionUID)object);
        if (remoteTransactionAckEntryArray != null) {
            Object object2;
            DestinationUID[] destinationUIDArray;
            ArrayList<TransactionAcknowledgement> arrayList = new ArrayList<TransactionAcknowledgement>();
            for (int i = 0; i < remoteTransactionAckEntryArray.length; ++i) {
                destinationUIDArray = remoteTransactionAckEntryArray[i];
                TransactionAcknowledgement[] transactionAcknowledgementArray = destinationUIDArray.getAcks();
                for (int j = 0; j < transactionAcknowledgementArray.length; ++j) {
                    arrayList.add(transactionAcknowledgementArray[j]);
                }
            }
            TransactionAcknowledgement[] transactionAcknowledgementArray = arrayList.toArray(new TransactionAcknowledgement[0]);
            destinationUIDArray = new DestinationUID[transactionAcknowledgementArray.length];
            for (int i = 0; i < transactionAcknowledgementArray.length; ++i) {
                SysMessageID sysMessageID = transactionAcknowledgementArray[i].getSysMessageID();
                object2 = Destination.get(sysMessageID);
                DestinationUID destinationUID = null;
                if (object2 != null) {
                    destinationUID = ((PacketReference)object2).getDestinationUID();
                } else {
                    logger.log(16, "Could not find packet for " + sysMessageID);
                }
                destinationUIDArray[i] = destinationUID;
            }
            TransactionBroker transactionBroker = this.transactionList.getRemoteTransactionHomeBroker((TransactionUID)object);
            BrokerAddress brokerAddress = transactionBroker.getBrokerAddress();
            object2 = new RemoteTransaction((TransactionUID)object, transactionState, transactionAcknowledgementArray, destinationUIDArray, brokerAddress);
            this.store.logTxn((BaseTransaction)object2);
        } else {
            logger.log(32, "Could not find RemoteTransactionAckEntry for " + object);
        }
    }
}

