/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core.cluster;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.core.ClusterRouter;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.cluster.BrokerConsumers;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultibrokerRouter
implements ClusterRouter {
    private static boolean DEBUG = false;
    private static Logger logger = Globals.getLogger();
    ClusterBroadcast cb = null;
    Protocol p = null;
    BrokerConsumers bc = null;

    public MultibrokerRouter(ClusterBroadcast clusterBroadcast) {
        this.cb = clusterBroadcast;
        this.p = clusterBroadcast.getProtocol();
        this.bc = new BrokerConsumers(this.p);
    }

    public static String msgToString(int n) {
        switch (n) {
            case 0: {
                return "MSG_DELIVERED";
            }
            case 1: {
                return "MSG_ACKNOWLEDGED";
            }
            case 8: {
                return "MSG_PREPARE";
            }
            case 9: {
                return "MSG_ROLLEDBACK";
            }
            case 5: {
                return "MSG_IGNORED";
            }
            case 6: {
                return "MSG_UNDELIVERABLE";
            }
            case 7: {
                return "MSG_DEAD";
            }
        }
        return "UNKNOWN";
    }

    public void addConsumer(Consumer consumer) throws BrokerException, IOException, SelectorFormatException {
        this.bc.addConsumer(consumer);
    }

    public void removeConsumer(ConsumerUID consumerUID, Set set, boolean bl) throws BrokerException, IOException {
        this.bc.removeConsumer(consumerUID, set, bl);
    }

    public void removeConsumers(ConnectionUID connectionUID) throws BrokerException, IOException {
        this.bc.removeConsumers(connectionUID);
    }

    public void brokerDown(BrokerAddress brokerAddress) throws BrokerException, IOException {
        this.bc.brokerDown(brokerAddress);
    }

    public void forwardMessage(PacketReference packetReference, Collection collection) {
        this.bc.forwardMessageToRemote(packetReference, collection);
    }

    public void shutdown() {
        this.bc.destroy();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void handleJMSMsg(Packet var1_1, List var2_2, BrokerAddress var3_3, boolean var4_4) throws BrokerException {
        var5_5 = new ArrayList<Object>();
        var6_6 = new ArrayList<Object>();
        for (ConsumerUID var8_8 : var2_2) {
            var9_10 = Consumer.getConsumer(var8_8);
            if (var9_10 != null && var9_10.isValid()) {
                var5_5.add(var9_10);
                continue;
            }
            var6_6.add(var8_8);
        }
        var8_9 = false;
        var9_10 = Destination.get(var1_1.getSysMessageID());
        if (!(var9_10 == null || (var10_11 = var9_10.getAddress()) != null && var10_11.equals(var3_3))) {
            if (MultibrokerRouter.DEBUG) {
                MultibrokerRouter.logger.log(8, "Remote message " + var9_10.getSysMessageID() + " home broker " + var10_11 + " changed to " + var3_3);
            }
            Destination.remoteCheckMessageHomeChange((PacketReference)var9_10, var3_3);
        }
        if ((var9_10 = Destination.get(var1_1.getSysMessageID())) != null) {
            var8_9 = true;
            var9_10.setBrokerAddress(var3_3);
            if (var1_1.getRedelivered()) {
                var9_10.overrideRedeliver();
            }
        } else {
            var9_10 = PacketReference.createReference(var1_1, null);
            var9_10.setBrokerAddress(var3_3);
        }
        if (var4_4) {
            for (var10_12 = 0; var10_12 < var5_5.size(); ++var10_12) {
                var11_13 = (Consumer)var5_5.get(var10_12);
                var9_10.addMessageDeliveredAck(var11_13.getConsumerUID());
            }
        }
        var10_11 = null;
        try {
            if (var9_10 == null) {
                return;
            }
            if (var9_10.getDestinationUID().isWildcard()) {
                var10_11 = Destination.findMatchingIDs(var9_10.getDestinationUID());
            } else {
                var11_13 = Destination.getDestination(var9_10.getDestinationUID().getName(), var9_10.getDestinationUID().isQueue() != false ? 1 : 2, true, true);
                if (var11_13 != null) {
                    var10_11 = new ArrayList<DestinationUID>();
                    var10_11.add(var11_13.getDestinationUID());
                }
            }
            if (var10_11 == null || var10_11.isEmpty()) {
                var6_6.addAll(var5_5);
            } else if (!var8_9 && !var5_5.isEmpty()) {
                var9_10.setNeverStore(true);
                var9_10.store(var5_5);
                for (Object var11_13 : var10_11) {
                    var12_16 = Destination.getDestination((DestinationUID)var11_13);
                    var12_16.queueMessage((PacketReference)var9_10, false);
                }
            } else if (var8_9) {
                var9_10.add(var5_5);
            }
        }
        catch (IOException var11_14) {
            MultibrokerRouter.logger.logStack(8, "Internal Exception ", var11_14);
            var6_6.addAll(var5_5);
        }
        catch (BrokerException var11_15) {
            var6_6.addAll(var5_5);
        }
        var11_13 = "\n";
        for (var12_17 = 0; var12_17 < var5_5.size(); ++var12_17) {
            var13_18 = (Consumer)var5_5.get(var12_17);
            if (!var13_18.routeMessage((PacketReference)var9_10, false)) {
                try {
                    if (!var9_10.acknowledged(var13_18.getConsumerUID(), var13_18.getStoredConsumerUID(), true, false)) ** GOTO lbl86
                    if (var10_11 == null) continue;
                    for (ConsumerUID var14_19 : var10_11) {
                        var15_21 = Destination.getDestination((DestinationUID)var14_19 /* !! */ );
                        var15_21.removeRemoteMessage(var9_10.getSysMessageID(), RemoveReason.ACKNOWLEDGED, (PacketReference)var9_10);
                    }
                }
                catch (Exception var14_20) {
                    MultibrokerRouter.logger.log(8, "Internal error processing ack", var14_20);
                }
            } else {
                var9_10.addRemoteConsumerUID(var13_18.getConsumerUID(), var13_18.getConsumerUID().getConnectionUID());
            }
lbl86:
            // 4 sources

            if (!MultibrokerRouter.DEBUG) continue;
            var11_13 = (String)var11_13 + "\t" + var13_18.getConsumerUID() + "\n";
        }
        if (MultibrokerRouter.DEBUG) {
            MultibrokerRouter.logger.log(1, "MessageBus: Delivering message to : {0}", var11_13);
        }
        var11_13 = "\n";
        var13_18 = null;
        var14_19 /* !! */  = null;
        for (var12_17 = 0; var12_17 < var6_6.size(); ++var12_17) {
            try {
                var13_18 = var6_6.get(var12_17);
                var14_19 /* !! */  = var13_18 instanceof Consumer != false ? var13_18.getConsumerUID() : (ConsumerUID)var13_18;
                this.cb.acknowledgeMessage(var3_3, var9_10.getSysMessageID(), var14_19 /* !! */ , 5, null, false);
            }
            catch (Exception var15_22) {
                MultibrokerRouter.logger.log(16, "sendMessageAck IGNORE failed to" + var3_3);
            }
            if (!MultibrokerRouter.DEBUG) continue;
            var11_13 = (String)var11_13 + "\t" + var6_6.get(var12_17) + "\n";
        }
        if (MultibrokerRouter.DEBUG && var6_6.size() > 0) {
            MultibrokerRouter.logger.log(1, "MessageBus: Invalid targets : {0}", var11_13);
        }
    }

    public void handleAck(int n, SysMessageID sysMessageID, ConsumerUID consumerUID, Map map) throws BrokerException {
        this.bc.acknowledgeMessageFromRemote(n, sysMessageID, consumerUID, map);
    }

    public void handleAck2P(int n, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray, Map map, Long l, BrokerAddress brokerAddress) throws BrokerException {
        this.bc.acknowledgeMessageFromRemote2P(n, sysMessageIDArray, consumerUIDArray, map, l, brokerAddress);
    }

    public void handleCtrlMsg(int n, HashMap hashMap) throws BrokerException {
    }

    public Hashtable getDebugState() {
        return this.bc.getDebugState();
    }
}

