/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TransactionWorkMessageAck {
    DestinationUID destUID;
    SysMessageID sysMessageID;
    ConsumerUID consumerID;

    public TransactionWorkMessageAck() {
    }

    public TransactionWorkMessageAck(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID) {
        this.destUID = destinationUID;
        this.sysMessageID = sysMessageID;
        this.consumerID = consumerUID;
    }

    public DestinationUID getDestUID() {
        return this.destUID;
    }

    public void setDest(DestinationUID destinationUID) {
        this.destUID = destinationUID;
    }

    public SysMessageID getSysMessageID() {
        return this.sysMessageID;
    }

    public void setSysMessageID(SysMessageID sysMessageID) {
        this.sysMessageID = sysMessageID;
    }

    public ConsumerUID getConsumerID() {
        return this.consumerID;
    }

    public void setConsumerID(ConsumerUID consumerUID) {
        this.consumerID = consumerUID;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("dest=").append(this.destUID);
        stringBuffer.append(" sysMessageID=").append(this.sysMessageID);
        stringBuffer.append(" consumerID=").append(this.consumerID);
        return stringBuffer.toString();
    }

    public void writeWork(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.destUID.toString());
        this.sysMessageID.writeID(dataOutputStream);
        dataOutputStream.writeLong(this.consumerID.longValue());
    }

    public void readWork(DataInputStream dataInputStream) throws IOException, BrokerException {
        String string = dataInputStream.readUTF();
        this.destUID = new DestinationUID(string);
        this.sysMessageID = new SysMessageID();
        this.sysMessageID.readID(dataInputStream);
        long l = dataInputStream.readLong();
        this.consumerID = new ConsumerUID(l);
    }
}

