/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms;

import com.sun.messaging.bridge.service.BridgeCmdSharedReplyData;
import com.sun.messaging.bridge.service.BridgeContext;
import com.sun.messaging.bridge.service.JMSBridgeStore;
import com.sun.messaging.bridge.service.LogSimpleFormatter;
import com.sun.messaging.bridge.service.jms.AsyncStartListener;
import com.sun.messaging.bridge.service.jms.AutoDestination;
import com.sun.messaging.bridge.service.jms.ConnectionFactoryImpl;
import com.sun.messaging.bridge.service.jms.DMQ;
import com.sun.messaging.bridge.service.jms.EventListener;
import com.sun.messaging.bridge.service.jms.EventNotifier;
import com.sun.messaging.bridge.service.jms.Link;
import com.sun.messaging.bridge.service.jms.NotXAConnectionFactoryException;
import com.sun.messaging.bridge.service.jms.PooledConnectionFactory;
import com.sun.messaging.bridge.service.jms.ProviderConnectException;
import com.sun.messaging.bridge.service.jms.Refable;
import com.sun.messaging.bridge.service.jms.SharedConnectionFactory;
import com.sun.messaging.bridge.service.jms.XAConnectionFactoryImpl;
import com.sun.messaging.bridge.service.jms.resources.JMSBridgeResources;
import com.sun.messaging.bridge.service.jms.tx.TransactionManagerAdapter;
import com.sun.messaging.bridge.service.jms.tx.TransactionManagerImpl;
import com.sun.messaging.bridge.service.jms.tx.log.FileTxLogImpl;
import com.sun.messaging.bridge.service.jms.xml.ConnectionFactoryElement;
import com.sun.messaging.bridge.service.jms.xml.DMQElement;
import com.sun.messaging.bridge.service.jms.xml.DestinationElement;
import com.sun.messaging.bridge.service.jms.xml.JMSBridgeElement;
import com.sun.messaging.bridge.service.jms.xml.JMSBridgeReader;
import com.sun.messaging.bridge.service.jms.xml.LinkElement;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSBridge {
    private static final String PROP_XMLURL_SUFFIX = ".xmlurl";
    private static final String PROP_LOGFILE_LIMIT_SUFFIX = ".logfile.limit";
    private static final String PROP_LOGFILE_COUNT_SUFFIX = ".logfile.count";
    private static JMSBridgeResources _jbr = JMSBridge.getJMSBridgeResources();
    Map<Object, Object> _spcfs = Collections.synchronizedMap(new LinkedHashMap());
    LinkedHashMap<String, Object> _allCF = new LinkedHashMap();
    LinkedHashMap<String, Object> _localCFs = new LinkedHashMap();
    LinkedHashMap<String, Object> _localXACFs = new LinkedHashMap();
    LinkedHashMap<String, Link> _links = new LinkedHashMap();
    LinkedHashMap<String, DMQ> _dmqs = new LinkedHashMap();
    private static Logger _logger = null;
    private String _name = null;
    private BridgeContext _bc = null;
    private String _xmlurl = null;
    private JMSBridgeElement _jmsbridge = null;
    protected final EventNotifier _notifier = new EventNotifier();
    private TransactionManagerAdapter _tma = null;
    private TransactionManager _tm = null;
    private int _transactionTimeout = 180;
    private boolean _supportTransactionTimeout = false;
    private boolean _reset = false;
    private Object _initLock = new Object();
    public static final String BRIDGE_NAME_PROPERTY = "JMS_SUN_JMSBRIDGE_NAME";
    private ExecutorService _asyncStartExecutor = null;
    private Object _startFutureLock = new Object();
    private LinkedHashMap _startFutures = new LinkedHashMap();
    private final CountDownLatch _startLatch = new CountDownLatch(1);

    public void init(BridgeContext bridgeContext, String string, boolean bl) throws Exception {
        Map.Entry entry22;
        String string2;
        this._bc = bridgeContext;
        this._name = string;
        this._reset = bl;
        Properties properties = bridgeContext.getConfig();
        String string3 = properties.getProperty("BRIDGE_PROP_PREFIX");
        this._xmlurl = properties.getProperty(string3 + PROP_XMLURL_SUFFIX);
        if (this._xmlurl == null) {
            throw new IllegalArgumentException(_jbr.getKString("BSJ4008", this._name, string3 + PROP_XMLURL_SUFFIX));
        }
        _logger = Logger.getLogger(string3);
        String string4 = bridgeContext.getRootDir();
        File file = new File(string4);
        if (!file.exists()) {
            file.mkdirs();
        }
        String string5 = string4 + File.separator + "jms%g.log";
        int n = 0;
        int n2 = 1;
        String string6 = properties.getProperty(string3 + PROP_LOGFILE_LIMIT_SUFFIX);
        if (string6 != null) {
            n = Integer.parseInt(string6);
        }
        if ((string2 = properties.getProperty(string3 + PROP_LOGFILE_COUNT_SUFFIX)) != null) {
            n2 = Integer.parseInt(string2);
        }
        FileHandler fileHandler = new FileHandler(string5, n, n2, true);
        fileHandler.setFormatter(new LogSimpleFormatter(_logger));
        _logger.addHandler(fileHandler);
        _logger.log(Level.INFO, _jbr.getString("BSJ1002", this._name, string3));
        _logger.log(Level.INFO, _jbr.getString("BSJ1003", this._name, string5) + "[" + n + "," + n2 + "]");
        String string7 = bridgeContext.getLibDir();
        if (string7 == null) {
            throw new IllegalArgumentException("JMS bridge " + this._name + " lib dir not specified");
        }
        String string8 = string7 + File.separator + "dtd" + File.separator;
        File file2 = new File(string8);
        if (!file2.exists()) {
            throw new IllegalArgumentException(_jbr.getKString("BSJ4009", this._name, string8));
        }
        String string9 = file2.toURI().toURL().toString();
        Object[] objectArray = new String[]{this._name, this._xmlurl, string9};
        _logger.log(Level.INFO, _jbr.getString("BSJ1004", objectArray));
        JMSBridgeReader jMSBridgeReader = new JMSBridgeReader(this._xmlurl, string9, _logger);
        this._jmsbridge = jMSBridgeReader.getJMSBridgeElement();
        if (!this._name.equals(this._jmsbridge.getName())) {
            Object[] objectArray2 = new String[]{this._name, this._jmsbridge.getName(), this._xmlurl};
            throw new IllegalArgumentException(_jbr.getKString("BSJ4010", objectArray2));
        }
        this.createBuiltInDMQ(this._jmsbridge);
        Map map = this._jmsbridge.getDMQs();
        for (Map.Entry entry22 : map.entrySet()) {
            if (((String)entry22.getKey()).equals("built-in-dmq")) continue;
            this.createDMQ((DMQElement)entry22.getValue(), this._jmsbridge);
        }
        boolean bl2 = false;
        entry22 = this._jmsbridge.getLinks();
        for (Map.Entry object : entry22.entrySet()) {
            bl2 |= this.createLink((LinkElement)object.getValue(), this._jmsbridge);
        }
        if (bl2) {
            TransactionManagerAdapter transactionManagerAdapter = this.getTransactionManagerAdapter();
            if (transactionManagerAdapter.registerRM()) {
                Map.Entry<String, Object> entry3;
                LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(this._localXACFs);
                for (Map.Entry<String, Object> entry3 : this._allCF.entrySet()) {
                    if (linkedHashMap.get(entry3.getKey()) != null || !(entry3.getValue() instanceof XAConnectionFactory)) continue;
                    linkedHashMap.put(entry3.getKey(), (XAConnectionFactoryImpl)entry3.getValue());
                }
                Object object = null;
                entry3 = null;
                Map map2 = this._jmsbridge.getAllCF();
                for (Map.Entry entry4 : map2.entrySet()) {
                    object = (String)entry4.getKey();
                    if (linkedHashMap.get(object) != null) continue;
                    try {
                        entry3 = this.createConnectionFactory((ConnectionFactoryElement)entry4.getValue(), true);
                    }
                    catch (NotXAConnectionFactoryException notXAConnectionFactoryException) {
                        _logger.log(Level.INFO, _jbr.getString("BSJ1005", entry4.getKey(), "XAConnectionFactory"));
                        continue;
                    }
                    if (entry3 == null) {
                        entry3 = new XAConnectionFactoryImpl(this._bc.getXAConnectionFactory(this._jmsbridge.getCF((String)object).getProperties()), this._bc.isEmbeded(), (String)object, ((ConnectionFactoryElement)entry4.getValue()).isMultiRM());
                    }
                    linkedHashMap.put((String)object, (XAConnectionFactoryImpl)((Object)entry3));
                }
                this.registerXAResources(linkedHashMap);
            } else {
                Object var24_28 = null;
                for (Map.Entry<String, Link> entry : this._links.entrySet()) {
                    Link link = entry.getValue();
                    if (!link.isTransacted()) continue;
                    link.registerXAResources();
                }
            }
        }
        this._asyncStartExecutor = Executors.newSingleThreadExecutor();
    }

    protected String getBridgeName() {
        return this._name;
    }

    protected boolean needTagBridgeName() {
        return this._jmsbridge.tagBridgeName();
    }

    protected boolean logMessageTransfer() {
        return this._jmsbridge.logMessageTransfer();
    }

    protected void tagBridgeName(Message message, Message message2) throws Exception {
        Enumeration enumeration = message.getPropertyNames();
        String string = null;
        Object object = null;
        while (enumeration != null && enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = message.getObjectProperty(string);
            message2.setObjectProperty(string, object);
        }
        message.clearProperties();
        Exception exception = null;
        enumeration = message2.getPropertyNames();
        while (enumeration != null && enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            try {
                object = message2.getObjectProperty(string);
                message.setObjectProperty(string, object);
            }
            catch (Exception exception2) {
                if (exception == null) continue;
                exception = exception2;
            }
        }
        if (exception != null) {
            throw exception;
        }
        message.setStringProperty(BRIDGE_NAME_PROPERTY, this._name);
    }

    private boolean createLink(LinkElement linkElement, JMSBridgeElement jMSBridgeElement) throws Exception {
        _logger.log(Level.INFO, _jbr.getString("BSJ1006", linkElement.getName(), jMSBridgeElement.getName()));
        if (this._links.get(linkElement.getName()) != null) {
            throw new IllegalArgumentException(_jbr.getKString("BSJ4011", linkElement.getName(), jMSBridgeElement.getName()));
        }
        Properties properties = linkElement.getSource();
        String string = properties.getProperty("connection-factory-ref");
        Object object = this._allCF.get(string);
        if (object == null && (object = this.createConnectionFactory(jMSBridgeElement.getCF(string), linkElement.isTransacted())) != null) {
            this._allCF.put(string, object);
        }
        String string2 = properties.getProperty("destination-ref");
        Object object2 = this.createDestination(jMSBridgeElement.getDestination(string2));
        Properties properties2 = linkElement.getTarget().getAttributes();
        String string3 = properties2.getProperty("connection-factory-ref");
        Object object3 = this._allCF.get(string3);
        if (object3 == null && (object3 = this.createConnectionFactory(jMSBridgeElement.getCF(string3), linkElement.isTransacted())) != null) {
            this._allCF.put(string3, object3);
        }
        string2 = properties2.getProperty("destination-ref");
        Object object4 = null;
        object4 = !string2.equals("AS_SOURCE") ? this.createDestination(jMSBridgeElement.getDestination(string2)) : "AS_SOURCE";
        if (object == null) {
            if (linkElement.isTransacted()) {
                object = this._localXACFs.get(string);
                if (object == null) {
                    object = new XAConnectionFactoryImpl(this._bc.getXAConnectionFactory(jMSBridgeElement.getCF(string).getProperties()), this._bc.isEmbeded(), string, jMSBridgeElement.getCF(string).isMultiRM());
                    this._localXACFs.put(string, object);
                }
            } else {
                object = this._localCFs.get(string);
                if (object == null) {
                    object = new ConnectionFactoryImpl(this._bc.getConnectionFactory(jMSBridgeElement.getCF(string).getProperties()), this._bc.isEmbeded(), string);
                    this._localCFs.put(string, object);
                }
            }
            this._allCF.put(string, object);
        }
        if (object3 == null) {
            if (linkElement.isTransacted()) {
                object3 = this._localXACFs.get(string3);
                if (object3 == null) {
                    object3 = new XAConnectionFactoryImpl(this._bc.getXAConnectionFactory(jMSBridgeElement.getCF(string3).getProperties()), this._bc.isEmbeded(), string3, jMSBridgeElement.getCF(string3).isMultiRM());
                    this._localXACFs.put(string3, object3);
                }
            } else {
                object3 = this._localCFs.get(string3);
                if (object3 == null) {
                    object3 = new ConnectionFactoryImpl(this._bc.getConnectionFactory(jMSBridgeElement.getCF(string3).getProperties()), this._bc.isEmbeded(), string3);
                    this._localCFs.put(string3, object3);
                }
            }
            this._allCF.put(string3, object3);
        }
        if (object == null) {
            throw new IllegalArgumentException("Source connection factory " + string + " object is null");
        }
        if (object3 == null) {
            throw new IllegalArgumentException("Target connection factory " + string3 + " object is null");
        }
        if (!((Refable)object).getRefed().getClass().getName().startsWith("com.sun.messaging") && !((Refable)object3).getRefed().getClass().getName().startsWith("com.sun.messaging")) {
            throw new IllegalArgumentException(_jbr.getKString("BSJ4012", ((Refable)object).getRefed().getClass().getName(), ((Refable)object3).getRefed().getClass().getName()));
        }
        if (object instanceof ConnectionFactory && object3 instanceof XAConnectionFactory) {
            throw new IllegalArgumentException(_jbr.getKString("BSJ4013", string, string3));
        }
        if (object instanceof XAConnectionFactory && object3 instanceof ConnectionFactory) {
            throw new IllegalArgumentException(_jbr.getKString("BSJ4014", string, string3));
        }
        Properties properties3 = linkElement.getSource();
        Properties properties4 = linkElement.getTarget().getAttributes();
        Properties properties5 = linkElement.getTarget().getProperties();
        Link link = new Link();
        link.setName(linkElement.getName());
        link.setLogger(_logger);
        link.setSourceConnectionFactory(object);
        link.setTargetConnectionFactory(object3);
        link.setSourceDestination(object2);
        link.setTargetDestination(object4);
        link.init(linkElement.getAttributes(), properties3, properties4, properties5, this);
        this._links.put(linkElement.getName(), link);
        return object instanceof XAConnectionFactory;
    }

    private void createDMQ(DMQElement dMQElement, JMSBridgeElement jMSBridgeElement) throws Exception {
        _logger.log(Level.INFO, _jbr.getKString("BSJ1007", dMQElement.getName(), jMSBridgeElement.getName()));
        if (this._dmqs.get(dMQElement.getName()) != null) {
            throw new IllegalArgumentException(_jbr.getKString("BSJ4015", dMQElement.getName(), jMSBridgeElement.getName()));
        }
        String string = dMQElement.getCFRef();
        Object object = this._allCF.get(string);
        if (object == null) {
            object = this.createConnectionFactory(jMSBridgeElement.getCF(string), false);
        }
        Object object2 = this.createDestination(jMSBridgeElement.getDestination(dMQElement.getDestinationRef()));
        if (object == null && (object = this._localCFs.get(string)) == null) {
            object = new ConnectionFactoryImpl(this._bc.getConnectionFactory(jMSBridgeElement.getCF(string).getProperties()), this._bc.isEmbeded(), string);
            this._localCFs.put(string, object);
        }
        if (object instanceof XAConnectionFactory) {
            Object[] objectArray = new String[]{"XAConnectionFactory", object.getClass().getName(), string, dMQElement.getName()};
            throw new IllegalArgumentException(_jbr.getKString("BSJ4016", objectArray));
        }
        Properties properties = dMQElement.getAttributes();
        DMQ dMQ = new DMQ();
        dMQ.setName(dMQElement.getName());
        dMQ.setLogger(_logger);
        dMQ.setConnectionFactory(object);
        dMQ.setDestination(object2);
        dMQ.init(dMQElement.getAttributes(), dMQElement.getProperties(), this);
        this._dmqs.put(dMQElement.getName(), dMQ);
    }

    private void createBuiltInDMQ(JMSBridgeElement jMSBridgeElement) throws Exception {
        DMQElement dMQElement = jMSBridgeElement.getBuiltInDMQ();
        String string = dMQElement.getName();
        _logger.log(Level.INFO, _jbr.getString("BSJ1008", string, jMSBridgeElement.getName()));
        AutoDestination autoDestination = new AutoDestination("imq.bridge.jms.dmq", true);
        ConnectionFactoryImpl connectionFactoryImpl = new ConnectionFactoryImpl(this._bc.getAdminConnectionFactory(dMQElement.getProperties()), this._bc.isEmbeded(), "built-in-dmq");
        if (connectionFactoryImpl instanceof XAConnectionFactory) {
            Object[] objectArray = new String[]{"XAConnectionFactory", connectionFactoryImpl.getClass().getName(), string, string};
            throw new IllegalArgumentException(_jbr.getKString("BSJ4016", objectArray));
        }
        DMQ dMQ = new DMQ();
        dMQ.setName(string);
        dMQ.setLogger(_logger);
        dMQ.setConnectionFactory(connectionFactoryImpl);
        dMQ.setDestination(autoDestination);
        dMQ.init(dMQElement.getAttributes(), dMQElement.getProperties(), this);
        this._dmqs.put(string, dMQ);
    }

    private Object createConnectionFactory(ConnectionFactoryElement connectionFactoryElement, boolean bl) throws Exception {
        String string;
        Properties properties = connectionFactoryElement.getProperties();
        if (properties == null) {
            properties = new Properties();
        }
        if ((string = connectionFactoryElement.getLookupName()) == null) {
            return null;
        }
        _logger.log(Level.INFO, _jbr.getString("BSJ1009", string, connectionFactoryElement.getRefName()));
        InitialContext initialContext = new InitialContext(properties);
        Object object = initialContext.lookup(string);
        if (object == null) {
            Object[] objectArray = new String[]{string, "connection-factory".toString(), connectionFactoryElement.getRefName()};
            throw new NamingException(_jbr.getKString("BSJ4020", objectArray));
        }
        if (object instanceof XAConnectionFactory) {
            if (!bl) {
                Object[] objectArray = new String[]{"ConnectionFactory", connectionFactoryElement.getRefName(), object.getClass().getName()};
                throw new IllegalArgumentException(_jbr.getKString("BSJ4017", objectArray));
            }
            return new XAConnectionFactoryImpl((XAConnectionFactory)object, connectionFactoryElement.getRefName(), connectionFactoryElement.isMultiRM());
        }
        if (object instanceof ConnectionFactory) {
            if (bl) {
                Object[] objectArray = new String[]{"XAConnectionFactory", connectionFactoryElement.getRefName(), object.getClass().getName()};
                throw new NotXAConnectionFactoryException(_jbr.getKString("BSJ4017", objectArray));
            }
            return new ConnectionFactoryImpl((ConnectionFactory)object, connectionFactoryElement.getRefName());
        }
        if (bl) {
            Object[] objectArray = new String[]{"XAConnectionFactory", connectionFactoryElement.getRefName(), object.getClass().getName()};
            throw new NotXAConnectionFactoryException(_jbr.getKString("BSJ4017", objectArray));
        }
        Object[] objectArray = new String[]{"ConnectionFactory", connectionFactoryElement.getRefName(), object.getClass().getName()};
        throw new IllegalArgumentException(_jbr.getKString("BSJ4017", objectArray));
    }

    public Object createDestination(String string) throws Exception {
        return this.createDestination(this._jmsbridge.getDestination(string));
    }

    private Object createDestination(DestinationElement destinationElement) throws Exception {
        String string;
        Properties properties = destinationElement.getProperties();
        if (properties == null) {
            properties = new Properties();
        }
        if ((string = destinationElement.getLookupName()) == null) {
            String string2 = destinationElement.getName();
            if (string2 == null) {
                Object[] objectArray = new String[]{"lookup-name", "name", destinationElement.getRefName(), this._xmlurl};
                throw new IllegalArgumentException(_jbr.getKString("BSJ4018", objectArray));
            }
            return new AutoDestination(string2, destinationElement.isQueue());
        }
        _logger.log(Level.INFO, _jbr.getKString("BSJ1010", string, destinationElement.getRefName()));
        InitialContext initialContext = new InitialContext(properties);
        Destination destination = (Destination)initialContext.lookup(string);
        if (destination == null) {
            Object[] objectArray = new String[]{string, "destination".toString(), destinationElement.getRefName()};
            throw new NamingException(_jbr.getKString("BSJ4020", objectArray));
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStartFuture(String string, String string2, boolean bl) throws Exception {
        Object object = this._startFutureLock;
        synchronized (object) {
            if (this._startFutures.size() > 0) {
                String[] stringArray = this._startFutures.keySet().toArray(new String[0]);
                Future future = (Future)this._startFutures.get(stringArray[0]);
                if (future.isDone()) {
                    this._startFutures.remove(stringArray[0]);
                    this.checkStartFuture(string, string2, bl);
                }
                String string3 = _jbr.getString("BSJ0010") + (stringArray[0].equals(BRIDGE_NAME_PROPERTY) ? " " + _jbr.getString("BSJ0012") + " " + this._name : " " + _jbr.getString("BSJ0013") + " " + stringArray[0]);
                String string4 = string + (string2 == null ? " " + _jbr.getString("BSJ0012") + " " + this._name : " " + _jbr.getString("BSJ0013") + " " + string2);
                if (bl && future.cancel(true)) {
                    _logger.log(Level.WARNING, _jbr.getKString("BSJ2024", string3));
                }
                String string5 = _jbr.getKString("BSJ2023", string4, string3);
                _logger.log(Level.WARNING, string5);
                throw new RejectedExecutionException(string5);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(String string, AsyncStartListener asyncStartListener) throws Exception {
        Object object = this._startFutureLock;
        synchronized (object) {
            String string2 = _jbr.getString("BSJ0010");
            this.checkStartFuture(string2, string, false);
            Starter starter = new Starter(string, this, asyncStartListener);
            try {
                starter.setAsync(false);
                starter.call();
                return true;
            }
            catch (Exception exception) {
                if (!(exception.getCause() instanceof ProviderConnectException) && !(exception instanceof ProviderConnectException)) {
                    throw exception;
                }
                String string3 = string2 + (string == null ? " " + _jbr.getString("BSJ0012") + " " + this._name : " " + _jbr.getString("BSJ0013") + " " + string);
                _logger.log(Level.INFO, _jbr.getKString("BSJ1076", string3, "ProviderConnectException"));
                starter.setAsync(true);
                Future<Void> future = this._asyncStartExecutor.submit(starter);
                if (string != null) {
                    this._startFutures.put(string, future);
                } else {
                    this._startFutures.put(BRIDGE_NAME_PROPERTY, future);
                }
                try {
                    this._startLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    _logger.log(Level.WARNING, "Waiting for async start task to run interrupted ");
                    throw interruptedException;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<BridgeCmdSharedReplyData> list(String string, ResourceBundle resourceBundle, boolean bl) throws Exception {
        ArrayList<BridgeCmdSharedReplyData> arrayList = new ArrayList<BridgeCmdSharedReplyData>();
        BridgeCmdSharedReplyData bridgeCmdSharedReplyData = new BridgeCmdSharedReplyData(5, 3, "-");
        Object[] objectArray = new String[]{resourceBundle.getString("BS1004"), resourceBundle.getString("BS1005"), resourceBundle.getString("BS1006"), resourceBundle.getString("BS1007"), resourceBundle.getString("BS1008")};
        bridgeCmdSharedReplyData.addTitle((String[])objectArray);
        Link link = null;
        if (string != null) {
            link = this._links.get(string);
            if (link == null || !link.isEnabled()) {
                throw new IllegalArgumentException(_jbr.getKString("BSJ4019", string, this._name));
            }
            objectArray[0] = link.getName();
            objectArray[1] = link.getState().toString();
            objectArray[2] = link.getSourceString();
            objectArray[3] = link.getTargetString();
            objectArray[4] = String.valueOf(link.isTransacted());
            bridgeCmdSharedReplyData.add(objectArray);
            arrayList.add(bridgeCmdSharedReplyData);
            if (!bl) {
                return arrayList;
            }
            if (link.isTransacted()) {
                BridgeCmdSharedReplyData bridgeCmdSharedReplyData2 = new BridgeCmdSharedReplyData(1, 3, "-");
                Object[] objectArray2 = new String[]{resourceBundle.getString("BS1009")};
                bridgeCmdSharedReplyData2.addTitle((String[])objectArray2);
                if (this._tma != null) {
                    try {
                        String[] stringArray = this._tma.getAllTransactions();
                        if (stringArray != null) {
                            for (int i = 0; i < stringArray.length; ++i) {
                                objectArray2[0] = stringArray[i];
                                bridgeCmdSharedReplyData2.add(objectArray2);
                            }
                        }
                    }
                    catch (Exception exception) {
                        _logger.log(Level.WARNING, _jbr.getKString("BSJ2009", this._name));
                    }
                }
                arrayList.add(bridgeCmdSharedReplyData2);
            }
            return arrayList;
        }
        Link[] linkArray = null;
        LinkedHashMap<String, Link> linkedHashMap = this._links;
        synchronized (linkedHashMap) {
            linkArray = this._links.values().toArray(new Link[0]);
        }
        for (int i = 0; i < linkArray.length; ++i) {
            link = linkArray[i];
            if (!link.isEnabled()) continue;
            objectArray[0] = link.getName();
            objectArray[1] = link.getState().toString();
            objectArray[2] = link.getSourceString();
            objectArray[3] = link.getTargetString();
            objectArray[4] = String.valueOf(link.isTransacted());
            bridgeCmdSharedReplyData.add(objectArray);
        }
        arrayList.add(bridgeCmdSharedReplyData);
        if (!bl) {
            return arrayList;
        }
        BridgeCmdSharedReplyData bridgeCmdSharedReplyData3 = new BridgeCmdSharedReplyData(7, 3, "-", 1);
        bridgeCmdSharedReplyData3.setTitleAlign(1);
        Object[] objectArray3 = new String[]{resourceBundle.getString("BS1010"), "XA", resourceBundle.getString("BS1011"), resourceBundle.getString("BS1012"), resourceBundle.getString("BS1013"), resourceBundle.getString("BS1015"), resourceBundle.getString("BS1017")};
        bridgeCmdSharedReplyData3.addTitle((String[])objectArray3);
        objectArray3[0] = "ConnectionFactory";
        objectArray3[1] = "";
        objectArray3[2] = "";
        objectArray3[3] = "";
        objectArray3[4] = resourceBundle.getString("BS1014");
        objectArray3[5] = resourceBundle.getString("BS1016");
        objectArray3[6] = resourceBundle.getString("BS1018");
        bridgeCmdSharedReplyData3.addTitle((String[])objectArray3);
        BridgeCmdSharedReplyData bridgeCmdSharedReplyData4 = new BridgeCmdSharedReplyData(6, 3, "-", 1);
        bridgeCmdSharedReplyData4.setTitleAlign(1);
        Object[] objectArray4 = new String[]{resourceBundle.getString("BS1019"), "XA", resourceBundle.getString("BS1020"), resourceBundle.getString("BS1013"), resourceBundle.getString("BS1015"), resourceBundle.getString("BS1017")};
        bridgeCmdSharedReplyData4.addTitle((String[])objectArray4);
        objectArray4[0] = "ConnectionFactory";
        objectArray4[1] = "";
        objectArray4[2] = resourceBundle.getString("BS1021");
        objectArray4[3] = resourceBundle.getString("BS1014");
        objectArray4[4] = resourceBundle.getString("BS1016");
        objectArray4[5] = resourceBundle.getString("BS1018");
        bridgeCmdSharedReplyData4.addTitle((String[])objectArray4);
        Object[] objectArray5 = null;
        Object object = this._spcfs;
        synchronized (object) {
            objectArray5 = this._spcfs.values().toArray();
        }
        object = null;
        SharedConnectionFactory sharedConnectionFactory = null;
        for (int i = 0; i < objectArray5.length; ++i) {
            if (objectArray5[i] instanceof PooledConnectionFactory) {
                object = (PooledConnectionFactory)objectArray5[i];
                objectArray3[0] = ((Refable)((PooledConnectionFactory)object).getCF()).getRef();
                objectArray3[1] = String.valueOf(((PooledConnectionFactory)object).getCF() instanceof XAConnectionFactory);
                objectArray3[2] = String.valueOf(((PooledConnectionFactory)object).getNumInUseConns());
                objectArray3[3] = String.valueOf(((PooledConnectionFactory)object).getNumIdleConns());
                objectArray3[4] = String.valueOf(((PooledConnectionFactory)object).getIdleTimeout());
                objectArray3[5] = String.valueOf(((PooledConnectionFactory)object).getMaxRetries());
                objectArray3[6] = String.valueOf(((PooledConnectionFactory)object).getRetryInterval());
                bridgeCmdSharedReplyData3.add(objectArray3);
                continue;
            }
            if (!(objectArray5[i] instanceof SharedConnectionFactory)) continue;
            sharedConnectionFactory = (SharedConnectionFactory)objectArray5[i];
            objectArray4[0] = ((Refable)sharedConnectionFactory.getCF()).getRef();
            objectArray4[1] = String.valueOf(sharedConnectionFactory.getCF() instanceof XAConnectionFactory);
            objectArray4[2] = String.valueOf(sharedConnectionFactory.getRefCount());
            objectArray4[3] = String.valueOf(sharedConnectionFactory.getIdleTimeout());
            objectArray4[4] = String.valueOf(sharedConnectionFactory.getMaxRetries());
            objectArray4[5] = String.valueOf(sharedConnectionFactory.getRetryInterval());
            bridgeCmdSharedReplyData4.add(objectArray4);
        }
        if (bridgeCmdSharedReplyData3 != null) {
            arrayList.add(bridgeCmdSharedReplyData3);
        }
        if (bridgeCmdSharedReplyData4 != null) {
            arrayList.add(bridgeCmdSharedReplyData4);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumLinks() {
        Link[] linkArray = null;
        LinkedHashMap<String, Link> linkedHashMap = this._links;
        synchronized (linkedHashMap) {
            linkArray = this._links.values().toArray(new Link[0]);
        }
        int n = 0;
        for (int i = 0; i < linkArray.length; ++i) {
            if (!linkArray[i].isEnabled()) continue;
            ++n;
        }
        return n;
    }

    public void pause(String string) throws Exception {
        String string2 = _jbr.getString("BSJ0014");
        this.checkStartFuture(string2, string, false);
        this.internalPause(string);
    }

    private synchronized void internalPause(String string) throws Exception {
        if (string != null) {
            Link link = this._links.get(string);
            if (link == null) {
                throw new IllegalArgumentException(_jbr.getKString("BSJ4019", string, this._name));
            }
            link.pause();
            return;
        }
        for (Map.Entry<String, Link> entry : this._links.entrySet()) {
            try {
                entry.getValue().pause();
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, _jbr.getKString("BSJ3005", entry.getKey(), this._name), exception);
                throw exception;
            }
        }
    }

    public void resume(String string) throws Exception {
        String string2 = _jbr.getString("BSJ0009");
        this.checkStartFuture(string2, string, false);
        this.internalResume(string);
    }

    private synchronized void internalResume(String string) throws Exception {
        if (string != null) {
            Link link = this._links.get(string);
            if (link == null) {
                throw new IllegalArgumentException(_jbr.getKString("BSJ4019", string, this._name));
            }
            link.resume(true);
            return;
        }
        for (Map.Entry<String, Link> entry : this._links.entrySet()) {
            try {
                entry.getValue().resume(true);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, _jbr.getKString("BSJ3006", entry.getKey(), this._name), exception);
                throw exception;
            }
        }
    }

    public void stop(String string) throws Exception {
        String string2 = _jbr.getString("BSJ0015");
        this.checkStartFuture(string2, string, true);
        this.internalStop(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void internalStop(String string, boolean bl) throws Exception {
        if (string != null) {
            Link link = this._links.get(string);
            if (link == null) {
                throw new IllegalArgumentException(_jbr.getKString("BSJ4019", string, this._name));
            }
            link.stop(bl);
            return;
        }
        this._notifier.notifyEvent(EventListener.EventType.BRIDGE_STOP, this);
        for (Map.Entry<String, Link> entry : this._links.entrySet()) {
            try {
                this._notifier.notifyEvent(EventListener.EventType.BRIDGE_STOP, this);
                entry.getValue().stop();
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, _jbr.getKString("BSJ3007", entry.getKey(), this._name), exception);
            }
        }
        for (Map.Entry<String, Object> entry : this._dmqs.entrySet()) {
            try {
                this._notifier.notifyEvent(EventListener.EventType.BRIDGE_STOP, this);
                ((DMQ)entry.getValue()).stop();
            }
            catch (Throwable throwable) {
                _logger.log(Level.SEVERE, _jbr.getKString("BSJ3008", entry.getKey(), this._name), throwable);
            }
        }
        for (Map.Entry<Object, Object> entry : this._spcfs.entrySet()) {
            try {
                Object object = entry.getValue();
                if (object instanceof PooledConnectionFactory) {
                    ((PooledConnectionFactory)object).close();
                    continue;
                }
                if (!(object instanceof SharedConnectionFactory)) continue;
                ((SharedConnectionFactory)object).close();
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, _jbr.getKString("BSJ2010", entry.getKey()), exception);
            }
        }
        this._spcfs.clear();
        if (bl) {
            return;
        }
        Object object = this._initLock;
        synchronized (object) {
            if (this._tma != null) {
                try {
                    this._tma.shutdown();
                }
                catch (Throwable throwable) {
                    _logger.log(Level.WARNING, _jbr.getKString("BSJ2011", throwable.getMessage()), throwable);
                }
            }
        }
    }

    public Connection obtainConnection(Object object, String string, Object object2) throws Exception {
        return this.obtainConnection(object, string, object2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection obtainConnection(Object object, String string, Object object2, boolean bl) throws Exception {
        Object object3 = null;
        Connection connection = null;
        Object[] objectArray = this._spcfs;
        synchronized (this._spcfs) {
            object3 = this._spcfs.get(object);
            if (object3 == null) {
                Properties properties = this._jmsbridge.getCF(((Refable)object).getRef()).getAttributes();
                EventListener eventListener = new EventListener(object2);
                try {
                    this._notifier.addEventListener(EventListener.EventType.BRIDGE_STOP, eventListener);
                    this._notifier.addEventListener(EventListener.EventType.LINK_STOP, eventListener);
                    connection = JMSBridge.openConnection(object, properties, string, object2, eventListener, _logger);
                }
                finally {
                    this._notifier.removeEventListener(eventListener);
                }
                try {
                    if (connection.getClientID() == null) {
                        _logger.log(Level.INFO, _jbr.getString("BSJ1011", ((Refable)object).getRef()));
                        object3 = new PooledConnectionFactory(object, properties, _logger);
                    } else {
                        _logger.log(Level.INFO, _jbr.getString("BSJ1012", ((Refable)object).getRef()));
                        object3 = new SharedConnectionFactory(object, properties, _logger);
                    }
                    this._spcfs.put(object, object3);
                }
                catch (Exception exception) {
                    _logger.log(Level.SEVERE, _jbr.getKString("BSJ3009", ((Refable)object).getRef(), exception.getMessage()));
                    try {
                        connection.close();
                        connection = null;
                    }
                    catch (Exception exception2) {
                        _logger.log(Level.FINE, "Exception in closing connection from connection factory" + ((Refable)object).getRef() + ": " + exception2.getMessage());
                    }
                    throw exception;
                }
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            if (object3 instanceof PooledConnectionFactory) {
                objectArray = new String[]{object3.toString(), string, object2.toString()};
                _logger.log(Level.INFO, _jbr.getString("BSJ1013", objectArray));
                return ((PooledConnectionFactory)object3).obtainConnection(connection, string, object2, bl);
            }
            objectArray = new String[]{object3.toString(), string, object2.toString()};
            _logger.log(Level.INFO, _jbr.getString("BSJ1014", objectArray));
            return ((SharedConnectionFactory)object3).obtainConnection(connection, string, object2, bl);
        }
    }

    public void returnConnection(Connection connection, Object object) throws Exception {
        Object object2 = this._spcfs.get(object);
        if (object2 == null) {
            throw new IllegalStateException("Nowhere to return connection " + connection + " from connection factory " + object);
        }
        if (object2 instanceof PooledConnectionFactory) {
            _logger.log(Level.INFO, _jbr.getString("BSJ1015", object2.toString()));
            ((PooledConnectionFactory)object2).returnConnection(connection);
        } else if (object2 instanceof SharedConnectionFactory) {
            _logger.log(Level.INFO, _jbr.getString("BSJ1016", object2.toString()));
            ((SharedConnectionFactory)object2).returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toDMQ(Message message, String string, DMQ.DMQReason dMQReason, Throwable throwable, Link link) throws Exception {
        DMQ.logMessage(message, string, link, _logger);
        DMQ[] dMQArray = null;
        Serializable serializable = this._dmqs;
        synchronized (serializable) {
            dMQArray = this._dmqs.values().toArray(new DMQ[0]);
        }
        serializable = null;
        boolean bl = false;
        for (int i = 0; i < dMQArray.length; ++i) {
            Object[] objectArray = new String[]{string, dMQArray[i].toString(), link.toString()};
            try {
                _logger.log(Level.INFO, _jbr.getString("BSJ1017", objectArray));
                dMQArray[i].sendMessage(message, string, dMQReason, throwable, link);
                bl = true;
                _logger.log(Level.INFO, _jbr.getString("BSJ1018", objectArray));
                if (!dMQArray[i].getName().equals("built-in-dmq")) break;
                continue;
            }
            catch (Exception exception) {
                serializable = exception;
                _logger.log(Level.WARNING, _jbr.getString("BSJ2012", objectArray), exception);
            }
        }
        if (bl) {
            return;
        }
        throw serializable;
    }

    protected Properties getCFAttributes(Object object) throws Exception {
        if (((Refable)object).getRef().equals("built-in-dmq")) {
            return new Properties();
        }
        return this._jmsbridge.getCF(((Refable)object).getRef()).getAttributes();
    }

    public static Connection openConnection(Object object, Properties properties, String string, Object object2, EventListener eventListener, Logger logger) throws Exception {
        return JMSBridge.openConnection(object, properties, string, object2, eventListener, logger, false);
    }

    public static Connection openConnection(Object object, Properties properties, String string, Object object2, EventListener eventListener, Logger logger, boolean bl) throws Exception {
        int n = 0;
        long l = 0L;
        String string2 = properties.getProperty("connect-attempts", "-1");
        if (string2 != null) {
            n = Integer.valueOf(string2);
        }
        if ((string2 = properties.getProperty("connect-attempt-interval-in-seconds", "5")) != null) {
            l = Integer.valueOf(string2).intValue();
        }
        if (l < 0L) {
            l = 0L;
        }
        l *= 1000L;
        String string3 = null;
        String string4 = null;
        string2 = properties.getProperty("username");
        if (string2 != null) {
            string3 = string2.trim();
            string4 = properties.getProperty("password");
        }
        return JMSBridge.openConnection(object, n, l, string3, string4, string, object2, eventListener, logger, bl);
    }

    public static Connection openConnection(Object object, int n, long l, String string, String string2, String string3, Object object2, EventListener eventListener, Logger logger) throws Exception {
        return JMSBridge.openConnection(object, n, l, string, string2, string3, object2, eventListener, logger, false);
    }

    public static Connection openConnection(Object object, int n, long l, String string, String string2, String string3, Object object2, EventListener eventListener, Logger logger, boolean bl) throws Exception {
        if (eventListener.hasEventOccurred()) {
            throw new JMSException("" + (Object)((Object)eventListener.occurredEvent()));
        }
        int n2 = n;
        Connection connection = null;
        int n3 = 0;
        JMSException jMSException = null;
        int n4 = 0;
        while (true) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException(_jbr.getKString("BSJ4037", object.toString(), object2.toString()));
            }
            if (n3 > 0 && l > 0L) {
                Thread.sleep(l);
            }
            try {
                Object[] objectArray = new String[3];
                objectArray[0] = string == null ? "" : _jbr.getString("BSJ0011", string);
                objectArray[1] = object.toString();
                objectArray[2] = object2.toString();
                Object[] objectArray2 = objectArray;
                if (object instanceof XAConnectionFactory) {
                    logger.log(Level.INFO, _jbr.getString("BSJ1019", objectArray2));
                    connection = string == null ? ((XAConnectionFactory)object).createXAConnection() : ((XAConnectionFactory)object).createXAConnection(string, string2);
                } else {
                    logger.log(Level.INFO, _jbr.getString("BSJ1020", objectArray2));
                    connection = string == null ? ((ConnectionFactory)object).createConnection() : ((ConnectionFactory)object).createConnection(string, string2);
                }
                return connection;
            }
            catch (JMSException jMSException2) {
                Object[] objectArray;
                ++n3;
                jMSException = jMSException2;
                Exception exception = jMSException2.getLinkedException();
                if (jMSException2 instanceof InvalidClientIDException) {
                    ++n4;
                }
                if (jMSException2 instanceof JMSSecurityException || exception instanceof JMSSecurityException || jMSException2 instanceof InvalidClientIDException && n4 > 1) {
                    objectArray = new String[]{string3, object2.toString(), n3 + "(" + l + ")"};
                    _logger.log(Level.SEVERE, _jbr.getKString("BSJ2013", objectArray), jMSException2);
                    throw jMSException2;
                }
                objectArray = new String[]{string3, object2.toString(), n3 + "(" + l + "): " + jMSException2.getMessage() + (exception == null ? "" : " - " + exception.getMessage())};
                _logger.log(Level.WARNING, _jbr.getKString("BSJ2013", objectArray));
                if (bl || n2 <= 1 && n2 >= 0) continue;
                throw new ProviderConnectException("Failed to connect to " + object + ": " + jMSException2.getMessage() + (exception == null ? "" : " - " + exception.getMessage()));
                if ((n2 < 0 || n3 < n2) && !eventListener.hasEventOccurred()) continue;
                if (eventListener.hasEventOccurred()) {
                    throw new JMSException("" + (Object)((Object)eventListener.occurredEvent()));
                }
                throw jMSException;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionManager getTransactionManager() throws Exception {
        Object object = this._initLock;
        synchronized (object) {
            if (this._tm != null) {
                return this._tm;
            }
            this.initTransactionManager();
            return this._tm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionManagerAdapter getTransactionManagerAdapter() throws Exception {
        Object object = this._initLock;
        synchronized (object) {
            if (this._tma != null) {
                return this._tma;
            }
            this.initTransactionManager();
            return this._tma;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTransactionManager() throws Exception {
        Object object = this._initLock;
        synchronized (object) {
            if (this._tma != null) {
                return;
            }
            String string = this._bc.getTransactionManagerClass();
            if (string == null) {
                string = "com.sun.messaging.bridge.service.jms.tx.TransactionManagerImpl";
            }
            _logger.log(Level.INFO, _jbr.getString("BSJ1021", string.toString()));
            Class<?> clazz = Class.forName(string);
            this._tma = (TransactionManagerAdapter)clazz.newInstance();
            this._tma.setLogger(_logger);
            Properties properties = this._bc.getTransactionManagerProps();
            if (properties == null) {
                properties = new Properties();
            }
            if (this._tma instanceof TransactionManagerImpl) {
                properties.setProperty("tmname", this._bc.getIdentityName() + ":" + this._name);
                properties.setProperty("txlogDir", this._bc.getRootDir());
                properties.setProperty("txlogSuffix", this._name);
                properties.setProperty("jmsbridge", this._name);
                if (this._bc.isJDBCStoreType()) {
                    properties.setProperty("txlogType", "jdbc");
                    ((TransactionManagerImpl)this._tma).setJDBCStore((JMSBridgeStore)this._bc.getJDBCStore("JMS"));
                }
                this._supportTransactionTimeout = false;
            }
            _logger.log(Level.INFO, _jbr.getString("BSJ1022", properties.toString()));
            this._tma.init(properties, this._reset);
            this._tm = this._tma.getTransactionManager();
            if (!(this._tma instanceof TransactionManagerImpl)) {
                _logger.log(Level.INFO, _jbr.getString("BSJ1023", this._transactionTimeout));
                this._tm.setTransactionTimeout(this._transactionTimeout);
                this._supportTransactionTimeout = true;
            }
        }
    }

    public int getTransactionTimeout() {
        return this._transactionTimeout;
    }

    public boolean supportTransactionTimeout() {
        return this._supportTransactionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerXAResources(Map<String, ? extends Object> map) throws Exception {
        TransactionManagerAdapter transactionManagerAdapter = this.getTransactionManagerAdapter();
        if (!transactionManagerAdapter.registerRM()) {
            return;
        }
        String string = null;
        Object object = null;
        Connection connection = null;
        for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
            string = entry.getKey();
            object = entry.getValue();
            if (!(object instanceof XAConnectionFactory)) continue;
            if (((Refable)object).isMultiRM()) {
                _logger.log(Level.INFO, _jbr.getString("BSJ1024", "multi-rm", string.toString()));
                continue;
            }
            Object object2 = null;
            EventListener eventListener = new EventListener(this);
            try {
                String string2 = this._jmsbridge.getCF(((Refable)object).getRef()).getUsername();
                String string3 = this._jmsbridge.getCF(((Refable)object).getRef()).getPassword();
                this._notifier.addEventListener(EventListener.EventType.BRIDGE_STOP, eventListener);
                connection = (XAConnection)JMSBridge.openConnection(object, 1, 0L, string2, string3, "", this, eventListener, _logger);
                XASession xASession = connection.createXASession();
                object2 = xASession.getXAResource();
                _logger.log(Level.INFO, _jbr.getString("BSJ1025", string.toString(), object2.toString()));
                transactionManagerAdapter.registerRM(string, (XAResource)object2);
            }
            catch (Throwable throwable) {
                _logger.log(Level.WARNING, _jbr.getKString("BSJ2014", string.toString(), object2 == null ? "" : object2.toString()), throwable);
            }
            finally {
                this._notifier.removeEventListener(eventListener);
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String toString() {
        return "jmsbridge(" + this._name + ")";
    }

    public static Object exportJMSBridgeStoreService(Properties properties) throws Exception {
        Object object;
        String string = properties.getProperty("jmsbridge");
        String string2 = properties.getProperty("instanceRootDir");
        String string3 = properties.getProperty("reset", "true");
        String string4 = properties.getProperty("logdomain");
        if (string2 == null) {
            throw new IllegalArgumentException("instanceRootDir not found in " + properties);
        }
        if (string4 == null) {
            throw new IllegalArgumentException("logdomain property not found in " + properties);
        }
        String string5 = string2 + File.separator + "bridges";
        properties.setProperty("txlogDirParent", string5);
        boolean bl = Boolean.valueOf(string3);
        File file = new File(string5);
        if (bl && string == null) {
            if (file.exists() && !file.renameTo(new File(string5 + ".save"))) {
                throw new IOException("Unable to rename existing directory " + string5 + " to " + string5 + ".save");
            }
            return null;
        }
        if (string == null) {
            if (!file.exists()) {
                return null;
            }
            object = file.listFiles();
            if (object == null) {
                throw new IOException("Can't list files in " + string5);
            }
            if (((File[])object).length == 0) {
                return null;
            }
            for (int i = 0; i < ((File[])object).length; ++i) {
                if (!object[i].isDirectory()) continue;
                string = object[i].getName();
                break;
            }
            if (string == null) {
                return null;
            }
            properties.setProperty("jmsbridge", string);
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        object = Logger.getLogger(string4);
        properties.setProperty("txlogDir", string5);
        properties.setProperty("tmname", properties.getProperty("identityName") + ":" + string);
        properties.setProperty("txlogSuffix", string);
        String string6 = string5 + File.separator + string;
        properties.setProperty("txlogDir", string6);
        file = new File(string6);
        if (!file.exists()) {
            file.mkdirs();
        }
        String string7 = file + File.separator + "jms%g.log";
        FileHandler fileHandler = new FileHandler(string7, true);
        fileHandler.setFormatter(new LogSimpleFormatter((Logger)object));
        ((Logger)object).addHandler(fileHandler);
        ((Logger)object).log(Level.INFO, "Exported JMSBridgeStore txlogDir is " + string6);
        ((Logger)object).log(Level.INFO, "Exported JMSBridgeStore uses log domain: " + string4);
        ((Logger)object).log(Level.INFO, "Exported JMSBridgeStore uses log file: " + string7);
        FileTxLogImpl fileTxLogImpl = new FileTxLogImpl();
        fileTxLogImpl.setLogger((Logger)object);
        fileTxLogImpl.init(properties, bl);
        return fileTxLogImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JMSBridgeResources getJMSBridgeResources() {
        if (_jbr != null) return _jbr;
        Class<JMSBridge> clazz = JMSBridge.class;
        synchronized (JMSBridge.class) {
            if (_jbr != null) return _jbr;
            _jbr = JMSBridgeResources.getResources(Locale.getDefault());
            // ** MonitorExit[var0] (shouldn't be in output)
            return _jbr;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Starter
    implements Callable<Void> {
        private String linkName = null;
        private boolean async = true;
        private JMSBridge parent = null;
        private AsyncStartListener asl = null;

        public Starter(String string, JMSBridge jMSBridge2, AsyncStartListener asyncStartListener) {
            this.linkName = string;
            this.parent = jMSBridge2;
            this.asl = asyncStartListener;
        }

        public void setAsync(boolean bl) {
            this.async = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                JMSBridge jMSBridge = this.parent;
                synchronized (jMSBridge) {
                    block44: {
                        if (this.async) {
                            JMSBridge.this._startLatch.countDown();
                        }
                        if (this.linkName == null) break block44;
                        Link link = JMSBridge.this._links.get(this.linkName);
                        if (link == null) {
                            JMSBridgeResources jMSBridgeResources = _jbr;
                            _jbr;
                            throw new IllegalArgumentException(jMSBridgeResources.getKString("BSJ4019", this.linkName, JMSBridge.this._name));
                        }
                        link.start(this.async);
                        link.postStart();
                        Void void_ = null;
                        return void_;
                    }
                    DMQ dMQ = null;
                    for (Map.Entry<String, DMQ> object2 : JMSBridge.this._dmqs.entrySet()) {
                        dMQ = object2.getValue();
                        try {
                            if (!dMQ.isEnabled()) continue;
                            dMQ.start(this.async);
                        }
                        catch (Exception exception) {
                            Logger logger = _logger;
                            JMSBridgeResources jMSBridgeResources = _jbr;
                            _jbr;
                            logger.log(Level.SEVERE, jMSBridgeResources.getKString("BSJ3002", dMQ.toString(), JMSBridge.this._name), exception);
                            try {
                                JMSBridge.this.internalStop(null, !this.async && exception instanceof ProviderConnectException);
                            }
                            catch (Exception exception2) {
                                Logger logger2 = _logger;
                                JMSBridgeResources jMSBridgeResources2 = _jbr;
                                _jbr;
                                logger2.log(Level.WARNING, jMSBridgeResources2.getKString("BSJ2006", JMSBridge.this._name), exception2);
                            }
                            throw exception;
                        }
                    }
                    ArrayList arrayList = new ArrayList();
                    Object var4_11 = null;
                    for (Map.Entry<String, Link> entry : JMSBridge.this._links.entrySet()) {
                        Link link = entry.getValue();
                        try {
                            if (!link.isEnabled()) continue;
                            link.start(this.async);
                            arrayList.add(link);
                        }
                        catch (Exception exception) {
                            Logger logger = _logger;
                            JMSBridgeResources jMSBridgeResources = _jbr;
                            _jbr;
                            logger.log(Level.SEVERE, jMSBridgeResources.getKString("BSJ3003", link.toString(), JMSBridge.this._name), exception);
                            try {
                                JMSBridge.this.internalStop(null, !this.async && (exception.getCause() instanceof ProviderConnectException || exception instanceof ProviderConnectException));
                            }
                            catch (Exception exception3) {
                                Logger logger3 = _logger;
                                JMSBridgeResources jMSBridgeResources3 = _jbr;
                                _jbr;
                                logger3.log(Level.WARNING, jMSBridgeResources3.getKString("BSJ2007", JMSBridge.this._name), exception3);
                            }
                            throw exception;
                        }
                    }
                    Iterator<Map.Entry<String, Link>> iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        Link link = (Link)((Object)iterator.next());
                        try {
                            link.postStart();
                        }
                        catch (Exception exception) {
                            Logger logger = _logger;
                            JMSBridgeResources jMSBridgeResources = _jbr;
                            _jbr;
                            logger.log(Level.SEVERE, jMSBridgeResources.getKString("BSJ3004", link.toString()), exception);
                            try {
                                JMSBridge.this.internalStop(null, !this.async && (exception.getCause() instanceof ProviderConnectException || exception instanceof ProviderConnectException));
                            }
                            catch (Exception exception4) {
                                Logger logger4 = _logger;
                                JMSBridgeResources jMSBridgeResources4 = _jbr;
                                _jbr;
                                logger4.log(Level.WARNING, jMSBridgeResources4.getKString("BSJ2008", JMSBridge.this._name), exception4);
                            }
                            throw exception;
                        }
                    }
                }
                try {
                    if (this.async) {
                        this.asl.asyncStartCompleted();
                    }
                }
                catch (Exception exception) {
                    _logger.log(Level.SEVERE, exception.getMessage());
                    try {
                        JMSBridge.this.internalStop(null, false);
                    }
                    catch (Exception exception5) {
                        _logger.log(Level.WARNING, "Stop bridge " + JMSBridge.this._name + " failed: " + exception5.getMessage(), exception5);
                    }
                    throw exception;
                }
            }
            catch (Exception exception) {
                if (this.async) {
                    this.asl.asyncStartFailed();
                }
                throw exception;
            }
            finally {
                Object object = JMSBridge.this._startFutureLock;
                synchronized (object) {
                    if (this.linkName != null) {
                        JMSBridge.this._startFutures.remove(this.linkName);
                    } else {
                        JMSBridge.this._startFutures.remove(JMSBridge.BRIDGE_NAME_PROPERTY);
                    }
                }
            }
            return null;
        }
    }
}

